var __extends = (this && this.__extends) || (function () {
    var extendStatics = function (d, b) {
        extendStatics = Object.setPrototypeOf ||
            ({ __proto__: [] } instanceof Array && function (d, b) { d.__proto__ = b; }) ||
            function (d, b) { for (var p in b) if (b.hasOwnProperty(p)) d[p] = b[p]; };
        return extendStatics(d, b);
    };
    return function (d, b) {
        extendStatics(d, b);
        function __() { this.constructor = d; }
        d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
    };
})();
//import * as angular from 'angular';
//import mapDefaults from './mapDefaults';
//declare var ol:any;
//import mapStyles from './mapStyles';
//import CameraIcons from './CameraIcons';
//import { Feature, style } from 'openlayers';
//import CameraIcons from './CameraIcons';
var standalonePlayer;
//import * as angular from 'angular';
//import mapDefaults from './mapDefaults';
//declare var ol:any;
//import mapStyles from './mapStyles';
//import CameraIcons from './CameraIcons';
//import { Feature, style } from 'openlayers';
//import CameraIcons from './CameraIcons';
(function (standalonePlayer) {
    "use strict";
    var CameraIcons = /** @class */ (function () {
        function CameraIcons(iconSize) {
            if (iconSize === void 0) { iconSize = 100; }
            this.imageSize = [128, 128];
            this.imageSizeResize = {
                75: [128, 128],
                50: [128, 128],
                25: [128, 128]
            };
            this.imageScaleResize = {
                100: 0.35,
                75: 0.30,
                50: 0.23,
                25: 0.15
            };
            this.alarmSize = [32, 31];
            this.anchorSize = [0.5, 0.48];
            this.imageScale = 0.35;
            this.getIconStyle = function (src, iconSize) {
                // if (iconSize != 25 && iconSize != 50 && iconSize != 75 && iconSize) {
                //     return src;
                // }
                // let srcParts = src.split("/");
                // if (srcParts.length <= 1) return src;
                // srcParts.splice(srcParts.length - 1, 0, iconSize);
                // return srcParts.join("/");
                return src;
            };
            this.icon1 = new ol.style.Style({
                image: new ol.style.Icon({
                    anchor: this.anchorSize,
                    size: this.getIconSize(iconSize),
                    opacity: 1,
                    scale: this.getIconScale(iconSize),
                    src: this.getIconStyle(CameraIcons.ICON_SRC.default, iconSize),
                    rotation: 0
                }),
                zIndex: 2
            });
            this.icon360Style = new ol.style.Style({
                image: new ol.style.Icon({
                    anchor: this.anchorSize,
                    size: this.getIconSize(iconSize),
                    opacity: 1,
                    scale: this.getIconScale(iconSize),
                    src: this.getIconStyle(CameraIcons.ICON_SRC.icon360, iconSize),
                    rotation: 0
                }),
                zIndex: 2
            });
            this.icon360MixedStyle = new ol.style.Style({
                image: new ol.style.Icon({
                    anchor: this.anchorSize,
                    size: this.getIconSize(iconSize),
                    opacity: 1,
                    scale: this.getIconScale(iconSize),
                    src: this.getIconStyle(CameraIcons.ICON_SRC.iconMixed360, iconSize),
                    rotation: 0
                }),
                zIndex: 2
            });
            this.ptzIconStyle = new ol.style.Style({
                image: new ol.style.Icon({
                    anchor: this.anchorSize,
                    size: this.getIconSize(iconSize),
                    opacity: 1,
                    scale: this.getIconScale(iconSize),
                    src: this.getIconStyle(CameraIcons.ICON_SRC.ptz, iconSize),
                    rotation: 0
                }),
                zIndex: 2
            });
            this.ptzMixedIconStyle = new ol.style.Style({
                image: new ol.style.Icon({
                    anchor: this.anchorSize,
                    size: this.getIconSize(iconSize),
                    opacity: 1,
                    scale: this.getIconScale(iconSize),
                    src: this.getIconStyle(CameraIcons.ICON_SRC.ptzMixed, iconSize),
                    rotation: 0
                }),
                zIndex: 2
            });
            this.mixedIconStyle = new ol.style.Style({
                image: new ol.style.Icon({
                    anchor: this.anchorSize,
                    size: this.getIconSize(iconSize),
                    opacity: 1,
                    scale: this.getIconScale(iconSize),
                    src: this.getIconStyle(CameraIcons.ICON_SRC.ptzMixed, iconSize),
                    rotation: 0
                }),
                zIndex: 2
            });
            this.vaxIconStyle = new ol.style.Style({
                image: new ol.style.Icon({
                    anchor: this.anchorSize,
                    size: this.getIconSize(iconSize),
                    opacity: 1,
                    scale: this.getIconScale(iconSize),
                    src: this.getIconStyle(CameraIcons.ICON_SRC.vaxDoorActive, iconSize),
                    rotation: 0
                }),
                zIndex: 2
            });
            this.vaxActionPlanIconStyle = new ol.style.Style({
                image: new ol.style.Icon({
                    anchor: this.anchorSize,
                    size: this.getIconSize(iconSize),
                    opacity: 1,
                    scale: this.getIconScale(iconSize),
                    src: this.getIconStyle(CameraIcons.ICON_SRC.vaxActionPlanIdle, iconSize),
                    rotation: 0
                }),
                zIndex: 2
            });
            //Added to create funnel style
            this.iconfunnel = new ol.style.Style({
                // Pi/4 is 45 degrees
                image: new ol.style.RegularShape({
                    fill: new ol.style.Fill({ color: [53, 140, 216, 0.5] }),
                    stroke: new ol.style.Stroke({ color: [53, 140, 216, 0], width: 0 }),
                    points: 3,
                    radius: 10,
                    angle: Math.PI / 4
                }),
                text: new ol.style.Text(({ rotateWithView: true, rotation: 0 })),
                fill: new ol.style.Fill({ color: [53, 140, 216, 0.5] }),
                stroke: new ol.style.Stroke({ color: [53, 140, 216, 0], width: 0 })
            });
            //Sticky Note
            this.iconStickyNotes = new ol.style.Style({
                fill: new ol.style.Fill({
                    color: 'rgba(255, 255, 255, 0.2)',
                }),
                stroke: new ol.style.Stroke({
                    color: '#ffcc33',
                    width: 2
                }),
                text: new ol.style.Text({
                    font: '14px Arial Italic',
                    fill: new ol.style.Fill({ color: '#1a2028' }),
                    text: '',
                    textAlign: 'center',
                    textBaseline: 'middle'
                }),
                image: new ol.style.RegularShape({
                    points: 4,
                    radius: 30,
                    fill: new ol.style.Fill({ color: [255, 255, 255, 0] }),
                    stroke: new ol.style.Stroke({ color: [53, 140, 216, 0.5], width: 2 })
                }),
            });
            //circle for 360
            this.iconCircle = new ol.style.Style({
                // Pi/4 is 45 degrees
                image: new ol.style.Circle({
                    fill: new ol.style.Fill({ color: [53, 140, 216, 0.5] }),
                    stroke: new ol.style.Stroke({ color: [53, 140, 216, 0], width: 0 }),
                    radius: 10
                }),
                text: new ol.style.Text(({ rotateWithView: true, rotation: 0 })),
                fill: new ol.style.Fill({ color: [53, 140, 216, 0.5] }),
                stroke: new ol.style.Stroke({ color: [53, 140, 216, 0], width: 0 })
            });
            //default shape for add highlight
            this.shapeStyle = new ol.style.Style({
                image: new ol.style.Circle({
                    fill: new ol.style.Fill({ color: [226, 43, 138, 0.5] }),
                    stroke: new ol.style.Stroke({ color: [226, 43, 138, 0], width: 0 }),
                    radius: 5
                }),
                text: new ol.style.Text(({
                    rotateWithView: true,
                    rotation: 0,
                    font: '14px Arial Italic',
                    fill: new ol.style.Fill({ color: '#1a2028' }),
                    text: '',
                })),
                fill: new ol.style.Fill({ color: [226, 43, 138, 0.5] }),
                stroke: new ol.style.Stroke({ color: [226, 43, 138, 0], width: 0 })
            });
            this.urlSourceStyle = new ol.style.Style({
                image: new ol.style.RegularShape({
                    points: 4,
                    radius: 30,
                    angle: Math.PI / 4,
                    fill: new ol.style.Fill({ color: [255, 255, 255, 0] }),
                }),
                text: new ol.style.Text(({
                    scale: 1,
                    font: 'normal 38px vicon-font',
                    offsetX: 0,
                    offsetY: 0,
                    rotateWithView: true,
                    text: '\ue92a',
                    textAlign: 'center',
                    textBaseline: 'middle',
                    fill: new ol.style.Fill({
                        color: [0, 0, 255, 1],
                    }),
                    //stroke: new ol.style.Stroke({
                    //	color: [255, 255, 255, 1],
                    //	width: 1
                    //}),
                    rotation: 0 //== Rotation in radians -2 to 2*Math.PI (1 Pi = 3.14 = 180 degrees)
                })),
                zIndex: 2
            });
            this.diSourceStyle = new ol.style.Style({
                image: new ol.style.Icon({
                    anchor: this.anchorSize,
                    size: this.getIconSize(iconSize),
                    opacity: 1,
                    scale: this.getIconScale(iconSize),
                    src: this.getIconStyle(CameraIcons.ICON_SRC.digitalInput, iconSize),
                    rotation: 0
                }),
                zIndex: 2
            });
            this.roSourceStyle = new ol.style.Style({
                image: new ol.style.Icon({
                    anchor: this.anchorSize,
                    size: this.getIconSize(iconSize),
                    opacity: 1,
                    scale: this.getIconScale(iconSize),
                    src: this.getIconStyle(CameraIcons.ICON_SRC.relayOutput, iconSize),
                    rotation: 0
                }),
                zIndex: 2
            });
            this.audioSourceStyle = new ol.style.Style({
                image: new ol.style.Icon({
                    anchor: this.anchorSize,
                    size: this.getIconSize(iconSize),
                    opacity: 1,
                    scale: this.getIconScale(iconSize),
                    src: this.getIconStyle(CameraIcons.ICON_SRC.audio, iconSize),
                    rotation: 0
                }),
                zIndex: 2
            });
            this.viewSourceStyle = new ol.style.Style({
                image: new ol.style.Icon({
                    anchor: this.anchorSize,
                    size: this.getIconSize(iconSize),
                    opacity: 1,
                    scale: this.getIconScale(iconSize),
                    src: this.getIconStyle(CameraIcons.ICON_SRC.view, iconSize),
                    rotation: 0
                }),
                zIndex: 2
            });
            this.tourIconStyle = new ol.style.Style({
                image: new ol.style.Icon({
                    anchor: this.anchorSize,
                    size: this.getIconSize(iconSize),
                    opacity: 1,
                    scale: this.getIconScale(iconSize),
                    src: this.getIconStyle(CameraIcons.ICON_SRC.tour, iconSize),
                    rotation: 0
                }),
                zIndex: 2
            });
            this.lprIconStyle = new ol.style.Style({
                image: new ol.style.Icon({
                    anchor: this.anchorSize,
                    size: this.getIconSize(iconSize),
                    opacity: 1,
                    scale: this.getIconScale(iconSize),
                    src: this.getIconStyle(CameraIcons.ICON_SRC.iconLPR, iconSize),
                    rotation: 0
                }),
                zIndex: 2
            });
            this.removedChannelIconStyle = new ol.style.Style({
                image: new ol.style.Icon({
                    anchor: this.anchorSize,
                    size: this.getIconSize(iconSize),
                    opacity: 1,
                    scale: this.getIconScale(iconSize),
                    src: this.getIconStyle(CameraIcons.ICON_SRC.audioIdle, iconSize),
                    rotation: 0
                }),
                zIndex: 2
            });
            this.notes = new ol.style.Style({
                text: new ol.style.Text({
                    font: '14px Arial Italic',
                    fill: new ol.style.Fill({ color: '#1a2028' }),
                    text: 'Please double click to update notes',
                    textAlign: 'center',
                    textBaseline: 'middle'
                })
            });
            this.linkedAlarm = new ol.style.Style({
                image: new ol.style.Icon({
                    anchor: this.anchorSize,
                    size: this.getIconSize(iconSize),
                    opacity: 1,
                    scale: 1,
                    src: this.getIconStyle(CameraIcons.ICON_SRC.linkedAlarm, iconSize),
                    rotation: 0
                }),
                zIndex: 2
            });
            this.iconMobileStyle = new ol.style.Style({
                image: new ol.style.Icon({
                    anchor: this.anchorSize,
                    size: this.getIconSize(iconSize),
                    opacity: 1,
                    scale: this.getIconScale(iconSize),
                    src: this.getIconStyle(CameraIcons.ICON_SRC.iconMobileActive, iconSize),
                    rotation: 0
                }),
                zIndex: 2
            });
            this.iconThermalStyle = new ol.style.Style({
                image: new ol.style.Icon({
                    anchor: this.anchorSize,
                    size: this.getIconSize(iconSize),
                    opacity: 1,
                    scale: this.getIconScale(iconSize),
                    src: this.getIconStyle(CameraIcons.ICON_SRC.iconThermalActive, iconSize),
                    rotation: 0
                }),
                zIndex: 2
            });
        }
        CameraIcons.prototype.getIconSize = function (iconSize) {
            if (iconSize != 25 && iconSize != 50 && iconSize != 75) {
                return this.imageSize;
            }
            return this.imageSizeResize[iconSize];
        };
        CameraIcons.prototype.getIconScale = function (iconSize) {
            if (iconSize != 25 && iconSize != 50 && iconSize != 75) {
                return this.imageScale;
            }
            return this.imageScaleResize[iconSize];
        };
        CameraIcons.HIGHLIGHTCAMERA_IMG = "images/yellow.png";
        CameraIcons.ICON_SRC = {
            default: "images/02A_DomeStaticCameraActive.png",
            defaultIdle: "images/02A_DomeStaticCamera.png",
            defaultAlarm: "images/02A_DomeStaticCameraAlarm.png",
            ptz: "images/04B_PTZDomeActive.png",
            ptzIdle: "images/04B_PTZDome.png",
            ptzAlarm: "images/04B_PTZDomeAlarm.png",
            ptzMixed: "images/10_PTZDome2Active.png",
            ptzMixedIdle: "images/10_PTZDome2.png",
            ptzMixedAlarm: "images/10_PTZDome2Alarm.png",
            mixedIcon: "images/02_MixedChannelActive.png",
            mixedIconIdle: "images/02_MixedChannel.png",
            mixedIconAlarm: "images/02_MixedChannelAlarm.png",
            digitalInput: "images/04_DigitalInput.png",
            relayOutput: "images/03_Relayoutput.png",
            audio: "images/01_MicrophoneActive.png",
            audioIdle: "images/01_Microphone.png",
            audioAlarm: "images/01_MicrophoneAlarm.png",
            digitalInputActive: "images/04_DigitalInputActive.png",
            relayOutputActive: "images/03_RelayoutputActive.png",
            view: "images/05_ViewActive.png",
            viewIdle: "images/05_View.png",
            viewAlarm: "images/05_ViewAlarm.png",
            digitalInputAlarm: "images/04_DigitalInputAlarm.png",
            relayOutputAlarm: "images/03_RelayoutputAlarm.png",
            tourIdle: "images/06_Tour.png",
            tourAlarm: "images/06_TourAlarm.png",
            tour: "images/06_TourActive.png",
            icon360: "images/05A_360CameraActive.png",
            icon360Idle: "images/05A_360Camera.png",
            icon360Alarm: "images/05A_360CameraAlarm.png",
            iconMixed360: "images/11_360CameraActive.png",
            iconMixed360Idle: "images/11_360Camera.png",
            iconMixed360Alarm: "images/11_360CameraAlarm.png",
            linkedAlarm: "images/alarm.png",
            iconMobile: "images/Mobile.png",
            iconMobileActive: "images/MobileActive.png",
            iconMobileAlarm: "images/MobileAlarm.png",
            iconThermal: "images/ThermalRadar2.png",
            iconThermalActive: "images/Thermal Radar2Active.png",
            iconThermalAlarm: "images/Thermal Radar2Alarm.png",
            iconLPR: "images/lprActive.png",
            iconLPRAlarm: "images/lprImage.png",
            vaxDoorIdle: "images/door-idle.png",
            vaxDoorActive: "images/door-active.png",
            vaxDoorAlarm: "images/door-alarm.png",
            vaxActionPlanIdle: "images/vax_action_plan_idle.png",
            vaxActionPlanActive: "images/vax_action_plan_idle.png",
            vaxActionPlanAlarm: "images/vax_action_play_active.png"
        };
        return CameraIcons;
    }());
    var mapDefaults = { mapLayers: {
            mapLayer: 'bgMapImageLayer',
            cameraLayer: 'cameraImagesLayer',
            funnelLayer: 'funnelLayer',
            linkedMapsLayer: 'linkedMapsLayer',
            stickyNotesLayer: 'stickyNotesLayer',
            viewLayer: 'viewLayer'
        }, mapTypes: {
            static: 'Image',
            geo: 'MapService'
        }, mapFeatureTypes: {
            camera: 'iconFeature',
            funnel: 'funnelIconFeature',
            linkedMap: 'linkedMapFeature',
            stickyNote: 'stickyNoteFeature',
            view: 'viewFature'
        },
        mapCameraTypes: {
            image: 'image',
            text: 'text'
        }, mapLinkedType: {
            linked: 'linked',
            unlinked: 'unlinked'
        } };
    var mapStyles = {
        defaultStyle: {
            highlight: new ol.style.Style({
                fill: new ol.style.Fill({
                    color: [147, 147, 93, 0.8]
                }),
                stroke: new ol.style.Stroke({
                    color: [147, 147, 93, 0.8],
                    width: 2,
                    lineDash: [5]
                })
            }),
            note: new ol.style.Style({
                fill: new ol.style.Fill({
                    color: [252, 233, 168, 1]
                }),
                stroke: new ol.style.Stroke({
                    color: [191, 183, 154, 1],
                    width: 1
                }),
                text: new ol.style.Text(({
                    scale: 1,
                    font: 'normal 18px Arial',
                    offsetX: 0,
                    offsetY: 0,
                    rotateWithView: true,
                    textAlign: 'center',
                    textBaseline: 'middle',
                    //overflow: true,
                    fill: new ol.style.Fill({
                        color: [0, 0, 0, 1]
                    }),
                    stroke: new ol.style.Stroke({
                        color: [0, 0, 0, 0],
                        width: 1
                    }),
                    rotation: 0 //== Rotation in radians -2 to 2*Math.PI (1 Pi = 3.14 = 180 degrees)
                })),
                zIndex: 2
            })
        },
        selectedStyle: {
            camera: new ol.style.Style({
                text: new ol.style.Text(({
                    scale: 1,
                    font: 'normal 34px vicon-font',
                    //placement: 'point',
                    offsetX: 10,
                    offsetY: 10,
                    //overflow: false,
                    rotateWithView: true,
                    text: '\ue928',
                    textAlign: 'center',
                    textBaseline: 'middle',
                    fill: new ol.style.Fill({
                        color: 'rgba(0, 0, 255, 1)',
                    }),
                    //padding: [1, 1, 1, 1],
                    stroke: new ol.style.Stroke({
                        color: 'rgba(255, 0, 0, 0.5)',
                        width: 2
                    })
                })),
                zIndex: 2
            }),
            funnel: new ol.style.Style({
                text: new ol.style.Text(({
                    scale: 1,
                    font: 'normal 34px vicon-font',
                    //placement: 'point',
                    offsetX: 10,
                    offsetY: 10,
                    //overflow: false,
                    rotateWithView: true,
                    text: '\ue928',
                    textAlign: 'center',
                    textBaseline: 'middle',
                    fill: new ol.style.Fill({
                        color: 'rgba(0, 0, 255, 1)',
                    }),
                    //padding: [1, 1, 1, 1],
                    stroke: new ol.style.Stroke({
                        color: 'rgba(255, 0, 0, 0.5)',
                        width: 2
                    })
                })),
                zIndex: 2
            }),
            highlight: new ol.style.Style({
                fill: new ol.style.Fill({
                    color: [147, 147, 93, 0.8]
                }),
                stroke: new ol.style.Stroke({
                    color: [255, 0, 0, 1],
                    width: 2
                })
            }),
            note: new ol.style.Style({
                fill: new ol.style.Fill({
                    color: [252, 233, 168, 1]
                }),
                stroke: new ol.style.Stroke({
                    color: [255, 0, 0, 1],
                    width: 1
                }),
                text: new ol.style.Text(({
                    scale: 1,
                    font: 'normal 18px Arial',
                    offsetX: 0,
                    offsetY: 0,
                    rotateWithView: true,
                    textAlign: 'center',
                    textBaseline: 'middle',
                    //overflow: true,
                    fill: new ol.style.Fill({
                        color: [0, 0, 0, 1]
                    }),
                    stroke: new ol.style.Stroke({
                        color: [0, 0, 0, 0],
                        width: 1
                    }),
                    rotation: 0 //== Rotation in radians -2 to 2*Math.PI (1 Pi = 3.14 = 180 degrees)
                })),
                zIndex: 2
            })
        },
        hoverStyle: {
            highlight: new ol.style.Style({
                fill: new ol.style.Fill({
                    color: [147, 147, 93, 0.8]
                }),
                stroke: new ol.style.Stroke({
                    color: [53, 140, 216, 0.5],
                    width: 2
                })
            }),
            camera: new ol.style.Style({
                fill: new ol.style.Fill({
                    color: [147, 147, 93, 0.8]
                }),
                stroke: new ol.style.Stroke({
                    color: [53, 140, 216, 0.5],
                    width: 2
                })
            }),
            note: new ol.style.Style({
                fill: new ol.style.Fill({
                    color: [252, 233, 168, 1]
                }),
                stroke: new ol.style.Stroke({
                    color: [53, 140, 216, 1],
                    width: 1
                }),
                text: new ol.style.Text(({
                    scale: 1,
                    font: 'normal 18px Arial',
                    offsetX: 0,
                    offsetY: 0,
                    rotateWithView: true,
                    textAlign: 'center',
                    textBaseline: 'middle',
                    //overflow: true,
                    fill: new ol.style.Fill({
                        color: [0, 0, 0, 1]
                    }),
                    stroke: new ol.style.Stroke({
                        color: [0, 0, 0, 0],
                        width: 1
                    }),
                    rotation: 0 //== Rotation in radians -2 to 2*Math.PI (1 Pi = 3.14 = 180 degrees)
                })),
                zIndex: 2
            })
        },
        rotateStyles: {
            anchor: [
                new ol.style.Style({
                    image: new ol.style.RegularShape({
                        fill: new ol.style.Fill({
                            color: '#4a4a4a'
                        }),
                        stroke: new ol.style.Stroke({
                            color: '#bababa',
                            width: 1
                        }),
                        radius: 3,
                        points: 6
                    }),
                    zIndex: Infinity
                })
            ],
            arrow: [
                new ol.style.Style({
                    image: new ol.style.Icon({
                        //font: 'normal 20px vicon-font',
                        //offsetX: -1,
                        //offsetY: 0,
                        //text: '\u25EF',
                        //text: '\ue91e',
                        rotateWithView: false,
                        src: "images/icons/restore.png",
                        //textAlign: 'center',
                        // fill: new ol.style.Fill({
                        //     color: '#4a4a4a'
                        // }),
                        // stroke: new ol.style.Stroke({
                        //     color: 'white',
                        //     width: 2
                        // }),
                        scale: 0.02
                    }),
                    zIndex: Infinity
                }),
                new ol.style.Style({
                    stroke: new ol.style.Stroke({
                        color: 'white',
                        width: 3,
                        lineDash: [5, 5]
                    }),
                    text: new ol.style.Text({
                        font: '12px sans-serif',
                        offsetX: 20,
                        offsetY: -20,
                        fill: new ol.style.Fill({
                            color: '#4a4a4a'
                        }),
                        stroke: new ol.style.Stroke({
                            color: 'white',
                            width: 2
                        })
                    }),
                    zIndex: Infinity
                }),
                new ol.style.Style({
                    stroke: new ol.style.Stroke({
                        color: '#4a4a4a',
                        width: 2,
                        lineDash: [5, 5]
                    }),
                    zIndex: Infinity
                }),
                new ol.style.Style({
                    stroke: new ol.style.Stroke({
                        color: [0, 0, 0, 0.1],
                        width: 6,
                        lineDash: [5, 5]
                    }),
                    zIndex: Infinity
                })
            ]
        }
    };
    var MapsOpenLayers = /** @class */ (function () {
        //== constructor
        function MapsOpenLayers(mapsExternalLibrariesService) {
            var _this_1 = this;
            //== Defined Variables
            this.mapResourceDragOverClass = 'map-drag-over';
            this.stickeyCount = false;
            this.funnelCount = false;
            this.linkedCount = false;
            this.isContextMenuOpen = false;
            this.layersCount = 0;
            this.animationCout = 0;
            this.overLayList = [];
            this.selectedLinkedMap = null;
            this.selectedStickyNote = null;
            this.selectedOverlay = null;
            this.overlayDiffX = 0;
            this.overlayDiffY = 0;
            this.currentMousePoint = 0;
            this.isPanelSelected = false;
            this.clientX = null;
            this.clientY = null;
            this.playerOpen = false;
            this.playerOpenId = [];
            this.playerOpenIdQplayBack = [];
            this.lastZoom = 0;
            this.infoFeature = null;
            this.isExpended = false;
            this.linkedMapResources = [];
            this.defaultHome = {
                center: null,
                zoom: null
            };
            this.deltaXDiff = null;
            this.prePolledDataId = [];
            this.prePolledData = [];
            this.prePolledDataNvrId = [];
            this.prePolledDataPresetId = [];
            this.existingMap = false;
            this.isSysOnline = true;
            this.infoWindowTiomout = null;
            this.monitoringViewID = null;
            this.playbackResource = null;
            this.openPlayerIds = {};
            this.snapshotId = null;
            this.cameraInfoBoxId = null;
            this.cameraInfoBoxIdText = null;
            //== Main init function
            this.init = function () {
                // this.checkIsOnline();
            };
            //showOnMap
            //  public setMapSelectedResource = (resource: any, currentMap: any): void => {
            //      //clear existing cameras
            //      while (MapsOpenLayers.monitoringCameraResource.length > 0) {
            //          MapsOpenLayers.monitoringCameraResource.pop();
            //      }
            //      //add latest camera
            //      let objCurrentView = this.monitoringViewContainer.getActiveView();
            //      let mapObject = MapsOpenLayers.monitoringCameraResource.filter((r) => {
            //          return (r.map == currentMap._id && r.resource == resource._id && r.view == objCurrentView._id);
            //      })
            //      if (!mapObject || mapObject.length == 0) {
            //          MapsOpenLayers.isFromMonitoring++;
            //          MapsOpenLayers.monitoringCameraResource.push({ map: currentMap._id, resource: resource._id, view: objCurrentView ? objCurrentView._id : null });
            //      }
            //  }
            //  //========== Configurarion Settings - creating and editing Map ===========\\
            //  //== Create a map instance on Monitoring screen inside a Pane
            this.createMapForEdit = function (payload, controllerItem) {
                _this_1.controllerItem = controllerItem;
                _this_1.globalDataAccessPoint = controllerItem.globalDataAccessPoint;
                _this_1.mapResource = payload.resource;
                _this_1.mObjectPane = payload;
                var changeIconBtnId = document.getElementById("changeIconBtn");
                //console.log("changeIconBtnId=>", changeIconBtnId);
                if (changeIconBtnId) {
                    changeIconBtnId.setAttribute("disabled", 'true');
                    _this_1.scope.mapsIcon = true;
                    _this_1.eventDispatcher.fireEvent('DISABLE_CHANGE_ICON', null, _this_1.scope, _this_1.globalDataAccessPoint);
                }
                //const mapOuterElement:any = document.getElementById('config-maparea');
                var domContainer = payload.domContainer;
                var elementToRemove = domContainer.getElementsByClassName("map-monitoring-item");
                if (elementToRemove.length > 0) {
                    domContainer.removeChild(elementToRemove[0]);
                }
                var mapElement = angular.element('<div class="map-monitoring-item"></div>')[0];
                _this_1.mapElement = mapElement;
                _this_1.setDragResourceOverMap(mapElement);
                domContainer.appendChild(mapElement);
                _this_1.createOpenLayerMapOnConfig();
            };
            //  //== Setup drag resource over map 
            this.setDragResourceOverMap = function (mapElement) {
                //== Set drag over map event
                mapElement.ondragover = function (e) {
                    //== Must prevent default for enabling Drop Event            
                    e.preventDefault();
                    //== Prevent inserting same class name multiple times
                    if (!mapElement.classList.contains(_this_1.mapResourceDragOverClass)) {
                        mapElement.classList.add(_this_1.mapResourceDragOverClass);
                    }
                };
                //== Set drag map leave event
                mapElement.ondragleave = function (e) {
                    mapElement.classList.remove(_this_1.mapResourceDragOverClass);
                };
                //== Set resource drop to map event
                mapElement.ondrop = function (e) {
                    //var isHomeSet = this.isHomePositionSet();
                    //if (isHomeSet) {
                    mapElement.classList.remove(_this_1.mapResourceDragOverClass);
                    var strSerializedData = (e && e.dataTransfer) ? e.dataTransfer.getData("text") : "{}";
                    var draggedData = angular.fromJson(strSerializedData);
                    var resourceIdAdded = [];
                    angular.forEach(_this_1.mapResource.mapItems, function (ele) {
                        if (ele.type === 'MapItemPolygon') {
                            resourceIdAdded.push(ele.funnels.resourceId);
                        }
                        if (ele.type === 'MapItemImage') {
                            resourceIdAdded.push(ele.images.resourceId);
                        }
                    });
                    if (!!draggedData && draggedData.id && resourceIdAdded.indexOf(draggedData.id) < 0) {
                        /*@todo
                        $('.resources-in-views-inner #vms-treeview-' + draggedData.resourceIds[0]).css({ 'background': 'red', 'disabled': 'disabled' })
                        */
                        if (draggedData.id) {
                            _this_1.mObjectPane.resourcesArray.push(draggedData);
                            // this.globalDataAccessPoint.resources.byGuid[draggedData.id] = draggedData;
                        }
                        var eventCoordinates = _this_1.map.getEventCoordinate(e);
                        _this_1.addResourceToMapOnConfig(draggedData.id, eventCoordinates);
                    }
                    //}
                    //else {
                    //    this.controllerItem.showHomePositionSetAlert();
                    //}
                };
            };
            //  public updateCameraIcon = (addResource: any): any => {
            //      //const addResource: any = this.globalDataAccessPoint.resources.byGuid[resourceId];
            //      if (addResource.resourceType === 'VideoSource') {
            //          let FixedCamera = addResource.sourceProperties;
            //      }
            //  }
            //  //== Adding resource by drag it from Available Resources list to Map
            this.addResourceToMapOnConfig = function (resourceId, coordinates) {
                if (!resourceId) {
                    return;
                }
                //== get actual resource
                var addResource = _this_1.mObjectPane.resourcesArray.filter(function (item) {
                    return item.id == resourceId;
                })[0];
                //console.log('addResource', addResource);
                if (!addResource) {
                    return;
                }
                //bloking web link to drop on map
                if (addResource.resourceType == 'Url') {
                    return;
                }
                //bloking Maps from Group to drop on map for configuration
                if (addResource.resourceType == 'Map') {
                    return;
                }
                var CameraIconstyle = new CameraIcons(_this_1.mapResource.mapIconSize).icon1;
                var funnelIconStyle = new CameraIcons(_this_1.mapResource.mapIconSize).iconfunnel;
                //circel for 360 funnel
                var circleIconStyle = new CameraIcons(_this_1.mapResource.mapIconSize).iconCircle;
                var icon360Camera = new CameraIcons(_this_1.mapResource.mapIconSize).icon360Style;
                var icon360MixedCamera = new CameraIcons(_this_1.mapResource.mapIconSize).icon360MixedStyle;
                var iconThermal = new CameraIcons(_this_1.mapResource.mapIconSize).iconThermalStyle;
                var iconMobile = new CameraIcons(_this_1.mapResource.mapIconSize).iconMobileStyle;
                var check360Camera = _this_1.is360CameraItem(addResource);
                var getResourceStyle;
                if (addResource.isThermalRadar) {
                    getResourceStyle = iconThermal;
                    //check360Camera = true;
                }
                else if (addResource.isMobileDevice) {
                    getResourceStyle = iconMobile;
                    //check360Camera = true;
                }
                else if ((addResource.resourceType === 'MixedVideoSource' || addResource.resourceType === 'PtzMixedVideoSource') && check360Camera === true) {
                    getResourceStyle = icon360MixedCamera;
                }
                else if (check360Camera) {
                    getResourceStyle = icon360Camera;
                }
                else {
                    getResourceStyle = _this_1.getResourceStyle(addResource);
                }
                var iconFeature = new ol.Feature({
                    id: resourceId,
                    geometry: new ol.geom.Point(coordinates),
                    name: addResource.name,
                    type: mapDefaults.mapFeatureTypes.camera,
                    resourceId: resourceId,
                    alarm: false,
                    iconStyle: getResourceStyle,
                    description: check360Camera ? 'Camera360' : 'other',
                });
                iconFeature.setStyle(getResourceStyle);
                iconFeature.setId(resourceId); //== Set external feature ID, now getFeatureById can be used
                iconFeature.set("actualCoordinates", coordinates);
                iconFeature.set('defaultStyle', getResourceStyle);
                var self = _this_1;
                setTimeout(function () {
                    self.cameraVectorSource.addFeature(iconFeature);
                    self.testingDataPush.push(iconFeature);
                }, 100);
                // this.getRecordingStatus(iconFeature, addResource.nvrId);
                if (addResource.resourceType != 'View' && addResource.resourceType != 'DigitalInput' && addResource.resourceType != 'RelayOutput' && addResource.resourceType != 'AudioSource' && addResource.resourceType != 'Tour' && addResource.resourceType != 'PlaybackAudioSource' && addResource.resourceType != 'LPRSensorResource' && addResource.resourceType != 'VAXDoorResource' && addResource.resourceType != 'VAXActionPlanResource' && addResource.resourceType != 'FacialRecognitionResource') {
                    //circel for 360 funnel
                    var geoC = _this_1.getMapTypeDelta();
                    var geoMFunnel = check360Camera === true ? ol.geom.Polygon.fromCircle(new ol.geom.Circle(coordinates, .2 * geoC, 'XY')) : new ol.geom.Polygon([[coordinates, [coordinates[0] + .2 * geoC, coordinates[1] - .2 * geoC], [coordinates[0] + .2 * geoC, coordinates[1] + .2 * geoC]]]);
                    var fStyle = check360Camera === true ? circleIconStyle : funnelIconStyle;
                    // Added polygon shape to camera
                    var funnelIconFeature = new ol.Feature({
                        id: resourceId,
                        geometry: geoMFunnel,
                        //geometry: new ol.geom.Point(coordinates),
                        type: mapDefaults.mapFeatureTypes.funnel,
                        resourceId: resourceId,
                        iconStyle: fStyle,
                        description: check360Camera ? 'Camera360' : 'other',
                    });
                    funnelIconFeature.setStyle(check360Camera ? circleIconStyle : funnelIconStyle);
                    funnelIconFeature.setId(resourceId); //== Set external feature ID, now getFeatureById can be used
                    var self = _this_1;
                    setTimeout(function () {
                        self.funnelsVectorSource.addFeature(funnelIconFeature);
                        self.testingDataPush.push(funnelIconFeature);
                    }, 100);
                }
                //check:-> command to enable save button
                _this_1.controllerItem.setMapDirty();
            };
            //  //== Functions and map object for editing cureent map
            this.createOpenLayerMapOnConfig = function () {
                _this_1.map = _this_1.createMap(_this_1.mapElement);
                _this_1.createMapDataAndLayers(_this_1.map, _this_1.mapResource, _this_1.mapElement);
                _this_1.setupRightClickContextMenuForConfiguration(_this_1.mObjectPane);
                _this_1.setEditInteractions();
                _this_1.setOnMapMooveEvents();
                //  //Added for sticky notes
                _this_1.setAndUpdateStickyNoteInfo(_this_1.map);
                //  //resizing funnel
                _this_1.setFunnelLayerInteraction(_this_1.map);
                //  //Ends
                _this_1.setStickNoteLayerInteraction(_this_1.map);
                _this_1.setLinkedMapInteraction(_this_1.map);
                _this_1.setObjectNameOnConfig(_this_1.map, _this_1.mapResource);
                //  //Resize Icon 
                _this_1.setIconInteraction(_this_1.map);
                _this_1.setResizeMouseConfig();
                //Resize Icon End
                //resize font on zoom
                _this_1.internetOverlay();
                //this.setFontOnZoom(this.map);  // Uncomment if font resizing needed at config
                //end
                /*@todo for showing selected/added cameras
                angular.forEach(this.mapResource.mapItems, function (ele) {
                    //console.log('element data TESTINGNGNGN');
                    //console.log(ele);
                    if (ele.type === 'MapItemImage') {
                        //console.log('.resources-in-views-inner #vms-treeview-' + ele.images.resourceId)
                        $('.resources-in-views-inner #vms-treeview-' + ele.images.resourceId).css({ 'background': 'red', 'disabled': 'disabled' })
                    }
                })
                */
            };
            this.setResizeMouseConfig = function () {
                _this_1.map.on("pointermove", function (e) {
                    var mCoords = _this_1.map.getEventPixel(e.originalEvent);
                    var currentLayer = null;
                    _this_1.map.forEachFeatureAtPixel(mCoords, function (feature, layer) {
                        currentLayer = layer;
                        if (!!layer && layer == _this_1.funnelResizelayer || layer == _this_1.stickyNoteResizelayer || layer == _this_1.linkedMapResizelayer || layer == _this_1.iconResizelayer) {
                            _this_1.mapElement.style.cursor = "nw-resize";
                        }
                    });
                    if (!currentLayer) {
                        _this_1.mapElement.style.cursor = "";
                    }
                });
            };
            this.drawGeometry = function (coord) {
                var c = null;
                var geoC = _this_1.getMapTypeDelta();
                if (coord.length > 1) {
                    c = coord;
                }
                else {
                    c = coord[0][0];
                }
                var g = null;
                switch (_this_1.defaultShapeName) {
                    case 'Circle':
                        g = ol.geom.Polygon.fromCircle(new ol.geom.Circle(c, 0.08 * geoC, 'XY'));
                        break;
                    case 'Triangle':
                        g = new ol.geom.Polygon([[c, [c[0] + 0.1 * geoC, c[1] + 0.1 * geoC], [c[0] + 0.2 * geoC, c[1]], c]]);
                        break;
                    case 'Ractangle':
                        g = new ol.geom.Polygon([[c, [c[0], c[1] + 0.1 * geoC], [c[0] + 0.1 * geoC, c[1] + 0.1 * geoC], [c[0] + 0.1 * geoC, c[1]], c]]);
                        break;
                    case 'LeftArrow':
                        g = new ol.geom.Polygon([
                            [
                                c,
                                [c[0] + 0.1 * geoC, c[1] + 0.09 * geoC],
                                [c[0] + 0.1 * geoC, c[1] + 0.05 * geoC],
                                [c[0] + 0.15 * geoC, c[1] + 0.05 * geoC],
                                [c[0] + 0.15 * geoC, c[1] - 0.05 * geoC],
                                //[c[0] + 0.15, c[1] - 0.05],
                                [c[0] + 0.1 * geoC, c[1] - 0.05 * geoC],
                                [c[0] + 0.1 * geoC, c[1] - 0.09 * geoC],
                                c
                            ]
                        ]);
                        break;
                    case 'RightArrow':
                        g = new ol.geom.Polygon([
                            [
                                c,
                                [c[0] - 0.1 * geoC, c[1] + 0.09 * geoC],
                                [c[0] - 0.1 * geoC, c[1] + 0.05 * geoC],
                                [c[0] - 0.15 * geoC, c[1] + 0.05 * geoC],
                                [c[0] - 0.15 * geoC, c[1] - 0.05 * geoC],
                                [c[0] - 0.15 * geoC, c[1] - 0.05 * geoC],
                                [c[0] - 0.1 * geoC, c[1] - 0.05 * geoC],
                                [c[0] - 0.1 * geoC, c[1] - 0.09 * geoC],
                                c
                            ]
                        ]);
                        break;
                    case 'DownArrow':
                        g = new ol.geom.Polygon([
                            [
                                c,
                                [c[0] + 0.09 * geoC, c[1] + 0.1 * geoC],
                                [c[0] + 0.05 * geoC, c[1] + 0.1 * geoC],
                                [c[0] + 0.05 * geoC, c[1] + 0.15 * geoC],
                                [c[0] - 0.05 * geoC, c[1] + 0.15 * geoC],
                                [c[0] - 0.05 * geoC, c[1] + 0.15 * geoC],
                                [c[0] - 0.05 * geoC, c[1] + 0.1 * geoC],
                                [c[0] - 0.09 * geoC, c[1] + 0.1 * geoC],
                                c
                            ]
                        ]);
                        break;
                    case 'UpArrow':
                        g = new ol.geom.Polygon([
                            [
                                c,
                                [c[0] + 0.09 * geoC, c[1] - 0.1 * geoC],
                                [c[0] + 0.05 * geoC, c[1] - 0.1 * geoC],
                                [c[0] + 0.05 * geoC, c[1] - 0.15 * geoC],
                                [c[0] - 0.05 * geoC, c[1] - 0.15 * geoC],
                                [c[0] - 0.05 * geoC, c[1] - 0.15 * geoC],
                                [c[0] - 0.05 * geoC, c[1] - 0.1 * geoC],
                                [c[0] - 0.09 * geoC, c[1] - 0.1 * geoC],
                                c
                            ]
                        ]);
                        break;
                }
                return g;
            };
            this.updateShape = function (shape) {
                if (_this_1.selectedLinkedMap && _this_1.selectedLinkedMap.get('type') == 'linkedMapFeature') {
                    var coord = _this_1.selectedLinkedMap.getGeometry().getCoordinates();
                    var g = _this_1.drawGeometry(coord);
                    _this_1.selectedLinkedMap.setGeometry(g);
                    _this_1.selectedLinkedMap.set("shape", shape);
                    //check:-> command check
                    _this_1.controllerItem.setMapDirty();
                }
                else if (_this_1.selectedFeature && _this_1.selectedFeature.get('type') == 'resize_linkedMap_rec') {
                    var feature = _this_1.selectedFeature.get("feature");
                    var coord = feature.getGeometry().getCoordinates();
                    var g = _this_1.drawGeometry(coord);
                    feature.setGeometry(g);
                    feature.set("shape", shape);
                    //check:-> command check
                    _this_1.controllerItem.setMapDirty();
                }
            };
            this.updateOpacity = function (opacity) {
                if (_this_1.selectedLinkedMap && _this_1.selectedLinkedMap.get('type') == 'linkedMapFeature') {
                    var style = _this_1.selectedLinkedMap.getStyle();
                    var currentFill = style.getFill();
                    style.setFill(new ol.style.Fill({
                        color: [currentFill.color_[0], currentFill.color_[1], currentFill.color_[2], opacity]
                    }));
                    _this_1.selectedLinkedMap.setStyle(style);
                    _this_1.controllerItem.setMapDirty();
                }
                else if (_this_1.selectedFeature && _this_1.selectedFeature.get('type') == 'resize_linkedMap_rec') {
                    var feature = _this_1.selectedFeature.get("feature");
                    var style = feature.getStyle();
                    var currentFill = style.getFill();
                    style.setFill(new ol.style.Fill({
                        color: [currentFill.color_[0], currentFill.color_[1], currentFill.color_[2], opacity]
                    }));
                    feature.setStyle(style);
                    //check:-> command add
                    _this_1.controllerItem.setMapDirty();
                }
            };
            this.updateColor = function (color) {
                if (_this_1.selectedLinkedMap && _this_1.selectedLinkedMap.get('type') == 'linkedMapFeature') {
                    var style = _this_1.selectedLinkedMap.getStyle();
                    var currentFill = style.getFill();
                    var rgb = _this_1.hexToRgb(color);
                    style.setFill(new ol.style.Fill({
                        color: [rgb.r, rgb.g, rgb.b, currentFill.color_[3]]
                    }));
                    _this_1.selectedLinkedMap.setStyle(style);
                    _this_1.controllerItem.setMapDirty();
                }
                else if (_this_1.selectedFeature && _this_1.selectedFeature.get('type') == 'resize_linkedMap_rec') {
                    var feature = _this_1.selectedFeature.get("feature");
                    var style = feature.getStyle();
                    var currentFill = style.getFill();
                    var rgb = _this_1.hexToRgb(color);
                    style.setFill(new ol.style.Fill({
                        color: [rgb.r, rgb.g, rgb.b, currentFill.color_[3]]
                    }));
                    feature.setStyle(style);
                    _this_1.controllerItem.setMapDirty();
                }
            };
            this.updateFillColor = function () {
                if (_this_1.selectedLinkedMap && _this_1.selectedLinkedMap.get('type') == 'linkedMapFeature') {
                    var style = _this_1.selectedLinkedMap.getStyle();
                    var currentFill = style.getFill();
                    var rgb = _this_1.hexToRgb(_this_1.defaultFontColor);
                    style.setFill(new ol.style.Fill({
                        color: [rgb.r, rgb.g, rgb.b, currentFill.color_[3]]
                    }));
                    _this_1.selectedLinkedMap.setStyle(style);
                    _this_1.controllerItem.setMapDirty();
                }
                else if (_this_1.selectedFeature && _this_1.selectedFeature.get('type') == 'resize_linkedMap_rec') {
                    var feature = _this_1.selectedFeature.get("feature");
                    var style = feature.getStyle();
                    var currentFill = style.getFill();
                    var rgb = _this_1.hexToRgb(_this_1.defaultFontColor);
                    style.setFill(new ol.style.Fill({
                        color: [rgb.r, rgb.g, rgb.b, currentFill.color_[3]]
                    }));
                    feature.setStyle(style);
                    _this_1.controllerItem.setMapDirty();
                }
            };
            this.adjustRelatedFeaturesOnTranslate = function (e) {
                _this_1.mapConfigSelectInteraction.getFeatures().clear();
                //Dragging existing resource along with funnel
                var f = e.features.array_["0"];
                var currentCord = JSON.stringify(f.getGeometry().getCoordinates());
                var currentId = e.features.array_["0"].values_.resourceId;
                var currentType = e.features.array_["0"].values_.type;
                var scalvalues = e.features.array_["0"].get("scaleCoords");
                var coordinates = f.getGeometry().getCoordinates();
                //circle for 360 funnel
                if (!coordinates) {
                    coordinates = f.getGeometry().getCenter();
                }
                var extent = _this_1.map.getView().calculateExtent();
                var fCoord = f.getGeometry().getCoordinates();
                var dPoint = fCoord;
                if (fCoord.length == 1) {
                    var ext = f.getGeometry().getExtent();
                    dPoint = ol.extent.getCenter(ext);
                }
                if (dPoint[0] <= extent[0]) {
                    if (fCoord.length > 1)
                        fCoord[0] = extent[0];
                    else {
                        var dx_1 = Math.abs(dPoint[0] - extent[0]);
                        fCoord[0].forEach(function (c) {
                            c[0] = c[0] + dx_1;
                        });
                    }
                    f.getGeometry().setCoordinates(fCoord);
                }
                if (dPoint[0] >= extent[2]) {
                    if (fCoord.length > 1)
                        fCoord[0] = extent[2];
                    else {
                        var dx_2 = Math.abs(dPoint[0] - extent[2]);
                        fCoord[0].forEach(function (c) {
                            c[0] = c[0] - dx_2;
                        });
                    }
                    f.getGeometry().setCoordinates(fCoord);
                }
                if (dPoint[1] <= extent[1]) {
                    if (fCoord.length > 1)
                        fCoord[1] = extent[1];
                    else {
                        var dy_1 = Math.abs(dPoint[1] - extent[1]);
                        fCoord[0].forEach(function (c) {
                            c[1] = c[1] + dy_1;
                        });
                    }
                    f.getGeometry().setCoordinates(fCoord);
                }
                if (dPoint[1] >= extent[3]) {
                    if (fCoord.length > 1)
                        fCoord[1] = extent[3];
                    else {
                        var dy_2 = Math.abs(dPoint[1] - extent[3]);
                        fCoord[0].forEach(function (c) {
                            c[1] = c[1] - dy_2;
                        });
                    }
                    f.getGeometry().setCoordinates(fCoord);
                }
                if (!_this_1.mapResource || !_this_1.mapResource.mapItems)
                    return;
                var data = _this_1.mapResource.mapItems;
                angular.forEach(data, function (ele) {
                    if (ele.type === 'MapItemPolygon' && currentType == 'funnelIconFeature' && ele.funnels.resourceId == currentId) {
                        ele.funnels.coordinates = currentCord;
                    }
                    if (ele.type === 'MapItemImage' && currentType == 'iconFeature' && ele.images.resourceId == currentId) {
                        ele.images.coordinates = currentCord;
                    }
                });
                /*angular.forEach(this.testingDataPush, (ele2) => {
                    if (ele2.get('type') === 'iconFeature' && ele2.get('resourceId') == currentId && currentType == 'funnelFeature') { // has moved funnel
                        //set for camera/image
                        let rotation = ele2.get('rotation');
                        let iconGeometry = new ol.geom.Point(coordinates[0][0]);
                        ele2.set('geometry', iconGeometry);
                        //need to extend to set rotaion
                        ele2.getGeometry().rotate(rotation, coordinates[0][0]);
                        ele2.set('rotation', rotation);
                        e.features.array_["0"].set("actualCoordinates", coordinates);
                        angular.forEach(data, function (ele3) {
                            if (ele3.type === 'MapItemImage' && currentType == 'funnelFeature' && ele3.images.resourceId == ele2.get('resourceId')) {
                                ele3.images.coordinates = JSON.stringify(coordinates[0][0])
                            }
                        })
                    }
                    // set resize scalling
                    if (ele2.get('resourceId') == currentId && currentType == 'iconFeature') {
                        //adjust resize geom translation
                        let funExistingXY = f.get("actualCoordinates");
                        if (funExistingXY) {
                            let x = funExistingXY[0]
                            let y = funExistingXY[1];
                            let deltaX = coordinates[0] - x;
                            let deltaY = coordinates[1] - y;
                            if (scalvalues) {
                                scalvalues[0].forEach((c) => {
                                    c[0] = c[0] + deltaX;
                                    c[1] = c[1] + deltaY;
                                });
                                e.features.array_["0"].set("scaleCoords", scalvalues);
                            }
                            e.features.array_["0"].set("actualCoordinates", coordinates);
                        }
                        //end
                    }
                    else if (ele2.get('type') === 'iconFeature' && ele2.get('resourceId') == currentId && currentType == 'funnelFeature') {
                        let funExistingXY = ele2.get("actualCoordinates");
                        let sValues = ele2.get("scaleCoords");
                        if (funExistingXY) {
                            let x = funExistingXY[0]
                            let y = funExistingXY[1];
                            let aCoordinates = ele2.getGeometry().getCoordinates();
                            let deltaX = aCoordinates[0] - x;
                            let deltaY = aCoordinates[1] - y;
                            if (sValues) {
                                sValues[0].forEach((c) => {
                                    c[0] = c[0] + deltaX;
                                    c[1] = c[1] + deltaY;
                                });
                                ele2.set("scaleCoords", sValues);
                            }
                            ele2.set("actualCoordinates", aCoordinates);
                        }
                    }
                    //end
                    if (ele2.get('type') === 'funnelFeature' && ele2.get('resourceId') == currentId && currentType == 'iconFeature') {// has move camera
                        //set for funnel
                        let funExistingXY = ele2.getGeometry().getCoordinates();
                        let x = funExistingXY[0][0][0];
                        let y = funExistingXY[0][0][1];
                        let deltaX = coordinates[0] - x;
                        let deltaY = coordinates[1] - y;
                        let x1Delta = (this.x1Delta == undefined) ? .2 : this.x1Delta;
                        let x2Delta = (this.x2Delta == undefined) ? .2 : this.x2Delta;
                        let y1Delta = (this.y1Delta == undefined) ? .2 : this.y1Delta;
                        let y2Delta = (this.y2Delta == undefined) ? .2 : this.y2Delta;
                        ele2.getGeometry().translate(deltaX, deltaY);
                        angular.forEach(data, (ele3) => {
                            //funnel redraw
                            if (ele3.type === 'MapItemPolygon' && currentType == 'iconFeature' && ele3.funnels.resourceId == ele2.get('resourceId')) {
                                ele3.funnels.coordinates = JSON.stringify([[coordinates, [coordinates[0] + x1Delta, coordinates[1] - y1Delta], [coordinates[0] + x2Delta, coordinates[1] + y2Delta]]]);
                            }
                        })
                    }
                })*/
                angular.forEach(_this_1.getAllFeaturesForSave(), function (ele) {
                    var resourceId = ele.get('resourceId');
                    if (resourceId == currentId && currentType == 'funnelIconFeature' && ele.get('type') === 'iconFeature') {
                        if (ele.get('description') == 'Camera360') {
                            var iconExtent = f.getGeometry().getExtent();
                            var iconCenter = ol.extent.getCenter(iconExtent);
                            var iconGeometry = new ol.geom.Point(iconCenter);
                            ele.set('geometry', iconGeometry);
                        }
                        else {
                            var iconGeometry = new ol.geom.Point(coordinates[0][0]);
                            ele.set('geometry', iconGeometry);
                        }
                    }
                    if (resourceId == currentId && currentType == 'iconFeature' && ele.get('type') === 'funnelIconFeature') {
                        var geom = ele.getGeometry();
                        var coord = geom.getCoordinates();
                        var x = coordinates[0];
                        var y = coordinates[1];
                        if (ele.get('description') == 'Camera360') {
                            var gextent = geom.getExtent();
                            var center = ol.extent.getCenter(gextent);
                            var deltaX = x - center[0];
                            var deltaY = y - center[1];
                            geom.translate(deltaX, deltaY);
                        }
                        else {
                            var deltaX = x - coord[0][0][0];
                            var deltaY = y - coord[0][0][1];
                            geom.translate(deltaX, deltaY);
                        }
                    }
                    var objFeature = ele;
                    if (objFeature.values_.type == "stickyNoteFeature") {
                        _this_1.map.getLayers().forEach(function (l) {
                            if (l.get('name') == "notes") {
                                var s = l.getSource();
                                var f_1 = s.getFeatures();
                                f_1.forEach(function (fItem) {
                                    if (fItem.getId() == objFeature.getId()) {
                                        var coords = objFeature.getGeometry().getCoordinates();
                                        fItem.getGeometry().setCoordinates([coords[0].slice(1, 7)]);
                                    }
                                });
                            }
                        });
                    }
                });
                // scale funnel,sticky and link high light shapes with point 
                _this_1.translateFunnel(currentType, coordinates, f);
                _this_1.translateNote(currentType, coordinates, f);
                _this_1.translateLinkedMap(currentType, coordinates, f);
                //Resize Icon
                _this_1.translateIcon(currentType, coordinates, f);
                //Resize Icon End
                //end
                _this_1.controllerItem.setMapDirty();
            };
            //  //== Only one selected feature will be editable  
            this.setEditInteractions = function () {
                var select;
                var modify;
                var translate;
                var test;
                //======== Dragging any feature on map 
                //== User can drag any feature on map
                translate = new ol.interaction.Translate({});
                translate.on('translating', function (e) {
                    _this_1.adjustRelatedFeaturesOnTranslate(e);
                });
                translate.on('translateend', function (e) {
                    _this_1.adjustRelatedFeaturesOnTranslate(e);
                });
                var dTest = _this_1.funnelLayer;
                // Get the array of features
                var features = dTest.getSource().getFeatures();
                _this_1.map.addInteraction(translate);
                //== Allow selecting any feature on map
                _this_1.mapConfigSelectInteraction = new ol.interaction.Select({
                    toggleCondition: ol.events.condition.never,
                    layers: [_this_1.cameraImagesLayer, _this_1.funnelLayer, _this_1.linkedMapsLayer],
                });
                _this_1.map.addInteraction(_this_1.mapConfigSelectInteraction);
                //== On select will triger both select and deselect
                _this_1.mapConfigSelectInteraction.on('select', function (e) {
                    var selected = e.selected;
                    var deselected = e.deselected;
                    //== deselecting all features - no features selected
                    deselected.forEach(function (feature) {
                        //  this.eventDispatcher.fireEvent('DISABLE_CHANGE_ICON', feature, this.scope, this.globalDataAccessPoint);
                        if (feature.get('type') != 'iconFeature' || feature.get('type') != 'linkedMapFeature') {
                            _this_1.mapConfigSelectInteraction.getFeatures().clear();
                            _this_1.editingFeature = null;
                        }
                    });
                    //== set selected style for feature
                    selected.forEach(function (feature) {
                        //Change Icon
                        //enabling change Icon on clicking on resources
                        if (feature.get('type') != 'linkedMapFeature' && feature.get('type') !== 'funnelIconFeature') {
                            // this.eventDispatcher.fireEvent('ENABLE_CHANGE_ICON', feature, this.scope, this.globalDataAccessPoint);
                        }
                        //enabling rotate line for video resources
                        var addResource = null;
                        var resourceId = feature.get("resourceId");
                        if (feature.get('type') == 'iconFeature') {
                            _this_1.setAngleDisplacement(feature);
                        }
                        if (resourceId && resourceId != '') {
                            addResource = _this_1.globalDataAccessPoint.resources.byGuid[resourceId];
                        }
                        //enabling rotate line for video resources
                        if (feature.get('description') == 'Camera360' && (feature.get('type') != 'iconFeature' || feature.get('type') != 'linkedMapFeature')) {
                            _this_1.mapConfigSelectInteraction.getFeatures().clear();
                        }
                        else if (addResource && (addResource.resourceType == 'DigitalInput' || addResource.resourceType == 'RelayOutput' || addResource.resourceType == 'AudioSource' || addResource.resourceType == 'View' || addResource.resourceType == 'Tour' || addResource.resourceType == 'LPRSensorResource' || addResource.resourceType == 'VAXDoorResource')) {
                            _this_1.mapConfigSelectInteraction.getFeatures().clear();
                        }
                        else {
                            _this_1.editingFeature = feature; //== save this feature globally
                            //for camera icon
                            console.log("feature.get('type') ", feature.get('type'));
                            console.log("this.mapConfigRotateInteraction ", _this_1.mapConfigRotateInteraction);
                            if ((feature.get('type') == 'iconFeature' || feature.get('type') == 'linkedMapFeature') && !_this_1.mapConfigRotateInteraction) {
                                _this_1.setFeatureRotation();
                            }
                            //else {
                            var angle = _this_1.editingFeature.getStyle().getImage().getRotation() * -1;
                            //set angle when this rotation starts
                            if (_this_1.mapConfigRotateInteraction) {
                                _this_1.mapConfigRotateInteraction.setAngle(angle);
                            }
                            //}
                            //for funnel shape style
                            if (feature.get('type') == 'funnelIconFeature' && feature.get('description') != 'Camera360') {
                                _this_1.mapConfigSelectInteraction.getFeatures().clear();
                                var funnelStyle = new CameraIcons(_this_1.mapResource.mapIconSize).iconfunnel;
                                feature.setStyle(funnelStyle);
                            }
                            //for sticky note
                            if (feature.get('type') == 'stickyNoteFeature') {
                                var stickyNotesStyle = new CameraIcons(_this_1.mapResource.mapIconSize).iconStickyNotes;
                                var colorName = _this_1.getCurrentAppliedColor();
                                var fontSize = _this_1.getCurrentAppliedSize();
                                var fontName = _this_1.getCurrentAppliedName();
                                var combineFontStyle = fontSize + ' ' + fontName;
                                stickyNotesStyle.getText().getFill().setColor(colorName);
                                stickyNotesStyle.getText().setFont(combineFontStyle);
                                feature.setStyle(stickyNotesStyle);
                            }
                        }
                    });
                });
                //======== Modifying selected feature        
                _this_1.map.on('pointermove', function (e) {
                    if (e.dragging) {
                        return;
                    }
                    var mouseCoordinates = _this_1.map.getEventPixel(e.originalEvent);
                    //this.onFeatureHover(mouseCoordinates, e);
                });
            };
            this.setGDA = function (data) {
                _this_1.globalDataAccessPoint = data;
            };
            this.divideString = function (str, width, spaceReplacer) {
                if (str.length > width) {
                    var p = width;
                    while (p > 0 && (str[p] != ' ' && str[p] != '-')) {
                        p--;
                    }
                    if (p > 0) {
                        var left;
                        if (str.substring(p, p + 1) == '-') {
                            left = str.substring(0, p + 1);
                        }
                        else {
                            left = str.substring(0, p);
                        }
                        var right = str.substring(p + 1);
                        var str1 = left + spaceReplacer + _this_1.divideString(right, width, spaceReplacer);
                        return str1;
                    }
                }
                console.log("divided string: ", str);
                return str;
            };
            //  //Added for Sticky notes setAndUpdateStickyNoteInfo    
            this.setAndUpdateStickyNoteInfo = function (map) {
                //  let singelClickedStickyNote: HTMLElement = document.getElementById('getStickyNoteBox');
                //  if (!singelClickedStickyNote) {
                //      singelClickedStickyNote = angular.element('<div id="getStickyNoteBox" style="background-color:rgb(26, 32, 40);padding: 1em;width: 300px;min-height: 300px;margin: 0 30px 30px 0;z-index: 1;position: relative;display: block;"><a href="javascript:;" style="float:right" id="stickynote-popup-closer" title="Close">X</a><span style="margin-bottom: 12px;display:block; color:#fff;font-weight:600;" id="noteTitle">Enter Note</span><div id="textAreaLimitError"></div><div><textarea id="getStickyNoteBoxDesc" placeholder="Enter Note Description here" style="background-color: transparent;border: none;width: 100%;min-height: 250px;background-color: #f6f6f6;"></textarea></div><div><button title="Save Your Note" style="background-color: transparent;color: #358cd8;border: 1px solid #358cd8;margin: auto;flex-grow: 1;transition: 100ms;outline: none;margin-left: 0px;margin-top: 10px;white-space: nowrap;padding: 0 10px;font-family: Arial, Helvetica, sans-serif;" id="stickyNoteBtn">Save Your Note</button></div></div>')[0];
                //      document.body.appendChild(singelClickedStickyNote);
                //  }
                //  let stickyNoteBox = new ol.Overlay({
                //      id: 'singelClickedStickyNote',
                //      element: singelClickedStickyNote,
                //      stopEvent: false,
                //      positioning: 'center-center',
                //      offset: [0, 0],
                //      autoPan: true
                //  });
                //  stickyNoteBox.set("name", "stickynoteOverlay");
                //  map.addOverlay(stickyNoteBox);
                var allTempStickyNoteFeature = [];
                //dblclick to open sticky note popup
                //let stickyNoteBoxpopup = map.getOverlayById('singelClickedStickyNote');
                map.on("click", function (e) {
                    map.forEachFeatureAtPixel(e.pixel, function (feature, layer) {
                        _this_1.selectedFeature = feature;
                        var currentId = _this_1.selectedFeature.getId();
                        if (_this_1.selectedFeature.values_.type === 'stickyNoteFeature') {
                            _this_1.selectedStickyNote = feature;
                            _this_1.selectedLinkedMap = null;
                            var featureCurrentStyle = _this_1.selectedFeature.getStyle();
                            var currentFont = featureCurrentStyle.getText().getFont();
                            var currentFill = featureCurrentStyle.getFill();
                            var opacity = null;
                            if (currentFill)
                                opacity = currentFill.color_[3];
                            var fSize = currentFont.split(" ")[0];
                            var fName = currentFont.split(" ")[1];
                            var currentColor = featureCurrentStyle.getText().getFill().getColor();
                            //check:-> command to update current font, color, size to controller
                            var payload = {
                                type: "stickynote",
                                fontSize: fSize,
                                fontName: fName,
                                color: currentColor,
                                opacity: 1,
                                shape: "",
                                id: currentId
                            };
                            _this_1.defaultFontColor = currentColor;
                            _this_1.defaultFontName = fName;
                            _this_1.defaultFontSize = fSize;
                            console.log("default values: ", _this_1.defaultFontColor, ",  ", _this_1.defaultFontName, ", ", _this_1.defaultFontSize);
                            _this_1.controllerItem.mapFeatureClicked(payload);
                        }
                        else if (_this_1.selectedFeature.values_.type === 'linkedMapFeature') {
                            _this_1.selectedLinkedMap = feature;
                            _this_1.selectedStickyNote = null;
                            var featureCurrentStyle = _this_1.selectedFeature.getStyle();
                            var currentFill = featureCurrentStyle.getFill();
                            var opacity = null;
                            var color = null;
                            var shape = _this_1.selectedFeature.get("shape");
                            if (currentFill) {
                                opacity = currentFill.color_[3];
                                color = _this_1.rgbToHex(currentFill.color_[0], currentFill.color_[1], currentFill.color_[2]);
                            }
                            //check:-> command to update current font, color, shape to controller
                            var payload = {
                                type: "highlight",
                                fontSize: 0,
                                fontName: "",
                                color: color,
                                opacity: opacity,
                                shape: shape,
                                id: currentId
                            };
                            _this_1.controllerItem.mapFeatureClicked(payload);
                        }
                        else if (_this_1.selectedFeature.values_.type === 'funnelIconFeature') {
                            var payload = {
                                type: "funnel",
                                fontSize: 0,
                                fontName: "",
                                color: "#FFFFFF",
                                opacity: 1,
                                shape: "",
                                id: currentId
                            };
                            _this_1.controllerItem.mapFeatureClicked(payload);
                        }
                        else {
                            var payload = {
                                type: "icon",
                                fontSize: 0,
                                fontName: "",
                                color: "#FFFFFF",
                                opacity: 1,
                                shape: "",
                                id: currentId
                            };
                            _this_1.controllerItem.mapFeatureClicked(payload);
                        }
                    });
                });
                map.on('dblclick', function (evt) {
                    //check:-> command to open popup for text description
                    evt.preventDefault();
                    map.forEachFeatureAtPixel(evt.pixel, function (feature, layer) {
                        if (layer.get('name') == mapDefaults.mapLayers.stickyNotesLayer || layer.get('name') == mapDefaults.mapLayers.linkedMapsLayer) {
                            var resourceId = feature.getId();
                            var geom = feature.getGeometry();
                            var featureExtent = geom.getExtent();
                            var featureCenter = ol.extent.getCenter(featureExtent);
                            var center = featureCenter;
                            // allTempStickyNoteFeature.push(feature);
                            // stickyNoteBoxpopup.setPosition(center);
                            var fStyle = feature.getStyle();
                            var featureDescription = "";
                            if (fStyle && fStyle.getText()) {
                                if (fStyle.getText().getText() != "Please double click to update notes")
                                    featureDescription = (layer.get('name') == mapDefaults.mapLayers.stickyNotesLayer) ? feature.get("textvalue") : fStyle.getText().getText();
                                else
                                    featureDescription = "";
                            }
                            else {
                                featureDescription = "";
                            }
                            if (layer.get('name') == mapDefaults.mapLayers.stickyNotesLayer) {
                                var payload = {
                                    type: "stickynote",
                                    id: resourceId,
                                    x: center[0],
                                    y: center[1],
                                    text: featureDescription
                                };
                                _this_1.controllerItem.mapFeatureDoubleClicked(payload);
                            }
                            else if (layer.get('name') == mapDefaults.mapLayers.linkedMapsLayer) {
                                var payload = {
                                    type: "highlight",
                                    id: resourceId,
                                    x: center[0],
                                    y: center[1],
                                    text: featureDescription
                                };
                                _this_1.controllerItem.mapFeatureDoubleClicked(payload);
                            }
                            //this.map.getInteractions().forEach((interaction) => { interaction.setActive(false); });
                        }
                    });
                });
                //closing sticky note popup
                //  let closer: HTMLElement = document.getElementById('stickynote-popup-closer');
                //  if (closer) {
                //      closer.onclick = () => {
                //          stickyNoteBoxpopup.setPosition(undefined);
                //          closer.blur();
                //          this.map.getInteractions().forEach((interaction) => { interaction.setActive(true); });
                //          return false;
                //      };
                //  }
                //get sticky note popup value
                //  let getStickyNoteBtn: HTMLElement = document.getElementById('stickyNoteBtn');
                //  let stickyNoteBoxDesc = <HTMLTextAreaElement>$("#getStickyNoteBoxDesc")[0];
                //  if (getStickyNoteBtn) {
                //      getStickyNoteBtn.onclick = () => {
                //          let source;
                //          let feature;
                //          let stickyNotesStyle = new CameraIcons(this.mapResource.mapIconSize).iconStickyNotes;
                //          let shapeStyle = new CameraIcons(this.mapResource.mapIconSize).shapeStyle;
                //          let stickyNoteBoxDescVal = stickyNoteBoxDesc.value.replace(/\s+/g, " ");
                //          let featureCurrentStyle;
                //          var tempCurrentId;
                //          allTempStickyNoteFeature.forEach(function (featureItem) {
                //              if (featureItem.values_.type === 'stickyNoteFeature' || featureItem.values_.type === 'linkedMapFeature') {
                //                  tempCurrentId = featureItem.getId();
                //                  if (!tempCurrentId) {
                //                      tempCurrentId = featureItem.values_.id;
                //                  }
                //              }
                //          });
                //          map.getLayers().forEach((layer) => {
                //              if (layer instanceof ol.layer.Vector) {
                //                  source = layer.getSource();
                //                  feature = source.getFeatures();
                //                  feature.forEach((featureItem) => {
                //                      featureCurrentStyle = featureItem.getStyle();
                //                      let currentId = featureItem.getId();
                //                      if (!currentId) {
                //                          currentId = featureItem.values_.id;
                //                      }
                //                      if (featureItem.values_.type === 'stickyNoteFeature' && currentId == tempCurrentId) {
                //                          featureItem.setProperties({ 'id': currentId, 'resourceId': currentId, 'type': 'stickyNoteFeature' });
                //                          stickyNotesStyle = featureItem.getStyle();
                //                          let text = stickyNotesStyle.getText().getText();
                //                          if (text != stickyNoteBoxDescVal) {
                //                              this.map.getLayers().forEach((l: any) => {
                //                                  if (l.get('name') == "notes") {
                //                                      let s = l.getSource();
                //                                      let f = s.getFeatures();
                //                                      f.forEach((fItem: any) => {
                //                                          if (fItem.getId() == featureItem.getId()) {
                //                                              let stl = fItem.getStyle();
                //                                              let coordinates = featureItem.getGeometry().getCoordinates();
                //                                              let diffCoords = coordinates[0][4][0] - coordinates[0][3][0];
                //                                              let textSize = Math.ceil((MapsOpenLayers.TEXT_DELTA / 100.0) * diffCoords);
                //                                              stl.getText().setText(this.divideString(stickyNoteBoxDescVal, textSize, "\n"));
                //                                              fItem.setStyle(stl);
                //                                          }
                //                                      });
                //                                  }
                //                              })
                //                              featureItem.set("textvalue", stickyNoteBoxDescVal)
                //                              featureItem.setStyle(stickyNotesStyle);
                //                              this.selectedFeature = featureItem;
                //                              this.controllerItem.setMapDirty();
                //                              this.map.getInteractions().forEach((interaction) => { interaction.setActive(true); });
                //                          }
                //                      }
                //                      else if (featureItem.values_.type === 'linkedMapFeature' && currentId == tempCurrentId) {
                //                          shapeStyle = featureItem.getStyle();
                //                          let text = shapeStyle.getText().getText();
                //                          if (text != stickyNoteBoxDescVal) {
                //                              shapeStyle.getText().setText(stickyNoteBoxDescVal);
                //                              featureItem.setStyle(shapeStyle);
                //                              this.selectedFeature = featureItem;
                //                              this.controllerItem.setMapDirty();
                //                              this.map.getInteractions().forEach((interaction) => { interaction.setActive(true); });
                //                          }
                //                      }
                //                  });
                //              }
                //          });
                //          stickyNoteBoxpopup.setPosition(undefined);
                //          closer.blur();
                //          return false;
                //      };
                //      //issue for "Save your Note" is not enabled even if the sticky note does not have 100 characters
                //      stickyNoteBoxDesc.onkeyup = () => {
                //          let textAreaLimitErrorId: any = document.getElementById('textAreaLimitError');
                //          if (stickyNoteBoxDesc.value.length == 0) {
                //              getStickyNoteBtn.style.color = '#6d727c';
                //              getStickyNoteBtn.style.border = '1px solid #6d727c';
                //              getStickyNoteBtn.setAttribute("disabled", 'true');
                //              this.map.getInteractions().forEach((interaction) => { interaction.setActive(false); });
                //          }
                //          else if (stickyNoteBoxDesc.value.length <= 100) {
                //              let errorTextTag = textAreaLimitErrorId.getElementsByTagName("span")[0];
                //              if (errorTextTag) {
                //                  textAreaLimitErrorId.removeChild(errorTextTag);
                //              }
                //              getStickyNoteBtn.removeAttribute("disabled");
                //              getStickyNoteBtn.style.color = '#358cd8';
                //              getStickyNoteBtn.style.border = '1px solid #358cd8';
                //              this.map.getInteractions().forEach((interaction) => { interaction.setActive(false); });
                //              return true;
                //          }
                //          else {
                //              let errorText = document.createElement("span");
                //              let errorTextMsg = document.createTextNode("Maximum 100 charecter can Add.");
                //              errorText.appendChild(errorTextMsg);
                //              errorText.setAttribute("style", "color: red;");
                //              if (textAreaLimitErrorId.childElementCount == 0) {
                //                  textAreaLimitErrorId.appendChild(errorText);
                //              }
                //              getStickyNoteBtn.style.color = '#6d727c';
                //              getStickyNoteBtn.style.border = '1px solid #6d727c';
                //              getStickyNoteBtn.setAttribute("disabled", 'true');
                //              this.map.getInteractions().forEach((interaction) => { interaction.setActive(false); });
                //              return false;
                //          }
                //      }
                //      // end
                //  }
            };
            //Ends
            //  // Change Properties of styling highlight
            //  public updateHighlightStyle = (field: string, value: any): void => {
            //      switch (field) {
            //          case "shape":
            //              if (value)
            //                  (document.getElementById("populateShapeName") as HTMLInputElement).value = value;
            //              break;
            //          case "opacity":
            //              if (value) {
            //                  (document.querySelector("#populateShapeOpacity span") as HTMLElement).style.left = `${value}%`;
            //                  (document.getElementById("chaged-opacity-span") as HTMLElement).innerHTML = `${value}%`;
            //                  (document.getElementById("auto-opacity-span") as HTMLElement).style.display = "none";
            //                  (document.getElementById("chaged-opacity-span") as HTMLElement).style.display = "block";
            //              }
            //              break;
            //          case "color":
            //              if (value) {
            //                  (document.getElementById("populateFontColors-highlight") as HTMLInputElement).value = value;
            //                  (document.getElementById("populateFontColors-highlight") as HTMLInputElement).style.color = value;
            //                  (document.getElementById("populateFontColors-highlight") as HTMLInputElement).style.background = value;
            //              }
            //              break;
            //          default:
            //              break;
            //      }
            //  }
            this.getFunnelFeature = function (currentSelectedFeature) {
                var funnelFeature;
                var currentCamResourceId = currentSelectedFeature.values_.resourceId;
                _this_1.map.getLayers().forEach(function (layer) {
                    if (layer instanceof ol.layer.Vector) {
                        var source = layer.getSource();
                        var feature = source.getFeatures();
                        feature.forEach(function (featureItem) {
                            if (featureItem.values_.type === 'funnelIconFeature' && currentCamResourceId === featureItem.values_.resourceId) {
                                funnelFeature = featureItem;
                            }
                        });
                    }
                });
                return funnelFeature;
            };
            this.rotateFunnel = function (currentSelectedFeature, currentAngel) {
                var camCoordinates = currentSelectedFeature.getGeometry().getCoordinates();
                var flip = currentSelectedFeature.get("flip");
                var currentCamResourceId = currentSelectedFeature.values_.resourceId;
                var ang = currentSelectedFeature.getStyle().getImage().getRotation();
                var tempAngle = _this_1.convertAngleDisplay(ang * 180 / Math.PI);
                _this_1.map.getLayers().forEach(function (layer) {
                    if (layer instanceof ol.layer.Vector) {
                        var source = layer.getSource();
                        var feature = source.getFeatures();
                        var x1Delta_1 = (_this_1.x1Delta == undefined) ? .2 : _this_1.x1Delta;
                        var x2Delta_1 = (_this_1.x2Delta == undefined) ? .2 : _this_1.x2Delta;
                        var y1Delta_1 = (_this_1.y1Delta == undefined) ? .2 : _this_1.y1Delta;
                        var y2Delta_1 = (_this_1.y2Delta == undefined) ? .2 : _this_1.y2Delta;
                        feature.forEach(function (featureItem) {
                            if (featureItem.values_.type === 'funnelIconFeature' && currentCamResourceId === featureItem.values_.resourceId) {
                                var iconGeometryFunnel = new ol.geom.Polygon([[camCoordinates, [camCoordinates[0] + x1Delta_1, camCoordinates[1] - y1Delta_1], [camCoordinates[0] + x2Delta_1, camCoordinates[1] + y2Delta_1]]]);
                                if (flip) {
                                    iconGeometryFunnel = new ol.geom.Polygon([[camCoordinates, [camCoordinates[0] - x1Delta_1, camCoordinates[1] + y1Delta_1], [camCoordinates[0] - x2Delta_1, camCoordinates[1] - y2Delta_1]]]);
                                }
                                //circle for 360
                                if (featureItem.values_.description == 'Camera360') {
                                    iconGeometryFunnel = ol.geom.Polygon.fromCircle(new ol.geom.Circle(camCoordinates, 0.2, 'XY'));
                                }
                                featureItem.set('geometry', iconGeometryFunnel);
                                featureItem.getGeometry().rotate((-tempAngle * Math.PI / 180), camCoordinates);
                                featureItem.set('rotation', (-tempAngle * Math.PI / 180));
                            }
                        });
                    }
                });
            };
            //  //======== Rotating selected feature
            this.setFeatureRotation = function () {
                var RotateFeatureInteraction = _this_1.mapsExternalLibrariesService.getMapsRotateFeature();
                _this_1.mapConfigRotateInteraction = new RotateFeatureInteraction({
                    features: _this_1.mapConfigSelectInteraction.getFeatures(),
                    angle: 0,
                    style: _this_1.createRotateIconStyle()
                });
                var currentFeatures = null;
                var rotatingImageFeature = null;
                // this.linkedMapResizeSource.clear();
                //== get feature we about to rotate
                _this_1.mapConfigRotateInteraction.on('rotatestart', function (e) {
                    currentFeatures = _this_1.mapConfigSelectInteraction.getFeatures();
                    currentFeatures.forEach(function (feature) {
                        var angle = 0;
                        var featureType = feature.get('type');
                        //== Camera Default (text) or custom image
                        if (featureType == mapDefaults.mapFeatureTypes.camera) {
                            rotatingImageFeature = feature;
                            if (_this_1.editingFeature.get('cameraIconType') == mapDefaults.mapCameraTypes.image) {
                                try {
                                    angle = _this_1.editingFeature.getStyle().getImage().getRotation() * -1;
                                }
                                catch (ex) { }
                            }
                            else {
                                try {
                                    angle = _this_1.editingFeature.getStyle().getImage().getRotation() * -1;
                                }
                                catch (ex) { }
                            }
                        }
                        if (angle) {
                            _this_1.mapConfigRotateInteraction.setAngle(angle);
                            feature.set('rotation', angle);
                        }
                    });
                });
                //== if this is imge we need to rotate it manualy - RotateF Plugin does not rotates images
                _this_1.mapConfigRotateInteraction.on('rotating', function (e) {
                    //check:-> temp comment
                    _this_1.funnelResizeSource.clear();
                    _this_1.stickyNoteResizeSource.clear();
                    _this_1.linkedMapResizeSource.clear();
                    if (!!rotatingImageFeature) {
                        if (!!e.angle) {
                            try {
                                var currentAngel = void 0;
                                rotatingImageFeature.getStyle().getImage().setRotation(-e.angle);
                                rotatingImageFeature.set('rotation', -e.angle);
                                /* Setting funnel rotation on camera changes by Nikhil */
                                currentAngel = -e.angle;
                                _this_1.rotateFunnel(rotatingImageFeature, currentAngel);
                                /* Ends Setting funnel rotation on camera changes*/
                            }
                            catch (ex) { }
                            try {
                                rotatingImageFeature.getStyle().getImage().setRotation(-e.angle);
                                rotatingImageFeature.set('rotation', -e.angle);
                            }
                            catch (ex) { }
                        }
                    }
                });
                //== changing controller to Dirty on rotate
                _this_1.mapConfigRotateInteraction.on('rotateend', function (e) {
                    //check:-> command to enable save button
                    _this_1.controllerItem.setMapDirty();
                    rotatingImageFeature = null;
                });
                _this_1.map.addInteraction(_this_1.mapConfigRotateInteraction);
            };
            //  //== Creating Rotating Line
            this.createRotateIconStyle = function () {
                return function (feature, resolution) {
                    var style;
                    var angle = feature.get('angle') || 0;
                    //== Setup an initial angle of Rotating Line
                    if (!angle && !!_this_1.editingFeature) {
                        if (_this_1.editingFeature.get('type') == mapDefaults.mapFeatureTypes.camera) {
                            if (_this_1.editingFeature.get('cameraIconType') == mapDefaults.mapCameraTypes.image) {
                                try {
                                    angle = _this_1.editingFeature.getStyle().getImage().getRotation() * -1;
                                }
                                catch (ex) { }
                            }
                        }
                    }
                    switch (true) {
                        case feature.get('rotate-anchor'):
                            style = mapStyles.rotateStyles.anchor;
                            return style;
                        case feature.get('rotate-arrow'):
                            style = mapStyles.rotateStyles.arrow;
                            var coordinates = feature.getGeometry().getCoordinates();
                            // generate arrow polygon
                            var line = new ol.geom.LineString([
                                coordinates,
                                [coordinates[0], coordinates[1] + 85 * resolution]
                            ]);
                            var endPoint = new ol.geom.Point([coordinates[0], coordinates[1] + 95 * resolution]);
                            //== applying all styles to rotating line
                            for (var i = 1; i < style.length; i++) {
                                style[i].setGeometry(line);
                            }
                            style[0].setGeometry(endPoint);
                            // and rotate it according to current angle
                            line.rotate(angle, coordinates);
                            endPoint.rotate(angle, coordinates);
                            //== convert Radiant angle to 360 degrees based angle for displaying
                            var tempAngle = _this_1.convertAngleDisplay(-angle * 180 / Math.PI);
                            var text = tempAngle + '°';
                            style[1].getText().setText(text);
                            return style;
                    }
                };
            };
            //  //== on rotation angle can be infinite - we need to show and save only -359 to 359 
            //  //== Rotation in radians -2 to 2 * Math.PI (1 Pi = 3.14 = 180 degrees)
            this.convertAngleDisplay = function (angle) {
                var tempAngle = angle;
                if (angle >= 360) {
                    tempAngle = angle % 360;
                }
                else if (angle <= -360) {
                    tempAngle = angle % 360;
                }
                if (tempAngle < 0) {
                    tempAngle = 360 + tempAngle;
                }
                return Math.round(tempAngle);
            };
            //  //Added to generate random number including alphabets for Sticky Note
            //  /**
            //  * RANDOM STRING GENERATOR
            //  *
            //  * Use:       randomString(length [,"A"] [,"N"] );
            //  * Default:   return a random alpha-numeric string
            //  * Arguments: If you use the optional "A", "N" flags:
            //  *            "A" (Alpha flag)   return random a-Z string
            //  *            "N" (Numeric flag) return random 0-9 string
            //  */
            this.randomStringGenerator = function () {
                return Math.floor((1 + Math.random()) * 0x10000).toString(16).substring(1);
            };
            //  /**
            //  * Convert RANDOM STRING GENERATOR id to GUID
            //  **/
            this.randomStringToGuidConverter = function () {
                return "ss-s-s-s-sss".replace(/s/g, _this_1.randomStringGenerator());
            };
            //  public onFeatureHover = (mouseCoordinates: ol.Coordinate, e: any): void => {
            //      const feature = this.map.forEachFeatureAtPixel(mouseCoordinates, (feature: ol.Feature, layer: ol.layer.Layer): ol.Feature => {
            //          if (!!layer && layer.get('name') != mapDefaults.mapLayers.funnelLayer) {
            //              return feature;
            //          }
            //      });
            //      //== Do not change style when hovering Feature in Edit mode
            //      if (!!feature && feature == this.editingFeature) {
            //          return;
            //      }
            //  }
            //  //== get all features existing on map
            this.getAllFeaturesForSave = function () {
                var allFeatures = [];
                var featuresList;
                //== Get Cameras
                if (!!_this_1.cameraVectorSource) {
                    featuresList = _this_1.cameraVectorSource.getFeatures();
                    if (!!featuresList) {
                        featuresList.forEach(function (feature) {
                            allFeatures.push(feature);
                        });
                    }
                }
                //== Get Funnels
                if (!!_this_1.funnelsVectorSource) {
                    featuresList = _this_1.funnelsVectorSource.getFeatures();
                    if (!!featuresList) {
                        featuresList.forEach(function (feature) {
                            allFeatures.push(feature);
                        });
                    }
                }
                //== Get Highlights
                if (!!_this_1.linkedMapsVectorSource) {
                    featuresList = _this_1.linkedMapsVectorSource.getFeatures();
                    if (!!featuresList) {
                        featuresList.forEach(function (feature) {
                            allFeatures.push(feature);
                        });
                    }
                }
                //== Get Sticky Notes
                if (!!_this_1.stickyNotesVectorSource) {
                    featuresList = _this_1.stickyNotesVectorSource.getFeatures();
                    if (!!featuresList) {
                        featuresList.forEach(function (feature) {
                            allFeatures.push(feature);
                        });
                    }
                }
                return allFeatures;
            };
            this.deleteStickyNote = function (payload) {
                //check:-> need command to get confirmation from user before delete
                console.log("Delete Feature Payload Object ::", payload);
                console.log("Action Type ::", payload.ActionType);
                var obj = _this_1.objectToDelete;
                if (payload.ActionType == 'Ok') {
                    if (!!obj.data) {
                        _this_1.funnelResizeSource.clear();
                        //check:-> temp commented 2 lines
                        _this_1.stickyNoteResizeSource.clear();
                        _this_1.linkedMapResizeSource.clear();
                        if (!!obj.data) {
                            _this_1.mapConfigSelectInteraction.getFeatures().clear();
                            _this_1.map.removeInteraction(_this_1.mapConfigRotateInteraction);
                            _this_1.mapConfigRotateInteraction = null;
                            _this_1.removeFeatureFromLayer(obj.data.feature, obj.data.layer);
                            _this_1.removeItemFromMapResource(obj.data.feature);
                            //enable delete button 
                            //check:-> command to make save button enabled
                            _this_1.controllerItem.setMapDirty();
                        }
                    }
                }
                else {
                    //check:-> command to make save button enabled
                    _this_1.controllerItem.setMapDirty();
                }
                //  let messageBuilder = {
                //      body: {
                //          text: this.languageService.getValueByKey('maps_single_delete_confirm') + "'?",
                //          controls: true,
                //          yes: this.languageService.getValueByKey('yes'),
                //          no: this.languageService.getValueByKey('no')
                //      },
                //      headerText: this.languageService.getValueByKey('_delete_')
                //  };
                //  if (obj.data.hasOwnProperty('feature') && obj.data.feature.values_.type == "stickyNoteFeature") {
                //      messageBuilder.body.text = this.languageService.getValueByKey('delete_sticky_note') + "?";
                //      messageBuilder.headerText = this.languageService.getValueByKey('_sticky_note')
                //  }
                //  if (obj.data.hasOwnProperty('feature') && obj.data.feature.values_.type == "iconFeature") {
                //      messageBuilder.body.text = this.languageService.getValueByKey('delete_device_map') + "?";
                //      messageBuilder.headerText = this.languageService.getValueByKey('_delete_device');
                //  }
                //  if (obj.data.hasOwnProperty('feature') && obj.data.feature.values_.type == "linkedMapFeature") {
                //      if (obj.data.feature.values_.hasOwnProperty('featureType') && obj.data.feature.values_.featureType == "unlinked") {
                //          messageBuilder.body.text = this.languageService.getValueByKey('delete_unlinked_map') + "?";
                //          messageBuilder.headerText = this.languageService.getValueByKey('_unlinked_map');
                //      } else {
                //          messageBuilder.body.text = this.languageService.getValueByKey('delete_linked_map') + "?";
                //          messageBuilder.headerText = this.languageService.getValueByKey('_linked_map');
                //      }
                //  }
                //  this.confirmService.fire(
                //      //== Yes clicked
                //      () => {
                //          if (!!obj.data) {
                //              this.funnelResizeSource.clear();
                //              this.stickyNoteResizeSource.clear();
                //              this.linkedMapResizeSource.clear();
                //              if (!!obj.data) {
                //                  this.mapConfigSelectInteraction.getFeatures().clear();
                //                  this.map.removeInteraction(this.mapConfigRotateInteraction);
                //                  this.mapConfigRotateInteraction = null;
                //                  this.removeFeatureFromLayer(obj.data.feature, obj.data.layer);
                //                  this.removeItemFromMapResource(obj.data.feature);
                //                  //enable delete button 
                //                  var ctr = angular.element(document.getElementById("populateFontSize")).controller();
                //                  if (ctr) {
                //                      ctr.setDirty();
                //                  }
                //              }
                //          }
                //      },
                //      //== No clicked
                //      () => { },
                //      null,
                //      messageBuilder
                //  );
            };
            //  //== creating a right click menu on  feature click in configuration 
            this.setupRightClickContextMenuForConfiguration = function (objPane) {
                var Delete_icon = 'images/icons/trash.png';
                var Vertical_icon = 'images/icons/flip-vertical.png';
                var Horizantal_icon = 'images/icons/flip-horizontal.png';
                var show_property_icon = 'images/icons/show_property.png';
                var lpr_show_property_icon = 'images/icons/lpr_info_icon.svg';
                var deleteFeature = function (obj) {
                    var type = obj.data.feature.values_.type;
                    var resourceId = obj.data.feature.values_.id;
                    var payload = {
                        "Type": type,
                        "Id": resourceId
                    };
                    _this_1.objectToDelete = obj;
                    var obj1 = new ThickClientCommunication();
                    obj1.callBackToThickClientFunction('showConfirmationDialog', payload);
                    //   this.deleteStickyNote(obj,payload);
                };
                var toDegree = function (radian) {
                    return radian * 180 / Math.PI;
                };
                var toRadian = function (degree) {
                    return degree * (Math.PI / 180);
                };
                var contextmenu_items = [
                    {
                        text: "Delete",
                        callback: deleteFeature,
                        data: {},
                        icon: Delete_icon,
                    },
                    {
                        text: '',
                        data: { type: 'asset' },
                        icon: show_property_icon,
                    },
                    {
                        text: '',
                        data: { type: 'sensorIp' },
                        icon: lpr_show_property_icon,
                    },
                    {
                        text: 'Flip Horizontal',
                        data: { flipType: "horizontal" },
                        callback: _this_1.flipFeature,
                        icon: Horizantal_icon
                    },
                    {
                        text: 'Flip Vertical',
                        data: { flipType: "vertical" },
                        callback: _this_1.flipFeature,
                        icon: Vertical_icon
                    }
                    // Ends Sub Menu to right click on camera in configuration
                ];
                var onMenuOpen = function () {
                };
                var options = {
                    items: contextmenu_items,
                    width: 180,
                    onopen: onMenuOpen,
                    layersOn: [],
                    layersOff: [mapDefaults.mapLayers.funnelLayer, mapDefaults.mapLayers.mapLayer, "funnelIconLayer"]
                };
                _this_1.setupRightClickContextMenu(options, objPane);
            };
            //  //flip icons
            this.flipFeature = function (e) {
                ////console.log(e.data.feature);
                // this.funnelResizeSource.clear();
                // this.stickyNoteResizeSource.clear();
                // this.linkedMapResizeSource.clear();
                if (!e.data || !e.data.feature)
                    return;
                if (e.data.flipType == 'vertical')
                    _this_1.applyFlip(e.data.feature, false, true); // parameters: - feature, horizontal,vertical
                else
                    _this_1.applyFlip(e.data.feature, true, false);
            };
            this.applyFlip = function (feature, flip, flop, fromLoading) {
                if (flip === void 0) { flip = false; }
                if (flop === void 0) { flop = false; }
                if (fromLoading === void 0) { fromLoading = false; }
                var style = feature.getStyle();
                var src = style.getImage().getSrc();
                var canvasEle = document.createElement("canvas");
                var context = canvasEle.getContext("2d");
                canvasEle.height = 128;
                canvasEle.width = 128;
                var rotateOnItsAxis = function (canvas, ctx, image, angle, flip, flop) {
                    var img = new Image();
                    img.height = 128;
                    img.width = 128;
                    img.onload = function () {
                        var cache = img; //cache the local copy of image element for future reference
                        var iw = cache.width;
                        var ih = cache.height;
                        ctx.save(); //saves the state of canvas
                        ctx.clearRect(0, 0, canvas.width, canvas.height); //clear the canvas
                        ctx.translate(canvas.width / 2, canvas.height / 2); //let's translate
                        if (flip || flop)
                            angle = -angle;
                        ctx.rotate(angle * Math.PI / 180); //increment the angle and rotate the image 
                        var flipScale;
                        var flopScale;
                        flip ? flipScale = -1 : flipScale = 1;
                        flop ? flopScale = -1 : flopScale = 1;
                        ctx.scale(flipScale, flopScale);
                        ctx.translate(-(canvas.width / 2), -(canvas.height / 2)); //let's translate
                        //  ctx.scale(-1, 1);
                        ctx.drawImage(img, canvas.width / 2 - iw / 2, canvas.height / 2 - ih / 2, iw, ih); //draw the image ;)
                        ctx.restore(); //restore the state of canvas
                        var scaleValue = feature.get("scaleValue");
                        var imIcon = new ol.style.Icon({
                            anchor: new CameraIcons(_this_1.mapResource.mapIconSize).anchorSize,
                            size: new CameraIcons(_this_1.mapResource.mapIconSize).getIconSize(_this_1.mapResource.mapIconSize),
                            opacity: 1,
                            scale: scaleValue ? scaleValue : new CameraIcons(_this_1.mapResource.mapIconSize).getIconScale(_this_1.mapResource.mapIconSize),
                            src: canvas.toDataURL(),
                            rotation: feature.getStyle().getImage().getRotation()
                        });
                        style.setImage(imIcon);
                        feature.setStyle(style);
                        if (flip) {
                            var flipValue = feature.get("flip");
                            feature.set("flip", flipValue ? !flipValue : true);
                        }
                        if (flop) {
                            var flopValue = feature.get("flop");
                            feature.set("flop", flopValue ? !flopValue : true);
                        }
                        if (!fromLoading) {
                            _this_1.map.getLayers().forEach(function (l) {
                                if (l.get('name') == "funnelIconLayer") {
                                    var s = l.getSource();
                                    var f = s.getFeatures();
                                    f.forEach(function (fItem) {
                                        if (fItem.values_.resourceId == feature.values_.resourceId) {
                                            var fcoords_1 = feature.getGeometry().getCoordinates();
                                            var iCoords = fItem.getGeometry().getCoordinates();
                                            if (flip) {
                                                iCoords[0].forEach(function (c) {
                                                    var deltaX = fcoords_1[0] - c[0];
                                                    c[0] = c[0] + (deltaX * 2);
                                                    var deltaY = fcoords_1[1] - c[1];
                                                    c[1] = c[1] + (deltaY * 2);
                                                });
                                            }
                                            fItem.getGeometry().setCoordinates(iCoords);
                                        }
                                    });
                                }
                            });
                            _this_1.controllerItem.setMapDirty();
                        }
                    };
                    if (image.split("/").length == 2) {
                        var imgArrayElement = image.split("/")[1];
                        if (img64[imgArrayElement.toLowerCase()])
                            img.src = img64[imgArrayElement.toLowerCase()];
                        else
                            img.src = image;
                    }
                    else
                        img.src = image; //img
                };
                rotateOnItsAxis(canvasEle, context, src, 0, flip, flop);
            };
            //  //flip icons
            this.removeFeatureFromLayer = function (feature, layer) {
                if (!!layer && !!feature) {
                    var source = layer.getSource();
                    try {
                        switch (feature.values_.type) {
                            case "linkedMapFeature":
                                _this_1.linkedMapsVectorSource.removeFeature(feature);
                                break;
                            case "stickyNoteFeature":
                                //set text for polygon
                                var noteFeature_1 = null;
                                _this_1.map.getLayers().forEach(function (l) {
                                    if (l.get('name') == "notes") {
                                        var s = l.getSource();
                                        var f = s.getFeatures();
                                        f.forEach(function (fItem) {
                                            if (fItem.getId() == feature.getId()) {
                                                noteFeature_1 = fItem;
                                            }
                                        });
                                    }
                                });
                                if (noteFeature_1)
                                    _this_1.noteSource.removeFeature(noteFeature_1);
                                //end
                                _this_1.stickyNotesVectorSource.removeFeature(feature);
                                break;
                            default:
                                _this_1.cameraVectorSource.removeFeature(feature);
                                var funnelFeature = _this_1.getFunnelFeature(feature);
                                _this_1.funnelsVectorSource.removeFeature(funnelFeature);
                        }
                    }
                    catch (err) { }
                }
            };
            //  //============= Displaying Map in monitoring on Pane ===============\\
            //  //== Create a map instance on Monitoring screen inside a Pane
            this.createMapForMonitoring = function (objPane) {
                objPane._id = objPane.id;
                //this.setViewID();
                var domContainer = objPane.domContainer;
                //try {
                //    let ln = domContainer.childNodes.length;
                //}
                //catch (e) {
                //    domContainer = objPane.domContainer[0]
                //    domContainer.appendChild(this.fnCreateHeader());
                //}
                _this_1.mObjectPane = objPane;
                for (var i = 1; i < domContainer.childNodes.length; i++) {
                    domContainer.childNodes[i].style.setProperty("display", "none");
                }
                _this_1.monitoringViewID = Math.round(Date.now() + Math.random());
                //////it will reinitialize the player when dropped...
                ////objPane.vmsPlayerId = null;
                ////end
                //if (!domContainer) throw new Error("paneModule.executeResourceSpecificLogic: No domContainer defined on the pane!");
                //try {
                //    domContainer.querySelector(".vms-player-resource-title").textContent = objPane.resource.name;
                //} catch (e) {
                //}
                ////== Remove an existing map item before re-creating a new one
                var elementToRemove = domContainer.getElementsByClassName("map-monitoring-item");
                if (elementToRemove.length > 0) {
                    domContainer.removeChild(elementToRemove[0]);
                }
                //== setting draggable="true" removes default monitoring pane drag event
                _this_1.mapElement = angular.element('<div class="map-monitoring-item geocoder-css" draggable="true" data-pane-id="' + objPane.id + '" data-resource-id="' + objPane.resource.id + '"></div>')[0];
                //== remove VMSLayout drag event
                _this_1.mapElement.ondragstart = function (e) {
                    e.stopImmediatePropagation();
                    if (!MapsOpenLayers.currentResourceId.id)
                        return false;
                    var img = new Image();
                    img.src = MapsOpenLayers.currentResourceId.img;
                    img.width = 30;
                    img.height = 30;
                    e.dataTransfer.setDragImage(img, 0, 0, e.target);
                    e.dataTransfer.setData("text", angular.toJson({ "resourceType": "ResourceGroup", "resourceIds": [MapsOpenLayers.currentResourceId.id], pane: _this_1.mObjectPane.id }));
                };
                _this_1.mapElement.ondragend = function (e) {
                    e.stopImmediatePropagation();
                    MapsOpenLayers.currentResourceId.id = null;
                    MapsOpenLayers.currentResourceId.name = null;
                    _this_1.mapElement.style.cursor = 'pointer';
                };
                domContainer.appendChild(_this_1.mapElement);
                _this_1.mapResource = objPane.resource;
                //show on Map
                _this_1.fromMonitoring = true;
                //== creating Map
                _this_1.createOpenLayerMapOnMonitoring(objPane);
                ////== creating control panel 
                ////this.createControlPannel(objPane);
                ////Added changes to maintain local storage for zoom in/out and funnel  
                var viewId = _this_1.monitoringViewID;
                if (localStorage.getItem('zoomIn' + objPane._id + viewId) != null) {
                    var zoomInLayer = parseFloat(localStorage.getItem('zoomIn' + objPane._id + viewId));
                    var view = _this_1.map.getView();
                    view.animate({
                        zoom: zoomInLayer,
                        duration: 200
                    });
                }
                objPane.mapInstance = _this_1;
            };
            this.createMapForGallery = function (objPane) {
                var domContainer = objPane.domContainer;
                var elementToRemove = domContainer.getElementsByClassName("geo-loadBgImg");
                if (elementToRemove.length > 0) {
                    domContainer.removeChild(elementToRemove[0]);
                }
                _this_1.mapResource = objPane.resource;
                var mapElementCls = angular.element('<div class="geo-loadBgImg"></div>')[0];
                var GEOmapElement = mapElementCls;
                domContainer.appendChild(mapElementCls);
                _this_1.createOpenLayerGEOMapOnMapGallaryPopUp(GEOmapElement);
            };
            this.createOpenLayerGEOMapOnMapGallaryPopUp = function (GEOmapElement) {
                var GEOMap = _this_1.createGEOMap(GEOmapElement);
                _this_1.createGEOMapDataAndLayers(GEOMap);
            };
            this.createGEOMap = function (GEOmapElement) {
                var GEOMap;
                if (GEOmapElement) {
                    GEOMap = new ol.Map({
                        target: GEOmapElement,
                        interactions: ol.interaction.defaults({ doubleClickZoom: false, dragPan: false }),
                        controls: []
                    });
                    return GEOMap;
                }
                //== save current map sizes - canvas size
                //const mapSize = GEOMap.getSize();
                // mapWidth = mapSize[0];
                // mapHeight = mapSize[1];
                return GEOMap;
            };
            this.createGEOMapDataAndLayers = function (GEOMap) {
                GEOMap.setLayerGroup(new ol.layer.Group());
                var GEOMapLayersData = [];
                var home = _this_1.getInitialHomePosition();
                //mapOuterElement
                _this_1.bgMapImageLayer = new ol.layer.Tile({
                    source: new ol.source.OSM()
                });
                GEOMap.addLayer(_this_1.bgMapImageLayer);
                var view = new ol.View({
                    center: [0, 0],
                    zoom: 3,
                    minZoom: 3
                });
                if (!home.initial) {
                    view = new ol.View({
                        center: home.center,
                        zoom: home.zoom,
                        minZoom: 3
                    });
                }
                _this_1.bgMapImageLayer.set('name', 'bgMapImageLayer');
                GEOMap.setView(view);
                _this_1.setMapGalleryData(GEOMapLayersData);
            };
            this.setMapGalleryData = function (GEOMapLayersData) {
                if (_this_1.bgMapImageLayer) {
                    _this_1.bgMapImageLayer.setZIndex(1);
                    GEOMapLayersData.push(_this_1.bgMapImageLayer);
                }
            };
            //  //== creating map control panel with saved position
            this.createControlPannel = function (objPane) {
                var controlPanelWidth = 50;
                var controlPanelHeight = 350;
                var paneId = objPane.resource.id;
                var mapContainerSize = objPane.domContainer.getBoundingClientRect();
                //      //== creating an HTML DOM element
                var controlEle = _this_1.mapElement.getElementsByClassName('map-controls-panel draggable-panel custom-panel');
                var controlsElement = null;
                if (controlEle && controlEle.length > 0) {
                    _this_1.mapElement.removeChild(controlEle[0]);
                    controlsElement = angular.element('<div  class="map-controls-panel draggable-panel custom-panel" draggable="true" data-pane-id="' + objPane.id + '" data-resource-id="' + objPane.resource.id + '"><div class="map-controls-drag"><span></span></div></div>')[0];
                    _this_1.mapElement.appendChild(controlsElement);
                    //  controlsElement.setProperty("data-pane-id", objPane.id);
                    //  controlsElement.setProperty("data-resource-id", objPane.resource.id);
                }
                else {
                    controlsElement = angular.element('<div  class="map-controls-panel draggable-panel custom-panel" draggable="true" data-pane-id="' + objPane.id + '" data-resource-id="' + objPane.resource.id + '"><div class="map-controls-drag"><span></span></div></div>')[0];
                    _this_1.mapElement.appendChild(controlsElement);
                }
                //      //== Get session data for stored panel position
                //      const mapPanels = this.cacheManager.localStorage.get("mapPanels");
                var mapPanels = objPane.resource.mapPanels;
                if (!!mapPanels) {
                    //          //== parse as JSON and check is this panel have saved data
                    //          let mapPanelsArr = JSON.parse(mapPanels);
                    //          if (!!mapPanelsArr && mapPanelsArr[paneId]) {
                    //              //== check map container (Pane) size before restoring Pane - it can be out of the boundaries
                    if (mapContainerSize.width > mapPanels.left + controlPanelWidth
                        &&
                            mapContainerSize.height > mapPanels.top + controlPanelHeight) {
                        controlsElement.style.left = mapPanels.left + 'px';
                        controlsElement.style.top = mapPanels.top + 'px';
                    }
                    //          }
                }
                //      //== remove double click event on Control Panel - prevent opening fulscreen
                //      controlsElement.ondblclick = (e: any): boolean => {
                //          e.stopImmediatePropagation();
                //          return false;
                //      };
                //      //== setup dragging
                _this_1.setupPanelDragging(controlsElement, _this_1.mapElement, 20);
                //      //== inserting Controls to DOM
                //      //Passing objPane param to createMapControlsFunctionality for Zoom in/out
                //      if (!this.existingMap) {
                _this_1.createMapControlsFunctionality(controlsElement, objPane);
                //      } else {
                //          // map control related fixes start
                //          let controls: any = this.map.getControls();
                //          let controlArray = [
                //              "overviewToggleControl",
                //              //"mapOverview",
                //              "zInControl",
                //              "zOutcontrol",
                //              "funnelToggleControl",
                //              "linkedMapTextControl",
                //              "linkedToggleControl",
                //              "stickyToggleControl",
                //              "homeControl",
                //              "backButtonControll",
                //              "searchButtonControl"
                //          ];
                //          if (!controls || !controls.array_ || controls.array_.length == 0) return;
                //          //let elementControl = angular.element(controlsElement);
                //          let isControlDrawn: any = false;
                //          for (let i = 0; i < controls.array_.length; i++) {
                //              let name: any = controls.array_[i].get("name");
                //              if (controlArray.indexOf(name) < 0) {
                //                  if (controls.array_[i].get("name") == "mapOverview") {
                //                      this.mapElement.appendChild(controls.array_[i].element);
                //                      controls.array_[i].setTarget(this.mapElement);
                //                  }
                //                  continue;
                //              }
                //              this.mObjectPane = objPane;
                //              if (controls.array_[i].get("name") == "backButtonControll") {
                //                  let pane:any = this.map.get("map_pane");
                //                  if (this.globalDataAccessPoint.olMapDataLink[pane._id] && this.globalDataAccessPoint.olMapDataLink[pane._id].length > 0)
                //                      controls.array_[i].element.style.setProperty("display", "block");
                //                  else
                //                      controls.array_[i].element.style.setProperty("display", "none");
                //              }
                //              controlsElement.appendChild(controls.array_[i].element);
                //              controls.array_[i].setTarget(controlsElement);
                //              isControlDrawn = true;
                //          }
                //          if (isControlDrawn == false)
                //              this.createMapControlsFunctionality(controlsElement, objPane);
                //      }
                //      //Ends
            };
            this.resetMapControl = function () {
                _this_1.createControlPannel(_this_1.mObjectPane);
            };
            //  //== saving panel position on drag stop
            this.savePanelCurrentPosition = function (dragElem) {
                var paneId = dragElem.dataset.resourceId;
                var item = {
                    left: parseInt(dragElem.style.left) > 0 ? parseInt(dragElem.style.left) : 0,
                    top: parseInt(dragElem.style.top) > 0 ? parseInt(dragElem.style.top) : 0
                };
                //== Get session data for stored panel position
                var mapPanels = localStorage.get("mapPanels");
                //== get saved data or creating new array
                var mapPanelsArr = JSON.parse(mapPanels) || {};
                //== if this data exists we need to add/replace
                mapPanelsArr[paneId] = item;
                //== Saving data
                localStorage.set("mapPanels", JSON.stringify(mapPanelsArr));
            };
            //  //== set up dragging element inside other element (if supplied)
            this.setupPanelDragging = function (dragElem, boundariesElem, topOffcet) {
                if (!dragElem || !boundariesElem)
                    return;
                topOffcet = topOffcet || 0;
                var myWindow = window;
                var dragElemSize;
                var elemX, elemY;
                var startX, startY;
                var limits;
                var limitLeft, limitRight, limitTop, limitBottom;
                var isLimitSet = false;
                dragElem.dragging = false;
                var pointElement = dragElem.getElementsByClassName('map-controls-drag')[0];
                //      //== Start moving - calculating start position
                pointElement.onmousedown = function (event) {
                    event = event || window.event;
                    myWindow.dragElem = dragElem;
                    myWindow.dragElem.dragging = true;
                    startX = event.clientX;
                    startY = event.clientY;
                    dragElemSize = dragElem.getBoundingClientRect();
                    elemX = dragElem.offsetLeft;
                    elemY = dragElem.offsetTop;
                    limits = boundariesElem.getBoundingClientRect();
                    limitLeft = 0;
                    limitRight = limits.width - dragElemSize.width;
                    limitTop = topOffcet;
                    limitBottom = limits.height - dragElemSize.height + topOffcet;
                    if (limitRight < 0) {
                        limitRight = 0;
                    }
                    if (limitBottom < 0) {
                        limitBottom = 0;
                    }
                };
                //      //== On mouse move - moving element by setting it's position
                boundariesElem.onmousemove = function (event) {
                    event = event || window.event;
                    if (!!myWindow.dragElem && myWindow.dragElem.dragging === true && myWindow.dragElem.dataset.panelId == boundariesElem.dataset.panelId) {
                        var mouseX = parseFloat(event.clientX) - startX + elemX;
                        var mouseY = parseFloat(event.clientY) - startY + elemY;
                        if (isNaN(mouseX) || isNaN(mouseY)) {
                            //== out of current pane - start and elem will be undefined
                        }
                        else {
                            //== check boundaries
                            myWindow.dragElem.style.left = Math.min(Math.max(mouseX, 0), limitRight) + "px";
                            myWindow.dragElem.style.top = Math.min(Math.max(mouseY, limitTop), limitBottom) + "px";
                        }
                    }
                };
                //      //== Stop moving when mouse released
                document.onmouseup = function (event) {
                    event = event || window.event;
                    if (!!myWindow.dragElem && myWindow.dragElem.dragging === true) {
                        myWindow.dragElem.dragging = false;
                        _this_1.savePanelCurrentPosition(myWindow.dragElem);
                        myWindow.dragElem = null;
                    }
                };
            };
            this.createMapControlsFunctionality = function (controlsElement, objPane) {
                //      //============ Add Small Overview Map
                _this_1.createOverviewMap(controlsElement, objPane);
                //      //======== Zoom Map control
                //      //Added code to saperate zoom in/out functionality
                var zoomInControl = /** @class */ (function (_super) {
                    __extends(zoomInControl, _super);
                    // element: any;
                    function zoomInControl(opt_options) {
                        if (opt_options === void 0) { opt_options = null; }
                        var _this_1 = _super.call(this, {}) || this;
                        var options = opt_options || {};
                        //== Options received from constructor
                        var layerName = options.layerName;
                        var className = options.className; //'ol-zoom-in';
                        var buttonInner = options.buttonInner;
                        var name = options.name;
                        var map = options.map;
                        var viewContainer = options.viewContainer;
                        var getLayersByName = options.getLayersByName;
                        var layerObj = getLayersByName(layerName);
                        var eventDispatcher = options.eventDispatcher;
                        var AUDITLOGMSGES = options.AUDITLOGMSGES;
                        //== layer not exists on current map - not creating a button
                        if (!layerObj) {
                            return _this_1;
                        }
                        //== Creating a button 
                        var button = document.createElement('button');
                        button.appendChild(angular.element(buttonInner)[0]);
                        button.title = name;
                        button.className = className;
                        button.style.setProperty("background-color", "#353f4c");
                        //== click function
                        var zoomInButtonPressed = function (e) {
                            var view = map.getView();
                            var zoom = view.getZoom();
                            view.animate({
                                zoom: zoom + 1,
                                duration: 200
                            });
                            var id = objPane.id;
                            var zState = zoom + 1;
                            var viewActive = viewContainer.getActiveView();
                            var resourceName = objPane._resource._name;
                            localStorage.setItem('zoomIn' + id, '' + zState.toString() + '');
                            //    eventDispatcher.fireEvent("enter_application_log", AUDITLOGMSGES.monitoring.resource.mapDropped.toolBox.zoomIn + resourceName, AUDITLOGMSGES.entryOperation.monitoring.zoomOnMap, AUDITLOGMSGES.entryOperation.operation.mapview, false, true, true, 2);
                        };
                        button.addEventListener('click', zoomInButtonPressed, false);
                        button.addEventListener('touchstart', zoomInButtonPressed, false);
                        //== inserting a button to div element like all other map controls
                        var element = document.createElement('div');
                        element.className = 'hide-layer ol-unselectable ol-control ';
                        element.appendChild(button);
                        //this.set("name", "zoomInControl");
                        ol.control.Control.call(_this_1, {
                            element: element,
                            target: controlsElement
                        });
                        return _this_1;
                    }
                    return zoomInControl;
                }(ol.control.ZoomToExtent));
                var zInControl = new zoomInControl({
                    name: 'Zoom In',
                    //buttonInner: '<span class="vicon-font v-zoom-in"></span>',
                    buttonInner: "<span class=\"bg-zoomin-icon\"></span>",
                    className: 'zoom-in',
                    layerName: 'bgMapImageLayer',
                    map: _this_1.map,
                    viewContainer: _this_1.monitoringViewContainer,
                    getLayersByName: _this_1.getLayersByName,
                });
                zInControl.set("name", "zInControl");
                _this_1.map.addControl(zInControl);
                var zoomOutControl = /** @class */ (function (_super) {
                    __extends(zoomOutControl, _super);
                    // element: any;
                    function zoomOutControl(opt_options) {
                        if (opt_options === void 0) { opt_options = null; }
                        var _this_1 = _super.call(this, {}) || this;
                        var options = opt_options || {};
                        //== Options received from constructor
                        var layerName = options.layerName;
                        var className = options.className;
                        var buttonInner = options.buttonInner;
                        var name = options.name;
                        var map = options.map;
                        var viewContainer = options.viewContainer;
                        //    const getLayersByName = options.getLayersByName;
                        //   const layerObj = getLayersByName(layerName);
                        var layerObj = 'bgMapImageLayer';
                        //== layer not exists on current map - not creating a button
                        if (!layerObj) {
                            return _this_1;
                        }
                        var eventDispatcher = options.eventDispatcher;
                        var AUDITLOGMSGES = options.AUDITLOGMSGES;
                        var mapResource = options.mapResource;
                        //== Creating a button 
                        var button = document.createElement('button');
                        button.appendChild(angular.element(buttonInner)[0]);
                        button.title = name;
                        button.style.setProperty("background-color", "#353f4c");
                        button.className = className;
                        //== click function
                        var zoomOutButtonPressed = function (e) {
                            var view = map.getView();
                            var zoom = view.getZoom();
                            view.animate({
                                zoom: zoom - 1,
                                duration: 200,
                            });
                            var id = objPane.id;
                            var zState = zoom - 1;
                            var viewActive = viewContainer.getActiveView();
                            var resourceName = objPane._resource._name;
                            localStorage.setItem('zoomIn' + id, '' + zState.toString() + '');
                            //    eventDispatcher.fireEvent("enter_application_log", AUDITLOGMSGES.monitoring.resource.mapDropped.toolBox.zoomOut + resourceName, AUDITLOGMSGES.entryOperation.monitoring.zoomOnMap, AUDITLOGMSGES.entryOperation.operation.mapview, false, true, true, 2);
                        };
                        button.addEventListener('click', zoomOutButtonPressed, false);
                        button.addEventListener('touchstart', zoomOutButtonPressed, false);
                        //== inserting a button to div element like all other map controls
                        var element = document.createElement('div');
                        element.className = 'hide-layer ol-unselectable ol-control ' + className;
                        element.appendChild(button);
                        //this.set("name", "zoomOutControl");
                        ol.control.Control.call(_this_1, {
                            element: element,
                            target: controlsElement
                        });
                        return _this_1;
                    }
                    return zoomOutControl;
                }(ol.control.ZoomToExtent));
                var zOutcontrol = new zoomOutControl({
                    name: 'Zoom Out',
                    buttonInner: "<span class=\"bg-zoomout-icon\"></span>",
                    className: 'zoom-out',
                    layerName: 'Zoom Out',
                    map: _this_1.map,
                    viewContainer: _this_1.monitoringViewContainer,
                    getLayersByName: _this_1.getLayersByName,
                    eventDispatcher: _this_1.eventDispatcher,
                    AUDITLOGMSGES: _this_1.AUDITLOGMSGES
                });
                zOutcontrol.set("name", "zOutcontrol");
                _this_1.map.addControl(zOutcontrol);
                //      //Ends
                //      //=== Buttons for hiding layers
                var toggleLayerControll = /** @class */ (function (_super) {
                    __extends(toggleLayerControll, _super);
                    function toggleLayerControll(opt_options) {
                        if (opt_options === void 0) { opt_options = null; }
                        var _this_1 = _super.call(this, {}) || this;
                        var options = opt_options || {};
                        //== Options received from constructor
                        var layerName = options.layerName;
                        var className = options.className;
                        var buttonInner = options.buttonInner;
                        var name = options.name;
                        var map = options.map;
                        var viewContainer = options.viewContainer;
                        var isDisabled = options.isDisable;
                        var getLayersByName = options.getLayersByName;
                        var layerObj = getLayersByName(layerName);
                        var stickyTextLayer = getLayersByName("notes");
                        //              let viewActive = null;
                        //              if (!viewContainer || !viewContainer.getActiveView()) {
                        //                  viewActive = {
                        //                      _id: options.viewID
                        //                  }
                        //              } else {
                        //                  viewActive = viewContainer.getActiveView();
                        //              }
                        var linkedTextControl = options.linkedTextControl;
                        //              let eventDispatcher: any = options.eventDispatcher;
                        //              let AUDITLOGMSGES: any = options.AUDITLOGMSGES;
                        var mapResource = options.mapResource;
                        if (layerName == 'stickyNotesLayer') {
                            if (objPane && objPane.resource && objPane.resource.mapItems && objPane.resource.mapItems.length !== 0) {
                                if (layerName == 'stickyNotesLayer') {
                                    var stickyTextItems_1 = objPane.resource.mapItems.filter(function (item) {
                                        return (item.type == 'MapItemText');
                                    });
                                    if (stickyTextItems_1 == '') {
                                        localStorage.setItem('visibilityLayerSticky' + objPane.id, 'noData');
                                        _this_1.toolBoxIconDisabled = 'bg-stickynotes-tool-disabled';
                                        layerObj.setVisible(false);
                                        stickyTextLayer.setVisible(false);
                                    }
                                    else {
                                        if (localStorage.getItem('visibilityLayerSticky' + objPane.id) == null) {
                                            _this_1.toolBoxIconDisabled = 'bg-stickynotes-tool';
                                            localStorage.setItem('visibilityLayerSticky' + objPane.id, 'true');
                                            layerObj.setVisible(true);
                                            stickyTextLayer.setVisible(true);
                                        }
                                        else if (localStorage.getItem('visibilityLayerSticky' + objPane.id) == 'true') {
                                            _this_1.toolBoxIconDisabled = 'bg-stickynotes-tool';
                                            localStorage.setItem('visibilityLayerSticky' + objPane.id, 'true');
                                            layerObj.setVisible(true);
                                            stickyTextLayer.setVisible(true);
                                        }
                                        else if (localStorage.getItem('visibilityLayerSticky' + objPane.id) == 'false') {
                                            _this_1.toolBoxIconDisabled = 'bg-stickynotes-tool';
                                            localStorage.setItem('visibilityLayerSticky' + objPane.id, 'false');
                                            layerObj.setVisible(false);
                                            stickyTextLayer.setVisible(false);
                                        }
                                        else if (localStorage.getItem('visibilityLayerSticky' + objPane.id) == 'noData') {
                                            _this_1.toolBoxIconDisabled = 'bg-stickynotes-tool';
                                            localStorage.setItem('visibilityLayerSticky' + objPane.id, 'true');
                                            layerObj.setVisible(true);
                                            stickyTextLayer.setVisible(true);
                                        }
                                    }
                                }
                            }
                            else {
                                if (layerName == 'stickyNotesLayer') {
                                    localStorage.setItem('visibilityLayerSticky' + objPane.id, 'noData');
                                    _this_1.toolBoxIconDisabled = 'bg-stickynotes-tool-disabled';
                                    layerObj.setVisible(false);
                                    stickyTextLayer.setVisible(false);
                                }
                            }
                        }
                        if (layerName == 'funnelIconLayer') {
                            if (objPane && objPane.resource && objPane.resource.mapItems && objPane.resource.mapItems.length !== 0) {
                                if (layerName == 'funnelIconLayer') {
                                    var stickyTextItems_2 = objPane.resource.mapItems.filter(function (item) {
                                        if (item != null && item.hasOwnProperty('type')) {
                                            return (item.type == 'MapItemPolygon');
                                        }
                                    });
                                    if (stickyTextItems_2 == '') {
                                        localStorage.setItem('visibilityLayer' + objPane.id, 'noData');
                                        _this_1.toolBoxIconDisabled = 'bg-funnel-tool-disabled';
                                        layerObj.setVisible(false);
                                    }
                                    else {
                                        if (localStorage.getItem('visibilityLayer' + objPane.id) == null) {
                                            _this_1.toolBoxIconDisabled = 'bg-funnel-tool';
                                            localStorage.setItem('visibilityLayer' + objPane.id, 'true');
                                            layerObj.setVisible(true);
                                        }
                                        else if (localStorage.getItem('visibilityLayer' + objPane.id) == 'true') {
                                            _this_1.toolBoxIconDisabled = 'bg-funnel-tool';
                                            localStorage.setItem('visibilityLayer' + objPane.id, 'true');
                                            //console.log("LayerObject::",layerObj);  
                                            //layerObj.setVisible(true);
                                        }
                                        else if (localStorage.getItem('visibilityLayer' + objPane.id) == 'false') {
                                            _this_1.toolBoxIconDisabled = 'bg-funnel-tool';
                                            localStorage.setItem('visibilityLayer' + objPane.id, 'false');
                                            layerObj.setVisible(false);
                                        }
                                        else if (localStorage.getItem('visibilityLayer' + objPane.id) == 'noData') {
                                            _this_1.toolBoxIconDisabled = 'bg-funnel-tool';
                                            localStorage.setItem('visibilityLayer' + objPane.id, 'true');
                                            layerObj.setVisible(true);
                                        }
                                    }
                                }
                            }
                            else {
                                if (layerName == 'funnelIconLayer') {
                                    localStorage.setItem('visibilityLayer' + objPane.id, 'noData');
                                    _this_1.toolBoxIconDisabled = 'bg-funnel-tool-disabled';
                                    //   layerObj.setVisible(false);
                                }
                            }
                        }
                        if (layerName == 'linkedMapsLayer') {
                            if (objPane && objPane.resource && objPane.resource.mapItems && objPane.resource.mapItems.length !== 0) {
                                if (layerName == 'linkedMapsLayer') {
                                    var stickyTextItems = 0;
                                    objPane.resource.mapItems.forEach(function (value) {
                                        if (value.type == 'MapItemPolygon') {
                                            var objFinder = value.funnels.propertyBagDetails;
                                            if (objFinder.shape != undefined && objFinder.shape != "" && objFinder != undefined) {
                                                stickyTextItems = 1;
                                            }
                                        }
                                    });
                                    if (stickyTextItems == 0) {
                                        localStorage.setItem('visibilityLayerLinked' + objPane.id, 'noData');
                                        _this_1.toolBoxIconDisabled = 'bg-hightlight-tool-disabled';
                                        layerObj.setVisible(false);
                                    }
                                    else {
                                        if (localStorage.getItem('visibilityLayerLinked' + objPane.id) == null) {
                                            _this_1.toolBoxIconDisabled = 'bg-hightlight-tool';
                                            localStorage.setItem('visibilityLayerLinked' + objPane.id, 'true');
                                            layerObj.setVisible(true);
                                        }
                                        else if (localStorage.getItem('visibilityLayerLinked' + objPane.id) == 'true') {
                                            _this_1.toolBoxIconDisabled = 'bg-hightlight-tool';
                                            localStorage.setItem('visibilityLayerLinked' + objPane.id, 'true');
                                            layerObj.setVisible(true);
                                        }
                                        else if (localStorage.getItem('visibilityLayerLinked' + objPane.id) == 'false') {
                                            _this_1.toolBoxIconDisabled = 'bg-hightlight-tool';
                                            localStorage.setItem('visibilityLayerLinked' + objPane.id, 'false');
                                            layerObj.setVisible(false);
                                        }
                                        else if (localStorage.getItem('visibilityLayerLinked' + objPane.id) == 'noData') {
                                            _this_1.toolBoxIconDisabled = 'bg-hightlight-tool';
                                            localStorage.setItem('visibilityLayerLinked' + objPane._id, 'true');
                                            layerObj.setVisible(true);
                                        }
                                    }
                                }
                            }
                            else {
                                if (layerName == 'linkedMapsLayer') {
                                    localStorage.setItem('visibilityLayerLinked' + objPane.id, 'noData');
                                    _this_1.toolBoxIconDisabled = 'bg-hightlight-tool-disabled';
                                    layerObj.setVisible(false);
                                }
                            }
                        }
                        //              //== layer not exists on current map - not creating a button
                        if (!layerObj && !stickyTextLayer) {
                            return _this_1;
                        }
                        //              //== Creating a button 
                        var button = document.createElement('button');
                        var toolBoxIconDis = angular.element(buttonInner)[0];
                        toolBoxIconDis.setAttribute('class', _this_1.toolBoxIconDisabled);
                        button.appendChild(toolBoxIconDis);
                        button.title = name;
                        button.disabled = !isDisabled;
                        button.style.setProperty("background-color", "#353f4c");
                        //              //== click function
                        var toggleLayerVisibility = function (e) {
                            //                  //== toggle layer visibility
                            // var resourceName = objPane._resource._name;
                            var resourceName = ""; //objPane._resource._name;
                            if (objPane._resource)
                                resourceName = objPane._resource._name;
                            else
                                resourceName = objPane.resource.name;
                            var visibility = layerObj.getVisible();
                            if (visibility == true) {
                                layerObj.setVisible(false);
                                if (layerName == 'funnelIconLayer') {
                                    localStorage.setItem('visibilityLayer' + objPane.id, 'false');
                                    $(e.currentTarget.parentElement).removeClass("ol-active-btn");
                                    //   eventDispatcher.fireEvent("enter_application_log", AUDITLOGMSGES.monitoring.resource.mapDropped.toolBox.overViewFunnelOff + resourceName, AUDITLOGMSGES.entryOperation.monitoring.funnel, AUDITLOGMSGES.entryOperation.operation.mapview, false, true, true, 2);
                                }
                                if (layerName == 'stickyNotesLayer') {
                                    var stickyTextLayer_1 = MapsOpenLayers.getMapLayerByName(map, "notes");
                                    stickyTextLayer_1.setVisible(false);
                                    localStorage.setItem('visibilityLayerSticky' + objPane.id, 'false');
                                    $(e.currentTarget.parentElement).removeClass("ol-active-btn");
                                    //  eventDispatcher.fireEvent("enter_application_log", AUDITLOGMSGES.monitoring.resource.mapDropped.toolBox.stickyNoteTextOff + resourceName, AUDITLOGMSGES.entryOperation.monitoring.stickyNote, AUDITLOGMSGES.entryOperation.operation.mapview, false, true, true, 2);
                                }
                                if (layerName == 'linkedMapsLayer') {
                                    localStorage.setItem('visibilityLayerLinked' + objPane.id, 'false');
                                    $(e.currentTarget.parentElement).removeClass("ol-active-btn");
                                    //  eventDispatcher.fireEvent("enter_application_log", AUDITLOGMSGES.monitoring.resource.mapDropped.toolBox.linkHighlightOff + resourceName, AUDITLOGMSGES.entryOperation.monitoring.linkHighlight, AUDITLOGMSGES.entryOperation.operation.mapview, false, true, true, 2);
                                    if (linkedTextControl) {
                                        var show = localStorage.getItem('visibilityLayerLinkedMapText' + objPane.id + mapResource.id);
                                        if (!show || show == 'false' || show == undefined) {
                                            linkedTextControl.toggleTextPressed();
                                        }
                                    }
                                }
                            }
                            else {
                                layerObj.setVisible(true);
                                if (layerName == 'funnelIconLayer') {
                                    $(e.currentTarget.parentElement).addClass("ol-active-btn");
                                    localStorage.setItem('visibilityLayer' + objPane.id, 'true');
                                    // eventDispatcher.fireEvent("enter_application_log", AUDITLOGMSGES.monitoring.resource.mapDropped.toolBox.overViewFunnelOn + resourceName, AUDITLOGMSGES.entryOperation.monitoring.funnel, AUDITLOGMSGES.entryOperation.operation.mapview, false, true, true, 2);
                                }
                                if (layerName == 'stickyNotesLayer') {
                                    var stickyTextLayer_2 = MapsOpenLayers.getMapLayerByName(map, "notes");
                                    stickyTextLayer_2.setVisible(true);
                                    $(e.currentTarget.parentElement).addClass("ol-active-btn");
                                    localStorage.setItem('visibilityLayerSticky' + objPane.id, 'true');
                                    //  eventDispatcher.fireEvent("enter_application_log", AUDITLOGMSGES.monitoring.resource.mapDropped.toolBox.stickyNoteTextOn + resourceName, AUDITLOGMSGES.entryOperation.monitoring.stickyNote, AUDITLOGMSGES.entryOperation.operation.mapview,false, true, true, 2);
                                }
                                if (layerName == 'linkedMapsLayer') {
                                    $(e.currentTarget.parentElement).addClass("ol-active-btn");
                                    localStorage.setItem('visibilityLayerLinked' + objPane.id, 'true');
                                    // eventDispatcher.fireEvent("enter_application_log", AUDITLOGMSGES.monitoring.resource.mapDropped.toolBox.linkHighlightOn + resourceName, AUDITLOGMSGES.entryOperation.monitoring.linkHighlight, AUDITLOGMSGES.entryOperation.operation.mapview, false, true, true, 2);
                                    if (linkedTextControl) {
                                        linkedTextControl.toggleTextPressed();
                                    }
                                }
                            }
                        };
                        //              //== Click event listener
                        button.addEventListener('click', toggleLayerVisibility, false);
                        button.addEventListener('touchstart', toggleLayerVisibility, false);
                        //              //== inserting a button to div element like all other map controls
                        var stateClass = localStorage.getItem('visibilityLayer' + objPane.id) == 'true' ? ' ol-active-btn ' : '';
                        if (layerName == 'stickyNotesLayer') {
                            stateClass = localStorage.getItem('visibilityLayerSticky' + objPane.id) == 'true' ? ' ol-active-btn ' : '';
                        }
                        if (layerName == 'funnelLayer') {
                            stateClass = localStorage.getItem('visibilityLayer' + objPane.id) == 'true' ? ' ol-active-btn ' : '';
                        }
                        if (layerName == 'linkedMapsLayer') {
                            stateClass = localStorage.getItem('visibilityLayerLinked' + objPane._id) == 'true' ? ' ol-active-btn ' : '';
                        }
                        var element = document.createElement('div');
                        element.className = 'hide-layer ol-unselectable ol-control ' + stateClass + className;
                        element.appendChild(button);
                        //              //this.set("name", "toggleLayerControll");
                        //              //== registering this control as map control
                        ol.control.Control.call(_this_1, {
                            element: element,
                            target: controlsElement
                        });
                        return _this_1;
                    }
                    return toggleLayerControll;
                }(ol.control.Control));
                var LinkedMapTextButtonControll = /** @class */ (function (_super) {
                    __extends(LinkedMapTextButtonControll, _super);
                    function LinkedMapTextButtonControll(opt_options) {
                        if (opt_options === void 0) { opt_options = null; }
                        var _this_1 = _super.call(this, {}) || this;
                        _this_1.toggleTextPressed = function (e) {
                            var show = localStorage.getItem('visibilityLayerLinkedMapText' + _this_1.objPane.id + _this_1.mapResource.id);
                            if (show && show == 'true') {
                                $(_this_1.element).addClass("ol-active-btn");
                                localStorage.setItem('visibilityLayerLinkedMapText' + _this_1.objPane.id + _this_1.mapResource.id, 'false');
                                _this_1.callback(false);
                            }
                            else {
                                $(_this_1.element).removeClass("ol-active-btn");
                                localStorage.setItem('visibilityLayerLinkedMapText' + _this_1.objPane.id + _this_1.mapResource.id, 'true');
                                _this_1.callback(true);
                            }
                        };
                        var options = opt_options || {};
                        //== Options received from constructor
                        var buttonInner = options.buttonInner;
                        var name = options.name;
                        var callback = options.func;
                        var objPane = options.objPane;
                        var isDisabled = options.isDisable;
                        //== Creating a button 
                        var button = document.createElement('button');
                        //  const viewContainer = options.viewContainer;
                        _this_1.mapResource = options.mapResource;
                        //let viewActive = null;
                        //if (!viewContainer || !viewContainer.getActiveView()) {
                        //    viewActive = {
                        //        _id: options.viewID
                        //    }
                        //} else {
                        //    viewActive = viewContainer.getActiveView();
                        //}
                        var span = angular.element(buttonInner)[0];
                        button.appendChild(span);
                        button.title = name;
                        button.style.setProperty("background-color", "#353f4c");
                        button.style.setProperty("margin-left", "0.5px");
                        button.style.setProperty("border", "0");
                        button.style.setProperty("outline", "0");
                        button.style.setProperty("padding", "0");
                        //== inserting a button to div element like all other map controls
                        var element = document.createElement('div');
                        element.id = "txtLinkedMapControl_" + objPane.id;
                        element.className = 'hide-layer ol-unselectable ol-control ';
                        element.appendChild(button);
                        element.style.setProperty("display", "block");
                        if (!isDisabled) {
                            button.disabled = true;
                            span.setAttribute('class', 'highlight-icon-disabled');
                        }
                        else {
                            button.disabled = false;
                            $(element).addClass("ol-active-btn");
                            span.setAttribute('class', 'highlight-icon');
                        }
                        _this_1.element = element;
                        _this_1.objPane = objPane;
                        //  this.viewActive = viewActive;
                        _this_1.callback = callback;
                        var show = localStorage.getItem('visibilityLayerLinkedMapText' + objPane.id + _this_1.mapResource.id);
                        if (show && show == 'true') {
                            $(element).removeClass("ol-active-btn");
                            callback(true);
                        }
                        button.addEventListener('click', _this_1.toggleTextPressed, false);
                        button.addEventListener('touchstart', _this_1.toggleTextPressed, false);
                        //== registering this control as map control
                        //this.set("name", "LinkedMapTextButtonControll");
                        ol.control.Control.call(_this_1, {
                            element: element,
                            target: controlsElement
                        });
                        return _this_1;
                    }
                    return LinkedMapTextButtonControll;
                }(ol.control.Control));
                try {
                    var funnelToggleControl = new toggleLayerControll({
                        name: 'Overview Funnels',
                        buttonInner: "<span class=\"bg-funnel-tool\"></span>",
                        className: 'toggle-funnels',
                        layerName: 'funnelIconLayer',
                        map: _this_1.map,
                        isDisable: _this_1.funnelCount,
                        viewContainer: _this_1.monitoringViewContainer,
                        getLayersByName: _this_1.getLayersByName,
                        eventDispatcher: _this_1.eventDispatcher,
                        mapResource: _this_1.mapResource,
                        AUDITLOGMSGES: _this_1.AUDITLOGMSGES,
                        viewID: _this_1.monitoringViewID
                    });
                    funnelToggleControl.set("name", "funnelToggleControl");
                    _this_1.map.addControl(funnelToggleControl);
                }
                catch (e) {
                    console.log("Error in toggle control ", e);
                }
                try {
                    _this_1.linkedMapText = new LinkedMapTextButtonControll({
                        name: "Show Linked Highlight Text",
                        buttonInner: "<span class=\"highlight-icon\"></span>",
                        map: _this_1.map,
                        isDisable: _this_1.linkedCount,
                        func: _this_1.hideLinkedMapText,
                        objPane: _this_1.mObjectPane,
                        LinkedMapTextButtonControll: LinkedMapTextButtonControll,
                        mapResource: _this_1.mapResource
                        //   viewContainer: this.monitoringViewContainer,
                        //   viewID: this.monitoringViewID
                    });
                }
                catch (e) {
                    console.log("Error in linked map control ", e);
                }
                try {
                    var linkedToggleControl = new toggleLayerControll({
                        name: "Linked Highlight",
                        buttonInner: "<span class=\"bg-hightlight-tool\"></span>",
                        className: 'toggle-linked-maps',
                        layerName: "linkedMapsLayer",
                        map: _this_1.map,
                        isDisable: _this_1.linkedCount,
                        //  viewContainer: this.monitoringViewContainer,
                        linkedTextControl: _this_1.linkedMapText,
                        getLayersByName: _this_1.getLayersByName,
                        eventDispatcher: _this_1.eventDispatcher,
                        mapResource: _this_1.mapResource,
                    });
                    linkedToggleControl.set("name", "linkedToggleControl");
                    _this_1.map.addControl(linkedToggleControl);
                    _this_1.linkedMapText.set("name", "linkedMapTextControl");
                    _this_1.map.addControl(_this_1.linkedMapText);
                }
                catch (e) {
                    console.log("Error in toggle linked map tax control ", e);
                }
                //      // Sticky Note
                try {
                    var stickyToggleControl = new toggleLayerControll({
                        name: "Sticky Notes",
                        buttonInner: "<span class=\"bg-stickynotes-tool\"></span>",
                        className: 'toggle-sticky-note',
                        layerName: "stickyNotesLayer",
                        map: _this_1.map,
                        isDisable: _this_1.stickeyCount,
                        //    viewContainer: this.monitoringViewContainer,
                        getLayersByName: _this_1.getLayersByName,
                        eventDispatcher: _this_1.eventDispatcher,
                        mapResource: _this_1.mapResource,
                    });
                    stickyToggleControl.set("name", "stickyToggleControl");
                    _this_1.map.addControl(stickyToggleControl);
                }
                catch (e) {
                    console.log("Error in sticky control ", e);
                }
                //      //== Home Button
                var homeButtonControll = /** @class */ (function (_super) {
                    __extends(homeButtonControll, _super);
                    function homeButtonControll(opt_options) {
                        if (opt_options === void 0) { opt_options = null; }
                        var _this_1 = _super.call(this, {}) || this;
                        var options = opt_options || {};
                        //== Options received from constructor
                        var className = options.className;
                        var buttonInner = options.buttonInner;
                        var name = options.name;
                        var map = options.map;
                        var home = options.home;
                        var fromMonitoring = options.fromMonitoring;
                        var modifyCoordinates = options.modifyCoordinates;
                        var defaultHome = options.defaultHome;
                        var mapResource = options.mapResource;
                        var homeButtonPressed = options.homeButtonPressed;
                        var localHome = localStorage.getItem("homesetFor_" + mapResource.id);
                        _this_1.isHome = false;
                        //              //== Creating a button 
                        var button = document.createElement('button');
                        button.style.setProperty("background-color", "#353f4c");
                        button.title = name;
                        //if (home && !home.initial) {
                        if ((home && !home.initial) || localHome && localHome == 'true') {
                            button.disabled = false;
                            _this_1.homeIconDisableState = "bg-home-icon";
                        }
                        else {
                            button.disabled = true;
                            _this_1.homeIconDisableState = "bg-home-icon-disabled";
                        }
                        var buttonIconHome = angular.element(buttonInner)[0];
                        buttonIconHome.setAttribute('class', _this_1.homeIconDisableState);
                        button.appendChild(buttonIconHome);
                        //              //== Click event listener
                        button.addEventListener('click', homeButtonPressed, false);
                        button.addEventListener('touchstart', homeButtonPressed, false);
                        //== inserting a button to div element like all other map controls
                        var element = document.createElement('div');
                        element.className = 'hide-layer ol-unselectable ol-control ' + className;
                        setTimeout(function () { $('.map-home-btn').find('button').find('button').trigger('click'); }, 20);
                        element.appendChild(button);
                        //this.set("name", "homeButtonControll");
                        //== registering this control as map control
                        ol.control.Control.call(_this_1, {
                            element: element,
                            target: controlsElement
                        });
                        return _this_1;
                    }
                    return homeButtonControll;
                }(ol.control.Control));
                try {
                    var homeControl = new homeButtonControll({
                        name: 'Home',
                        buttonInner: "<span class=\"bg-home-icon\"></span>",
                        className: 'map-home-btn',
                        map: _this_1.map,
                        home: _this_1.getInitialHomePosition(),
                        fromMonitoring: _this_1.fromMonitoring,
                        modifyCoordinates: _this_1.calculateRelativeCoordinates,
                        defaultHome: _this_1.defaultHome,
                        mapResource: _this_1.mapResource,
                        homeButtonPressed: _this_1.homeButtonPressed,
                    });
                    homeControl.set("name", "homeControl");
                    _this_1.map.addControl(homeControl);
                }
                catch (e) {
                    console.log("Error in home control ", e);
                }
                //backbutton for maps
                var backButtonControll = /** @class */ (function (_super) {
                    __extends(backButtonControll, _super);
                    function backButtonControll(opt_options) {
                        if (opt_options === void 0) { opt_options = null; }
                        var _this_1 = _super.call(this, {}) || this;
                        var options = opt_options || {};
                        //== Options received from constructor
                        var buttonInner = options.buttonInner;
                        var name = options.name;
                        var back = options.back;
                        var objPane = options.objPane;
                        var isVisible = options.isVisible;
                        //const globalDataAccessPoint = options.globalDataAccessPoint
                        //== Creating a button 
                        var button = document.createElement('button');
                        button.appendChild(angular.element(buttonInner)[0]);
                        button.title = name;
                        button.style.setProperty("background-color", "#353f4c");
                        button.style.setProperty("margin-left", "0.5px");
                        button.style.setProperty("border", "0");
                        button.style.setProperty("outline", "0");
                        button.style.setProperty("padding", "0");
                        //== click function
                        var backButtonPressed = function (e) {
                            back(e);
                        };
                        //== Click event listener
                        button.addEventListener('click', backButtonPressed, false);
                        button.addEventListener('touchstart', backButtonPressed, false);
                        //== inserting a button to div element like all other map controls
                        var element = document.createElement('div');
                        element.id = "historyControl_" + objPane._id;
                        element.className = 'back-btn';
                        var existingControl = document.getElementById("historyControl_" + objPane._id);
                        if (existingControl) {
                            existingControl.parentElement.removeChild(existingControl);
                        }
                        //element.className = 'hide-layer ol-unselectable ol-control ' + className;
                        element.appendChild(button);
                        //  localStorage.setItem('OldMapId',_this.mapResource.id )
                        //         localStorage.setItem('BackButton', 'true');
                        if (isVisible)
                            element.style.setProperty("display", "block");
                        else
                            element.style.setProperty("display", "none");
                        _this_1.btnelement = element;
                        //== registering this control as map control
                        ol.control.Control.call(_this_1, {
                            element: element,
                            target: controlsElement
                        });
                        return _this_1;
                    }
                    return backButtonControll;
                }(ol.control.Control));
                //      //var eleBack = MapsOpenLayers.tempObjPane ? MapsOpenLayers.tempObjPane : this.mObjectPane
                try {
                    var eleBack = _this_1.map.get("map_pane");
                    _this_1.backButton = new backButtonControll({
                        name: "Back",
                        buttonInner: "<span class=\"bg-back-icon\"></span>",
                        map: _this_1.map,
                        back: _this_1.navigateToPrevieousMap,
                        objPane: eleBack,
                        isVisible: (_this_1.mapResource.mapParentId && _this_1.mapResource.mapParentId != '') ? true : false,
                    });
                    _this_1.backButton.set("name", "backButtonControll");
                    _this_1.map.addControl(_this_1.backButton);
                }
                catch (e) {
                    console.log("Error in back button control ", e);
                }
                var SearchButtonControll = /** @class */ (function (_super) {
                    __extends(SearchButtonControll, _super);
                    function SearchButtonControll(opt_options) {
                        if (opt_options === void 0) { opt_options = null; }
                        var _this_1 = _super.call(this, {}) || this;
                        var options = opt_options || {};
                        //== Options received from constructor
                        var className = options.className;
                        var buttonInner = options.buttonInner;
                        var name = options.name;
                        var title = options.title;
                        var map = options.map;
                        var home = options.home;
                        var fromMonitoring = options.fromMonitoring;
                        var modifyCoordinates = options.modifyCoordinates;
                        var defaultHome = options.defaultHome;
                        var mapResource = options.mapResource;
                        var homeButtonPressed = options.homeButtonPressed;
                        var localHome = localStorage.getItem("homesetFor_" + mapResource.id);
                        //              //== Creating a button 
                        var button = document.createElement('button');
                        button.title = title;
                        var buttonIconHome = angular.element(buttonInner)[0];
                        button.appendChild(buttonIconHome);
                        button.style.setProperty("background-color", "#353f4c");
                        //              //== Click event listener
                        button.addEventListener('click', homeButtonPressed, false);
                        button.addEventListener('touchstart', homeButtonPressed, false);
                        //== inserting a button to div element like all other map controls
                        var element = document.createElement('div');
                        element.className = 'hide-layer ol-unselectable ol-control ol-active-btn ' + className;
                        setTimeout(function () { $('.map-home-btn').find('button').find('button').trigger('click'); }, 10);
                        element.appendChild(button);
                        //this.set("name", "homeButtonControll");
                        //== registering this control as map control
                        ol.control.Control.call(_this_1, {
                            element: element,
                            target: controlsElement
                        });
                        return _this_1;
                    }
                    return SearchButtonControll;
                }(ol.control.Control));
                try {
                    if (_this_1.mapResource.mapType == "MapService") {
                        var searchControl = new SearchButtonControll({
                            name: "maps_search_control",
                            title: 'Search Location',
                            buttonInner: "<span class=\"bg-search-icon\"></span>",
                            className: 'map-home-btn',
                            map: _this_1.map,
                            home: _this_1.getInitialHomePosition(),
                            fromMonitoring: _this_1.fromMonitoring,
                            modifyCoordinates: _this_1.calculateRelativeCoordinates,
                            defaultHome: _this_1.defaultHome,
                            mapResource: _this_1.mapResource,
                            homeButtonPressed: _this_1.searchButtonPressed,
                        });
                        searchControl.set("name", "searchButtonControl");
                        _this_1.map.addControl(searchControl);
                    }
                }
                catch (e) {
                    console.log("Error in geo map search control ", e);
                }
            };
            this.hideLinkedMapText = function (show) {
                _this_1.map.getLayers().forEach(function (l) {
                    if (l.get('name') == "linkedMapsLayer") {
                        var s = l.getSource();
                        var f = s.getFeatures();
                        f.forEach(function (fItem) {
                            var style = fItem.getStyle();
                            if (show) {
                                var txtObj = style.getText();
                                if (!txtObj) {
                                    txtObj = style.text_.text_;
                                }
                                if (txtObj) {
                                    fItem.set("savedText", txtObj.getText());
                                    txtObj.setText('');
                                    style.setText(txtObj);
                                }
                            }
                            else {
                                var defaultText = fItem.get("savedText");
                                var style_1 = fItem.getStyle();
                                var txtObj = style_1.getText();
                                if (txtObj) {
                                    txtObj.setText(defaultText);
                                    style_1.setText(txtObj);
                                }
                            }
                            fItem.setStyle(style);
                        });
                    }
                });
            };
            //  //== Functions and map object for current pane
            this.createOpenLayerMapOnMonitoring = function (objPane) {
                //console.log("pre", objPane);
                ////clear pane before draw
                //let d = objPane._domContainer;
                //if (objPane.vmsPlayerId) {
                //    let player = d.getElementsByTagName("object");
                //    if (player) {
                //        objPane.vmsPlayerId = null;
                //    }
                //}
                //if (!this.globalDataAccessPoint.olMapDataLink['parent']) {
                //    this.globalDataAccessPoint.olMapDataLink['parent'] = [];
                //}
                //this.globalDataAccessPoint.olMapDataLink['parent'][objPane._id] = this.mObjectPane;
                //   if (!localStorage.getItem('olMapDataLink')) {
                //       let obj:any = {
                //         'parent': []
                //       }
                //       obj.parent[objPane._id] = this.mObjectPane;
                //      localStorage.setItem('olMapDataLink', JSON.stringify(obj));
                //   }
                //this.globalDataAccessPoint.olMapDataLink['parent'][objPane._id] = this.mObjectPane;
                //end
                _this_1.createOrUseMap(_this_1.mapResource, _this_1.mapElement, _this_1.mObjectPane);
                //default making on to show toolbox tool
                if (!_this_1.mapResource || !_this_1.mapResource.mapItems)
                    return;
                if (_this_1.mapResource.mapItems.length == 0) {
                    localStorage.setItem('visibilityLayer' + objPane._id, 'false');
                    localStorage.setItem('visibilityLayerSticky' + objPane._id, 'false');
                }
                else {
                    if (!_this_1.mapResource || !_this_1.mapResource.mapItems)
                        return;
                    var stickyTextItems = _this_1.mapResource.mapItems.filter(function (item) {
                        return (item && item.type == 'MapItemText');
                    });
                    if (!stickyTextItems || stickyTextItems.length == 0) {
                        localStorage.setItem('visibilityLayerSticky' + objPane._id, 'false');
                    }
                    var textItemsImage = _this_1.mapResource.mapItems.filter(function (item) {
                        return (item && item.type == 'MapItemImage');
                    });
                    if (!textItemsImage || textItemsImage.length == 0) {
                        localStorage.setItem('visibilityLayer' + objPane._id, 'false');
                    }
                }
                //end
                //if (this.fromMonitoring) {
                //    //============== Creating View, Layers, Features
                //    //this.eventDispatcher.subscribe("reload_map_screen_size_changed", (pane) => {
                //    //    this.eventDispatcher.fireEvent("draw_map_on_new_pane", this.mapResource, this.mObjectPane);
                //    //});
                //    let mp: any = this.map;
                //    this.eventDispatcher.subscribe("update_map_from_detach" + mp.values_.mapId, (mapId) => {
                //        let currentMap: any = this.map;
                //        if (currentMap.values_.mapId == mapId) {
                //            this.createMapDataAndLayers(this.map, this.mapResource, this.mapElement);
                //        }
                //    });
                //}
                _this_1.mObjectPane = objPane;
                //if (!this.existingMap) {
                localStorage.removeItem("showONMapPass");
                //console.log("this.globalDataAccessPoint.olMapDataLink1", this.globalDataAccessPoint.olMapDataLink)
                _this_1.map.set("map_pane", objPane);
                _this_1.createMapDataAndLayers(_this_1.map, _this_1.mapResource, _this_1.mapElement);
                //======================== Handle Camera drag outside the map
                _this_1.setUpMonitoringMapCameraDragEvent(_this_1.map, objPane, _this_1.globalDataAccessPoint, _this_1.permissionsService, _this_1.infoWindowTiomout);
                //== Right click context menu
                _this_1.setupRightClickContextMenuForMonitoring(objPane);
                //lpr alarm info Pop-up
                _this_1.loadLprInfoPopUpOnMapForMonitoring(_this_1.map, objPane);
                //lpr alarm info Pop-up end
                //Access Control - VAX
                _this_1.loadVAXInfoPopUpOnMapForMonitoring(_this_1.map, objPane);
                //vax end
                //=============== Creating a popup with Camera Data hor mouseover
                //this.createCameraInfoPopup(this.map, objPane);
                //===================== Map click event for switching to linked map
                _this_1.internetOverlay();
                //add listner to get features in viewport 
                _this_1.addListnerToGetViewportFeatures(_this_1.map);
                //const linkedMapsLayer = MapsOpenLayers.getMapLayerByName(this.map, 'linkedMapsLayer');
                var linkedMapsLayer = _this_1.getLayersByName('linkedMapsLayer');
                _this_1.setHightlightIconOnfunnelClick(objPane);
                //== Add selection feature to the map, only for layer with links
                document.onmousemove = function (e) {
                    if (e.target.className == 'volume-slider' || e.target.className == 'volume-slider-img') {
                        if (_this_1.map)
                            _this_1.map.getInteractions().forEach(function (interaction) { interaction.setActive(false); });
                    }
                    else {
                        if (_this_1.map)
                            _this_1.map.getInteractions().forEach(function (interaction) { interaction.setActive(true); });
                    }
                };
                //   const selectFeatureOnMap = new ol.interaction.Select({
                //      layers: [linkedMapsLayer]
                //   });
                //   this.map.addInteraction(selectFeatureOnMap);
                _this_1.setFontOnZoom(_this_1.map);
                //   selectFeatureOnMap.on('select', (e: any): void => {
                //      const selected = e.selected;
                //      //== for all features on click point
                //      selected.forEach((feature: ol.Feature) => {
                //          //== check if this is highlight feature
                //          if (feature.get('type') == 'linkedMapFeature') {
                //              const clickedMapId = feature.get('resourceId');
                //              if (!!clickedMapId) {
                //                  //== If Linked map Id set we loading to new map
                //                 // this.switchToLinkedMap(clickedMapId, objPane, feature);
                //                  return;
                //              }
                //          }
                //      });
                //   })
                _this_1.map.on("click", function (e) {
                    _this_1.map.forEachFeatureAtPixel(e.pixel, function (feature, layer) {
                        _this_1.selectedFeature = feature;
                        var resourceId = _this_1.selectedFeature.values_.id;
                        var _this = _this_1;
                        if (_this_1.selectedFeature.values_.type == 'linkedMapFeature') {
                            //pane wise history of linked map
                            // let linkedMapHistory = localStorage.getItem("OldMapId");
                            // if(linkedMapHistory)
                            // {
                            // }
                            if (_this_1.selectedFeature.get("featureType") != "unlinked") {
                                //localStorage.setItem('OldMapId',_this.mapResource.id )
                                //localStorage.setItem('BackButton', 'true');
                                var obj = new ThickClientCommunication();
                                obj.callBackToThickClientFunction('showLinkedMap', resourceId);
                            }
                            else {
                                return;
                            }
                        }
                    });
                });
                //this.adjustHomePostionOnChange()
                setTimeout(function () {
                    _this_1.updateCameraStatusOnLoad(objPane);
                }, 1000);
                // }
                //else {
                //    this.map.setTarget(this.mapElement);
                //    this.map.set("map_pane", objPane);
                //       this.map.getLayers().forEach((l: any) => {
                //           if (l.get('name') == "bgMapImageLayer") {
                //   //            this.bgMapImageLayer = l;
                //   //            this.refreshMapWithBg();
                //           }
                //           else if (l.get('name') == "cameraImagesLayer") {
                //   //            this.cameraImagesLayer = l;
                //   //            this.adjustImageCoordinates(this.cameraImagesLayer);
                //   //            //this.setShowOnMap(l);
                //   //            if (this.fromMonitoring) {
                //   //                this.checkAlarmOnLoad(l);
                //   //                this.registerDeviceChangedEvents();
                //   //            }
                //   //            //this.checkAlarmOnLoad(l);
                //               this.adjustCurrentResourceStatus(l);
                //   //            //Access Control - VAX
                //   //            //this.loadVAXInfoPopUpOnMapForMonitoring(this.map, objPane);
                //   //             //vax end
                //   //            //this.registerDeviceChangedEvents();
                //   //            //lpr alarm info Pop-up
                //   //            //this.lprAlarmTriggerdEvents();
                //   //            //lpr alarm info Pop-up end
                //           } 
                //           //else if (l.get('name') == "funnelLayer") {
                //   //            this.funnelLayer = l;
                //   //            this.adjustPolygonCoordinates(this.funnelLayer);
                //   //            let s = this.funnelLayer.getSource();
                //   //            if (s && s.getFeatures().length > 0)
                //   //                this.funnelCount = true;
                //   //            else
                //   //                this.funnelCount = false;
                //   //        }
                //   //        else if (l.get('name') == "stickyNotesLayer") {
                //   //            this.stickyNotesLayer = l;
                //   //            let s = this.stickyNotesLayer.getSource();
                //   //            if (s && s.getFeatures().length > 0)
                //   //                this.stickeyCount = true;
                //   //            else
                //   //                this.stickeyCount = false;
                //   //        }
                //   //        else if (l.get('name') == "notes") {
                //   //            this.noteLayer = l;
                //   //        }
                //   //        else if (l.get('name') == "linkedMapsLayer") {
                //   //            this.linkedMapsLayer = l;
                //   //            this.adjustLinkedMapsCoordinates(this.linkedMapsLayer);
                //   //            let s = this.linkedMapsLayer.getSource();
                //   //            if (s && s.getFeatures().length > 0)
                //   //                this.linkedCount = true;
                //   //            else
                //   //                this.linkedCount = false;
                //   //        }
                //       })
                //    // sticky texts
                //    if (this.stickyNotesLayer && this.noteLayer) {
                //        this.adjustStickyNoteCoordinates(this.stickyNotesLayer, this.noteLayer);
                //    }
                //    //end
                //    //adjust customInteractions 
                //    var interactions = this.map.getInteractions();
                //    if (interactions && interactions.getLength() > 0) {
                //        interactions.forEach((intr: any) => {
                //            let name = intr.get("name");
                //            if (name && name == "customDragInteraction") {
                //                intr.parentContext = this;
                //                intr.map = this.map;
                //                intr.objPane = this.mObjectPane;
                //            }
                //        })
                //        $(".overlayelement").remove();
                //    }
                //    //end
                //    let dom = this.mObjectPane.domContainer;
                //    let minimumWidth = (MapsOpenLayers.CONTROLPANEL_VISIBILITY_VALUE / 100) * window.innerWidth;
                //    if (dom && dom.offsetWidth > minimumWidth) {
                //        this.createControlPannel(this.mObjectPane);
                //        let controls: any = this.map.getControls();
                //        if (!controls || !controls.array_ || controls.array_.length == 0) return;
                //        //for (let i = 0; i < controls.array_.length; i++) {
                //        //    if (controls.array_[i].get("name") == "mapGeocoder") {
                //        //        $(controls.array_[i].element).css("display", "block");
                //        //    }
                //        //}
                //    }
                //    else {
                //        let controls: any = this.map.getControls();
                //        if (!controls || !controls.array_ || controls.array_.length == 0) return;
                //        for (let i = 0; i < controls.array_.length; i++) {
                //            if (controls.array_[i].get("name") == "mapGeocoder") {
                //                $(controls.array_[i].element).css("display", "none");
                //            }
                //        }
                //    }
                //    this.map.set("map_pane_id", this.mObjectPane.id);
                //}
            };
            //  private checkAlarmOnLoad = (layer) => {
            //      let source = layer.getSource();
            //      let features = source.getFeatures();
            //      if (!features || features.length == 0) return;
            //      if (!MapsOpenLayers.alarmedResources || MapsOpenLayers.alarmedResources.length == 0) return;
            //      features.forEach((fItem: any) => {
            //          let resourceId = fItem.values_.resourceId;
            //          let addResource: any = this.globalDataAccessPoint.resources.byGuid[resourceId];
            //          let alarmed = MapsOpenLayers.alarmedResources.indexOf(resourceId);
            //          let check360Camera = this.is360CameraItem(addResource);
            //          if (alarmed >= 0) {
            //              //let alarmStyle = this.getAlarmResourceStyle(addResource);
            //              let icon360CameraAlarm = CameraIcons.ICON_SRC.icon360Alarm;
            //              let icon360MixedCameraAlarm = CameraIcons.ICON_SRC.iconMixed360Alarm;
            //              let alarmStyle: any;
            //              let style = fItem.getStyle();
            //              if ((addResource.resourceType === 'MixedVideoSource' || addResource.resourceType === 'PtzMixedVideoSource') && check360Camera === true) {
            //                  alarmStyle = icon360MixedCameraAlarm;
            //              } else if (check360Camera) {
            //                  alarmStyle = icon360CameraAlarm;
            //              } else {
            //                  alarmStyle = this.getAlarmResourceStyle(addResource);
            //              }
            //              style.setImage(new ol.style.Icon({
            //                  anchor: new CameraIcons(this.mapResource.mapIconSize).anchorSize,
            //                  size: new CameraIcons(this.mapResource.mapIconSize).getIconSize(this.mapResource.mapIconSize),
            //                  opacity: 1,
            //                  scale: style.getImage().getScale(),
            //                  src: alarmStyle,
            //                  rotation: style.getImage().getRotation()
            //              }))
            //              fItem.setStyle(style);
            //          }
            //      })
            //  }
            //  //== create a small Overview Map and toggle button
            this.createOverviewMap = function (controlsElement, objPane) {
                //      //== get only background layer for small map
                if (objPane.resource.mapType == 'Image') {
                    _this_1.bgMapImageLayer = MapsOpenLayers.getMapLayerByName(_this_1.map, 'BackLayer');
                }
                else {
                    _this_1.bgMapImageLayer = MapsOpenLayers.getMapLayerByName(_this_1.map, "backgroundLayer");
                }
                // console.log("This,bgMapImageLayer", this.bgMapImageLayer);
                //      //== we nned to create a controll for displaying a map - the map comes along with button
                var overviewMapControl = new ol.control.OverviewMap({
                    collapsed: true,
                    label: '',
                    collapseLabel: '',
                    tipLabel: '',
                    target: _this_1.mapElement,
                    view: new ol.View({
                        projection: _this_1.bgImageProjection,
                        maxZoom: 5,
                        minZoom: 0,
                        zoom: 0,
                        extent: _this_1.staticImagePoints
                    }),
                    layers: [_this_1.bgMapImageLayer]
                });
                overviewMapControl.set("name", "mapOverview");
                if (_this_1.mapResource.mapType != "Image") {
                    overviewMapControl = new ol.control.OverviewMap({ layers: [_this_1.bgMapImageLayer] });
                }
                var existingoverview = null;
                _this_1.map.getControls().forEach(function (control) {
                    if (control instanceof ol.control.OverviewMap) {
                        existingoverview = control;
                    }
                });
                if (existingoverview) {
                    _this_1.map.removeControl(existingoverview);
                }
                _this_1.map.addControl(overviewMapControl);
                //      //==============  Creating Custom Control Buttons
                //      //== Button for displaying small map - OverviewMap
                var toggleOverviewMapControll = /** @class */ (function (_super) {
                    __extends(toggleOverviewMapControll, _super);
                    function toggleOverviewMapControll(opt_options) {
                        if (opt_options === void 0) { opt_options = null; }
                        var _this_1 = _super.call(this, {}) || this;
                        var options = opt_options || {};
                        var name = options.name;
                        var viewContainer = options.viewContainer;
                        //== Creating a button 
                        var button = document.createElement('button');
                        button.className = 'vicon-font';
                        button.title = name;
                        button.style.setProperty("background-color", "#353f4c");
                        var buttonInner = options.buttonInner;
                        //  let viewActive = viewContainer.getActiveView();
                        //   let eventDispatcher: any = options.eventDispatcher;
                        //  let AUDITLOGMSGES: any = options.AUDITLOGMSGES;
                        //              //== click function
                        var toggleOverviewMapVisibility = function (e) {
                            //== toggle layer visibility
                            var collapseState = overviewMapControl.getCollapsed();
                            var resourceName = objPane.resource.name;
                            overviewMapControl.setCollapsed(!collapseState);
                            //== add/remove class for parent div
                            e.currentTarget.parentElement.classList.toggle("ol-active-btn");
                            localStorage.setItem('relativeLocation' + objPane.id, collapseState);
                            //   eventDispatcher.fireEvent("enter_application_log", AUDITLOGMSGES.monitoring.resource.mapDropped.toolBox.relativeLocation + resourceName, AUDITLOGMSGES.entryOperation.monitoring.mapRelativeLOC, AUDITLOGMSGES.entryOperation.operation.mapview, false, true, true, 2);
                        };
                        //              //== Click event listener
                        button.addEventListener('click', toggleOverviewMapVisibility, false);
                        button.addEventListener('touchstart', toggleOverviewMapVisibility, false);
                        button.appendChild(angular.element(buttonInner)[0]);
                        button.disabled = false;
                        //              //== inserting a button to div element like all other map controls
                        //   let viewPanelID = viewActive ? viewActive._id : options.viewID;
                        var stateClass = localStorage.getItem('relativeLocation' + objPane.id) == 'true' ? ' ol-active-btn ' : '';
                        if (localStorage.getItem('relativeLocation' + objPane.id) == 'true') {
                            var collapseState = overviewMapControl.getCollapsed();
                            overviewMapControl.setCollapsed(!collapseState);
                        }
                        var element = document.createElement('div');
                        element.className = 'ol-unselectable ol-control custom-overview-map ' + stateClass;
                        element.appendChild(button);
                        //== registering this control as map control
                        ol.control.Control.call(_this_1, {
                            element: element,
                            target: controlsElement
                        });
                        return _this_1;
                    }
                    return toggleOverviewMapControll;
                }(ol.control.Control));
                var overviewToggleControl = new toggleOverviewMapControll({
                    name: 'Relative Location',
                    buttonInner: "<span class=\"bg-relative-location-tool\"></span>",
                    viewContainer: _this_1.monitoringViewContainer,
                    eventDispatcher: _this_1.eventDispatcher,
                    AUDITLOGMSGES: _this_1.AUDITLOGMSGES,
                    viewID: _this_1.monitoringViewID
                });
                overviewToggleControl.set("name", "overviewToggleControl");
                _this_1.map.addControl(overviewToggleControl);
            };
            //  //== set up an event for camera drag and displaying info popup on camera hover
            this.setUpMonitoringMapCameraDragEvent = function (map, objPane, globalDataAccessPoint, permissionsService, infowindowTimeout) {
                var DragCamera = /** @class */ (function (_super) {
                    __extends(DragCamera, _super);
                    function DragCamera(parentContext) {
                        var _this_1 = _super.call(this) || this;
                        //== left or right mouse click
                        _this_1.handleDownEvent = function (e) {
                            //=====================
                            this.isDragging = false;
                            var isRightClick = e.originalEvent.which == 1 ? false : true;
                            var feature = this.map.forEachFeatureAtPixel(e.pixel, function (feature, layer) {
                                if (layer.get('name') == 'cameraImageLayer') {
                                    return feature;
                                }
                            });
                            if (!!feature) {
                                //    //== set up a dragged element position
                                this.resourceId = feature.get('resourceId') || '';
                                MapsOpenLayers.currentResourceId.id = this.resourceId;
                                MapsOpenLayers.currentResourceId.img = this.parentContext.getImageSrcFromFeature(feature);
                                MapsOpenLayers.currentResourceId.name = feature.get('name');
                            }
                            return !!feature;
                        };
                        //== while dragging dragging
                        _this_1.handleDragEvent = function (e) {
                            this.counter = 0;
                            this.isDragging = true;
                            this.thickClientObj.callBackToThickClientFunction('cameraDragStart', this.resourceId);
                        };
                        //== handle mousemove event - display cursor pointer and camera info popup
                        _this_1.handleMoveEvent = function (e) {
                            var _this_1 = this;
                            this.counter = 0;
                            //== if cursor moved while dragging
                            if (e.dragging) {
                                return;
                            }
                            var feature = this.map.forEachFeatureAtPixel(e.pixel, function (feature, layer) {
                                if (layer.get('name') == 'cameraImageLayer') {
                                    return feature;
                                }
                            });
                            var mapElem = this.map.getTarget();
                            //   let skipHoverResType:any={
                            //     // MixedVideoSource:1,
                            //     // PlaybackAudioSource:1,
                            //     // PlaybackVideoSource:1,
                            //     // PtzMixedVideoSource:1,
                            //     // PtzVideoSource:1,
                            //     // VideoSource:1
                            // }
                            //   if(!!feature)
                            //     console.log("feature.values_.resourceType", skipHoverResType[feature.values_.resourceType]);
                            if (!!feature && this.parentContext.isContextMenuOpen == false) {
                                //== cursor pointer - the camera icon is draggable and clickable
                                mapElem.style.cursor = 'pointer';
                                //== display camera info popup
                                if (this.parentContext.infoFeature != feature) {
                                    if (infowindowTimeout)
                                        clearTimeout(infowindowTimeout);
                                    infowindowTimeout = setTimeout(function () {
                                        _this_1.parentContext.showCameraInfoPopup(e.originalEvent, _this_1.map, feature, _this_1.objPane);
                                    }, 1000);
                                }
                                this.parentContext.infoFeature = feature;
                                //==
                            }
                            else {
                                //== hide camera info popup when not on camera icon
                                this.parentContext.infoFeature = null;
                                ////objPane = MapsOpenLayers.tempObjPane; //FIX FOR MULTI INSTANNSE PANE 
                                var popupCameraImg = document.getElementById('camera-info-img' + this.objPane.id + this.objPane.resource.id);
                                var popupCameraImgText = document.getElementById('camera-info-img-text' + objPane.id + objPane.resource.id);
                                if (popupCameraImg) {
                                    popupCameraImg.src = "";
                                    popupCameraImg.alt = "Loading...";
                                }
                                if (popupCameraImgText) {
                                    popupCameraImgText.style.display = "none";
                                    //popupCameraImg.src = "";
                                    // popupCameraImg.alt = "Loading..."
                                }
                                if (infowindowTimeout)
                                    clearTimeout(infowindowTimeout);
                                this.parentContext.hideCameraInfoPopup(this.map, this.objPane);
                                //== check if there are linked maps
                                var showCursor = this.map.hasFeatureAtPixel(e.pixel, { layerFilter: this.isHighlightLayer });
                                if (showCursor) {
                                    mapElem.style.cursor = 'pointer';
                                }
                                else {
                                    mapElem.style.cursor = '';
                                }
                                var linkedMapObj = this.map.forEachFeatureAtPixel(e.pixel, function (feature, layer) {
                                    if (layer.get('name') == 'linkedMapsLayer') {
                                        return feature;
                                    }
                                });
                                //this.parentContext.isContextMenuOpen = false;
                                if (linkedMapObj && linkedMapObj.values_ && linkedMapObj.values_.featureType && linkedMapObj.values_.featureType == 'unlinked') {
                                    mapElem.style.cursor = 'default';
                                }
                            }
                        };
                        //== Drop Action
                        _this_1.handleUpEvent = function (e) {
                            var _this_1 = this;
                            this.counter = 0;
                            var resourceId = this.resourceId;
                            MapsOpenLayers.currentResourceId.id = null;
                            //== if isDragging is still false on mouseUp event - it was a click, not a drag
                            if (!this.isDragging) {
                            }
                            else { //==  we need to handle drop event only if camera dragged
                                setTimeout(function () {
                                    //MapsOpenLayers.dropCameraOnMonitoringPane(resourceId, objPane);
                                    if (!e.dragging) {
                                        _this_1.isDragging = false;
                                        _this_1.thickClientObj.callBackToThickClientFunction('cameraDragEnd', _this_1.resourceId);
                                        _this_1.resourceId = '';
                                    }
                                }, 500);
                                //== Remove created HTML element
                                if (!!this.draggedDomObj) {
                                    document.body.removeChild(this.draggedDomObj);
                                }
                            }
                            //== changing state of drag
                            //this.isDragging = false;
                        };
                        _this_1.isDragging = false;
                        _this_1.draggedDomObj = null;
                        _this_1.resourceId = '';
                        _this_1.vdoLiv = '';
                        _this_1.parentContext = parentContext;
                        _this_1.counter = 0;
                        _this_1.map = map;
                        _this_1.objPane = objPane;
                        _this_1.thickClientObj = new ThickClientCommunication();
                        ol.interaction.Pointer.call(_this_1, {
                            handleDownEvent: _this_1.handleDownEvent,
                            handleDragEvent: _this_1.handleDragEvent,
                            handleMoveEvent: _this_1.handleMoveEvent,
                            handleUpEvent: _this_1.handleUpEvent
                        });
                        return _this_1;
                    }
                    return DragCamera;
                }(ol.interaction.Pointer));
                ;
                //      //Double click to open live video popup
                //   let doubleClickedLiveVdo: HTMLElement = document.getElementById('camera-live-video-info');
                //   if (!doubleClickedLiveVdo) {
                //       doubleClickedLiveVdo = angular.element('<div class="vms-display-layout-pane vms-player-pool playBackProxy" id="xyz' + "camInfo" + objPane.id + '" draggable = "true"  style="position:relative;  width:348px; height:220px; margin-top:-15px;" draggable="true"><div class="vms-player-tools flex-between"><div class="flex-start"><span class="vms-pane-resource-type-icon"> </span><div> </div><span class="vms-player-resource-title text-overflow"> </span><span title = "Alternate" class="vms-player-alternate"><span class="vicon-font v-warning"><span></span><i> </i><i> </i></span></span></div><div class="flex-end"></div></div></div>')[0];
                //       let spn: HTMLSpanElement = document.createElement("span");
                //       spn.setAttribute("class", "vicon-font v-close-x generalInfo");
                //       spn.onclick = (e) => {
                //           angular.element('#xyz' + "camInfo" + objPane.id).hide();
                //           if (localStorage.getItem("liveVdoPopUpId") && e) {
                //               localStorage.removeItem("liveVdoPopUpId");
                //           }
                //           this.playerOpenIdQplayBack = [];
                //       }
                //       doubleClickedLiveVdo.childNodes[0].childNodes[1].appendChild(spn);
                //       document.body.appendChild(doubleClickedLiveVdo);
                //   }
                //   var popup = new ol.Overlay({
                //       id: 'cameraLiveVdoPopup',
                //       element: doubleClickedLiveVdo,
                //       stopEvent: false,
                //       offset: [0, 0]
                //   });
                //   popup.set("name", "cameraLiveVdoPopup");
                //   map.addOverlay(popup);
                //      //double logic to open video popup
                var featuresList;
                if (!!_this_1.cameraVectorSource) {
                    featuresList = _this_1.cameraVectorSource.getFeatures();
                    //   if (!!featuresList) {
                    //       featuresList.forEach((feature: ol.Feature): void => {
                    //           let appendId = feature.get('resourceId')
                    //           //Double click to open live video popup
                    //           let doubleClickedLiveVdo: HTMLElement = document.getElementById('camera-live-video-info');
                    //           if (!doubleClickedLiveVdo) {
                    //               doubleClickedLiveVdo = angular.element('<div class="vms-display-layout-pane vms-player-pool " id="xyz' + "camInfo" + objPane.id + appendId + '" draggable = "true"  style="position:relative;  width:348px; height:220px; margin-top:-15px;" draggable="true"><div class="vms-player-tools flex-between"><div class="flex-start"><span class="vms-pane-resource-type-icon"> </span><div> </div><span class="vms-player-resource-title text-overflow"> </span><span title = "Alternate" class="vms-player-alternate"><span class="vicon-font v-warning"><span></span><i> </i><i> </i></span></span></div><div class="flex-end"></div></div></div>')[0];
                    //               let spn: HTMLSpanElement = document.createElement("span");
                    //               spn.setAttribute("class", "vicon-font v-close-x");
                    //               spn.onclick = (e) => {
                    //                   try {
                    //                       let playerPanel: any = angular.element('#xyz' + "camInfo" + objPane.id + appendId);
                    //                       if (playerPanel) {
                    //                           let player: any = playerPanel[0].getElementsByTagName("object");
                    //                           if (player && player.length > 0) {
                    //                               //player[0].Close();
                    //                               ///ele pl .click)(
                    //                               player[0].removeNode();
                    //                               try {
                    //                                   var bookmarkResource = globalDataAccessPoint.resources.byGuid[appendId];
                    //                                   if (bookmarkResource)
                    //                                       this.eventDispatcher.fireEvent("hide_bookmark_popup", bookmarkResource);
                    //                               }
                    //                               catch (e) {
                    //                               }
                    //                           }
                    //                       }
                    //                   }
                    //                   catch (e) {
                    //                       console.log("dispose error : ", e);
                    //                   }
                    //                   angular.element('#xyz' + "camInfo" + objPane.id + appendId).hide();
                    //                   if (localStorage.getItem("liveVdoPopUpId") && e) {
                    //                       localStorage.removeItem("liveVdoPopUpId");
                    //                   }
                    //                   let value = appendId;
                    //                   let arr = this.playerOpenId;
                    //                   arr = arr.filter(function (item :any) {
                    //                       return item !== value
                    //                   })
                    //                   this.playerOpenId = arr;
                    //                   this.playerOpenIdQplayBack = [];
                    //               }
                    //               doubleClickedLiveVdo.childNodes[0].childNodes[1].appendChild(spn);
                    //               document.body.appendChild(doubleClickedLiveVdo);
                    //           }
                    //           var popup = new ol.Overlay({
                    //               id: 'cameraLiveVdoPopup' + appendId,
                    //               element: doubleClickedLiveVdo,
                    //               stopEvent: false,
                    //               offset: [0, 0]
                    //           });
                    //           popup.set("name", "cameraLiveFeedOverlay");
                    //           map.addOverlay(popup);
                    //       })
                    //   }
                }
                //      //end
                var customDragInteraction = new DragCamera(_this_1);
                customDragInteraction.set("name", "customDragInteraction");
                var dValX = _this_1.vidData;
                var aValX = _this_1.audioData;
                var vxvmsTreeViewService = _this_1.vmsTreeViewService;
                map.on('pointermove', function (evt) {
                    _this_1.currentMousePoint = evt.coordinate;
                    if (_this_1.selectedOverlay) {
                        evt.preventDefault();
                        evt.stopPropagation();
                        _this_1.selectedOverlay.setPosition([(_this_1.currentMousePoint[0] + _this_1.overlayDiffX), (_this_1.currentMousePoint[1] + _this_1.overlayDiffY)]);
                    }
                });
                map.on('dblclick', function (evt) {
                    evt.preventDefault();
                    try {
                        if (_this_1.mObjectPane && _this_1.mObjectPane.domContainer.className == "player-div")
                            return;
                        _this_1.hideCameraInfoPopup(_this_1.map, _this_1.mObjectPane);
                        var feature = map.forEachFeatureAtPixel(evt.pixel, function (feature, layer) {
                            if (layer.get('name') == 'cameraImageLayer') {
                                var resourceId = feature.get('resourceId') || '';
                                var resource = objPane.resource.mapItems[0].resource;
                                for (var i = 0; i < objPane.resource.mapItems.length; i++) {
                                    if (objPane.resource.mapItems[i].resource && objPane.resource.mapItems[i].resource.id == resourceId) {
                                        resource = objPane.resource.mapItems[i].resource;
                                        resource._resourceType = resource.resourceType;
                                    }
                                }
                                var hasPlayLiveRestriction = _this_1.permissionsService.hasPlayliveRestriction(resource);
                                if (hasPlayLiveRestriction)
                                    return;
                                var geom = feature.getGeometry();
                                var coord = geom.getCoordinates();
                                var id = '#xyz' + "camInfo" + _this_1.mObjectPane.id + resourceId;
                                var payload = {
                                    "resourceId": resourceId,
                                    "Coordinates": coord,
                                    "playerOverlayId": id
                                };
                                var obj = new ThickClientCommunication();
                                obj.callBackToThickClientFunction('doubleClickOnResource', payload);
                                if (!_this_1.openPlayerIds[id])
                                    _this_1.openPlayerIds[id] = 1;
                                //   const popupLiveVdo = map.getOverlayById('cameraLiveVdoPopup' + resourceId);
                                //   let liveVdoPopUpId = '#xyz' + "camInfo" + this.mObjectPane.id + resourceId;
                                //   localStorage.setItem("liveVdoPopUpId", liveVdoPopUpId);
                                //   let isAudioObj = false;
                                //   var resourceTest = this.globalDataAccessPoint.resources.byGuid[resourceId];
                                //   let hasPlayLiveRestriction = this.permissionsService.hasPlayliveRestriction(/*resourceTest*/ false);
                                //   if (resourceId && resourceId != '') {
                                //       const addResource: any = this.globalDataAccessPoint.resources.byGuid[resourceId];
                                //       if (addResource) {
                                //           if (addResource.resourceType == 'View' || addResource.resourceType == 'DigitalInput' || addResource.resourceType == 'RelayOutput' || addResource.resourceType == 'Tour' || addResource.resourceType == "VAXDoorResource" || addResource.resourceType == "LPRSensorResource") {
                                //               return false;
                                //           } else if (addResource.resourceType == 'AudioSource') {
                                //               isAudioObj = true;
                                //           }
                                //       }
                                //   }
                                //   if (hasPlayLiveRestriction == false) {
                                //       coord[0] = coord[0] + this.deltaXDiff;
                                //       popupLiveVdo.setPosition(coord);
                                //       let popuLiveVdopObj: any = popupLiveVdo.getElement();
                                //       var copyObjPane: any = objPane.clone();
                                //       copyObjPane._domContainer = popuLiveVdopObj;
                                //       popuLiveVdopObj.style.display = 'block';
                                //       popupLiveVdo.set('resourceId', resourceId, true);
                                //       var res = this.getResourceObj(resourceId);
                                //       let elmTargetPane = this.getNewPanel(); // objPane.clone();
                                //       elmTargetPane._domContainer = popuLiveVdopObj;
                                //       elmTargetPane.id = "xyz" + "camInfo" + this.mObjectPane.id + resourceId;
                                //       elmTargetPane.resource = this.globalDataAccessPoint.resources.byGuid[resourceId]; //(res && res.length > 0) ? res.actualObject : this.globalDataAccessPoint.resources.byGuid[resourceId];
                                //       elmTargetPane.fireExtendEventOff = true;
                                //       if (isAudioObj == true)
                                //           aValX.executeResourceSpecificLogic(elmTargetPane);
                                //       else
                                //           this.createPlayer(elmTargetPane, elmTargetPane._domContainer, resourceId, false, null);
                                //       this.playerOpenId.push(resourceId);
                                //       //movable player
                                //       let moveObj: HTMLDivElement = document.createElement("div");
                                //       let titleSpan: any = popuLiveVdopObj.getElementsByClassName("vms-player-resource-title");
                                //       moveObj.setAttribute("style", "cursor:crosshair;width:25px;height:25px;display:block;overflow:hidden;position:absolute;left:-15px;top:-15px;background:blue;z-index:9999;background:url('images/MoveIcon.png')");
                                //       moveObj.setAttribute("rName", titleSpan[0].innerText);
                                //       let existingOverlay = this.overLayList.filter((overlayItem :any) => {
                                //           return (overlayItem.rName == titleSpan[0].innerText)
                                //       });
                                //       if (existingOverlay && existingOverlay.length > 0) {
                                //           existingOverlay[0].oObj = popupLiveVdo;
                                //           existingOverlay[0].resourceId = resourceId;
                                //           existingOverlay[0].rName = titleSpan[0].innerText;
                                //       }
                                //       else {
                                //           this.overLayList.push({ oObj: popupLiveVdo, resourceId: resourceId, rName: titleSpan[0].innerText });
                                //       }
                                //       this.resetOverlayPosWithPanel(resourceId);
                                //       moveObj.onmousedown = (e) => {
                                //           e.preventDefault();
                                //           e.stopPropagation();
                                //           if (!this.selectedOverlay) {
                                //               let overLays = this.overLayList.filter((o :any) => {
                                //                   let target: any = e.target;
                                //                   return (o.rName == target.getAttribute('rName'))
                                //               });
                                //               if (overLays && overLays.length > 0)
                                //                   this.selectedOverlay = overLays[0].oObj;
                                //               let pos = this.selectedOverlay.getPosition();
                                //               this.overlayDiffX = pos[0] - this.currentMousePoint[0];
                                //               this.overlayDiffY = pos[1] - this.currentMousePoint[1];
                                //           }
                                //       }
                                //       moveObj.onmouseup = (e) => {
                                //           e.preventDefault();
                                //           e.stopPropagation();
                                //           this.selectedOverlay = null;
                                //       }
                                //       document.onmouseup = (e) => {
                                //           e.preventDefault();
                                //           e.stopPropagation();
                                //           this.selectedOverlay = null;
                                //       }
                                //       //end
                                //       // resizing overlay
                                //       let resizeObj: HTMLDivElement = document.createElement("div");
                                //       //let frm: HTMLIFrameElement = document.createElement("iframe");
                                //       //frm.style.setProperty("border","0px");
                                //       let enteredInResizeDiv = false;
                                //       resizeObj.setAttribute("style", "cursor:nw-resize;width:45px;height:45px;display:block;overflow:hidden;position:absolute;right:-38px;bottom:-38px;background:blue;z-index:9999;background:url('images/Resize_Icon.png') no-repeat center");
                                //       this.isPanelSelected = false;
                                //       popuLiveVdopObj.onmouseover = (e :any) => {
                                //           e.preventDefault();
                                //           e.stopPropagation();
                                //           popuLiveVdopObj.appendChild(moveObj);
                                //           popuLiveVdopObj.appendChild(resizeObj);
                                //       }
                                //       resizeObj.onmousemove = (e) => {
                                //           e.preventDefault();
                                //           e.stopPropagation();
                                //           enteredInResizeDiv = true;
                                //           if (this.isPanelSelected == true) {
                                //               let diffX = e.offsetX - this.clientX;
                                //               let diffY = e.offsetY - this.clientY;
                                //               let height = parseInt(popuLiveVdopObj.style.height.substring(0, popuLiveVdopObj.style.height.length - 2)) + 2;
                                //               let width = parseInt(popuLiveVdopObj.style.width.substring(0, popuLiveVdopObj.style.width.length - 2)) + 2;
                                //               height = height + diffY;
                                //               width = width + diffX;
                                //               if (height >= 120) {
                                //                   popuLiveVdopObj.style.height = height.toString() + "px";
                                //               }
                                //               if (width >= 200) {
                                //                   popuLiveVdopObj.style.width = width.toString() + "px";
                                //               }
                                //           }
                                //       }
                                //       resizeObj.onmouseout = (e) => {
                                //           e.preventDefault();
                                //           e.stopPropagation();
                                //           this.isPanelSelected = false;
                                //       }
                                //       resizeObj.onmousedown = (e) => {
                                //           e.preventDefault();
                                //           e.stopPropagation();
                                //           this.clientX = e.offsetX;
                                //           this.clientY = e.offsetY;
                                //           this.isPanelSelected = true;
                                //           this.map.getInteractions().forEach((interaction) => { interaction.setActive(false); });
                                //       }
                                //       resizeObj.onmouseup = (e) => {
                                //           e.preventDefault();
                                //           e.stopPropagation();
                                //           this.isPanelSelected = false;
                                //           this.map.getInteractions().forEach((interaction) => { interaction.setActive(true); });
                                //       }
                                //       popuLiveVdopObj.onmouseup = (e:any) => {
                                //           e.preventDefault();
                                //           e.stopPropagation();
                                //           this.selectedOverlay = null;
                                //       }
                                //       this.mapElement.onmouseup = (e :any) => {
                                //           this.selectedOverlay = null;
                                //           this.isPanelSelected = false;
                                //           this.map.getInteractions().forEach((interaction) => { interaction.setActive(true); });
                                //       }
                                //       //end;
                                //   }
                            }
                        });
                    }
                    catch (e) {
                        console.log("popup player issue ", e);
                    }
                });
                map.addInteraction(customDragInteraction);
            };
            //  //End code for double click on specific camera for monitoring
            //  //== hiding camera info popup
            this.hideCameraInfoPopup = function (map, objPane) {
                var popup = map.getOverlayById('cameraInfoPopup');
                if (!map || !popup)
                    return;
                var popupElem = popup.getElement();
                popupElem.style.display = 'none';
                _this_1.infoFeatObj = null;
                _this_1.infoOvPoObj = null;
                //
                _this_1.snapshotId = null;
                _this_1.cameraInfoBoxId = null;
                _this_1.cameraInfoBoxIdText = null;
                _this_1.removeCameraInfoPopup(map, objPane);
            };
            //  //== get an image src used in feature - camera image
            this.getImageSrcFromFeature = function (feature) {
                var src = '';
                var chainObject = feature.getStyle();
                if (chainObject) {
                    chainObject = chainObject.getImage();
                }
                if (chainObject) {
                    chainObject = chainObject.getImage();
                }
                if (chainObject) {
                    chainObject = chainObject.src;
                }
                if (chainObject && typeof (chainObject) == 'string') {
                    src = chainObject;
                }
                return src;
            };
            //  //== creating an overlay for displaying camera info
            this.createCameraInfoPopup = function (map, objPane) {
                var infoElement = document.getElementById("camInfo" + objPane.id);
                if (infoElement) {
                    try {
                        document.body.removeChild(infoElement);
                    }
                    catch (e) { }
                    ;
                }
                infoElement = angular.element('<div class="overlayelement" style="width:200px;height:80px;word-break:break-all; background-color:#1a2028;text-align: center;" id="camInfo' + objPane.id + '"data-pane-id="' + objPane.id + '" data-resource-id="' + objPane.resource.id + '"><span id="camera-info-name' + objPane.id + objPane.resource.id + '" style="color: white;"></span><span id="camera-info-screen" ><span id="camera-info-img-text' + objPane.id + objPane.resource.id + '" class="imgLoadingText">Loading...</span><img id="camera-info-img' + objPane.id + objPane.resource.id + '" style="width:200px;height:80px;" src="RightClickContext/pixel.png" /></span></div>')[0];
                document.body.appendChild(infoElement);
                infoElement.ondblclick = function (e) {
                    e.preventDefault();
                    e.stopPropagation();
                    return false;
                };
                var infoOverlay = new ol.Overlay({
                    id: 'cameraInfoPopup',
                    element: infoElement,
                    offset: [0, 0],
                    stopEvent: false,
                    positioning: 'bottom-left'
                });
                infoOverlay.set("name", "cameraInfoPopup");
                map.addOverlay(infoOverlay);
            };
            this.removeCameraInfoPopup = function (map, objPane) {
                var infoOverlay = map.getOverlayById('cameraInfoPopup');
                if (infoOverlay)
                    map.removeOverlay(infoOverlay);
                var infoElement = document.getElementById("camInfo" + objPane.id);
                if (infoElement) {
                    try {
                        document.body.removeChild(infoElement);
                    }
                    catch (e) { }
                    ;
                }
            };
            //  //== load image to image object with pre-load test
            this.showCameraInfoPopup = function (coordinate, map, feature, objPane) {
                _this_1.removeCameraInfoPopup(map, objPane);
                _this_1.createCameraInfoPopup(map, objPane);
                _this_1.infoFeatObj = feature;
                var popup = map.getOverlayById('cameraInfoPopup');
                var resourceId = feature.get('resourceId') || '';
                var cameraName = feature.get('name') || '';
                var oldPopipResourceId = popup.get('resourceId');
                // const addResource: any = this.globalDataAccessPoint.resources.byGuid[resourceId];
                var addResource = objPane.resourcesArray.filter(function (item) {
                    return item.id == resourceId;
                })[0];
                var coordinates = map.getEventCoordinate(coordinate);
                //popup.setPosition(coordinates);
                var gFeature = feature.getGeometry();
                var coords = gFeature.getCoordinates();
                // this.showAlarmforPartnerEvent({
                //     SourceId: "d07ab688-b7bb-422b-8844-b2f87ec338fd",
                //     resourceType: 'LPRSensorResource',
                //     PlateNumber: "4025DKR",
                //     messagebody: 'MH12 BQ 1234',
                //     state: 'ON',
                //     isAlarm: false
                // });
                // console.log("Show Alarm Calledd.....!!!!");
                var payload = {
                    "resourceId": resourceId,
                    "coordinates": coordinates
                };
                _this_1.snapshotId = resourceId;
                coords[0] = coords[0] + _this_1.deltaXDiff;
                popup.setPosition(coords);
                _this_1.infoOvPoObj = popup;
                if (addResource && addResource.resourceType == 'PlaybackVideoSource')
                    return;
                //let resourceTest = this.globalDataAccessPoint.resources.byGuid[resourceId];
                var resource = objPane.resource.mapItems[0].resource;
                for (var i = 0; i < objPane.resource.mapItems.length; i++) {
                    if (objPane.resource.mapItems[i].resource && objPane.resource.mapItems[i].resource.id == resourceId) {
                        resource = objPane.resource.mapItems[i].resource;
                        resource._resourceType = resource.resourceType;
                    }
                }
                var hasPlayLiveRestriction = _this_1.permissionsService.hasPlayliveRestriction(resource);
                // if(hasPlayLiveRestriction)  return;
                // let hasPlayLiveRestriction = false;// this.permissionsService.hasPlayliveRestriction(resourceTest);
                // shows the live snap pop up if resource have access for live
                if (hasPlayLiveRestriction == false) {
                    var popupObj = popup.getElement();
                    popupObj.style.display = 'block';
                    //== setting up camera data only if resourceId changed
                    popup.set('resourceId', resourceId, true);
                    //== getting a screenshot from the camera
                    _this_1.cameraInfoBoxId = 'camera-info-img' + objPane.id + objPane.resource.id;
                    _this_1.cameraInfoBoxIdText = 'camera-info-img-text' + objPane.id + objPane.resource.id;
                    var popupCameraImg = document.getElementById('camera-info-img' + objPane.id + objPane.resource.id);
                    var popupCameraImgText = document.getElementById('camera-info-img-text' + objPane.id + objPane.resource.id);
                    if (popupCameraImgText)
                        popupCameraImgText.style.display = "none";
                    var infoContainer = document.getElementById("camInfo" + objPane.id);
                    if (popupCameraImg && infoContainer) {
                        popupCameraImg.src = "";
                        popupCameraImg.alt = "Loading...";
                        popupCameraImg.style.display = "none";
                        //setTimeout(() => {
                        var dom = _this_1.mObjectPane.domContainer;
                        if (addResource && (addResource.resourceType == 'AudioSource' || addResource.resourceType == 'DigitalInput' || addResource.resourceType == 'RelayOutput' || addResource.resourceType == 'View' || addResource.resourceType == 'Tour')) {
                            popupCameraImg.style.display = "none";
                            infoContainer.style.height = "20px";
                        }
                        else if (addResource && (addResource.resourceType == 'LPRSensorResource' || addResource.resourceType == 'VAXDoorResource' || addResource.resourceType == 'VAXActionPlanResource')) {
                            popupCameraImg.style.display = "none";
                            infoContainer.style.height = "auto";
                        }
                        else {
                            popupCameraImg.style.display = "none";
                            popupCameraImgText.style.display = "block";
                            infoContainer.style.height = "auto";
                        }
                        var left = 0;
                        if ((infoContainer.parentElement.offsetLeft + 200) > dom.offsetWidth) {
                            left = infoContainer.parentElement.offsetLeft - 200;
                        }
                        if (left > 0) {
                            infoContainer.parentElement.style.left = left.toString() + "px";
                        }
                        var rect = dom.getBoundingClientRect();
                        var infoRect = popup.getElement().getBoundingClientRect();
                        var paneBottom = rect.top;
                        var overlayBottom = infoRect.top;
                        if (paneBottom > overlayBottom) {
                            //console.log(" in rect modify");
                            popup.setPosition([coordinates[0], coordinates[1] - 125]);
                        }
                        //   this.videoChannelsHelperService.takeSnapshot(resourceId).then((success:any) => {
                        //       if (success) {
                        //           const screenSrc = this.videoChannelsHelperService.getResourceSnapshot(resourceId, "Large");
                        //           this.loadImageWithTest(popupCameraImg, screenSrc);
                        //       }
                        //   })
                        //}, 100);
                        //== getting current camera name
                        var popupCameraTitle = document.getElementById('camera-info-name' + objPane.id + objPane.resource.id);
                        popupCameraTitle.textContent = cameraName;
                    }
                }
                var obj = new ThickClientCommunication();
                obj.callBackToThickClientFunction('hoverOnResource', payload);
            };
            this.setupRightClickContextMenuForMonitoring = function (objPane) {
                var quickPlayBack_icon = 'RightClickContext/quick_play.png'; //'app/images/configuration/menu-DELETE/normal/quick_play.png';
                var gotToPreset_icon = 'RightClickContext/preset.png'; //'app/images/configuration/menu-DELETE/normal/preset.png';
                var show_property_icon = 'RightClickContext/show_property.png'; //'app/images/icons/tree_icons/show_property.png';
                var user_details_icon = 'RightClickContext/user_details.png'; //'app/images/icons/tree_icons/user_details.png';
                var pulse_block_icon = 'RightClickContext/pulse_block.png'; //'app/images/icons/tree_icons/pulse_block.png';
                var Dview_icon = 'RightClickContext/Dview.png'; //'app/images/icons/tree_icons/Dview.png';
                var vax_action_plan_view = 'RightClickContext/action_plan.svg'; //'app/images/icons/tree_icons/Dview.png';
                var resume_icon = 'RightClickContext/resume.png'; //'app/images/icons/tree_icons/resume.png';
                var override_icon = 'RightClickContext/override.png'; //'app/images/icons/tree_icons/override.png';
                var vax_action_plan_play = 'RightClickContext/vax_action_plan_play.svg'; //'app/images/icons/tree_icons/vax_action_plan_play.svg'
                var vax_action_plan_execute = 'RightClickContext/vax_action_plan_execute.svg'; //'app/images/icons/tree_icons/vax_action_plan_execute.svg'
                var center = function (obj) { };
                var marker = function (obj) { };
                //      //for quick play back context menu options
                //      this.eventDispatcher.subscribe("quick_playback_time_changed", (time, currentId) => {
                //          this.onQuickPlayback(time, currentId);
                //      });
                var objPane_val = objPane.id;
                //      //vax
                var resumeDoor = function () {
                    var resourceId = _this_1.selectedFeature.get('resourceId') || '';
                    var obj = new ThickClientCommunication();
                    obj.callBackToThickClientFunction('vaxOptionSelected', { 'action': 'resume', 'resourceId': resourceId });
                    //   const vaxDoorResource: any = this.globalDataAccessPoint.resources.byGuid[resourceId];
                    //   const id = vaxDoorResource.deviceId;
                    //   const req = [vaxDoorResource.door.id];
                    //   this.mapsFactory.resumeDoor(id,req).then((data: any) => {
                    //       console.log("resume door data:", data);
                    //   });
                    //console.log("selected", obj);
                };
                var pulseUnlockDoor = function () {
                    var resourceId = _this_1.selectedFeature.get('resourceId') || '';
                    var obj = new ThickClientCommunication();
                    obj.callBackToThickClientFunction('vaxOptionSelected', { 'action': 'pulseUnlock', 'resourceId': resourceId });
                    //   const vaxDoorResource: any = this.globalDataAccessPoint.resources.byGuid[resourceId];
                    //   const id = vaxDoorResource.deviceId;
                    //   const req = [vaxDoorResource.door.id];
                    //   this.mapsFactory.pulseDoor(id, req).then((data: any) => {
                    //       console.log("pulse unlock door data:", data);
                    //   });
                    //console.log("selected", obj);
                };
                var vaxDrpExcResTypes = ['map', 'view', 'tour', 'audiosource', 'url', 'lprsensorresource', 'alarmmonitor']; // not supported resource types in lowercase
                var viewVAXDoorResource = function () {
                    var resourceId = _this_1.selectedFeature.get('resourceId') || '';
                    var obj = new ThickClientCommunication();
                    obj.callBackToThickClientFunction('vaxOptionSelected', { 'action': 'view', 'resourceId': resourceId });
                    //   //const vaxDoorResource: any = this.globalDataAccessPoint.resources.byGuid[resourceId];
                    //   this.addPartnerService.getLPRSensorResourcesList(resourceId).then((data:any) => {
                    //       if (data) {
                    //           var isSupportedRes = false;
                    //           data.forEach((itm: any) => {
                    //               let vaxLinkedResource: any = this.globalDataAccessPoint.resources.byGuid[itm];
                    //               if (vaxDrpExcResTypes.indexOf(vaxLinkedResource.resourceType.toLowerCase()) < 0) {
                    //                   isSupportedRes = true;
                    //                   this.onPlayFromLinkedResource(vaxLinkedResource);
                    //               } else {
                    //                   isSupportedRes = false;
                    //               }
                    //           });
                    //           if (!isSupportedRes) {
                    //               var warningmsg = {
                    //                   headerText: this.languageService.getValueByKey('warning'),
                    //                   body: {
                    //                       controls: true,
                    //                       yes: this.languageService.getValueByKey('confirm_ok'),
                    //                       text: this.languageService.getValueByKey("vax_supported_view_msg")
                    //                   }
                    //               };
                    //               this.confirmService.fire(
                    //                   function () {
                    //                   },
                    //                   function () {
                    //                   },
                    //                   function () {
                    //                   },
                    //                   warningmsg
                    //               );
                    //           }
                    //       }
                    //   });
                };
                //View vax action plan related resource on map
                var viewVAXACtionPlanResource = function () {
                    var resourceId = _this_1.selectedFeature.get('resourceId') || '';
                    var obj = new ThickClientCommunication();
                    obj.callBackToThickClientFunction('vaxActionPlanOptionSelected', { 'action': 'view', 'resourceId': resourceId });
                };
                // Execute action plan from map 
                var executeActionPlan = function () {
                    var resourceId = _this_1.selectedFeature.get('resourceId') || '';
                    var obj = new ThickClientCommunication();
                    obj.callBackToThickClientFunction('vaxActionPlanOptionSelected', { 'action': 'execute', 'resourceId': resourceId });
                };
                var viewLPRSensorResource = function () {
                    var resourceId = _this_1.selectedFeature.get('resourceId') || '';
                    var obj = new ThickClientCommunication();
                    obj.callBackToThickClientFunction('lprOptionSelected', { 'action': 'view', 'resourceId': resourceId });
                    //let lprLinkedResourceItem: any = this.globalDataAccessPoint.resources.byGuid[lprLinkedResource.sensor.id];
                    //   const lPRSensorResource: any = this.globalDataAccessPoint.resources.byGuid[resourceId];
                    //   //.sensor.id
                    //   this.onPlayFromLinkedResource(lPRSensorResource);
                };
                var gotoDoors = function (obj) {
                    var resourceId = _this_1.selectedFeature.get('resourceId') || '';
                    var vaxDoorResource = _this_1.globalDataAccessPoint.resources.byGuid[resourceId];
                    //console.log("vaxDoorResource--->", vaxDoorResource);
                    _this_1.eventDispatcher.fireEvent("GO_TO_DOOR", vaxDoorResource.id);
                };
                var override = function (obj) {
                    var resourceId = _this_1.selectedFeature.get('resourceId') || '';
                    //   const vaxDoorResource: any = this.globalDataAccessPoint.resources.byGuid[resourceId];
                    //   const id = vaxDoorResource.deviceId;
                    /*Override types:
                     0 - specific time duration
                     1 - until next schedule
                     2 - until resume
  
                     timezone mode :
                     0 - lockdown
                     1 - card
                     2 - pin
                     3 - card or pin
                     4 - card and pin
                     5 - unlock
                     6 - first credential in
                     7 - dual credential
  
                       obj.data = { timezone: '', overridetype: '', minutes :'' }
                     */
                    var req = {
                        TimeZoneMode: obj.data.timezone,
                        OverrideType: obj.data.overridetype,
                        minutes: obj.data.minutes,
                        resourceId: resourceId
                    };
                    //   this.mapsFactory.overrideDoor(id, req).then((data: any) => {
                    //       console.log("override door data:", data);
                    //   });
                    var obj1 = new ThickClientCommunication();
                    obj1.callBackToThickClientFunction('vaxOptionSelected', { 'action': 'override', 'payload': req });
                };
                //      //vax end
                //      //end        
                //      //handling context menu as resources type like, videochannel
                var contextmenu_items = [
                    {
                        text: 'Quick Playback',
                        resourceType: ['AudioSource', 'PTZcamera', 'MixedChannel', 'FixedCamera', 'PtzMixedVideoSource', 'MixedVideoSource', 'PlaybackVideoSource', 'PlaybackAudioSource'],
                        icon: quickPlayBack_icon,
                        callback: center,
                        data: {},
                        items: [
                            {
                                text: "<div style='width:180px;display:block;overflow:hidden;'> \n                                      <div style='display:block;overflow:hidden;'>\n                                          <button style=\"font-size:11px;width:47px;margin:2px;float:left;border:1px solid transparent !important; border-radius: 0px !important; padding: 0px !important; backgrount-color: #4c5362 !important;\" class='btn btn-info' onclick='var ele = document.getElementById(\"map-canvas\");  var ctr = angular.element(ele).scope(); ctr.onQuickPlayback(10, \"" + objPane_val + "\");'>10 sec.</button>\n                                          <button style=\"font-size:11px;width:47px;margin:2px;float:left;border:1px solid transparent !important; border-radius: 0px !important; padding: 0px !important; backgrount-color: #4c5362 !important;\" class='btn btn-info' onclick='var ele = document.getElementById(\"map-canvas\");  var ctr = angular.element(ele).scope(); ctr.onQuickPlayback(30, \"" + objPane_val + "\");'>30 sec.</button>\n                                          <button style=\"font-size:11px;width:47px;margin:2px;float:left;border:1px solid transparent !important; border-radius: 0px !important; padding: 0px !important; backgrount-color: #4c5362 !important;\" class='btn btn-info' onclick='var ele = document.getElementById(\"map-canvas\");  var ctr = angular.element(ele).scope(); ctr.onQuickPlayback(50, \"" + objPane_val + "\");'>50 sec.</button>\n\n                                      </div>\n                                      <div style='display:block;overflow:hidden;'>\n                                          <button style=\"font-size:11px;width:47px;margin:2px;float:left;border:1px solid transparent !important; border-radius: 0px !important; padding: 0px !important; backgrount-color: #4c5362 !important;\" class='btn btn-info' onclick='var ele = document.getElementById(\"map-canvas\");  var ctr = angular.element(ele).scope(); ctr.onQuickPlayback(60, \"" + objPane_val + "\");'>1 min.</button>\n                                          <button style=\"font-size:11px;width:47px;margin:2px;float:left;border:1px solid transparent !important; border-radius: 0px !important; padding: 0px !important; backgrount-color: #4c5362 !important;\" class='btn btn-info'  onclick='var ele = document.getElementById(\"map-canvas\"); var ctr = angular.element(ele).scope(); ctr.onQuickPlayback(90, \"" + objPane_val + "\");'>1.5 min.</button>\n                                          <button style=\"font-size:11px;width:47px;margin:2px;float:left;border:1px solid transparent !important; border-radius: 0px !important; padding: 0px !important; backgrount-color: #4c5362 !important;\" class='btn btn-info' onclick='var ele = document.getElementById(\"map-canvas\");  var ctr = angular.element(ele).scope(); ctr.onQuickPlayback(120, \"" + objPane_val + "\");'> 2 min.</button>\n                                      </div>\n                                      <div style='display:block;overflow:hidden;'>\n                                          <button style=\"font-size:11px;width:47px;margin:2px;float:left;border:1px solid transparent !important; border-radius: 0px !important; padding: 0px !important; backgrount-color: #4c5362 !important;\" class='btn btn-info' onclick='var ele = document.getElementById(\"map-canvas\");  var ctr = angular.element(ele).scope(); ctr.onQuickPlayback(150, \"" + objPane_val + "\");'>2.5 min.</button>\n                                          <button style=\"font-size:11px;width:47px;margin:2px;float:left;border:1px solid transparent !important; border-radius: 0px !important; padding: 0px !important; backgrount-color: #4c5362 !important;\" class='btn btn-info' onclick='var ele = document.getElementById(\"map-canvas\");  var ctr = angular.element(ele).scope(); ctr.onQuickPlayback(180, \"" + objPane_val + "\");'>3 min.</button>\n                                          <button style=\"font-size:11px;width:47px;margin:2px;float:left;border:1px solid transparent !important; border-radius: 0px !important; padding: 0px !important; backgrount-color: #4c5362 !important;\" class='btn btn-info' onclick='var ele = document.getElementById(\"map-canvas\");  var ctr = angular.element(ele).scope(); ctr.onQuickPlayback(210, \"" + objPane_val + "\");'>3.5 min.</button>\n                                      </div>\n                                    </div>",
                            }
                        ]
                    },
                    {
                        text: 'Go to Preset',
                        resourceType: ['PTZcamera', 'PtzMixedVideoSource'],
                        icon: gotToPreset_icon,
                        callback: center,
                        data: {}
                    },
                    {
                        text: 'Show Properties',
                        resourceType: ['View', 'AudioSource', 'PTZcamera', 'MixedChannel', 'FixedCamera', 'PtzMixedVideoSource', 'PTZcamera', 'PtzMixedVideoSource', 'DigitalInput', 'RelayOutput', 'Tour', 'MixedVideoSource', 'Map', 'PlaybackVideoSource', 'PlaybackAudioSource'],
                        icon: show_property_icon,
                        callback: center,
                        data: {}
                    },
                    {
                        text: 'NVR Details',
                        resourceType: ['AudioSource', 'PTZcamera', 'MixedChannel', 'FixedCamera', 'PtzMixedVideoSource', 'PTZcamera', 'PtzMixedVideoSource', 'MixedVideoSource'],
                        icon: user_details_icon,
                        callback: center,
                        data: {}
                    },
                    {
                        //text: 'VAX_View',
                        text: 'View',
                        resourceType: ['VAXDoorResource'],
                        icon: Dview_icon,
                        callback: viewVAXDoorResource,
                        data: {},
                        hideOnAlarm: true
                        //items: [{
                        //    text: 'Vax Resources',
                        //    resourceType: ['VAXDoorResource'],
                        //    icon: '',
                        //    callback: center
                        //}]
                    },
                    {
                        text: 'Pulse Unlock',
                        resourceType: ['VAXDoorResource'],
                        icon: pulse_block_icon,
                        callback: pulseUnlockDoor,
                        data: {}
                    },
                    {
                        text: 'Resume',
                        resourceType: ['VAXDoorResource'],
                        icon: resume_icon,
                        callback: resumeDoor,
                        data: {}
                    },
                    {
                        text: 'Override',
                        resourceType: ['VAXDoorResource'],
                        icon: override_icon,
                        callback: center,
                        data: {},
                        items: [
                            {
                                text: 'LockDown',
                                resourceType: ['VAXDoorResource'],
                                icon: '',
                                callback: center,
                                data: { text: 'lockdown' },
                                items: [
                                    {
                                        text: 'Until Next Schedule',
                                        resourceType: ['VAXDoorResource'],
                                        icon: '',
                                        callback: override,
                                        data: { timezone: 0, overridetype: 1, minutes: Number }
                                    },
                                    {
                                        text: 'Until Resume',
                                        resourceType: ['VAXDoorResource'],
                                        icon: '',
                                        callback: override,
                                        data: { timezone: 0, overridetype: 2, minutes: Number }
                                    },
                                    {
                                        text: 'For Specified Duration',
                                        resourceType: ['VAXDoorResource'],
                                        icon: '',
                                        callback: center,
                                        data: {},
                                        items: [
                                            {
                                                text: '5 min',
                                                resourceType: ['VAXDoorResource'],
                                                icon: '',
                                                callback: override,
                                                data: { timezone: 0, overridetype: 0, minutes: 5 }
                                            },
                                            {
                                                text: '10 min',
                                                resourceType: ['VAXDoorResource'],
                                                icon: '',
                                                callback: override,
                                                data: { timezone: 0, overridetype: 0, minutes: 10 }
                                            },
                                            {
                                                text: '15 min',
                                                resourceType: ['VAXDoorResource'],
                                                icon: '',
                                                callback: override,
                                                data: { timezone: 0, overridetype: 0, minutes: 10 }
                                            },
                                            {
                                                text: '20 min',
                                                resourceType: ['VAXDoorResource'],
                                                icon: '',
                                                callback: override,
                                                data: { timezone: 0, overridetype: 0, minutes: 20 }
                                            },
                                            {
                                                text: '25 min',
                                                resourceType: ['VAXDoorResource'],
                                                icon: '',
                                                callback: override,
                                                data: { timezone: 0, overridetype: 0, minutes: 25 }
                                            },
                                            {
                                                text: '30 min',
                                                resourceType: ['VAXDoorResource'],
                                                icon: '',
                                                callback: override,
                                                data: { timezone: 0, overridetype: 0, minutes: 30 }
                                            }
                                        ]
                                    }
                                ]
                            },
                            {
                                text: 'Card',
                                resourceType: ['VAXDoorResource'],
                                icon: '',
                                callback: center,
                                data: { text: 'card' },
                                items: [
                                    {
                                        text: 'Until Next Schedule',
                                        resourceType: ['VAXDoorResource'],
                                        icon: '',
                                        callback: override,
                                        data: { timezone: 1, overridetype: 1, minutes: null }
                                    },
                                    {
                                        text: 'Until Resume',
                                        resourceType: ['VAXDoorResource'],
                                        icon: '',
                                        callback: override,
                                        data: { timezone: 1, overridetype: 2, minutes: null }
                                    },
                                    {
                                        text: 'For Specified Duration',
                                        resourceType: ['VAXDoorResource'],
                                        icon: '',
                                        callback: center,
                                        data: {},
                                        items: [
                                            {
                                                text: '5 min',
                                                resourceType: ['VAXDoorResource'],
                                                icon: '',
                                                callback: override,
                                                data: { timezone: 1, overridetype: 0, minutes: 5 }
                                            },
                                            {
                                                text: '10 min',
                                                resourceType: ['VAXDoorResource'],
                                                icon: '',
                                                callback: override,
                                                data: { timezone: 1, overridetype: 0, minutes: 10 }
                                            },
                                            {
                                                text: '15 min',
                                                resourceType: ['VAXDoorResource'],
                                                icon: '',
                                                callback: override,
                                                data: { timezone: 1, overridetype: 0, minutes: 10 }
                                            },
                                            {
                                                text: '20 min',
                                                resourceType: ['VAXDoorResource'],
                                                icon: '',
                                                callback: override,
                                                data: { timezone: 1, overridetype: 0, minutes: 20 }
                                            },
                                            {
                                                text: '25 min',
                                                resourceType: ['VAXDoorResource'],
                                                icon: '',
                                                callback: override,
                                                data: { timezone: 1, overridetype: 0, minutes: 25 }
                                            },
                                            {
                                                text: '30 min',
                                                resourceType: ['VAXDoorResource'],
                                                icon: '',
                                                callback: override,
                                                data: { timezone: 1, overridetype: 0, minutes: 30 }
                                            }
                                        ]
                                    }
                                ]
                            },
                            {
                                text: 'PIN',
                                resourceType: ['VAXDoorResource'],
                                icon: '',
                                callback: center,
                                data: { text: 'pin' },
                                items: [
                                    {
                                        text: 'Until Next Schedule',
                                        resourceType: ['VAXDoorResource'],
                                        icon: '',
                                        callback: override,
                                        data: { timezone: 2, overridetype: 1, minutes: null }
                                    },
                                    {
                                        text: 'Until Resume',
                                        resourceType: ['VAXDoorResource'],
                                        icon: '',
                                        callback: override,
                                        data: { timezone: 2, overridetype: 2, minutes: null }
                                    },
                                    {
                                        text: 'For Specified Duration',
                                        resourceType: ['VAXDoorResource'],
                                        icon: '',
                                        callback: center,
                                        data: {},
                                        items: [
                                            {
                                                text: '5 min',
                                                resourceType: ['VAXDoorResource'],
                                                icon: '',
                                                callback: override,
                                                data: { timezone: 2, overridetype: 0, minutes: 5 }
                                            },
                                            {
                                                text: '10 min',
                                                resourceType: ['VAXDoorResource'],
                                                icon: '',
                                                callback: override,
                                                data: { timezone: 2, overridetype: 0, minutes: 10 }
                                            },
                                            {
                                                text: '15 min',
                                                resourceType: ['VAXDoorResource'],
                                                icon: '',
                                                callback: override,
                                                data: { timezone: 2, overridetype: 0, minutes: 10 }
                                            },
                                            {
                                                text: '20 min',
                                                resourceType: ['VAXDoorResource'],
                                                icon: '',
                                                callback: override,
                                                data: { timezone: 2, overridetype: 0, minutes: 20 }
                                            },
                                            {
                                                text: '25 min',
                                                resourceType: ['VAXDoorResource'],
                                                icon: '',
                                                callback: override,
                                                data: { timezone: 2, overridetype: 0, minutes: 25 }
                                            },
                                            {
                                                text: '30 min',
                                                resourceType: ['VAXDoorResource'],
                                                icon: '',
                                                callback: override,
                                                data: { timezone: 2, overridetype: 0, minutes: 30 }
                                            }
                                        ]
                                    }
                                ]
                            },
                            {
                                text: 'Card or PIN',
                                resourceType: ['VAXDoorResource'],
                                icon: '',
                                callback: center,
                                data: { text: 'cardorpin' },
                                items: [
                                    {
                                        text: 'Until Next Schedule',
                                        resourceType: ['VAXDoorResource'],
                                        icon: '',
                                        callback: override,
                                        data: { timezone: 3, overridetype: 1, minutes: null }
                                    },
                                    {
                                        text: 'Until Resume',
                                        resourceType: ['VAXDoorResource'],
                                        icon: '',
                                        callback: override,
                                        data: { timezone: 3, overridetype: 2, minutes: null }
                                    },
                                    {
                                        text: 'For Specified Duration',
                                        resourceType: ['VAXDoorResource'],
                                        icon: '',
                                        callback: center,
                                        data: {},
                                        items: [
                                            {
                                                text: '5 min',
                                                resourceType: ['VAXDoorResource'],
                                                icon: '',
                                                callback: override,
                                                data: { timezone: 3, overridetype: 0, minutes: 5 }
                                            },
                                            {
                                                text: '10 min',
                                                resourceType: ['VAXDoorResource'],
                                                icon: '',
                                                callback: override,
                                                data: { timezone: 3, overridetype: 0, minutes: 10 }
                                            },
                                            {
                                                text: '15 min',
                                                resourceType: ['VAXDoorResource'],
                                                icon: '',
                                                callback: override,
                                                data: { timezone: 3, overridetype: 0, minutes: 10 }
                                            },
                                            {
                                                text: '20 min',
                                                resourceType: ['VAXDoorResource'],
                                                icon: '',
                                                callback: override,
                                                data: { timezone: 3, overridetype: 0, minutes: 20 }
                                            },
                                            {
                                                text: '25 min',
                                                resourceType: ['VAXDoorResource'],
                                                icon: '',
                                                callback: override,
                                                data: { timezone: 3, overridetype: 0, minutes: 25 }
                                            },
                                            {
                                                text: '30 min',
                                                resourceType: ['VAXDoorResource'],
                                                icon: '',
                                                callback: override,
                                                data: { timezone: 3, overridetype: 0, minutes: 30 }
                                            }
                                        ]
                                    }
                                ]
                            },
                            {
                                text: 'Card and PIN',
                                resourceType: ['VAXDoorResource'],
                                icon: '',
                                callback: center,
                                data: { text: 'cardandpin' },
                                items: [
                                    {
                                        text: 'Until Next Schedule',
                                        resourceType: ['VAXDoorResource'],
                                        icon: '',
                                        callback: override,
                                        data: { timezone: 4, overridetype: 1, minutes: null }
                                    },
                                    {
                                        text: 'Until Resume',
                                        resourceType: ['VAXDoorResource'],
                                        icon: '',
                                        callback: override,
                                        data: { timezone: 4, overridetype: 2, minutes: null }
                                    },
                                    {
                                        text: 'For Specified Duration',
                                        resourceType: ['VAXDoorResource'],
                                        icon: '',
                                        callback: center,
                                        data: {},
                                        items: [
                                            {
                                                text: '5 min',
                                                resourceType: ['VAXDoorResource'],
                                                icon: '',
                                                callback: override,
                                                data: { timezone: 4, overridetype: 0, minutes: 5 }
                                            },
                                            {
                                                text: '10 min',
                                                resourceType: ['VAXDoorResource'],
                                                icon: '',
                                                callback: override,
                                                data: { timezone: 4, overridetype: 0, minutes: 10 }
                                            },
                                            {
                                                text: '15 min',
                                                resourceType: ['VAXDoorResource'],
                                                icon: '',
                                                callback: override,
                                                data: { timezone: 4, overridetype: 0, minutes: 10 }
                                            },
                                            {
                                                text: '20 min',
                                                resourceType: ['VAXDoorResource'],
                                                icon: '',
                                                callback: override,
                                                data: { timezone: 4, overridetype: 0, minutes: 20 }
                                            },
                                            {
                                                text: '25 min',
                                                resourceType: ['VAXDoorResource'],
                                                icon: '',
                                                callback: override,
                                                data: { timezone: 4, overridetype: 0, minutes: 25 }
                                            },
                                            {
                                                text: '30 min',
                                                resourceType: ['VAXDoorResource'],
                                                icon: '',
                                                callback: override,
                                                data: { timezone: 4, overridetype: 0, minutes: 30 }
                                            }
                                        ]
                                    }
                                ]
                            },
                            {
                                text: 'Unlock',
                                resourceType: ['VAXDoorResource'],
                                icon: '',
                                callback: center,
                                data: { text: 'unlock' },
                                items: [
                                    {
                                        text: 'Until Next Schedule',
                                        resourceType: ['VAXDoorResource'],
                                        icon: '',
                                        callback: override,
                                        data: { timezone: 5, overridetype: 1, minutes: null }
                                    },
                                    {
                                        text: 'Until Resume',
                                        resourceType: ['VAXDoorResource'],
                                        icon: '',
                                        callback: override,
                                        data: { timezone: 5, overridetype: 2, minutes: null }
                                    },
                                    {
                                        text: 'For Specified Duration',
                                        resourceType: ['VAXDoorResource'],
                                        icon: '',
                                        callback: center,
                                        data: {},
                                        items: [
                                            {
                                                text: '5 min',
                                                resourceType: ['VAXDoorResource'],
                                                icon: '',
                                                callback: override,
                                                data: { timezone: 5, overridetype: 0, minutes: 5 }
                                            },
                                            {
                                                text: '10 min',
                                                resourceType: ['VAXDoorResource'],
                                                icon: '',
                                                callback: override,
                                                data: { timezone: 5, overridetype: 0, minutes: 10 }
                                            },
                                            {
                                                text: '15 min',
                                                resourceType: ['VAXDoorResource'],
                                                icon: '',
                                                callback: override,
                                                data: { timezone: 5, overridetype: 0, minutes: 10 }
                                            },
                                            {
                                                text: '20 min',
                                                resourceType: ['VAXDoorResource'],
                                                icon: '',
                                                callback: override,
                                                data: { timezone: 5, overridetype: 0, minutes: 20 }
                                            },
                                            {
                                                text: '25 min',
                                                resourceType: ['VAXDoorResource'],
                                                icon: '',
                                                callback: override,
                                                data: { timezone: 5, overridetype: 0, minutes: 25 }
                                            },
                                            {
                                                text: '30 min',
                                                resourceType: ['VAXDoorResource'],
                                                icon: '',
                                                callback: override,
                                                data: { timezone: 5, overridetype: 0, minutes: 30 }
                                            }
                                        ]
                                    }
                                ]
                            },
                            {
                                text: 'First Credential In',
                                resourceType: ['VAXDoorResource'],
                                icon: '',
                                callback: center,
                                data: { text: 'firstcardin' },
                                items: [
                                    {
                                        text: 'Until Next Schedule',
                                        resourceType: ['VAXDoorResource'],
                                        icon: '',
                                        callback: override,
                                        data: { timezone: 6, overridetype: 1, minutes: null }
                                    },
                                    {
                                        text: 'Until Resume',
                                        resourceType: ['VAXDoorResource'],
                                        icon: '',
                                        callback: override,
                                        data: { timezone: 6, overridetype: 2, minutes: null }
                                    },
                                    {
                                        text: 'For Specified Duration',
                                        resourceType: ['VAXDoorResource'],
                                        icon: '',
                                        callback: center,
                                        data: {},
                                        items: [
                                            {
                                                text: '5 min',
                                                resourceType: ['VAXDoorResource'],
                                                icon: '',
                                                callback: override,
                                                data: { timezone: 6, overridetype: 0, minutes: 5 }
                                            },
                                            {
                                                text: '10 min',
                                                resourceType: ['VAXDoorResource'],
                                                icon: '',
                                                callback: override,
                                                data: { timezone: 6, overridetype: 0, minutes: 10 }
                                            },
                                            {
                                                text: '15 min',
                                                resourceType: ['VAXDoorResource'],
                                                icon: '',
                                                callback: override,
                                                data: { timezone: 6, overridetype: 0, minutes: 10 }
                                            },
                                            {
                                                text: '20 min',
                                                resourceType: ['VAXDoorResource'],
                                                icon: '',
                                                callback: override,
                                                data: { timezone: 6, overridetype: 0, minutes: 20 }
                                            },
                                            {
                                                text: '25 min',
                                                resourceType: ['VAXDoorResource'],
                                                icon: '',
                                                callback: override,
                                                data: { timezone: 6, overridetype: 0, minutes: 25 }
                                            },
                                            {
                                                text: '30 min',
                                                resourceType: ['VAXDoorResource'],
                                                icon: '',
                                                callback: override,
                                                data: { timezone: 6, overridetype: 0, minutes: 30 }
                                            }
                                        ]
                                    }
                                ]
                            },
                            {
                                text: 'Dual Credential',
                                resourceType: ['VAXDoorResource'],
                                icon: '',
                                callback: center,
                                data: { text: 'dualcard' },
                                items: [
                                    {
                                        text: 'Until Next Schedule',
                                        resourceType: ['VAXDoorResource'],
                                        icon: '',
                                        callback: override,
                                        data: { timezone: 7, overridetype: 1, minutes: null }
                                    },
                                    {
                                        text: 'Until Resume',
                                        resourceType: ['VAXDoorResource'],
                                        icon: '',
                                        callback: override,
                                        data: { timezone: 7, overridetype: 2, minutes: null }
                                    },
                                    {
                                        text: 'For Specified Duration',
                                        resourceType: ['VAXDoorResource'],
                                        icon: '',
                                        callback: center,
                                        data: {},
                                        items: [
                                            {
                                                text: '5 min',
                                                resourceType: ['VAXDoorResource'],
                                                icon: '',
                                                callback: override,
                                                data: { timezone: 7, overridetype: 0, minutes: 5 }
                                            },
                                            {
                                                text: '10 min',
                                                resourceType: ['VAXDoorResource'],
                                                icon: '',
                                                callback: override,
                                                data: { timezone: 7, overridetype: 0, minutes: 10 }
                                            },
                                            {
                                                text: '15 min',
                                                resourceType: ['VAXDoorResource'],
                                                icon: '',
                                                callback: override,
                                                data: { timezone: 7, overridetype: 0, minutes: 10 }
                                            },
                                            {
                                                text: '20 min',
                                                resourceType: ['VAXDoorResource'],
                                                icon: '',
                                                callback: override,
                                                data: { timezone: 7, overridetype: 0, minutes: 20 }
                                            },
                                            {
                                                text: '25 min',
                                                resourceType: ['VAXDoorResource'],
                                                icon: '',
                                                callback: override,
                                                data: { timezone: 7, overridetype: 0, minutes: 25 }
                                            },
                                            {
                                                text: '30 min',
                                                resourceType: ['VAXDoorResource'],
                                                icon: '',
                                                callback: override,
                                                data: { timezone: 7, overridetype: 0, minutes: 30 }
                                            }
                                        ]
                                    }
                                ]
                            }
                        ]
                    },
                    {
                        text: 'View',
                        resourceType: ['LPRSensorResource'],
                        icon: Dview_icon,
                        callback: viewLPRSensorResource,
                        data: {},
                        hideOnAlarm: true
                        //items: [{
                        //    text: 'LPR Resources',
                        //    resourceType: ['LPRSensorResource'],
                        //    icon: '',
                        //    callback: center
                        //}]
                    },
                    {
                        text: 'View',
                        resourceType: ['VAXActionPlanResource'],
                        icon: vax_action_plan_view,
                        callback: viewVAXACtionPlanResource,
                        data: {},
                        hideOnAlarm: true
                    },
                    {
                        text: '',
                        resourceType: ['VAXActionPlanResource'],
                        icon: vax_action_plan_execute,
                        callback: {},
                        data: {},
                        hideOnAlarm: false,
                        nameUpdate: true
                    },
                    {
                        text: 'Run',
                        resourceType: ['VAXActionPlanResource'],
                        icon: vax_action_plan_play,
                        callback: executeActionPlan,
                        data: {},
                        hideOnAlarm: false
                    }
                ];
                //      //end
                var onMenuOpen = function () {
                    _this_1.hideCameraInfoPopup(_this_1.map, _this_1.mObjectPane);
                };
                var options = {
                    items: contextmenu_items,
                    width: 180,
                    onopen: onMenuOpen,
                    layersOn: ['cameraImageLayer', 'linkedMapsLayer'],
                };
                _this_1.setupRightClickContextMenu(options, objPane);
            };
            //  //== displaying right click context menu
            this.setupRightClickContextMenu = function (opt_options, objPane) {
                var options = opt_options || {};
                var that = _this_1;
                var showOnLayers = (!!options.layersOn && options.layersOn.length) ? options.layersOn : null;
                var hideOnLayers = (!!options.layersOff && options.layersOff.length) ? options.layersOff : null;
                var ContextMenu = _this_1.mapsExternalLibrariesService.getMapsContextMenu();
                var contextmenu = new ContextMenu({
                    width: options.width || 180,
                    items: options.items,
                    defaultItems: false
                });
                contextmenu.set("name", "contextmenuControl");
                _this_1.map.addControl(contextmenu);
                _this_1.map.on("pointermove", function (e) {
                    var mCoords = _this_1.map.getEventPixel(e.originalEvent);
                    var fItem = _this_1.map.forEachFeatureAtPixel(mCoords, function (feature, layer) {
                        return feature;
                    });
                    if ((!fItem || fItem == undefined || fItem.values_.type == "funnelIconFeature") && (e.originalEvent.target.tagName.toLowerCase() == "canvas")) {
                        contextmenu.close();
                    }
                });
                //      //== beforeopen we can check what to do    
                contextmenu.on('beforeopen', function (e) {
                    try {
                        $('.ol-ctx-menu-container').css({ 'visibility': 'hidden' });
                        //  $('.ol-ctx-menu-container').css({ 'visibility': '' })
                        _this_1.isContextMenuOpen = true;
                        //              if (this.fromMonitoring)
                        //                  this.hideCameraInfoPopup(this.map, this.mObjectPane);
                        var data_1 = _this_1.map.forEachFeatureAtPixel(e.pixel, function (feature, layer) {
                            var ret = {
                                feature: feature,
                                layer: layer
                            };
                            _this_1.selectedFeature = feature;
                            _this_1.selectedContextMenuItem = feature;
                            //                      //disable context menu for stickyNoteFeature
                            if (_this_1.fromMonitoring && _this_1.selectedFeature.values_.type == 'stickyNoteFeature')
                                return null;
                            var liveVdoPopUpId = localStorage.getItem("liveVdoPopUpId");
                            if (_this_1.fromMonitoring && liveVdoPopUpId) {
                                contextmenu.clear();
                            }
                            //                      //for context menu
                            var resId1 = feature.getProperties();
                            _this_1.playbackResource = resId1;
                            //restrict context menu if player is open 
                            if (_this_1.fromMonitoring && _this_1.openPlayerIds['#xyz' + "camInfo" + _this_1.mObjectPane.id + resId1.resourceId]) {
                                return false;
                            }
                            //    var resource = this.globalDataAccessPoint.resources.byGuid[resId1.resourceId];
                            var resource = null; //objPane.resource.mapItems[0].resource;
                            //Harry S. fix 
                            //   for(let i=0;i<objPane.resource.mapItems.length;i++){
                            //       if(objPane.resource.mapItems[i].resource && objPane.resource.mapItems[i].resource.id == resId1.resourceId){
                            //         resource = objPane.resource.mapItems[i].resource;
                            //         resource._resourceType = resource.resourceType;
                            //       }
                            //   }
                            resource = _this_1.mObjectPane.resourcesArray.filter(function (item) {
                                return item.id == resId1.resourceId;
                            })[0];
                            if (resource) {
                                resource._resourceType = resource.resourceType;
                            }
                            //end
                            if (options.items[0].resourceType) {
                                if (resource.resourceType === 'Tour') {
                                    //console.log('Tour');
                                    contextmenu.clear();
                                }
                                else if (resource.resourceType === 'View' && _this_1.fromMonitoring) {
                                    contextmenu.clear();
                                    contextmenu.extend(options.items);
                                }
                                else if (resource.resourceType === 'VAXDoorResource' && _this_1.fromMonitoring) {
                                    contextmenu.clear();
                                    contextmenu.extend(options.items);
                                    /*options.items.forEach((item: any) => {
                                        if (item.text == 'Override') {
                                            item.items.forEach((item1: any) => {
                                                if (item1.text == 'Lockdown') {
                                                    contextmenu.extend(item1.items);
                                                }
                                            })

                                        }
                                    })*/
                                    //  }
                                }
                                else if (resource.resourceType === 'LPRSensorResource' && _this_1.fromMonitoring) {
                                    contextmenu.clear();
                                    contextmenu.extend(options.items);
                                }
                                else {
                                    contextmenu.clear();
                                    contextmenu.extend(options.items);
                                }
                            }
                            else if (!_this_1.fromMonitoring) {
                                var feature_1 = _this_1.map.forEachFeatureAtPixel(e.pixel, function (ft, l) {
                                    return ft;
                                });
                                var resId1_1 = feature_1.getProperties();
                                if (resId1_1.type == 'stickyNoteFeature' || resId1_1.type == "linkedMapFeature") {
                                    var onlyDelete = options.items.slice(0, 1);
                                    contextmenu.clear();
                                    contextmenu.extend(onlyDelete);
                                }
                                else if (resId1_1.type == 'iconFeature') {
                                    if (resource._resourceType == 'LPRSensorResource') {
                                        var onlyShowProperty = Object.assign([], options);
                                        var lpr_info_property_icon_1 = 'images/icons/lpr_info_icon.svg';
                                        onlyShowProperty = onlyShowProperty.items.slice(0, 3);
                                        onlyShowProperty.forEach(function (item) {
                                            if (item.data.type == 'sensorIp') {
                                                item.text = _this_1.getLPRSensorNameResourceConfig;
                                            }
                                            if (item.data.type == 'asset') {
                                                item.icon = lpr_info_property_icon_1;
                                                item.text = _this_1.getNameResourceConfig;
                                            }
                                        });
                                        contextmenu.clear();
                                        contextmenu.extend(onlyShowProperty);
                                    }
                                    else if (resource._resourceType == 'VAXDoorResource') {
                                        var onlyShowProperty = Object.assign([], options);
                                        var lpr_info_property_icon1_1 = 'images/icons/lpr_info_icon.svg';
                                        if (_this_1.getVAXDoorNameResourceConfig) {
                                            onlyShowProperty = onlyShowProperty.items.slice(0, 3);
                                        }
                                        else {
                                            onlyShowProperty = onlyShowProperty.items.slice(0, 2);
                                        }
                                        onlyShowProperty.forEach(function (item) {
                                            if (item.data.type == 'sensorIp') {
                                                item.text = _this_1.getVAXDoorNameResourceConfig;
                                            }
                                            if (item.data.type == 'asset') {
                                                item.icon = lpr_info_property_icon1_1;
                                                item.text = _this_1.getVAXNameResourceConfig;
                                            }
                                        });
                                        contextmenu.clear();
                                        contextmenu.extend(onlyShowProperty);
                                    }
                                    else if (resource._resourceType == 'VideoSource' || resource._resourceType == 'MixedVideoSource' || resource._resourceType == 'PtzMixedVideoSource' || resource._resourceType == 'PtzVideoSource') {
                                        var onlyShowProperty = Object.assign([], options);
                                        onlyShowProperty = onlyShowProperty.items.slice(0, 5);
                                        onlyShowProperty.forEach(function (item) {
                                            if (item.data.type == 'asset') {
                                                item.text = _this_1.getNameResourceConfig;
                                            }
                                            if (item.data.type == 'sensorIp') {
                                                item.icon = '';
                                                item.text = '';
                                            }
                                        });
                                        contextmenu.clear();
                                        contextmenu.extend(onlyShowProperty);
                                    }
                                    else if (resource._resourceType == 'View' || resource._resourceType == 'Tour' || resource._resourceType == 'RelayOutput' || resource._resourceType == 'AudioSource' || resource._resourceType == 'DigitalInput' || resource._resourceType == 'PlaybackAudioSource') {
                                        var onlyShowProperty = Object.assign([], options);
                                        onlyShowProperty = onlyShowProperty.items.slice(0, 2);
                                        onlyShowProperty.forEach(function (item) {
                                            if (item.data.type == 'asset') {
                                                item.text = _this_1.getNameResourceConfig;
                                            }
                                        });
                                        contextmenu.clear();
                                        contextmenu.extend(onlyShowProperty);
                                    }
                                    else if (resource._resourceType == "VAXActionPlanResource") {
                                        var onlyShowProperty = Object.assign([], options);
                                        var vax_action_property_icon1 = 'images/icons/vax_action_plan_play.svg';
                                        if (_this_1.getVAXActionPlanNameResourceConfig) {
                                            onlyShowProperty = onlyShowProperty.items.slice(0, 1);
                                        }
                                        onlyShowProperty.push({
                                            text: _this_1.getVAXActionPlanNameResourceConfig,
                                            data: { type: 'actionPlanAsset' },
                                            icon: vax_action_property_icon1,
                                        });
                                        contextmenu.clear();
                                        contextmenu.extend(onlyShowProperty);
                                    }
                                }
                            }
                            //                      //end
                            var layerName = layer.get('name');
                            if (!!hideOnLayers && hideOnLayers.indexOf(layerName) == -1) { //== not present in Hide array
                                return ret;
                            }
                            else if (!!showOnLayers && showOnLayers.indexOf(layerName) > -1) { //== or present in Show array
                                return ret;
                            }
                            return null;
                        });
                        data_1.feature.getProperties().resourceId;
                        var value_1 = data_1.feature.getProperties().resourceId;
                        var arr = false;
                        arr = _this_1.playerOpenId.filter(function (item) {
                            if (item == value_1) {
                                return true;
                            }
                        });
                        var arrQpb = false;
                        arrQpb = _this_1.playerOpenIdQplayBack.filter(function (item) {
                            if (item == value_1) {
                                return true;
                            }
                        });
                        if (!!data_1 && !!data_1.feature && (arr == false && arrQpb == false)) {
                            $('.ol-ctx-menu-container').css({ 'visibility': '' });
                            contextmenu.enable();
                            //et obj = new ThickClientCommunication();
                            //obj.callBackToThickClientFunction('rightClickOnContextMenu', { 'resourceId': value });
                            options.items.forEach(function (item) {
                                item.data.feature = data_1.feature;
                                item.data.layer = data_1.layer;
                                if (item.text == 'Go to Preset') {
                                    _this_1.getPresetList(item, contextmenu, options.items);
                                }
                                if (item.text == 'Show Properties' && item.data.feature.values_.type === "iconFeature") {
                                    _this_1.getViewName(item, contextmenu, options.items);
                                }
                                else if (item.text == 'Show Properties' && item.data.feature.values_.type === "linkedMapFeature") {
                                    _this_1.getMapName(item, contextmenu, options.items);
                                }
                                if (item.text == 'NVR Details')
                                    _this_1.getNVRIdName(item, contextmenu, options.items);
                                //if (item.text == 'View' && item.resourceType[0] === "VAXDoorResource") {
                                //    this.getVAXLinkedResourceNameVal(item, contextmenu, options.items);
                                //}
                                //if (item.text == 'View' && item.resourceType[0] === "LPRSensorResource") {
                                //   this.getLPRLinkedResourceNameVal(item, contextmenu, options.items);
                                //}
                            });
                            if (options.items[0].resourceType) {
                                var feature = _this_1.map.forEachFeatureAtPixel(e.pixel, function (ft, l) {
                                    return ft;
                                });
                                // created dynamic contextmenu_items @@jaya  //////
                                var resId1 = feature.getProperties();
                                //Fix Harry S.
                                var resource = null; //objPane.resource.mapItems[0].resource;
                                for (var i = 0; i < objPane.resource.mapItems.length; i++) {
                                    if (objPane.resource.mapItems[i].resource && objPane.resource.mapItems[i].resource.id == resId1.resourceId) {
                                        resource = objPane.resource.mapItems[i].resource;
                                        resource._resourceType = resource.resourceType;
                                    }
                                }
                                //console.log("resource   ",resource);
                                var hasPlaybackRestriction = _this_1.permissionsService.hasPlaybackRestriction(resource);
                                //Resourcesset for contextmenu
                                contextmenu.options['clickedResource'] = resource;
                                var items = options.items.filter(function (item) {
                                    //check if menu items is required to hide on alarm page 
                                    if (!that.showViewOption && item.hideOnAlarm) {
                                        return false;
                                    }
                                    if (resource._resourceType === 'VideoSource') {
                                        if (item.resourceType.indexOf("FixedCamera") > -1) {
                                            var FixedCamera = resource.sourceProperties;
                                            return true;
                                        }
                                    }
                                    if (resource._resourceType === 'PtzMixedVideoSource') {
                                        if (item.resourceType.indexOf("PtzMixedVideoSource") > -1) {
                                            var PtzMixedVideoSource = resource.sourceProperties;
                                            return true;
                                        }
                                    }
                                    if (resource._resourceType === 'MixedVideoSource') {
                                        if (item.resourceType.indexOf("MixedVideoSource") > -1) {
                                            var MixedVideoSource = resource.sourceProperties;
                                            return true;
                                        }
                                    }
                                    if (resource._resourceType === 'PtzVideoSource') {
                                        if (item.resourceType.indexOf("PTZcamera") > -1) {
                                            var PtzVideoSource = resource.sourceProperties;
                                            return true;
                                        }
                                    }
                                    if (resource._resourceType === 'AudioSource') {
                                        if (item.resourceType.indexOf("AudioSource") > -1) {
                                            var AudioSource = resource.sourceProperties;
                                            return true;
                                        }
                                    }
                                    if (resource._resourceType === 'View') {
                                        if (item.resourceType.indexOf("View") > -1) {
                                            return true;
                                        }
                                    }
                                    if (resource._resourceType === 'Tour') {
                                        if (item.resourceType.indexOf("Tour") > -1) {
                                            return true;
                                        }
                                    }
                                    if (resource._resourceType === 'Map') {
                                        if (item.resourceType.indexOf("Map") > -1) {
                                            return true;
                                        }
                                    }
                                    if (resource._resourceType === 'DigitalInput') {
                                        if (item.resourceType.indexOf("DigitalInput") > -1) {
                                            return true;
                                        }
                                    }
                                    if (resource._resourceType === 'RelayOutput') {
                                        if (item.resourceType.indexOf("RelayOutput") > -1) {
                                            return true;
                                        }
                                    }
                                    if (resource._resourceType === 'PlaybackVideoSource') {
                                        if (item.resourceType.indexOf("PlaybackVideoSource") > -1) {
                                            return true;
                                        }
                                    }
                                    if (resource._resourceType === 'PlaybackAudioSource') {
                                        if (item.resourceType.indexOf("PlaybackAudioSource") > -1) {
                                            return true;
                                        }
                                    }
                                    if (resource._resourceType === 'VAXDoorResource') {
                                        if (item.resourceType.indexOf("VAXDoorResource") > -1) {
                                            return true;
                                        }
                                    }
                                    if (resource._resourceType === 'LPRSensorResource') {
                                        if (item.resourceType.indexOf("LPRSensorResource") > -1) {
                                            return true;
                                        }
                                    }
                                    if (resource._resourceType === 'VAXActionPlanResource') {
                                        if (item.resourceType.indexOf("VAXActionPlanResource") > -1) {
                                            return true;
                                        }
                                    }
                                });
                                var idxOfGTP_1 = -1;
                                var idxOfQPB_1 = -1;
                                var isPresetHasItems_1 = true;
                                //   let view = this.monitoringViewContainer.getActiveView()
                                //   // To restict context menu in smaller grids
                                //   var allowedLayout = ['2x2', '1x1', 'H-2', 'V-2'];
                                //   if (resource._resourceType === 'VAXDoorResource' && allowedLayout.indexOf(view._layout._name) === -1) {
                                //       items = [];
                                //   }
                                //   if (resource._resourceType === 'LPRSensorResource' && allowedLayout.indexOf(view._layout._name) === -1) {
                                //       items = [];
                                //   }
                                items.forEach(function (item) {
                                    if (item.text == 'Go to Preset') {
                                        idxOfGTP_1 = items.indexOf(item);
                                        if (!item.items || items.length == 0) {
                                            isPresetHasItems_1 = false;
                                        }
                                    }
                                    if (item.text == 'Quick Playback') {
                                        idxOfQPB_1 = items.indexOf(item);
                                    }
                                    if (item.nameUpdate) {
                                        item.text = resource.name || resource._name;
                                    }
                                });
                                // quick playback remove for alarm map 
                                try {
                                    if (_this_1.mObjectPane && _this_1.mObjectPane.domContainer.className == "player-div") {
                                        if (idxOfQPB_1 > -1)
                                            items.splice(idxOfQPB_1, 1);
                                        if (idxOfGTP_1 > -1) {
                                            items.splice(idxOfGTP_1, 1);
                                        }
                                    }
                                    else if (idxOfGTP_1 > -1 && !isPresetHasItems_1) {
                                        items.splice(idxOfGTP_1, 1);
                                    }
                                }
                                catch (e) {
                                    console.log("[-] Error in removing Gotopreset/ Quick playback: ", e);
                                }
                                //end
                                if (hasPlaybackRestriction == true && (resource._resourceType === 'PtzVideoSource' || resource._resourceType === 'MixedVideoSource' || resource._resourceType === 'PtzMixedVideoSource' || resource._resourceType === 'VideoSource')) {
                                    items = items.slice(1, items.length);
                                    contextmenu.clear();
                                    contextmenu.extend(items);
                                }
                                else {
                                    if (items.length < 0 || items.length == null || items == null || items.length == 0) {
                                        $('.ol-ctx-menu-container').css({ 'visibility': 'hidden' });
                                        contextmenu.clear();
                                    }
                                    else {
                                        contextmenu.clear();
                                        contextmenu.extend(items);
                                    }
                                }
                            }
                        }
                        else {
                            options.items.forEach(function (item) {
                                item.data.feature = null;
                                item.data.layer = null;
                            });
                        }
                    }
                    catch (e) {
                        console.log("Error on context menu ", e);
                    }
                });
                //      //== fire on open calback function
                contextmenu.on('open', function (e) {
                    if (!!options.onopen && angular.isFunction(options.onopen)) {
                        options.onopen();
                    }
                    // for context menu dynamically representing as per resource type
                    if (!!options.onopen && angular.isFunction(options.onopen)) {
                        options.onopen();
                    }
                    contextmenu.enable();
                    //end
                });
                //      //== fire on close calback function
                contextmenu.on('close', function (e) {
                    _this_1.isContextMenuOpen = false;
                    if (!!options.onclose && angular.isFunction(options.onclose)) {
                        options.onclose();
                    }
                });
            };
            //  //== creating a main map instance
            this.createMap = function (mapElement) {
                var mapId = _this_1.mapResource.id || 0;
                //== create Open Layers map instance
                _this_1.map = new ol.Map({
                    target: mapElement,
                    interactions: ol.interaction.defaults({ doubleClickZoom: false, dragPan: true }),
                    controls: []
                });
                _this_1.map.set('mapId', mapId);
                _this_1.map.setSize([window.outerWidth, window.outerHeight]);
                //== save current map sizes - canvas size
                var mapSize = _this_1.map.getSize();
                _this_1.mapWidth = mapSize[0] || 400;
                _this_1.mapHeight = mapSize[1] || 300;
                return _this_1.map;
            };
            //  public allLayer = (): any => {
            //      return this.map.getLayers();
            //  }
            //  //== on Map Move or Zoom
            this.setOnMapMooveEvents = function () {
                _this_1.map.on('moveend', (function () {
                    if (_this_1.fitToPageMoveStatrted) {
                        _this_1.fitToPageMoveStatrted = false;
                    }
                    else {
                        //check:-> controller code
                        //this.controllerItem.changeFitToPageInitialData(false);
                    }
                }));
            };
            //  //== get any feature by ID from specific layer
            this.changeBGLayerImage = function (file_path, isFitToPage) {
                //== get URL from input type file object
                var new_url = file_path; //this.getTempFileUrl(file);
                //== storing new URL for current resource
                _this_1.mapResource.imageUrl = new_url;
                //== re-creating background image and projection 
                _this_1.createBGLayerImage(new_url, isFitToPage);
                //== re-creating View according to new image data
                _this_1.createMapView(isFitToPage);
            };
            //  //== get any feature by ID from specific layer
            this.createBGLayerImage = function (image_url, isFitToPage) {
                _this_1.staticImagePoints = _this_1.getCurrentImageExtentPoints(isFitToPage);
                _this_1.bgImageProjection = new ol.proj.Projection({
                    code: 'xkcd-image',
                    units: 'pixels',
                    extent: _this_1.staticImagePoints
                });
                var imageMapSource = new ol.source.ImageStatic({
                    url: image_url,
                    projection: _this_1.bgImageProjection,
                    imageExtent: _this_1.staticImagePoints
                });
                imageMapSource.on("imageloadend", function () {
                });
                imageMapSource.on("imageloaderror", function () {
                    setTimeout(function () {
                        console.log("*Error on loading image");
                        _this_1.loadBackgroundForMap(null, _this_1.mapResource);
                    });
                });
                _this_1.bgMapImageLayer.setSource(imageMapSource);
            };
            //  //== Creating a main View for Map - object to act upon to change the center, resolution, and rotation of the map
            this.createMapView = function (isFitToPage) {
                if (_this_1.fromMonitoring) {
                    var mapView = new ol.View({
                        projection: _this_1.bgImageProjection,
                        center: ol.extent.getCenter(_this_1.staticImagePoints),
                        zoom: 1,
                        //minZoom: 0,
                        //maxZoom: 3,
                        resolution: 1,
                        extent: _this_1.staticImagePoints //== prevent dragging image outside the viewport
                    });
                    _this_1.map.setView(mapView);
                }
                else {
                    var homePositionData = _this_1.getInitialHomePosition();
                    console.log("initial home ", homePositionData);
                    var mapView = new ol.View({
                        projection: _this_1.bgImageProjection,
                        center: ol.extent.getCenter(_this_1.staticImagePoints),
                        zoom: 1,
                        // minZoom: 0,
                        // maxZoom: 3,
                        resolution: _this_1.getCurrentImageExtentResolution(isFitToPage, homePositionData.zoom),
                        extent: _this_1.staticImagePoints //== prevent dragging image outside the viewport
                    });
                    _this_1.map.setView(mapView);
                    //== only if some point saved as Home Position
                    if (!homePositionData.initial) {
                        mapView.setZoom(homePositionData.zoom);
                        mapView.setCenter(homePositionData.center);
                    }
                    //}
                }
                //  //== creating URL for file from input type file
                //  public getTempFileUrl = (file: any): string => {
                //      let new_url = '';
                //      const urlBuilder = window.URL;
                //      //== get temporary URL from input type file
                //      if (!!file) {
                //          try {
                //              new_url = urlBuilder.createObjectURL(file);
                //          } catch (err) { }
                //      }
                //      return new_url;
            };
            //  //== get extent points depend on image size and canvas size
            this.getCurrentImageExtentPoints = function (isFitToPage) {
                var extentRatio;
                if (_this_1.mapResource.mapImage != undefined && (_this_1.mapResource.mapImage.width && _this_1.mapResource.mapImage.height)) {
                    var imageW = _this_1.mapResource.mapImage.width;
                    var imageH = _this_1.mapResource.mapImage.height;
                }
                //  else if (this.mapResource.MapImage != undefined && (this.mapResource.MapImage.Width && this.mapResource.mapImage.Height)) {
                //var imageW = this.mapResource.MapImage.Width;
                // var imageH = this.mapResource.MapImage.Height;
                // }
                //== Canvas size  is the size of the map
                var canvasW = _this_1.map.getSize()[0];
                var canvasH = _this_1.map.getSize()[1];
                if (!_this_1.fromMonitoring) {
                    extentRatio = imageW / imageH;
                }
                else {
                    extentRatio = imageW / imageH;
                }
                //== Our image height is always 1
                var extent = [0, 0, extentRatio, 1];
                _this_1.actualExtent = Object.assign([], extent);
                if (_this_1.fromMonitoring) {
                    //extent = [0, 0, canvasW, canvasH]
                    var wRatio = canvasW / imageW;
                    var hRatio = canvasH / imageH;
                    var ratio = Math.min(wRatio, hRatio);
                    extent = [0, 0, imageW * ratio, imageH * ratio];
                    _this_1.modifiedExtend = Object.assign([], extent);
                    if (isFitToPage) {
                        extent = [0, 0, imageW, imageH];
                        _this_1.modifiedExtend = Object.assign([], extent);
                    }
                }
                else if (isFitToPage) {
                    extentRatio = imageW / imageH;
                    // change to make it actual  [0, 0, extentRatio, 1];
                    extent = [0, 0, extentRatio, 1];
                    _this_1.modifiedExtend = Object.assign([], extent);
                }
                else {
                    // let wRatio = canvasW / imageW;
                    // let hRatio = canvasH / imageH;
                    // let ratio = Math.min(wRatio, hRatio);
                    // extent = [0, 0, imageW * ratio, imageH * ratio]
                    // this.modifiedExtend = (<any>Object).assign([], extent);
                }
                return extent;
            };
            //  //== get view resolution depend on image size and canvas size
            this.getCurrentImageExtentResolution = function (isFitToPage, zoom) {
                var resolutionRatio;
                if (_this_1.mapResource.mapImage != undefined && (_this_1.mapResource.mapImage.hasOwnProperty('width') && _this_1.mapResource.mapImage.hasOwnProperty('height'))) {
                    var imageW = _this_1.mapResource.mapImage.width;
                    var imageH = _this_1.mapResource.mapImage.height;
                }
                else if (_this_1.mapResource.MapImage != undefined && (_this_1.mapResource.MapImage.hasOwnProperty('Width') && _this_1.mapResource.MapImage.hasOwnProperty('Height'))) {
                    var imageW = _this_1.mapResource.MapImage.Width;
                    var imageH = _this_1.mapResource.MapImage.Height;
                }
                var imageRatio = imageW / imageH;
                //== Canvas size  is the size of the map
                var canvasW = _this_1.map.getSize()[0];
                var canvasH = _this_1.map.getSize()[1];
                var canvasRatio = canvasW / canvasH;
                //== Resolution depend on fit, image ratio and canvas ratio
                if (isFitToPage) {
                    //resolutionRatio = imageH; //== When image fitted - we use only canvas height, because height is our 1 
                    resolutionRatio = imageH;
                }
                else {
                    if (canvasRatio > imageRatio) {
                        resolutionRatio = canvasH; //== if canvas ratio bigger than image ratio we also use only canvas height
                    }
                    else {
                        resolutionRatio = ((imageH / imageW) * canvasW); //== if image ratio bigger than canvas ratio - we need to calculate image invert ratio and multyply to canvas height - we need to scale it down to fit canvas width
                    }
                }
                resolutionRatio = 1 / resolutionRatio;
                return resolutionRatio;
            };
            //  //== get current zoom of the open layers map
            this.getMapZoom = function () {
                return _this_1.map.getView().getZoom();
            };
            //  //== get current center coordinates
            this.getMapCenter = function () {
                return _this_1.map.getView().getCenter();
            };
            //  //== Initial zoom an center coordinates depends if Home Position saved by user
            this.getInitialHomePosition = function () {
                //      //== Create data from saved parameters
                var data = {
                    zoom: _this_1.mapResource.zoom,
                    center: [_this_1.mapResource.longitude, _this_1.mapResource.latitude],
                    initial: false
                };
                //      //check and set custom home if set
                if (_this_1.fromMonitoring) {
                    // let pane: any = this.map.get("map_pane");
                    var customHome = localStorage.getItem("customhome_" + _this_1.map.get("mapId") + '_' + _this_1.getLayoutOfCurrentPane()); //this.globalDataAccessPoint.mapCustomHomes[this.map.get("mapId") + '_' + pane.id];
                    // console.log("customHome on  ==> ", customHome);
                    customHome = JSON.parse(customHome);
                    if (customHome) {
                        data = {
                            zoom: customHome.zoom,
                            center: customHome.center,
                            initial: false
                        };
                    }
                }
                //      //end
                //      //== If this is static image map and it's Home position never changed - set initial position for zoom=1 and map center
                if (_this_1.mapResource.mapType == "Image") {
                    if (_this_1.mapResource.longitude == 1 && _this_1.mapResource.latitude == 1 && _this_1.mapResource.zoom == 1) {
                        data.zoom = 1;
                        data.center = ol.extent.getCenter(_this_1.staticImagePoints);
                        data.initial = true;
                        //== set default valuse of fit data to true
                        if (!!_this_1.controllerItem) {
                            //check:-> require the TC command 
                            //this.controllerItem.changeFitToPageInitialData(true);
                        }
                    }
                }
                else if (_this_1.mapResource.mapType == "MapService") {
                    if (_this_1.mapResource.longitude == 1 && _this_1.mapResource.latitude == 1 && (_this_1.mapResource.zoom == 0 || _this_1.mapResource.zoom == 1)) {
                        data.zoom = 3;
                        data.center = [0, 0];
                        data.initial = true;
                    }
                }
                return data;
            };
            //  //== changing Fit To Page state 
            this.changeBGImageFitToPageState = function (isFitToPage) {
                _this_1.fitToPageMoveStatrted = true;
                //== get current image - we change only fit to Page without changing image 
                var staticMapImgUrl = _this_1.mapResource.imageUrl; //|| this.mapsApiProvider.getMapStaticImageUrl(this.mapResource.id);
                //== change background according to new state - we need to re-calculate extent points and resolution
                _this_1.createBGLayerImage(staticMapImgUrl, isFitToPage);
                var mapView = _this_1.map.getView();
                mapView.setResolution(_this_1.getCurrentImageExtentResolution(isFitToPage, 1));
                mapView.setCenter(ol.extent.getCenter(_this_1.staticImagePoints));
            };
            //  //Sticky Note Starts
            this.createStickyNotes = function (isClicked) {
                if (isClicked) {
                    _this_1.map.removeInteraction(_this_1.drawStickyNotes);
                    _this_1.createAndDrawStickyNotes();
                }
            };
            this.createAndDrawStickyNotes = function () {
                var value = 'LineString';
                var maxPoints = 2;
                var stickyNotesStyle = new CameraIcons(_this_1.mapResource.mapIconSize).iconStickyNotes;
                var noteStyle = new CameraIcons(_this_1.mapResource.mapIconSize).notes;
                var colorName = _this_1.getCurrentAppliedColor();
                var fontSize = _this_1.getCurrentAppliedSize();
                var fontName = _this_1.getCurrentAppliedName();
                var combineFontStyle;
                _this_1.drawStickyNotes = new ol.interaction.Draw({
                    source: _this_1.stickyNotesVectorSource,
                    type: (value),
                    geometryFunction: _this_1.geometryFunction,
                    maxPoints: maxPoints,
                    condition: function (e) {
                        // when the point's button is 1(leftclick), allows drawing
                        if (e.pointerEvent.buttons === 1) {
                            return true;
                        }
                        else {
                            return false;
                        }
                    }
                });
                _this_1.map.addInteraction(_this_1.drawStickyNotes);
                var mapsTest = _this_1.map;
                var mapsTestIn = _this_1.drawStickyNotes;
                var guid = _this_1.randomStringToGuidConverter();
                _this_1.drawStickyNotes.on('drawend', function (e) {
                    mapsTest.removeInteraction(mapsTestIn);
                    combineFontStyle = fontSize + ' ' + fontName;
                    e.feature.setStyle(stickyNotesStyle);
                    e.feature.setId(guid);
                    e.feature.setProperties({ 'id': guid, 'resourceId': guid, 'type': 'stickyNoteFeature' });
                    e.feature.getStyle().getText().getFill().setColor(colorName);
                    e.feature.getStyle().getText().setFont(combineFontStyle);
                    e.feature.set("textvalue", "");
                    _this_1.selectedFeature = e.feature;
                    setTimeout(function () {
                        var aCoords = [];
                        var coords = _this_1.selectedFeature.getGeometry().getCoordinates();
                        if (coords[0][0][1] < coords[0][1][1]) {
                            // point 0 to 1 swap
                            var y = coords[0][0][1];
                            coords[0][0][1] = coords[0][1][1];
                            coords[0][1][1] = y;
                            // point 2 to 3 swap
                            y = coords[0][2][1];
                            coords[0][2][1] = coords[0][3][1];
                            coords[0][3][1] = y;
                        }
                        if (coords[0][2][0] < coords[0][1][0]) {
                            // point 2 to 1 swap
                            var x = coords[0][1][0];
                            coords[0][1][0] = coords[0][2][0];
                            coords[0][2][0] = x;
                            // point 3 to 0 swap
                            x = coords[0][0][0];
                            coords[0][0][0] = coords[0][3][0];
                            coords[0][3][0] = x;
                        }
                        var midX = (coords[0][1][0] + coords[0][2][0]) / 2;
                        var midC = [midX, coords[0][1][1]];
                        var geoC = _this_1.getMapTypeDelta();
                        var br1 = [midC[0] - (0.03 * geoC), midC[1]];
                        var br2 = [midC[0] + (0.02 * geoC), midC[1]];
                        var br3 = [midC[0] - (0.04 * geoC), midC[1] - 0.03 * geoC];
                        //add all Coordinates
                        aCoords.push(br3);
                        aCoords.push(br1);
                        aCoords.push(coords[0][1]);
                        aCoords.push(coords[0][0]);
                        aCoords.push(coords[0][3]);
                        aCoords.push(coords[0][2]);
                        aCoords.push(br2);
                        _this_1.selectedFeature.getGeometry().setCoordinates([aCoords]);
                        var noteFeature = new ol.Feature({
                            id: guid,
                            geometry: new ol.geom.Polygon([aCoords.slice(1, 7)]),
                            type: "note"
                        });
                        noteFeature.setId(guid);
                        noteFeature.setProperties({ 'id': guid, 'resourceId': guid, 'type': 'note' });
                        noteStyle.setText(angular.copy(stickyNotesStyle.getText()));
                        if (noteStyle.getText().getText() == "") {
                            noteStyle.getText().setText(new CameraIcons(_this_1.mapResource.mapIconSize).notes.getText().getText());
                        }
                        noteFeature.setStyle(noteStyle);
                        _this_1.noteSource.addFeature(noteFeature);
                    }, 100);
                });
                //check:-> for command
                _this_1.controllerItem.setMapDirty();
            };
            //setting the shape to sticky note using coordinates
            this.geometryFunction = function (coordinates, geometry) {
                var start;
                var end;
                var points;
                var param = null;
                if (!geometry) {
                    geometry = new ol.geom.Polygon(param);
                }
                start = coordinates[0];
                end = coordinates[1];
                geometry.setCoordinates([[start, [start[0], end[1]], end, [end[0], start[1]], start]]);
                return geometry;
            };
            this.getLayersByName = function (layerName) {
                var layers = [
                    _this_1.funnelResizelayer,
                    _this_1.bgMapImageLayer,
                    _this_1.cameraImagesLayer,
                    _this_1.funnelLayer,
                    _this_1.linkedMapsLayer,
                    _this_1.stickyNotesLayer,
                    _this_1.noteLayer,
                    _this_1.stickyNoteResizelayer,
                    _this_1.linkedMapResizelayer,
                    _this_1.iconResizelayer,
                    _this_1.lprAlarmPopUpLayer,
                    _this_1.vaxAlarmPopUpLayer,
                    'bgMapImageLayer',
                    'cameraImagesLayer',
                    'funnelLayer',
                    'linkedMapsLayer',
                    'stickyNotesLayer',
                    'notes'
                ];
                //console.log("layouts ==> ",layers);
                var layerObjectsArr = layers.filter(function (layer) {
                    if (layer && layer != undefined)
                        return (layer.values_ && layer.values_.name || layer) == layerName;
                    else
                        return false;
                });
                //== layer not exists on current map - not creating a button
                if (!!layerObjectsArr && !!layerObjectsArr.length && !!layerObjectsArr[0]) {
                    return layerObjectsArr[0];
                }
                return null;
            };
            this.getImagePathFromUrl = function (url) {
                url = url.toLowerCase();
                if (url.indexOf('http') < 0)
                    return url;
                var urlArray = url.split("/");
                return "images/" + urlArray[urlArray.length - 1];
            };
            //  //== checkJsonParse
            //  private checkJsonParse = (propertyBag) => {
            //      let isJson = true;
            //      try {
            //          JSON.parse(propertyBag);
            //      } catch {
            //          isJson = false;
            //      }
            //      return isJson;
            //  };
            //  //== checkJsonParse
            this.setMapData = function (mapResource, linkedMapsListForLayer, cameraFunnelsListForLayer, CameraIconsListForLayer, map, stickyNotesListForLayer, notesListForLayer, mapLayersData, iconResizelayer, lprAlarmPopUpLayer, vaxAlarmPopUpLayer) {
                _this_1.showViewOption = mapResource.showViewOption;
                //      /* =========== Running for all map items and creating Layers ============= */
                var mapResourcesLength = !!mapResource.mapItems ? mapResource.mapItems.length : 0;
                //== map resource can be one of those types: resource, area, map
                if (mapResourcesLength > 0) {
                    for (var i = 0; i < mapResourcesLength; i++) {
                        if (!mapResource.mapItems[i])
                            continue;
                        switch (mapResource.mapItems[i].type) {
                            case 'MapItemPolygon':
                                _this_1.loadMapItemPolygon(mapResource, i, linkedMapsListForLayer, cameraFunnelsListForLayer);
                                break;
                            case 'MapItemImage':
                                _this_1.loadMapItemImage(mapResource, i, CameraIconsListForLayer);
                                break;
                            case 'MapItemText':
                                _this_1.loadMapItemText(mapResource, i, stickyNotesListForLayer, notesListForLayer);
                        }
                    }
                }
                //== Background Layer with static image
                if (_this_1.bgMapImageLayer) {
                    _this_1.bgMapImageLayer.setZIndex(1);
                    mapLayersData.push(_this_1.bgMapImageLayer);
                }
                //      //=========== Camera Icons layer =============
                //      //== The list of camera icons we put on Vectour Source    
                _this_1.cameraVectorSource = new ol.source.Vector({
                    features: CameraIconsListForLayer,
                    wrapX: false
                });
                _this_1.cameraImagesLayer = new ol.layer.Vector({
                    source: _this_1.cameraVectorSource
                });
                _this_1.cameraImagesLayer.set('name', "cameraImageLayer"); //== give a unique name to this Layer
                _this_1.cameraImagesLayer.setZIndex(3);
                mapLayersData.push(_this_1.cameraImagesLayer);
                //      //=========== Funnels Layer =============
                //      //== The list of camera icons we put on Vectour Source
                _this_1.funnelsVectorSource = new ol.source.Vector({
                    features: cameraFunnelsListForLayer,
                    wrapX: false
                });
                //== Then creating a Layer from the Vector
                _this_1.funnelLayer = new ol.layer.Vector({
                    source: _this_1.funnelsVectorSource
                });
                _this_1.funnelLayer.set('name', "funnelIconLayer"); //== give a unique name to this Layer
                _this_1.funnelLayer.setZIndex(2); //== funnels must be under the camera icons
                mapLayersData.push(_this_1.funnelLayer);
                //      //===========Sticky Notes Layer===========
                //      //This list of sticky notes we put on Vector Source
                _this_1.stickyNotesVectorSource = new ol.source.Vector({
                    features: stickyNotesListForLayer,
                    wrapX: false
                });
                //== Then creating layer from the Vector
                _this_1.stickyNotesLayer = new ol.layer.Vector({
                    source: _this_1.stickyNotesVectorSource
                });
                _this_1.stickyNotesLayer.set('name', "stickyNotesLayer");
                _this_1.stickyNotesLayer.setZIndex(2);
                mapLayersData.push(_this_1.stickyNotesLayer);
                _this_1.noteSource = new ol.source.Vector({
                    features: notesListForLayer,
                    wrapX: false
                });
                //== Then creating layer from the Vector
                _this_1.noteLayer = new ol.layer.Vector({
                    source: _this_1.noteSource
                });
                _this_1.noteLayer.set('name', "notes");
                _this_1.noteLayer.setZIndex(2);
                mapLayersData.push(_this_1.noteLayer);
                _this_1.linkedMapsVectorSource = new ol.source.Vector({
                    features: linkedMapsListForLayer,
                    wrapX: false
                });
                //== Then creating layer from the Vector
                _this_1.linkedMapsLayer = new ol.layer.Vector({
                    source: _this_1.linkedMapsVectorSource
                });
                _this_1.linkedMapsLayer.set('name', "linkedMapsLayer");
                _this_1.linkedMapsLayer.setZIndex(2);
                mapLayersData.push(_this_1.linkedMapsLayer);
                //      //linkedMapsListForLayer
                //iconResizeSource
                _this_1.iconResizeSource = new ol.source.Vector({
                    features: iconResizelayer,
                    wrapX: false
                });
                //== Then creating layer from the Vector
                _this_1.iconResizelayer = new ol.layer.Vector({
                    source: _this_1.iconResizeSource
                });
                _this_1.iconResizelayer.set('name', "iconResize");
                _this_1.iconResizelayer.setZIndex(9);
                mapLayersData.push(_this_1.iconResizelayer);
                //lpr alarm info Pop-up
                _this_1.lprAlarmPopUpSource = new ol.source.Vector({
                    features: lprAlarmPopUpLayer,
                    wrapX: false
                });
                _this_1.lprAlarmPopUpLayer = new ol.layer.Vector({
                    source: _this_1.lprAlarmPopUpSource
                });
                _this_1.lprAlarmPopUpLayer.set('name', "lprAlarmPopUp");
                _this_1.lprAlarmPopUpLayer.setZIndex(2);
                mapLayersData.push(_this_1.lprAlarmPopUpLayer);
                //      //lpr alarm info Pop-up end
                //      //Access control - VAX
                _this_1.vaxAlarmPopUpSource = new ol.source.Vector({
                    features: vaxAlarmPopUpLayer,
                    wrapX: false
                });
                _this_1.vaxAlarmPopUpLayer = new ol.layer.Vector({
                    source: _this_1.vaxAlarmPopUpSource
                });
                _this_1.vaxAlarmPopUpLayer.set('name', "vaxAlarmPopUp");
                _this_1.vaxAlarmPopUpLayer.setZIndex(2);
                mapLayersData.push(_this_1.vaxAlarmPopUpLayer);
                //      //vax end
                //      /* ============================================= */
                //      //== Create and set a view
                var fitval = false;
                if (mapResource.mapImage != undefined && mapResource.mapImage.hasOwnProperty('fit')) {
                    fitval = mapResource.mapImage.fit;
                }
                else if (_this_1.mapResource.MapImage != undefined && _this_1.mapResource.MapImage.hasOwnProperty('Fit')) {
                    fitval = _this_1.mapResource.MapImage.Fit;
                }
                if (mapResource.mapType == "Image")
                    _this_1.createMapView(fitval);
                //      //== Add all layers to map
                _this_1.layersCount = 0;
                //      let c = this.getMapCenter();
                //      let loderTime = this.loderTimeStamp || '';
                //      this.loadingMapOverlay(loderTime);
                //      let loadingOverlay = this.map.getOverlayById('mapLoadingOverlay_' + loderTime);
                //      if (loadingOverlay) {
                //          try {
                //              loadingOverlay.setPosition(c);
                //              this.disableControlPanel();
                //          } catch (e) { }
                //      }
                if (_this_1.fromMonitoring) {
                    var dom = _this_1.mObjectPane.domContainer;
                    var minimumWidth = (MapsOpenLayers.CONTROLPANEL_VISIBILITY_VALUE / 100) * window.innerWidth;
                    if (dom && dom.offsetWidth > minimumWidth && dom.className != "player-div") {
                        _this_1.createControlPannel(_this_1.mObjectPane);
                    }
                    //   else if (dom.className == "player-div") {
                    //       this.createControlPannel(this.mObjectPane);
                    //   }
                }
                //      if (this.fromMonitoring && this.mapResource.mapItems && this.mapResource.mapItems.length > 0) {
                //          this.setPollData(this.mapResource).then(() => {
                //              if (CameraIconsListForLayer && CameraIconsListForLayer.length > 0) {
                //                  CameraIconsListForLayer.forEach((iFeature: any) => {
                //                      this.addSpecialFeatureToIcon(iFeature, CameraIconsListForLayer);
                //                  })
                //              }
                if (CameraIconsListForLayer && CameraIconsListForLayer.length > 0) {
                    CameraIconsListForLayer.forEach(function (iFeature) {
                        _this_1.addSpecialFeatureToIcon(iFeature, CameraIconsListForLayer);
                    });
                }
                _this_1.loadDataToMapAsync(mapLayersData, mapResource);
                //          });
                //          //shows idel icon, if camera gets disconnected or unplugged
                //          this.registerDeviceChangedEvents();
                //          //alarm trigger for maps            
                //          let alrarmedData = JSON.parse(localStorage.getItem('trigger_alarm_data'));
                //          setTimeout(() => {
                //              if (alrarmedData) {
                //                  try {
                //                      this.map.getLayers().forEach((layer) => {
                //                          if (layer instanceof ol.layer.Vector) {
                //                              let source = layer.getSource();
                //                              let feature = source.getFeatures();
                //                              feature.forEach((featureItem: any) => {
                //                                  if (featureItem.values_.type === 'iconFeature' && featureItem.values_.resourceId == alrarmedData.source[0].Description) {
                //                                      MapsOpenLayers.alarmedResources.push(featureItem.values_.resourceId);
                //                                      let addResource: any = this.globalDataAccessPoint.resources.byGuid[featureItem.values_.resourceId];
                //                                      let check360Camera = this.is360CameraItem(addResource);
                //                                      let alarmImageSource: any;
                //                                      let icon360Alarm = CameraIcons.ICON_SRC.icon360Alarm;
                //                                      let icon360MixedAlarm = CameraIcons.ICON_SRC.iconMixed360Alarm;
                //                                      if ((addResource.resourceType === 'MixedVideoSource' || addResource.resourceType === 'PtzMixedVideoSource') && check360Camera === true) {
                //                                          alarmImageSource = icon360MixedAlarm;
                //                                      } else if (check360Camera) {
                //                                          alarmImageSource = icon360Alarm;
                //                                      } else {
                //                                          alarmImageSource = this.getAlarmResourceStyle(addResource);
                //                                      }
                //                                      //if (addResource.changeIcon && addResource.changeIcon.length > 0) {
                //                                      //    let alarm = addResource.changeIcon.filter((item) => {
                //                                      //        return (item.Type == "alarm");
                //                                      //    });
                //                                      //    if (alarm && alarm.length > 0) {
                //                                      //        alarmImageSource = alarm[0].Path;
                //                                      //    }
                //                                      //}
                //                                      let style: any = featureItem.getStyle();
                //                                      style.setImage(new ol.style.Icon({
                //                                          anchor: new CameraIcons(this.mapResource.mapIconSize).anchorSize,
                //                                          size: new CameraIcons(this.mapResource.mapIconSize).getIconSize(this.mapResource.mapIconSize),
                //                                          opacity: 1,
                //                                          scale: style.getImage().getScale(),
                //                                          src: alarmImageSource,
                //                                          rotation: style.getImage().getRotation()
                //                                      }))
                //                                      featureItem.setStyle(style);
                //                                  }
                //                              });
                //                          }
                //                      });
                //                  } catch (e) {
                //                      console.log("Eror in set data: ", e);
                //                  }
                //              }
                //          }, 500)
                //          this.eventDispatcher.on("trigger_alarm_on_camera", (data) => {
                //              try {
                //                  //const resource: any = this.globalDataAccessPoint.resources.byGuid[data.source[0].Description];
                //                  // handling alarm for digital input and relay output only
                //                  //if (!resource || (resource.resourceType != "DigitalInput" && resource.resourceType != "RelayOutput")) return;
                //                  this.map.getLayers().forEach((layer) => {
                //                      if (layer instanceof ol.layer.Vector) {
                //                          let source = layer.getSource();
                //                          let feature = source.getFeatures();
                //                          feature.forEach((featureItem: any) => {
                //                              if (featureItem.values_.type === 'iconFeature' && featureItem.values_.resourceId == data.source[0].Description) {
                //                                  MapsOpenLayers.alarmedResources.push(featureItem.values_.resourceId);
                //                                  let addResource: any = this.globalDataAccessPoint.resources.byGuid[featureItem.values_.resourceId];
                //                                  let check360Camera = this.is360CameraItem(addResource);
                //                                  let alarmImageSource: any;
                //                                  let icon360Alarm = CameraIcons.ICON_SRC.icon360Alarm;
                //                                  let icon360MixedAlarm = CameraIcons.ICON_SRC.iconMixed360Alarm;
                //                                  if ((addResource.resourceType === 'MixedVideoSource' || addResource.resourceType === 'PtzMixedVideoSource') && check360Camera === true) {
                //                                      alarmImageSource = icon360MixedAlarm;
                //                                  } else if (check360Camera) {
                //                                      alarmImageSource = icon360Alarm;
                //                                  } else {
                //                                      alarmImageSource = this.getAlarmResourceStyle(addResource);
                //                                  }
                //                                  //if (addResource.changeIcon && addResource.changeIcon.length > 0) {
                //                                  //    let alarm = addResource.changeIcon.filter((item) => {
                //                                  //        return (item.Type == "alarm");
                //                                  //    });
                //                                  //    if (alarm && alarm.length > 0) {
                //                                  //        alarmImageSource = alarm[0].Path;
                //                                  //    }
                //                                  //}
                //                                  let style: any = featureItem.getStyle();
                //                                  style.setImage(new ol.style.Icon({
                //                                      anchor: new CameraIcons(this.mapResource.mapIconSize).anchorSize,
                //                                      size: new CameraIcons(this.mapResource.mapIconSize).getIconSize(this.mapResource.mapIconSize),
                //                                      opacity: 1,
                //                                      scale: style.getImage().getScale(),
                //                                      src: alarmImageSource,
                //                                      rotation: style.getImage().getRotation()
                //                                  }))
                //                                  featureItem.setStyle(style);
                //                              }
                //                          });
                //                      }
                //                  });
                //              }
                //              catch (e) {
                //              }
                //          });
                //          angular.element(window).on('storage', (event: any) => {
                //              if (event.originalEvent.key === 'removed_trigger_item') {
                //                  this.map.getLayers().forEach((layer) => {
                //                      if (layer instanceof ol.layer.Vector) {
                //                          let source = layer.getSource();
                //                          let feature = source.getFeatures();
                //                          MapsOpenLayers.alarmedResources;
                //                          while (MapsOpenLayers.alarmedResources.length > 0)
                //                              MapsOpenLayers.alarmedResources.pop();
                //                          feature.forEach((featureItem: any) => {
                //                              if (featureItem.values_.type === 'iconFeature') {
                //                                  let addResource: any = this.globalDataAccessPoint.resources.byGuid[featureItem.values_.resourceId];
                //                                  this.restoreIconsAfterAlarm(featureItem, addResource.nvrId);
                //                              }
                //                          });
                //                      }
                //                  });
                //              }
                //          });
                //          this.eventDispatcher.on("INTERNAL_ALERT_ICON_HIDE", () => {
                //              if (localStorage.getItem('trigger_alarm_data')) {
                //                  localStorage.setItem("removed_trigger_item", localStorage.getItem('trigger_alarm_data'));
                //                  localStorage.removeItem('trigger_alarm_data');
                //              }
                //              this.map.getLayers().forEach((layer) => {
                //                  if (layer instanceof ol.layer.Vector) {
                //                      let source = layer.getSource();
                //                      let feature = source.getFeatures();
                //                      MapsOpenLayers.alarmedResources;
                //                      while (MapsOpenLayers.alarmedResources.length > 0)
                //                          MapsOpenLayers.alarmedResources.pop();
                //                      feature.forEach((featureItem: any) => {
                //                          if (featureItem.values_.type === 'iconFeature') {
                //                              let addResource: any = this.globalDataAccessPoint.resources.byGuid[featureItem.values_.resourceId];
                //                              this.restoreIconsAfterAlarm(featureItem, addResource.nvrId);
                //                          }
                //                      });
                //                  }
                //              });
                //          });
                //      }
                //      else {
                //          if (CameraIconsListForLayer && CameraIconsListForLayer.length > 0) {
                //              CameraIconsListForLayer.forEach((iFeature: any) => {
                //                  this.addSpecialFeatureToIcon(iFeature, CameraIconsListForLayer);
                //              })
                //          }
                //          //Change Icon
                //          //this.eventDispatcher.removeEvent('A_CHANGE_STYLE');
                //          //Change Icon
                //          this.loadDataToMapAsync(mapLayersData, mapResource);
                //      }
            };
            //  //for showOnMap
            this.flash = function (map, feature, duration) {
                var start = +new Date();
                var listenerKey; // to remove the listener after the duration
                var animate = function (event) {
                    // canvas context where the effect will be drawn
                    var vectorContext = event.vectorContext;
                    var frameState = event.frameState;
                    // create a clone of the original ol.Feature
                    // on each browser frame a new style will be applied
                    var flashGeom = feature.getGeometry().clone();
                    var elapsed = frameState.time - start;
                    var elapsedRatio = elapsed / duration;
                    // radius will be 5 at start and 30 at end.
                    var radius = ol.easing.easeOut(elapsedRatio) * 25 + 5;
                    var opacity = ol.easing.easeOut(1 - elapsedRatio);
                    // you can customize here the style
                    // like color, width
                    var style = new ol.style.Style({
                        image: new ol.style.Circle({
                            radius: radius,
                            snapToPixel: false,
                            stroke: new ol.style.Stroke({
                                color: [51, 51, 51, opacity],
                                width: 0.25 + opacity,
                            })
                        })
                    });
                    vectorContext.setStyle(style);
                    vectorContext.drawGeometry(flashGeom);
                    if (elapsed > duration) { // stop the effect
                        start = +new Date();
                        _this_1.animationCout = _this_1.animationCout + 1;
                        if (_this_1.animationCout == 3) {
                            ol.Observable.unByKey(listenerKey);
                            return;
                        }
                    }
                    // tell OL3 to continue postcompose animation
                    map.render();
                };
                listenerKey = map.on('postcompose', animate);
            };
            //  private changeAlertOnLinkedMap = () => {
            //      let alrarmedData = JSON.parse(localStorage.getItem('trigger_alarm_data'));
            //      setTimeout(() => {
            //          if (alrarmedData) {
            //              try {
            //                  this.map.getLayers().forEach((layer) => {
            //                      if (layer instanceof ol.layer.Vector) {
            //                          let source = layer.getSource();
            //                          let feature = source.getFeatures();
            //                          feature.forEach((featureItem: any) => {
            //                              if (featureItem.values_.type == 'linkedMapFeature') {
            //                                  //resourceId = this.selectedFeature.get('resourceId')
            //                                  let mapR: any = this.globalDataAccessPoint.resources.byGuid[featureItem.values_.resourceId];
            //                                  if (mapR && mapR.resourceType == 'Map') {
            //                                      let linkedMapObj = this.linkedMapResources.filter((item) => {
            //                                          return (item.map == mapR.id)
            //                                      })
            //                                      if (linkedMapObj && linkedMapObj.length > 0) {
            //                                          let idxOfResource = linkedMapObj[0].resources.indexOf(alrarmedData.source[0].Description);
            //                                          if (idxOfResource >= 0) {
            //                                              let fExtent = featureItem.getGeometry().getExtent();
            //                                              let center = ol.extent.getCenter(fExtent);
            //                                              let alarmPointFeature: ol.Feature = new ol.Feature({
            //                                                  id: "alaramed_linkmap" + new Date().toISOString(),
            //                                                  geometry: new ol.geom.Point(center),
            //                                                  name: "alaramed_linkmap" + new Date().toISOString(),
            //                                                  type: "alaramed_linkmap",
            //                                                  resourceId: "alaramed_linkmap_" + featureItem.values_.id
            //                                              });
            //                                              alarmPointFeature.setStyle(new CameraIcons(this.mapResource.mapIconSize).linkedAlarm);
            //                                              this.linkedAlarmSource.addFeature(alarmPointFeature);
            //                                              this.flash(this.map, alarmPointFeature, 3000);
            //                                          }
            //                                      }
            //                                  }
            //                              }
            //                          });
            //                      }
            //                  });
            //              } catch (e) {
            //              }
            //          }
            //      }, 100)
            //  }
            this.createMapDataAndLayers = function (map, mapResource, mapElement) {
                //      //== remove Layers if already exists on this map
                map.setLayerGroup(new ol.layer.Group());
                //      //== Main variables used for creating map and layers
                var mapLayersData = [];
                var CameraIconsListForLayer = [];
                var cameraFunnelsListForLayer = [];
                var linkedMapsListForLayer = [];
                var stickyNotesListForLayer = [];
                var notesListForLayer = [];
                var iconResizelayer = [];
                var lprAlarmPopUpLayer = [];
                var vaxAlarmPopUpLayer = [];
                //      //issue for Funnel gets separated from the camera icon
                //      if (this.mapConfigRotateInteraction) {
                //          map.removeInteraction(this.mapConfigRotateInteraction);
                //          this.mapConfigRotateInteraction = null;
                //      }
                //      //
                _this_1.testingDataPush = []; //@todo need to remove this usage under std model , note added to reset though comlete usage need to be under std models
                //      //== Geo or Static Image Map
                if (!!mapResource.mapType && mapResource.mapType != "Image") {
                    _this_1.bgMapImageLayer = new ol.layer.Tile({
                        source: new ol.source.OSM() //new ol.source.OSM({ wrapX: false}),
                    });
                    map.addLayer(_this_1.bgMapImageLayer);
                    var home = _this_1.getInitialHomePosition();
                    var view = new ol.View({
                        center: [0, 0],
                        zoom: 2,
                        minZoom: 2
                    });
                    if (!home.initial) {
                        view = new ol.View({
                            center: home.center,
                            zoom: home.zoom,
                            minZoom: 2
                        });
                    }
                    _this_1.bgMapImageLayer.set('name', "backgroundLayer");
                    map.setView(view);
                    _this_1.setMapData(mapResource, linkedMapsListForLayer, cameraFunnelsListForLayer, CameraIconsListForLayer, map, stickyNotesListForLayer, notesListForLayer, mapLayersData, iconResizelayer, lprAlarmPopUpLayer, vaxAlarmPopUpLayer);
                }
                else {
                    //          /* ======= Background Map Image - The main layer with static background image ======== */
                    //          const staticMapImgUrl = this.mapsApiProvider.getMapStaticImageUrl(mapResource.id);
                    var staticMapImgUrl = mapResource.ImageURI || mapResource.imageUrl;
                    ;
                    _this_1.bgMapImageLayer = new ol.layer.Image({
                        source: null,
                        zIndex: 1,
                        visible: true,
                        opacity: 1
                    });
                    if (mapResource.mapImage != undefined && mapResource.mapImage.hasOwnProperty('fit')) {
                        var fitval = mapResource.mapImage.fit;
                    }
                    else if (mapResource.MapImage != undefined && mapResource.MapImage.hasOwnProperty('Fit')) {
                        var fitval = mapResource.MapImage.Fit;
                    }
                    _this_1.bgMapImageLayer.set('name', "BackLayer");
                    _this_1.createBGLayerImage(staticMapImgUrl, fitval);
                    _this_1.bgMapImageLayer.setZIndex(1);
                    map.addLayer(_this_1.bgMapImageLayer);
                    //          //setTimeout(() => {
                    _this_1.setMapData(mapResource, linkedMapsListForLayer, cameraFunnelsListForLayer, CameraIconsListForLayer, map, stickyNotesListForLayer, notesListForLayer, mapLayersData, iconResizelayer, lprAlarmPopUpLayer, vaxAlarmPopUpLayer);
                    //          // },50)
                }
            };
            //  //==sets color name to openlayers
            this.setFontColor = function (isColor) {
                _this_1.defaultFontColor = (isColor != undefined) ? isColor : "#1a2028";
                _this_1.updateTextFontStyles(_this_1.defaultFontName, _this_1.defaultFontColor, _this_1.defaultFontSize);
                _this_1.updateFillColor();
            };
            //  //==sets font size to openlayers
            this.setFontSize = function (isSize) {
                _this_1.defaultFontSize = (isSize != undefined) ? isSize : "18px";
                _this_1.updateTextFontStyles(_this_1.defaultFontName, _this_1.defaultFontColor, _this_1.defaultFontSize);
            };
            //  //==sets font name to openlayers
            this.setFontName = function (isName) {
                _this_1.defaultFontName = (isName != undefined) ? isName : "Arial";
                _this_1.updateTextFontStyles(_this_1.defaultFontName, _this_1.defaultFontColor, _this_1.defaultFontSize);
            };
            this.setCurrentShape = function (isName) {
                _this_1.defaultShapeName = (isName != undefined) ? isName : "Circle";
                _this_1.updateShape(_this_1.defaultShapeName);
                _this_1.linkedMapResizeSource.clear();
                _this_1.mapConfigSelectInteraction.getFeatures().clear();
            };
            this.setCurrentOpacity = function (value) {
                _this_1.defaultOpacity = (value != undefined) ? value : 0.5;
                _this_1.updateOpacity(_this_1.defaultOpacity);
                _this_1.mapConfigSelectInteraction.getFeatures().clear();
            };
            this.setCurrentColor = function (value) {
                _this_1.defaultLinkedHighlight = (value != undefined) ? value : "#e22b8a";
                _this_1.updateColor(_this_1.defaultLinkedHighlight);
                _this_1.mapConfigSelectInteraction.getFeatures().clear();
            };
            this.DrawShapeForMaps = function (map) {
                if (!map || map == '')
                    return;
                var draggedMap = map;
                var c = _this_1.getMapCenter();
                var shapeStyle = new CameraIcons(_this_1.mapResource.mapIconSize).shapeStyle;
                var geoC = _this_1.getMapTypeDelta();
                var shapeFeature = new ol.Feature({
                    id: draggedMap.name + draggedMap.id,
                    geometry: new ol.geom.Polygon([[c, [c[0], c[1] + 0.1 * geoC], [c[0] + 0.1 * geoC, c[1] + 0.1 * geoC], [c[0] + 0.1 * geoC, c[1]], c]]),
                    name: draggedMap.name,
                    type: mapDefaults.mapFeatureTypes.linkedMap,
                    resourceId: draggedMap.id,
                    style: shapeStyle,
                    description: "shape"
                });
                _this_1.linkedMapsVectorSource.addFeature(shapeFeature);
                shapeFeature.setStyle(shapeStyle);
                shapeFeature.set("shape", "Ractangle");
                shapeFeature.set("featureType", "linkedMap");
                _this_1.controllerItem.setMapDirty();
            };
            this.DrawUnlinkShape = function () {
                //let draggedMap = maps[0];
                var guid = _this_1.randomStringToGuidConverter();
                var c = _this_1.getMapCenter();
                var shapeStyle = new CameraIcons(_this_1.mapResource.mapIconSize).shapeStyle;
                var geoC = _this_1.getMapTypeDelta();
                var shapeFeature = new ol.Feature({
                    id: guid,
                    geometry: new ol.geom.Polygon([[c, [c[0], c[1] + 0.1 * geoC], [c[0] + 0.1 * geoC, c[1] + 0.1 * geoC], [c[0] + 0.1 * geoC, c[1]], c]]),
                    name: guid,
                    type: mapDefaults.mapFeatureTypes.linkedMap,
                    resourceId: guid,
                    style: shapeStyle,
                    description: "shape"
                });
                shapeFeature.setProperties({ 'id': guid, 'resourceId': guid, 'type': mapDefaults.mapFeatureTypes.linkedMap, featureType: 'unlinked' });
                _this_1.linkedMapsVectorSource.addFeature(shapeFeature);
                shapeFeature.setStyle(shapeStyle);
                shapeFeature.set("shape", "Ractangle");
                //check:-> controller function to enable save button
                _this_1.controllerItem.setMapDirty();
            };
            //  //sticky note
            this.updateTextFontStyles = function (font, color, size) {
                if (_this_1.selectedStickyNote && _this_1.selectedStickyNote.get('type') == 'stickyNoteFeature') {
                    var stickyNotesStyle = new CameraIcons(_this_1.mapResource.mapIconSize).iconStickyNotes;
                    var colorName_1 = _this_1.getCurrentAppliedColor();
                    var fontSize = _this_1.getCurrentAppliedSize();
                    var fontName = _this_1.getCurrentAppliedName();
                    var combineFontStyle_1 = fontSize + ' ' + fontName;
                    stickyNotesStyle.getText().getFill().setColor(colorName_1);
                    stickyNotesStyle.getText().setFont(combineFontStyle_1);
                    stickyNotesStyle.getText().setText(_this_1.selectedStickyNote.getStyle().getText().getText());
                    //set text for polygon
                    _this_1.map.getLayers().forEach(function (l) {
                        if (l.get('name') == "notes") {
                            var s = l.getSource();
                            var f = s.getFeatures();
                            f.forEach(function (fItem) {
                                if (fItem.getId() == _this_1.selectedStickyNote.getId()) {
                                    var stl = fItem.getStyle();
                                    stl.getText().getFill().setColor(colorName_1);
                                    stl.getText().setFont(combineFontStyle_1);
                                    fItem.setStyle(stl);
                                }
                            });
                        }
                    });
                    //end
                    _this_1.selectedStickyNote.setStyle(stickyNotesStyle);
                    _this_1.controllerItem.setMapDirty();
                }
            };
            //  private getActiveResourcesData = (resourceObj: any) => {
            //      if (resourceObj.children && resourceObj.children.length > 0) {
            //          resourceObj.children.forEach((c) => {
            //              if (c.type == "ResourceGroup") {
            //                  this.getActiveResourcesData(c);
            //              }
            //              else {
            //                  this.activeResources.push(c);
            //              }
            //          })
            //      }
            //  }
            //  private getAllActiveResources = () => {
            //      let rObject = this.globalDataAccessPoint.resourceGroup.getWithoutPlaybackGroup();
            //      this.activeResources = [];
            //      if (rObject && rObject.unassociatedGroup && rObject.unassociatedGroup.children && rObject.unassociatedGroup.children.length > 0)
            //          this.activeResources = (<any>Object).assign([], rObject.unassociatedGroup.children);
            //      if (rObject.customGroups && rObject.customGroups.length > 0) {
            //          rObject.customGroups.forEach((group) => {
            //              //if (group.children && group.children.length > 0) {
            //              // group.children.forEach((c) => {
            //              // this.activeResources.push(c);
            //              // })
            //              //}
            //              this.getActiveResourcesData(group)
            //          })
            //      }
            //  }
            //  private checkActiveResource = (mapItemObj: any) => {
            //      let res = true;
            //      if (mapItemObj.type == 'MapItemPolygon') {
            //          let mapPolygon = mapItemObj.funnels;
            //          if (mapPolygon) {
            //              let resourceObj: any = this.globalDataAccessPoint.resources.byGuid[mapPolygon.resourceId];
            //              if (resourceObj._resourceType != "Map") {
            //                  var getActive = this.activeResources.filter((item) => {
            //                      return (item.id == mapPolygon.resourceId)
            //                  })
            //                  if (!getActive || getActive.length == 0) {
            //                      res = false;
            //                  }
            //              }
            //          }
            //      }
            //      else if (mapItemObj.type == 'MapItemImage') {
            //          let mapImages = mapItemObj.images;
            //          if (mapImages) {
            //              let resourceObj: any = this.globalDataAccessPoint.resources.byGuid[mapImages.resourceId];
            //              if (resourceObj._resourceType != "Map") {
            //                  var getActive = this.activeResources.filter((item) => {
            //                      return (item.id == mapImages.resourceId)
            //                  })
            //                  if (!getActive || getActive.length == 0) {
            //                      res = false;
            //                  }
            //              }
            //          }
            //      }
            //      return res;
            //  }
            //  //for go to preset context menu option
            //  private onPlayFromPreset = (data: any) => {
            //      //var d = document.getElementById("xyz" + "camInfo" + this.mObjectPane.id);
            //      //if (d.childElementCount > 1) {
            //      //    d.removeChild(d.lastElementChild);
            //      //}
            //      this.hideCameraInfoPopup(this.map, this.mObjectPane);
            //      setTimeout(() => {
            //          var dValX = this.vidData;
            //          var vxvmsTreeViewService = this.vmsTreeViewService;
            //          let geom: ol.geom.Point = this.selectedFeature.getGeometry() as ol.geom.Point;
            //          let coord = geom.getCoordinates();
            //          const resourceId = this.selectedFeature.get('resourceId') || '';
            //          const popupLiveVdo = this.map.getOverlayById('cameraLiveVdoPopup' + resourceId);
            //          popupLiveVdo.setPosition(coord);
            //          let popuLiveVdopObj: any = popupLiveVdo.getElement();
            //          var copyObjPane: any = this.mObjectPane.clone();
            //          copyObjPane._domContainer = popuLiveVdopObj;
            //          popuLiveVdopObj.style.display = 'block';
            //          popupLiveVdo.set('resourceId', resourceId, true);
            //          //var x = vxvmsTreeViewService.getTreeData().unassociatedGroup.children;
            //          //var res = x.filter(function (items) {
            //          //    return items.id === resourceId;
            //          //})[0];
            //          var res = this.globalDataAccessPoint.resources.byGuid[resourceId];
            //          this.playerOpenIdQplayBack = []
            //          this.playerOpenIdQplayBack.push(resourceId);
            //          let elmTargetPane = this.mObjectPane.clone();
            //          elmTargetPane._domContainer = popuLiveVdopObj;
            //          elmTargetPane.id = "xyz" + "camInfo" + this.mObjectPane.id + resourceId;
            //          elmTargetPane.resource = res; //res.actualObject;
            //          dValX.executeResourceSpecificLogic(elmTargetPane, false, null);
            //          this.map.getInteractions().forEach((interaction) => { interaction.setActive(false); });
            //          var vmsPlayerObj = this.vmsPlayerByPlayerIdMapping.get(elmTargetPane.vmsPlayerId);
            //          vmsPlayerObj.showTimeline = false;
            //          //movable player
            //          let moveObj: HTMLDivElement = document.createElement("div");
            //          let titleSpan: any = popuLiveVdopObj.getElementsByClassName("vms-player-resource-title");
            //          moveObj.setAttribute("style", "cursor:crosshair;width:25px;height:25px;display:block;overflow:hidden;position:absolute;left:-15px;top:-15px;background:blue;z-index:9999;background:url('images/MoveIcon.png')");
            //          //moveObj.setAttribute("id", "move_pane_overlay");
            //          moveObj.setAttribute("rName", titleSpan[0].innerText);
            //          let existingOverlay = this.overLayList.filter((overlayItem) => {
            //              return (overlayItem.rName == titleSpan[0].innerText)
            //          });
            //          if (existingOverlay && existingOverlay.length > 0) {
            //              existingOverlay[0].oObj = popupLiveVdo;
            //              existingOverlay[0].resourceId = resourceId;
            //              existingOverlay[0].rName = titleSpan[0].innerText;
            //          }
            //          else {
            //              this.overLayList.push({ oObj: popupLiveVdo, resourceId: resourceId, rName: titleSpan[0].innerText });
            //          }
            //          this.resetOverlayPosWithPanel(resourceId);
            //          moveObj.onmousedown = (e) => {
            //              e.preventDefault();
            //              e.stopPropagation();
            //              if (!this.selectedOverlay) {
            //                  let overLays = this.overLayList.filter((o) => {
            //                      let target: any = e.target;
            //                      return (o.rName == target.getAttribute('rName'))
            //                  });
            //                  if (overLays && overLays.length > 0)
            //                      this.selectedOverlay = overLays[0].oObj;
            //                  let pos = this.selectedOverlay.getPosition();
            //                  this.overlayDiffX = pos[0] - this.currentMousePoint[0];
            //                  this.overlayDiffY = pos[1] - this.currentMousePoint[1];
            //              }
            //              //else {
            //              //    this.selectedOverlay = null;
            //              //}
            //          }
            //          moveObj.onmouseup = (e) => {
            //              e.preventDefault();
            //              e.stopPropagation();
            //              this.selectedOverlay = null;
            //          }
            //          document.onmouseup = (e) => {
            //              e.preventDefault();
            //              e.stopPropagation();
            //              this.selectedOverlay = null;
            //          }
            //          //end
            //          // resizing overlay
            //          let resizeObj: HTMLDivElement = document.createElement("div");
            //          let enteredInResizeDiv = false;
            //          resizeObj.setAttribute("style", "cursor:nw-resize;;width:30px;height:30px;display:block;overflow:hidden;position:absolute;right:-20px;bottom:-20px;background:blue;z-index:9999;background:url('images/Resize_Icon.png')");
            //          this.isPanelSelected = false;
            //          //setTimeout(() => )
            //          popuLiveVdopObj.onmouseover = (e) => {
            //              e.preventDefault();
            //              e.stopPropagation();
            //              popuLiveVdopObj.appendChild(moveObj);
            //              popuLiveVdopObj.appendChild(resizeObj);
            //          }
            //          resizeObj.onmousemove = (e) => {
            //              e.preventDefault();
            //              enteredInResizeDiv = true;
            //              if (this.isPanelSelected == true) {
            //                  let diffX = e.offsetX - this.clientX;
            //                  let diffY = e.offsetY - this.clientY;
            //                  let height = parseInt(popuLiveVdopObj.style.height.substring(0, popuLiveVdopObj.style.height.length - 2)) + 2;
            //                  let width = parseInt(popuLiveVdopObj.style.width.substring(0, popuLiveVdopObj.style.width.length - 2)) + 2;
            //                  height = height + diffY;
            //                  width = width + diffX;
            //                  if (height >= 120) {
            //                      popuLiveVdopObj.style.height = height.toString() + "px";
            //                  }
            //                  if (width >= 200) {
            //                      popuLiveVdopObj.style.width = width.toString() + "px";
            //                  }
            //                  //popuLiveVdopObj.style.height = height.toString() + "px";
            //                  //popuLiveVdopObj.style.width = width.toString() + "px";
            //              }
            //          }
            //          popuLiveVdopObj.onmouseup = (e) => {
            //              e.preventDefault();
            //              e.stopPropagation();
            //              this.selectedOverlay = null;
            //          }
            //          this.mapElement.onmouseup = (e) => {
            //              this.selectedOverlay = null;
            //          }
            //          resizeObj.onmouseout = (e) => {
            //              e.preventDefault();
            //              e.stopPropagation();
            //              this.isPanelSelected = false;
            //          }
            //          resizeObj.onmousedown = (e) => {
            //              e.preventDefault();
            //              e.stopPropagation();
            //              this.clientX = e.offsetX;
            //              this.clientY = e.offsetY;
            //              this.isPanelSelected = true;
            //          }
            //          resizeObj.onmouseup = (e) => {
            //              e.preventDefault();
            //              e.stopPropagation();
            //              this.isPanelSelected = false;
            //          }
            //      }, 100)
            //  };
            this.onPlayFromLinkedResource = function (data) {
                //      this.hideCameraInfoPopup(this.map, this.mObjectPane);
                //      //console.log('linked resources->>>', data);
                //      setTimeout(() => {
                //          var dValX = this.vidData;
                //          //console.log("linked resource-->", data);
                //          var vxvmsTreeViewService = this.vmsTreeViewService;
                //          let geom: ol.geom.Point = this.selectedFeature.getGeometry() as ol.geom.Point;
                //          let coord = geom.getCoordinates();
                //          const resourceId = this.selectedFeature.get('resourceId') || '';
                //          const popupLiveVdo = this.map.getOverlayById('cameraLiveVdoPopup' + resourceId);
                //          popupLiveVdo.setPosition(coord);
                //          let popuLiveVdopObj: any = popupLiveVdo.getElement();
                //          var copyObjPane: any = this.mObjectPane.clone();
                //          copyObjPane._domContainer = popuLiveVdopObj;
                //          popuLiveVdopObj.style.display = 'block';
                //          popupLiveVdo.set('resourceId', resourceId, true);
                //          //var x = vxvmsTreeViewService.getTreeData().unassociatedGroup.children;
                //          //var res = x.filter(function (items) {
                //          //    return items.id === resourceId;
                //          //})[0];
                //          //resourceType
                //          //sensor
                //          var res = this.globalDataAccessPoint.resources.byGuid[data.id];
                //          if (res.resourceType == 'LPRSensorResource') {
                //              res = this.globalDataAccessPoint.resources.byGuid[res.sensor.id];
                //          }
                //          //console.log("res=======>", res);
                //          let elmTargetPane = this.mObjectPane.clone();
                //          elmTargetPane._domContainer = popuLiveVdopObj;
                //          elmTargetPane.id = "xyz" + "camInfo" + this.mObjectPane.id + resourceId;
                //          elmTargetPane.resource = res; //res.actualObject;
                //          dValX.executeResourceSpecificLogic(elmTargetPane, false, null);
                //          this.map.getInteractions().forEach((interaction) => { interaction.setActive(false); });
                //          var vmsPlayerObj = this.vmsPlayerByPlayerIdMapping.get(elmTargetPane.vmsPlayerId);
                //          vmsPlayerObj.showTimeline = false;
                //          //movable player
                //          let moveObj: HTMLDivElement = document.createElement("div");
                //          let titleSpan: any = popuLiveVdopObj.getElementsByClassName("vms-player-resource-title");
                //          moveObj.setAttribute("style", "cursor:crosshair;width:25px;height:25px;display:block;overflow:hidden;position:absolute;left:-15px;top:-15px;background:blue;z-index:9999;background:url('images/MoveIcon.png')");
                //          //moveObj.setAttribute("id", "move_pane_overlay");
                //          moveObj.setAttribute("rName", titleSpan[0].innerText);
                //          let existingOverlay = this.overLayList.filter((overlayItem) => {
                //              return (overlayItem.rName == titleSpan[0].innerText)
                //          });
                //          if (existingOverlay && existingOverlay.length > 0) {
                //              existingOverlay[0].oObj = popupLiveVdo;
                //              existingOverlay[0].resourceId = resourceId;
                //              existingOverlay[0].rName = titleSpan[0].innerText;
                //          }
                //          else {
                //              this.overLayList.push({ oObj: popupLiveVdo, resourceId: resourceId, rName: titleSpan[0].innerText });
                //          }
                //          this.resetOverlayPosWithPanel(resourceId);
                //          moveObj.onmousedown = (e) => {
                //              e.preventDefault();
                //              e.stopPropagation();
                //              if (!this.selectedOverlay) {
                //                  let overLays = this.overLayList.filter((o) => {
                //                      let target: any = e.target;
                //                      return (o.rName == target.getAttribute('rName'))
                //                  });
                //                  if (overLays && overLays.length > 0)
                //                      this.selectedOverlay = overLays[0].oObj;
                //                  let pos = this.selectedOverlay.getPosition();
                //                  this.overlayDiffX = pos[0] - this.currentMousePoint[0];
                //                  this.overlayDiffY = pos[1] - this.currentMousePoint[1];
                //              }
                //              //else {
                //              //    this.selectedOverlay = null;
                //              //}
                //          }
                //          moveObj.onmouseup = (e) => {
                //              e.preventDefault();
                //              e.stopPropagation();
                //              this.selectedOverlay = null;
                //          }
                //          document.onmouseup = (e) => {
                //              e.preventDefault();
                //              e.stopPropagation();
                //              this.selectedOverlay = null;
                //          }
                //          //end
                //          // resizing overlay
                //          let resizeObj: HTMLDivElement = document.createElement("div");
                //          let enteredInResizeDiv = false;
                //          resizeObj.setAttribute("style", "cursor:nw-resize;;width:30px;height:30px;display:block;overflow:hidden;position:absolute;right:-20px;bottom:-20px;background:blue;z-index:9999;background:url('images/Resize_Icon.png')");
                //          this.isPanelSelected = false;
                //          //setTimeout(() => )
                //          popuLiveVdopObj.onmouseover = (e) => {
                //              e.preventDefault();
                //              e.stopPropagation();
                //              popuLiveVdopObj.appendChild(moveObj);
                //              popuLiveVdopObj.appendChild(resizeObj);
                //          }
                //          resizeObj.onmousemove = (e) => {
                //              e.preventDefault();
                //              enteredInResizeDiv = true;
                //              if (this.isPanelSelected == true) {
                //                  let diffX = e.offsetX - this.clientX;
                //                  let diffY = e.offsetY - this.clientY;
                //                  let height = parseInt(popuLiveVdopObj.style.height.substring(0, popuLiveVdopObj.style.height.length - 2)) + 2;
                //                  let width = parseInt(popuLiveVdopObj.style.width.substring(0, popuLiveVdopObj.style.width.length - 2)) + 2;
                //                  height = height + diffY;
                //                  width = width + diffX;
                //                  if (height >= 120) {
                //                      popuLiveVdopObj.style.height = height.toString() + "px";
                //                  }
                //                  if (width >= 200) {
                //                      popuLiveVdopObj.style.width = width.toString() + "px";
                //                  }
                //                  //popuLiveVdopObj.style.height = height.toString() + "px";
                //                  //popuLiveVdopObj.style.width = width.toString() + "px";
                //              }
                //          }
                //          popuLiveVdopObj.onmouseup = (e) => {
                //              e.preventDefault();
                //              e.stopPropagation();
                //              this.selectedOverlay = null;
                //          }
                //          this.mapElement.onmouseup = (e) => {
                //              this.selectedOverlay = null;
                //          }
                //          resizeObj.onmouseout = (e) => {
                //              e.preventDefault();
                //              e.stopPropagation();
                //              this.isPanelSelected = false;
                //          }
                //          resizeObj.onmousedown = (e) => {
                //              e.preventDefault();
                //              e.stopPropagation();
                //              this.clientX = e.offsetX;
                //              this.clientY = e.offsetY;
                //              this.isPanelSelected = true;
                //          }
                //          resizeObj.onmouseup = (e) => {
                //              e.preventDefault();
                //              e.stopPropagation();
                //              this.isPanelSelected = false;
                //          }
                //      }, 100)
            };
            this.getPresetList = function (item, contextmenu, items) {
                var ptzResetItems = item.data.feature.get("presetData");
                try {
                    contextmenu.options.items.forEach(function (item) {
                        if (item.text == "Go to Preset") {
                            if (ptzResetItems && ptzResetItems.length > 0) {
                                item.items = ptzResetItems;
                            }
                            else {
                                item.items = null;
                            }
                        }
                    });
                }
                catch (e) { }
                return ptzResetItems;
            };
            this.getViewName = function (item, contextmenu, items) {
                var ViewItems = item.data.feature.get("name");
                try {
                    contextmenu.options.items.forEach(function (item) {
                        if (item.text == "Show Properties") {
                            item.items = [];
                            var obj = {
                                classname: "",
                                text: ViewItems
                            };
                            item.items.push(obj);
                        }
                    });
                }
                catch (e) { }
            };
            this.getMapName = function (item, contextmenu, items) {
                var mapItems1 = item.data.feature.get("name");
                try {
                    contextmenu.options.items.forEach(function (item) {
                        if (item.text == "Show Properties") {
                            item.items = mapItems1;
                        }
                    });
                }
                catch (e) { }
            };
            this.getNVRIdName = function (item, contextmenu, items) {
                var NVRItems = item.data.feature.get("nvrName");
                try {
                    contextmenu.options.items.forEach(function (item) {
                        //   if (item.text == "NVR Details") {
                        //       item.items = NVRItems;
                        //   }
                        if (item.text == "NVR Details") {
                            item.items = [];
                            var obj = {
                                classname: "",
                                text: NVRItems
                            };
                            item.items.push(obj);
                        }
                    });
                }
                catch (e) { }
            };
            //  //public getVAXLinkedResourceNameVal = (item, contextmenu, items) => {
            //  //    var resourceArr = item.data.feature.get("vaxLinkedResourceData");
            //  //    try {
            //  //        items.forEach((item) => {
            //  //            if (item.text == "View" && item.resourceType[0] == "VAXDoorResource") {
            //  //                if (resourceArr && resourceArr.length > 0) {
            //  //                    //console.log("item.items[0].text--->", item.items[0]);
            //  //                    //console.log("resourceArr.text--->", resourceArr);
            //  //                    item.text = resourceArr[0].text;
            //  //                    item.items = resourceArr;
            //  //                    item.items = item.items;
            //  //                }
            //  //                //console.log("final item--->", item);
            //  //            }
            //  //        })
            //  //    } catch (e) { }
            //  //    return resourceArr;
            //  //};
            //  //public getLPRLinkedResourceNameVal = (item, contextmenu, items) => {
            //  //    var lprResourceArr = item.data.feature.get("lprLinkedResourceData");
            //  //    try {
            //  //        contextmenu.options.items.forEach((item) => {
            //  //            if (item.text == "View" && item.resourceType[0] == "LPRSensorResource") {
            //  //                //console.log("lprResourceArr---->", lprResourceArr);
            //  //                if (lprResourceArr && lprResourceArr.length > 0) {
            //  //                    //console.log("lprLinkedResourceData-->", item.items[0]);
            //  //                    item.items[0].text = lprResourceArr[0].text;
            //  //                    item.items = lprResourceArr;
            //  //                    item.items = item.items;
            //  //                }
            //  //            }
            //  //        })
            //  //    } catch (e) { }
            //  //    return lprResourceArr;
            //  //};
            this.onPresetClick = function (data) {
                var priorityUser = { priorityLevel: 1000, UserName: "admin" };
                var presetObj = {
                    resourceId: data.data[0].values_.resourceId,
                    presetToken: data.data[1].presetToken,
                    coordinates: data.coordinate
                };
                var id = '#xyz' + "camInfo" + _this_1.mObjectPane.id + presetObj.resourceId;
                presetObj.playerOverlayId = id;
                var obj = new ThickClientCommunication();
                if (!_this_1.openPlayerIds[id])
                    _this_1.openPlayerIds[id] = 1;
                obj.callBackToThickClientFunction('GoToPreset', presetObj);
                //  this.ptzService.gotoPreset(data.data[0].values_.resourceId, data.data[1].presetToken, priorityUser).then(() => {
                //      this.onPlayFromPreset(data);
                //  });
            };
            //  //private onVaxLinkedResourceClick = (data) => {
            //  //    //console.log("data.data-->", data.data);
            //  //    if (data) {
            //  //        this.onPlayFromLinkedResource(data.data[1]);
            //  //    }
            //  //}
            //  //private onLPRLinkedResourceClick = (data) => {
            //  //    if (data) {
            //  //        this.onPlayFromLinkedResource(data.data[1].values_);
            //  //    }
            //  //}
            //  //end
            //  // for quick play back context menu options
            this.onQuickPlayback = function (seconds, currentId) {
                var obj = new ThickClientCommunication();
                var resId = _this_1.selectedFeature.get('resourceId') || '';
                var ovrlId = "xyz" + "camInfo" + _this_1.mObjectPane.id + resId;
                obj.callBackToThickClientFunction('quickPlayback', { 'seconds': seconds, 'currentId': currentId, 'playerOverlayId': ovrlId });
                _this_1.hideCameraInfoPopup(_this_1.map, _this_1.mObjectPane);
                if (_this_1.mObjectPane.id === currentId) {
                    setTimeout(function () {
                        var aValX = _this_1.audioData;
                        var geom = _this_1.selectedFeature.getGeometry();
                        var coord = geom.getCoordinates();
                        var resourceId = _this_1.selectedFeature.get('resourceId') || '';
                        var popupLiveVdo = _this_1.map.getOverlayById('cameraLiveVdoPopup' + resourceId);
                        $('.playBackProxy').attr('rel', resourceId);
                        var isAudioObj = false;
                        if (resourceId && resourceId != '') {
                            var addResource = _this_1.globalDataAccessPoint.resources.byGuid[resourceId];
                            if (addResource) {
                                if (addResource.resourceType == 'AudioSource') {
                                    isAudioObj = true;
                                }
                            }
                        }
                        coord[0] = coord[0] + _this_1.deltaXDiff;
                        popupLiveVdo.setPosition(coord);
                        var popuLiveVdopObj = popupLiveVdo.getElement();
                        popuLiveVdopObj.style.display = 'block';
                        popupLiveVdo.set('resourceId', resourceId, true);
                        var elmTargetPane = _this_1.getNewPanel();
                        elmTargetPane._domContainer = popuLiveVdopObj;
                        elmTargetPane.id = "xyz" + "camInfo" + _this_1.mObjectPane.id + resourceId;
                        elmTargetPane.resource = _this_1.globalDataAccessPoint.resources.byGuid[resourceId];
                        elmTargetPane.fireExtendEventOff = true;
                        var resourceName = _this_1.globalDataAccessPoint.resources.byGuid[resourceId].name;
                        if (isAudioObj == true) {
                            aValX.executeResourceSpecificLogic(elmTargetPane);
                            _this_1.playerOpenIdQplayBack = [];
                            _this_1.playerOpenIdQplayBack.push(resourceId);
                            //this.map.getInteractions().forEach((interaction) => { interaction.setActive(false); });
                            var vmsPlayerObj = _this_1.vmsPlayerByPlayerIdMapping.get(elmTargetPane.vmsPlayerId);
                            vmsPlayerObj.showTimeline = true;
                            var fromPlayback = true;
                            vmsPlayerObj.on("MediaPlayerStateChanged", function (message) {
                                if (message == 'PlayingLive' && fromPlayback == true) {
                                    var dt = new Date();
                                    dt.setSeconds(dt.getSeconds() - seconds);
                                    if (isAudioObj == true) {
                                        vmsPlayerObj.playbackFromMap(vmsPlayerObj._resourceId, true, dt.toISOString(), 1);
                                        _this_1.eventDispatcher.fireEvent("enter_application_log", _this_1.AUDITLOGMSGES.monitoring.resource.mapDropped.rightClickOnResource.quickPlayBack + resourceName, _this_1.AUDITLOGMSGES.entryOperation.monitoring.mapQuickPlay, _this_1.AUDITLOGMSGES.entryOperation.operation.deviceview, false, true, true, 2);
                                    }
                                    else {
                                        vmsPlayerObj.playback(vmsPlayerObj._resourceId, true, dt.toISOString(), 1);
                                        _this_1.eventDispatcher.fireEvent("enter_application_log", _this_1.AUDITLOGMSGES.monitoring.resource.mapDropped.rightClickOnResource.quickPlayBack + resourceName, _this_1.AUDITLOGMSGES.entryOperation.monitoring.mapQuickPlay, _this_1.AUDITLOGMSGES.entryOperation.operation.deviceview, false, true, true, 2);
                                    }
                                }
                                else if (message == "PlayingPlayback") {
                                    fromPlayback = false;
                                }
                            });
                        }
                        else {
                            var dt = new Date();
                            _this_1.eventDispatcher.fireEvent("enter_application_log", _this_1.AUDITLOGMSGES.monitoring.resource.mapDropped.rightClickOnResource.quickPlayBack + resourceName, _this_1.AUDITLOGMSGES.entryOperation.monitoring.mapQuickPlay, _this_1.AUDITLOGMSGES.entryOperation.operation.deviceview, false, true, true, 2);
                            dt.setSeconds(dt.getSeconds() - seconds);
                            _this_1.createPlayer(elmTargetPane, elmTargetPane._domContainer, resourceId, true, dt.toISOString());
                        }
                        //movable player
                        var moveObj = document.createElement("div");
                        var titleSpan = popuLiveVdopObj.getElementsByClassName("vms-player-resource-title");
                        moveObj.setAttribute("style", "cursor:crosshair;width:25px;height:25px;display:block;overflow:hidden;position:absolute;left:-15px;top:-15px;background:blue;z-index:9999;background:url('images/MoveIcon.png')");
                        moveObj.setAttribute("rName", titleSpan[0].innerText);
                        var existingOverlay = _this_1.overLayList.filter(function (overlayItem) {
                            return (overlayItem.rName == titleSpan[0].innerText);
                        });
                        if (existingOverlay && existingOverlay.length > 0) {
                            existingOverlay[0].oObj = popupLiveVdo;
                            existingOverlay[0].resourceId = resourceId;
                            existingOverlay[0].rName = titleSpan[0].innerText;
                        }
                        else {
                            _this_1.overLayList.push({ oObj: popupLiveVdo, resourceId: resourceId, rName: titleSpan[0].innerText });
                        }
                        _this_1.resetOverlayPosWithPanel(resourceId);
                        moveObj.onmousedown = function (e) {
                            e.preventDefault();
                            e.stopPropagation();
                            if (!_this_1.selectedOverlay) {
                                var overLays = _this_1.overLayList.filter(function (o) {
                                    var target = e.target;
                                    return (o.rName == target.getAttribute('rName'));
                                });
                                if (overLays && overLays.length > 0)
                                    _this_1.selectedOverlay = overLays[0].oObj;
                                var pos = _this_1.selectedOverlay.getPosition();
                                _this_1.overlayDiffX = pos[0] - _this_1.currentMousePoint[0];
                                _this_1.overlayDiffY = pos[1] - _this_1.currentMousePoint[1];
                            }
                        };
                        moveObj.onmouseup = function (e) {
                            e.preventDefault();
                            e.stopPropagation();
                            _this_1.selectedOverlay = null;
                        };
                        document.onmouseup = function (e) {
                            e.preventDefault();
                            e.stopPropagation();
                            _this_1.selectedOverlay = null;
                        };
                        //end
                        // resizing overlay
                        var resizeObj = document.createElement("div");
                        var enteredInResizeDiv = false;
                        resizeObj.setAttribute("style", "cursor:nw-resize;width:45px;height:45px;display:block;overflow:hidden;position:absolute;right:-38px;bottom:-38px;background:blue;z-index:9999;background:url('images/Resize_Icon.png') no-repeat center");
                        _this_1.isPanelSelected = false;
                        //setTimeout(() => )
                        popuLiveVdopObj.onmouseover = function (e) {
                            e.preventDefault();
                            e.stopPropagation();
                            popuLiveVdopObj.appendChild(moveObj);
                            popuLiveVdopObj.appendChild(resizeObj);
                        };
                        resizeObj.onmousemove = function (e) {
                            e.preventDefault();
                            e.stopPropagation();
                            enteredInResizeDiv = true;
                            if (_this_1.isPanelSelected == true) {
                                var diffX = e.offsetX - _this_1.clientX;
                                var diffY = e.offsetY - _this_1.clientY;
                                var height = parseInt(popuLiveVdopObj.style.height.substring(0, popuLiveVdopObj.style.height.length - 2)) + 2;
                                var width = parseInt(popuLiveVdopObj.style.width.substring(0, popuLiveVdopObj.style.width.length - 2)) + 2;
                                height = height + diffY;
                                width = width + diffX;
                                if (height >= 120) {
                                    popuLiveVdopObj.style.height = height.toString() + "px";
                                }
                                if (width >= 200) {
                                    popuLiveVdopObj.style.width = width.toString() + "px";
                                }
                                //popuLiveVdopObj.style.height = height.toString() + "px";
                                //popuLiveVdopObj.style.width = width.toString() + "px";
                            }
                        };
                        popuLiveVdopObj.onmouseup = function (e) {
                            e.preventDefault();
                            e.stopPropagation();
                            _this_1.selectedOverlay = null;
                        };
                        _this_1.mapElement.onmouseup = function (e) {
                            _this_1.selectedOverlay = null;
                            _this_1.isPanelSelected = false;
                            _this_1.map.getInteractions().forEach(function (interaction) { interaction.setActive(true); });
                        };
                        resizeObj.onmouseout = function (e) {
                            e.preventDefault();
                            e.stopPropagation();
                            _this_1.isPanelSelected = false;
                        };
                        resizeObj.onmousedown = function (e) {
                            e.preventDefault();
                            e.stopPropagation();
                            _this_1.clientX = e.offsetX;
                            _this_1.clientY = e.offsetY;
                            _this_1.isPanelSelected = true;
                            _this_1.map.getInteractions().forEach(function (interaction) { interaction.setActive(false); });
                        };
                        resizeObj.onmouseup = function (e) {
                            e.preventDefault();
                            e.stopPropagation();
                            _this_1.isPanelSelected = false;
                            _this_1.map.getInteractions().forEach(function (interaction) { interaction.setActive(true); });
                        };
                        //end;
                    }, 100);
                }
            };
            this.sendInfoToThickClient = function (command, payload) {
                var obj = new ThickClientCommunication();
                obj.callBackToThickClientFunction(command, payload);
            };
            //  //setting resource style as per resource type
            this.getResourceStyle = function (resource) {
                if (resource.isThermalRadar) {
                    return new ol.style.Style({
                        image: new ol.style.Icon({
                            anchor: [0.5, 0.48],
                            size: new CameraIcons(_this_1.mapResource.mapIconSize).getIconSize(_this_1.mapResource.mapIconSize),
                            opacity: 1,
                            scale: new CameraIcons(_this_1.mapResource.mapIconSize).getIconScale(_this_1.mapResource.mapIconSize),
                            src: 'images/Thermal Radar2Active.png',
                            rotation: 0
                        }),
                        zIndex: 2
                    }); //new CameraIcons(this.mapResource.mapIconSize).iconThermalStyle;
                }
                if (resource.isMobileDevice) {
                    return new ol.style.Style({
                        image: new ol.style.Icon({
                            anchor: [0.5, 0.48],
                            size: new CameraIcons(_this_1.mapResource.mapIconSize).getIconSize(_this_1.mapResource.mapIconSize),
                            opacity: 1,
                            scale: new CameraIcons(_this_1.mapResource.mapIconSize).getIconScale(_this_1.mapResource.mapIconSize),
                            src: 'images/MobileActive.png',
                            rotation: 0
                        }),
                        zIndex: 2
                    }); //new CameraIcons(this.mapResource.mapIconSize).iconMobileStyle;
                }
                switch (resource.resourceType) {
                    case "Url":
                        return new ol.style.Style({
                            image: new ol.style.RegularShape({
                                points: 4,
                                radius: 30,
                                angle: Math.PI / 4,
                                fill: new ol.style.Fill({ color: [255, 255, 255, 0] }),
                            }),
                            text: new ol.style.Text(({
                                scale: 1,
                                font: 'normal 38px vicon-font',
                                offsetX: 0,
                                offsetY: 0,
                                rotateWithView: true,
                                text: '\ue92a',
                                textAlign: 'center',
                                textBaseline: 'middle',
                                fill: new ol.style.Fill({
                                    color: [0, 0, 255, 1],
                                }),
                                //stroke: new ol.style.Stroke({
                                //	color: [255, 255, 255, 1],
                                //	width: 1
                                //}),
                                rotation: 0 //== Rotation in radians -2 to 2*Math.PI (1 Pi = 3.14 = 180 degrees)
                            })),
                            zIndex: 2
                        }); //new CameraIcons(this.mapResource.mapIconSize).urlSourceStyle;
                    case "DigitalInput":
                        return new ol.style.Style({
                            image: new ol.style.Icon({
                                anchor: [0.5, 0.48],
                                size: new CameraIcons(_this_1.mapResource.mapIconSize).getIconSize(_this_1.mapResource.mapIconSize),
                                opacity: 1,
                                scale: new CameraIcons(_this_1.mapResource.mapIconSize).getIconScale(_this_1.mapResource.mapIconSize),
                                src: 'images/04_DigitalInput.png',
                                rotation: 0
                            }),
                            zIndex: 2
                        }); //new CameraIcons(this.mapResource.mapIconSize).diSourceStyle;
                    case "RelayOutput":
                        return new ol.style.Style({
                            image: new ol.style.Icon({
                                anchor: [0.5, 0.48],
                                size: new CameraIcons(_this_1.mapResource.mapIconSize).getIconSize(_this_1.mapResource.mapIconSize),
                                opacity: 1,
                                scale: new CameraIcons(_this_1.mapResource.mapIconSize).getIconScale(_this_1.mapResource.mapIconSize),
                                src: 'images/03_Relayoutput.png',
                                rotation: 0
                            }),
                            zIndex: 2
                        }); //new CameraIcons(this.mapResource.mapIconSize).roSourceStyle;
                    case "AudioSource":
                        return new ol.style.Style({
                            image: new ol.style.Icon({
                                anchor: [0.5, 0.48],
                                size: new CameraIcons(_this_1.mapResource.mapIconSize).getIconSize(_this_1.mapResource.mapIconSize),
                                opacity: 1,
                                scale: new CameraIcons(_this_1.mapResource.mapIconSize).getIconScale(_this_1.mapResource.mapIconSize),
                                src: "images/01_MicrophoneActive.png",
                                rotation: 0
                            }),
                            zIndex: 2
                        });
                    //              return new CameraIcons(this.mapResource.mapIconSize).audioSourceStyle;
                    case "View":
                        return new ol.style.Style({
                            image: new ol.style.Icon({
                                anchor: [0.5, 0.48],
                                size: new CameraIcons(_this_1.mapResource.mapIconSize).getIconSize(_this_1.mapResource.mapIconSize),
                                opacity: 1,
                                scale: new CameraIcons(_this_1.mapResource.mapIconSize).getIconScale(_this_1.mapResource.mapIconSize),
                                src: "images/05_ViewActive.png",
                                // src: CameraIcons.ICON_SRC.view,
                                rotation: 0
                            }),
                            zIndex: 2
                        });
                    //              return new CameraIcons(this.mapResource.mapIconSize).viewSourceStyle;
                    case "PtzVideoSource":
                        return new ol.style.Style({
                            image: new ol.style.Icon({
                                anchor: [0.5, 0.48],
                                size: new CameraIcons(_this_1.mapResource.mapIconSize).getIconSize(_this_1.mapResource.mapIconSize),
                                opacity: 1,
                                scale: new CameraIcons(_this_1.mapResource.mapIconSize).getIconScale(_this_1.mapResource.mapIconSize),
                                src: "images/04B_PTZDomeActive.png",
                                rotation: 0
                            }),
                            zIndex: 2
                        });
                    case "MixedVideoSource":
                        return new ol.style.Style({
                            image: new ol.style.Icon({
                                anchor: [0.5, 0.48],
                                size: new CameraIcons(_this_1.mapResource.mapIconSize).getIconSize(_this_1.mapResource.mapIconSize),
                                opacity: 1,
                                scale: new CameraIcons(_this_1.mapResource.mapIconSize).getIconScale(_this_1.mapResource.mapIconSize),
                                src: 'images/10_PTZDome2Active.png',
                                rotation: 0
                            }),
                            zIndex: 2
                        }); //new CameraIcons(this.mapResource.mapIconSize).mixedIconStyle;
                    case "PtzMixedVideoSource":
                        return new ol.style.Style({
                            image: new ol.style.Icon({
                                anchor: [0.5, 0.48],
                                size: new CameraIcons(_this_1.mapResource.mapIconSize).getIconSize(_this_1.mapResource.mapIconSize),
                                opacity: 1,
                                scale: new CameraIcons(_this_1.mapResource.mapIconSize).getIconScale(_this_1.mapResource.mapIconSize),
                                src: 'images/10_PTZDome2Active.png',
                                rotation: 0
                            }),
                            zIndex: 2
                        }); //new CameraIcons(this.mapResource.mapIconSize).ptzMixedIconStyle;
                    case "Tour":
                        return new ol.style.Style({
                            image: new ol.style.Icon({
                                anchor: [0.5, 0.48],
                                size: new CameraIcons(_this_1.mapResource.mapIconSize).getIconSize(_this_1.mapResource.mapIconSize),
                                opacity: 1,
                                scale: new CameraIcons(_this_1.mapResource.mapIconSize).getIconScale(_this_1.mapResource.mapIconSize),
                                src: "images/06_TourActive.png",
                                // src: CameraIcons.ICON_SRC.tour,
                                rotation: 0
                            }),
                            zIndex: 2
                        });
                    //              return new CameraIcons(this.mapResource.mapIconSize).tourIconStyle;
                    case "PlaybackAudioSource":
                        return new ol.style.Style({
                            image: new ol.style.Icon({
                                anchor: [0.5, 0.48],
                                size: new CameraIcons(_this_1.mapResource.mapIconSize).getIconSize(_this_1.mapResource.mapIconSize),
                                opacity: 1,
                                scale: new CameraIcons(_this_1.mapResource.mapIconSize).getIconScale(_this_1.mapResource.mapIconSize),
                                src: 'images/01_Microphone.png',
                                rotation: 0
                            }),
                            zIndex: 2
                        }); //new CameraIcons(this.mapResource.mapIconSize).removedChannelIconStyle;
                    case "LPRSensorResource":
                        return new ol.style.Style({
                            image: new ol.style.Icon({
                                anchor: [0.5, 0.48],
                                size: new CameraIcons(_this_1.mapResource.mapIconSize).getIconSize(_this_1.mapResource.mapIconSize),
                                opacity: 1,
                                scale: new CameraIcons(_this_1.mapResource.mapIconSize).getIconScale(_this_1.mapResource.mapIconSize),
                                src: "images/lprActive.png",
                                rotation: 0
                            }),
                            zIndex: 2
                        });
                    //              return new CameraIcons(this.mapResource.mapIconSize).lprIconStyle;
                    case "VAXDoorResource":
                        return new ol.style.Style({
                            image: new ol.style.Icon({
                                anchor: [0.5, 0.48],
                                size: new CameraIcons(_this_1.mapResource.mapIconSize).getIconSize(_this_1.mapResource.mapIconSize),
                                opacity: 1,
                                scale: new CameraIcons(_this_1.mapResource.mapIconSize).getIconScale(_this_1.mapResource.mapIconSize),
                                src: "images/door-active.png",
                                rotation: 0
                            }),
                            zIndex: 2
                        });
                    //              return new CameraIcons(this.mapResource.mapIconSize).vaxIconStyle;
                    case "VAXActionPlanResource":
                        return new ol.style.Style({
                            image: new ol.style.Icon({
                                anchor: [0.5, 0.48],
                                size: new CameraIcons(_this_1.mapResource.mapIconSize).getIconSize(_this_1.mapResource.mapIconSize),
                                opacity: 1,
                                scale: new CameraIcons(_this_1.mapResource.mapIconSize).getIconScale(_this_1.mapResource.mapIconSize),
                                src: "images/vax_action_plan_idle.png",
                                rotation: 0
                            }),
                            zIndex: 2
                        });
                    default:
                        return new ol.style.Style({
                            image: new ol.style.Icon({
                                anchor: [0.5, 0.48],
                                size: new CameraIcons(_this_1.mapResource.mapIconSize).getIconSize(_this_1.mapResource.mapIconSize),
                                opacity: 1,
                                scale: new CameraIcons(_this_1.mapResource.mapIconSize).getIconScale(_this_1.mapResource.mapIconSize),
                                src: 'images/02A_DomeStaticCameraActive.png',
                                rotation: 0
                            }),
                            zIndex: 2
                        }); //new CameraIcons(this.mapResource.mapIconSize).icon1;
                }
            };
            //  //seeting alarm style image as per resource
            this.getAlarmResourceStyle = function (resource) {
                if (resource.changeIcon && resource.changeIcon.length > 0) {
                    var alarmIcon = resource.changeIcon.filter(function (item) {
                        return (item.type == "alarm");
                    });
                    if (alarmIcon && alarmIcon.length > 0 && resource.resourceType != "Url") {
                        return _this_1.getImagePathFromUrl(alarmIcon[0].path);
                    }
                }
                if (resource.isThermalRadar) {
                    return 'images/Thermal Radar2Alarm.png'; //CameraIcons.ICON_SRC.iconThermalAlarm;
                }
                if (resource.isMobileDevice) {
                    return 'images/MobileAlarm.png'; //CameraIcons.ICON_SRC.iconMobileAlarm;
                }
                switch (resource.resourceType) {
                    case "Url":
                        return new ol.style.Style({
                            image: new ol.style.RegularShape({
                                points: 4,
                                radius: 30,
                                angle: Math.PI / 4,
                                fill: new ol.style.Fill({ color: [255, 255, 255, 0] }),
                            }),
                            text: new ol.style.Text(({
                                scale: 1,
                                font: 'normal 38px vicon-font',
                                offsetX: 0,
                                offsetY: 0,
                                rotateWithView: true,
                                text: '\ue92a',
                                textAlign: 'center',
                                textBaseline: 'middle',
                                fill: new ol.style.Fill({
                                    color: [0, 0, 255, 1],
                                }),
                                //stroke: new ol.style.Stroke({
                                //	color: [255, 255, 255, 1],
                                //	width: 1
                                //}),
                                rotation: 0 //== Rotation in radians -2 to 2*Math.PI (1 Pi = 3.14 = 180 degrees)
                            })),
                            zIndex: 2
                        }); //new CameraIcons(this.mapResource.mapIconSize).urlSourceStyle;
                    case "DigitalInput":
                        return 'images/04_DigitalInputAlarm.png'; //CameraIcons.ICON_SRC.digitalInputAlarm;
                    case "RelayOutput":
                        return 'images/03_RelayoutputAlarm.png'; //CameraIcons.ICON_SRC.relayOutputAlarm;
                    case "AudioSource":
                        return 'images/01_MicrophoneAlarm.png'; //CameraIcons.ICON_SRC.audioAlarm;
                    case "View":
                        return 'images/05_ViewAlarm.png'; //CameraIcons.ICON_SRC.viewAlarm;
                    case "PtzVideoSource":
                        return 'images/04B_PTZDomeAlarm.png'; //CameraIcons.ICON_SRC.ptzAlarm;
                    case "MixedVideoSource":
                        return 'images/02_MixedChannelAlarm.png'; //CameraIcons.ICON_SRC.mixedIconAlarm;
                    case "PtzMixedVideoSource":
                        return 'images/10_PTZDome2Alarm.png'; //CameraIcons.ICON_SRC.ptzMixedAlarm;
                    case "LPRSensorResource":
                        return 'images/lprImage.png'; //CameraIcons.ICON_SRC.iconLPRAlarm;
                    case "Tour":
                        return 'images/06_TourAlarm.png'; //CameraIcons.ICON_SRC.tourAlarm;
                    case "VAXDoorResource":
                        return 'images/door-alarm.png'; //CameraIcons.ICON_SRC.vaxDoorAlarm;
                    case "VAXActionPlanResource":
                        return 'images/vax_action_play_active.png'; //cameraIcons.ICON_SRC.vaxActionPlanAlarm;
                    default:
                        return 'images/02A_DomeStaticCameraAlarm.png'; //CameraIcons.ICON_SRC.defaultAlarm;
                }
            };
            this.getIdleResourceStyle = function (resource) {
                if (resource.changeIcon && resource.changeIcon.length > 0) {
                    var idleIcon = resource.changeIcon.filter(function (item) {
                        return (item.type == "idle");
                    });
                    if (idleIcon && idleIcon.length > 0 && resource.resourceType != "Url") {
                        return _this_1.getImagePathFromUrl(idleIcon[0].path);
                    }
                }
                if (resource.isThermalRadar) {
                    return 'images/ThermalRadar2.png'; //CameraIcons.ICON_SRC.iconThermal;
                }
                if (resource.isMobileDevice) {
                    return 'images/Mobile.png'; //CameraIcons.ICON_SRC.iconMobile;
                }
                switch (resource.resourceType) {
                    case "Url":
                        return new ol.style.Style({
                            image: new ol.style.Icon({
                                anchor: [0.5, 0.48],
                                size: new CameraIcons(_this_1.mapResource.mapIconSize).getIconSize(_this_1.mapResource.mapIconSize),
                                opacity: 1,
                                scale: new CameraIcons(_this_1.mapResource.mapIconSize).getIconScale(_this_1.mapResource.mapIconSize),
                                src: 'images/05_ViewActive.png',
                                rotation: 0
                            }),
                            zIndex: 2
                        }); //new CameraIcons(this.mapResource.mapIconSize).viewSourceStyle;
                    case "DigitalInput":
                        return 'images/04_DigitalInput.png'; //CameraIcons.ICON_SRC.digitalInput;
                    case "RelayOutput":
                        return 'images/03_Relayoutput.png'; //CameraIcons.ICON_SRC.relayOutput;
                    case "AudioSource":
                        return 'images/01_Microphone.png'; //CameraIcons.ICON_SRC.audioIdle;
                    case "View":
                        return 'images/05_View.png'; //CameraIcons.ICON_SRC.viewIdle;
                    case "PtzVideoSource":
                        return 'images/04B_PTZDome.png'; //CameraIcons.ICON_SRC.ptzIdle;
                    case "MixedVideoSource":
                        return 'images/02_MixedChannel.png'; //CameraIcons.ICON_SRC.mixedIconIdle;
                    case "PtzMixedVideoSource":
                        return 'images/10_PTZDome2.png'; //CameraIcons.ICON_SRC.ptzMixedIdle;
                    case "Tour":
                        return 'images/06_Tour.png'; //CameraIcons.ICON_SRC.tourIdle;
                    case "PlaybackAudioSource":
                        return 'images/01_Microphone.png'; //CameraIcons.ICON_SRC.audioIdle;
                    case "LPRSensorResource":
                        return 'images/lprActive.png'; //CameraIcons.ICON_SRC.iconLPR;
                    case "VAXDoorResource":
                        return 'images/door-idle.png'; //CameraIcons.ICON_SRC.vaxDoorIdle;
                    case "VAXActionPlanResource":
                        return 'images/vax_action_plan_idle.png'; //cameraIcons.ICON_SRC.vaxActionPlanIdle;
                    default:
                        return 'images/02A_DomeStaticCamera.png'; //CameraIcons.ICON_SRC.defaultIdle;
                }
            };
            this.getActiveResourceStyle = function (resource) {
                if (resource.changeIcon && resource.changeIcon.length > 0) {
                    var activeIcon = resource.changeIcon.filter(function (item) {
                        return (item.type == "active");
                    });
                    if (activeIcon && activeIcon.length > 0 && resource.resourceType != "Url") {
                        return _this_1.getImagePathFromUrl(activeIcon[0].path);
                    }
                }
                if (resource.isThermalRadar) {
                    return 'images/Thermal Radar2Active.png'; //CameraIcons.ICON_SRC.iconThermalActive;
                }
                if (resource.isMobileDevice) {
                    return 'images/MobileActive.png'; //CameraIcons.ICON_SRC.iconMobileActive;
                }
                switch (resource.resourceType) {
                    case "Url":
                        return new ol.style.Style({
                            image: new ol.style.Icon({
                                anchor: [0.5, 0.48],
                                size: new CameraIcons(_this_1.mapResource.mapIconSize).getIconSize(_this_1.mapResource.mapIconSize),
                                opacity: 1,
                                scale: new CameraIcons(_this_1.mapResource.mapIconSize).getIconScale(_this_1.mapResource.mapIconSize),
                                src: 'images/05_ViewActive.png',
                                rotation: 0
                            }),
                            zIndex: 2
                        }); //new CameraIcons(this.mapResource.mapIconSize).viewSourceStyle;
                    case "DigitalInput":
                        return 'images/04_DigitalInputActive.png'; //CameraIcons.ICON_SRC.digitalInputActive;
                    case "RelayOutput":
                        return 'images/03_RelayoutputActive.png'; //CameraIcons.ICON_SRC.relayOutputActive;
                    case "AudioSource":
                        return 'images/01_MicrophoneActive.png'; //CameraIcons.ICON_SRC.audio;
                    case "View":
                        return 'images/05_ViewActive.png'; //CameraIcons.ICON_SRC.view;
                    case "PtzVideoSource":
                        return 'images/04B_PTZDomeActive.png'; //CameraIcons.ICON_SRC.ptz;
                    case "MixedVideoSource":
                        return 'images/02_MixedChannelActive.png'; //CameraIcons.ICON_SRC.mixedIcon;
                    case "PtzMixedVideoSource":
                        return 'images/10_PTZDome2Active.png'; //CameraIcons.ICON_SRC.ptzMixed;
                    case "Tour":
                        return 'images/06_TourActive.png'; //CameraIcons.ICON_SRC.tour;
                    case "LPRSensorResource":
                        return 'images/lprActive.png'; //CameraIcons.ICON_SRC.iconLPR;
                    case "VAXDoorResource":
                        return 'images/door-active.png'; //CameraIcons.ICON_SRC.vaxDoorActive;
                    case "VAXActionPlanResource":
                        return 'images/vax_action_plan_idle.png';
                    default:
                        return 'images/02A_DomeStaticCameraActive.png'; //CameraIcons.ICON_SRC.default;
                }
            };
            this.setResourcePath = function (resource, data) {
                if (!resource.changeIcon || resource.changeIcon == undefined) {
                    resource.changeIcon = [];
                    resource.changeIcon.push({ Id: data.id, Name: data.name, Path: data.src, Type: data.type, id: data.id, name: data.name, path: data.src, type: data.type });
                }
                else {
                    var existingTypeRecord = resource.changeIcon.filter(function (item) {
                        return (item.Type == data.type || item.type == data.type);
                    });
                    if (existingTypeRecord && existingTypeRecord.length > 0) {
                        resource.changeIcon = resource.changeIcon.map(function (item) {
                            if ((item.ResourceId == data.id && item.Type == data.type) ||
                                (item.resourceId == data.id && item.type == data.type) ||
                                (item.Id == data.id && item.Type == data.type) ||
                                (item.id == data.id && item.type == data.type)) {
                                item.Path = data.src;
                                item.path = data.src;
                            }
                            return item;
                        });
                        //existingTypeRecord[0].Path = data.src;
                        //return;
                    }
                    else {
                        resource.changeIcon.push({ Id: data.id, Name: data.name, Path: data.src, Type: data.type, id: data.id, name: data.name, path: data.src, type: data.type });
                    }
                }
            };
            this.setPresetList = function (feature) {
                var sourceId = feature.values_.resourceId;
                var presetList = feature.get('presetData');
                if (presetList != null && presetList.length) {
                    var ptzResetItems = [];
                    presetList.forEach(function (element) {
                        ptzResetItems.push({ text: element.presetName, data: [feature, element], callback: _this_1.onPresetClick });
                    });
                    feature.set("presetData", ptzResetItems);
                }
                else {
                    var ptzResetItems = [];
                    feature.set("presetData", ptzResetItems);
                }
            };
            //  //////////private setPresetList = (feature: any) => {
            //  //////////    var sourceId = feature.values_.resourceId;
            //  //////////    //default 
            //  //////////    var ptzResetItems = [];
            //  //////////    feature.set("presetData", ptzResetItems);
            //  //////////    if (!this.prePolledData || !this.prePolledData["recordingSettings"]) return;
            //  //////////    let rObj: any = this.prePolledData["recordingSettings"].filter((recordingData) => {
            //  //////////        return recordingData.SourceId == sourceId;
            //  //////////    })
            //  //////////    if (!rObj || rObj.length == 0) return;
            //  //////////    if (!rObj[0].ptzPreset || rObj[0].ptzPreset.length == 0) return;
            //  //////////    rObj[0].ptzPreset.forEach((itm) => {
            //  //////////        ptzResetItems.push({ text: itm.PresetName, data: [feature, itm], callback: this.onPresetClick })
            //  //////////    })
            //  //////////    feature.set("presetData", ptzResetItems);
            //  //////////};
            //  //private setVaxLinkedResourceList = (feature: any) => {
            //  //    var sourceId = feature.values_.resourceId;
            //  //    this.addPartnerService.getLPRSensorResourcesList(sourceId).then((data) => {
            //  //        var vaxLinkedResourceItems = []
            //  //        if (data) {
            //  //            data.forEach((itm) => {
            //  //                let vaxLinkedResource: any = this.globalDataAccessPoint.resources.byGuid[itm];
            //  //                let vaxLinkedResourceName = vaxLinkedResource._name;
            //  //                vaxLinkedResourceItems.push({ text: vaxLinkedResourceName, data: [feature, vaxLinkedResource], callback: this.onVaxLinkedResourceClick })
            //  //            })
            //  //        }
            //  //        feature.set("vaxLinkedResourceData", vaxLinkedResourceItems)
            //  //    }, (err) => {
            //  //        var vaxLinkedResourceItems = [];
            //  //        feature.set("vaxLinkedResourceData", vaxLinkedResourceItems);
            //  //    })
            //  //};
            //  //private setLPRLinkedResourceList = (feature: any) => {
            //  //    //var sourceId = feature.values_.resourceId;
            //  //    var lprLinkedResourceItems = []
            //  //    if (feature.values_.resourceId) {
            //  //        let lprLinkedResourceName = '';
            //  //        let lprLinkedResource: any = this.globalDataAccessPoint.resources.byGuid[feature.values_.id];
            //  //        //console.log("lprLinkedResource======>", lprLinkedResource);
            //  //        if (lprLinkedResource && lprLinkedResource.sensor && lprLinkedResource.sensor.id) {
            //  //            let lprLinkedResourceItem: any = this.globalDataAccessPoint.resources.byGuid[lprLinkedResource.sensor.id];
            //  //            //console.log("lprLinkedResourceItem----->", lprLinkedResourceItem);
            //  //            lprLinkedResourceName = lprLinkedResourceItem.name;
            //  //        }
            //  //        lprLinkedResourceItems.push({ text: lprLinkedResourceName, data: [feature, feature], callback: this.onLPRLinkedResourceClick });
            //  //    }
            //  //    feature.set("lprLinkedResourceData", lprLinkedResourceItems)
            //  //    //this.addPartnerService.getLPRSensorResourcesList(sourceId).then((data) => {
            //  //    //    var lprLinkedResourceItems = []
            //  //    //    if (data) {
            //  //    //        data.forEach((itm) => {
            //  //    //            let lprLinkedResource: any = this.globalDataAccessPoint.resources.byGuid[itm];
            //  //    //            let lprLinkedResourceName = lprLinkedResource._name;
            //  //    //            console.log("itm==>", itm);
            //  //    //            lprLinkedResourceItems.push({ text: lprLinkedResourceName, data: [feature, lprLinkedResource],
            //  //    //                callback: this.onLPRLinkedResourceClick})
            //  //    //        })
            //  //    //    }
            //  //    //    feature.set("lprLinkedResourceData", lprLinkedResourceItems)
            //  //    //}, (err) => {
            //  //    //    var lprLinkedResourceItems = [];
            //  //    //    feature.set("lprLinkedResourceData", lprLinkedResourceItems);
            //  //    //})
            //  //};
            //  private setViewList = (feature: any, resourceId) => {
            //      var sourceId = feature.values_.resourceId;
            //      var ViewItemList = []
            //      let views = this.globalDataAccessPoint.resources.byGuid[resourceId];
            //      const shwRemark: any = this.globalDataAccessPoint.resources.byGuid[feature.getId()];
            //      if (views._id == sourceId) {
            //          ViewItemList.push({ text: views._name })
            //      }
            //      if (views._resourceType == "View") {
            //          ViewItemList.push({ text: shwRemark._remarks });
            //      }
            //      feature.set("getCameraName", ViewItemList);
            //      let resourceObj: any = this.globalDataAccessPoint.resources.byGuid[resourceId];
            //      if (resourceObj._resourceType != "Map" && resourceObj._resourceType != "DigitalInput") {
            //          // Filter resources from all nested folders
            //          let getActive = this.filterLocalTreeNodes(this.activeResources, resourceId);
            //          //var getActive = this.activeResources.filter((item) => {
            //          //    return (item.id == resourceId)
            //          //})
            //          if (!getActive || getActive.length == 0) {
            //              feature.set("getCameraName", [{ text: views._name + "(Removed channel)" }]);
            //          }
            //      }
            //  };
            //  private filterLocalTreeNodes = (data, resourceId) => {
            //      return data.reduce((accu, ele) => {
            //          if ((ele.type === "ResourceGroup" || ele.Type === "ResourceGroup") && ele.children) {
            //              accu = [...accu, ...this.filterLocalTreeNodes(ele.children, resourceId)];
            //          }
            //          if (ele.id == resourceId) {
            //              accu.push(ele);
            //          }
            //          return accu;
            //      }, []);
            //  }
            //  private setNVRIdName = (feature: any, resourceId) => {
            //      var sourceId = feature.values_.resourceId;
            //      var NVRIdName = []
            //      let views = this.globalDataAccessPoint.resources.byGuid[resourceId];
            //      if (views.nvrId != undefined) {
            //          let nvrId = views.nvrId;
            //          let nvrObj = this.globalDataAccessPoint.nvrs.byGuid[nvrId];
            //          let NVRName = nvrObj ? this.globalDataAccessPoint.nvrs.byGuid[nvrId].viewName : "Unknown";
            //          if (views._id == sourceId) {
            //              NVRIdName.push({ text: NVRName })
            //          }
            //          feature.set("getNVRName", NVRIdName);
            //      }
            //  };
            //  private setMapName = (feature: any, resourceId) => {
            //      var mapName = []
            //      const addResource: any = this.globalDataAccessPoint.resources.byGuid[resourceId];
            //      if (!addResource) return;
            //      let maps = addResource._name;
            //      let remarks = addResource._description;
            //      if (this.mapResource._id && remarks == undefined) {
            //          mapName.push({ text: maps })
            //      } else {
            //          mapName.push({ text: maps }, { text: remarks })
            //      }
            //      feature.set("getMapName", mapName);
            //  };
            this.setFunnelLayerInteraction = function (map) {
                // configure layers for points
                _this_1.funnelResizeSource = new ol.source.Vector({
                    features: [],
                    wrapX: false
                });
                //== Then creating layer from the Vector
                _this_1.funnelResizelayer = new ol.layer.Vector({
                    source: _this_1.funnelResizeSource
                });
                _this_1.funnelResizelayer.set('name', "funnelResizeLayer");
                _this_1.funnelResizelayer.setZIndex(5);
                map.addLayer(_this_1.funnelResizelayer);
                map.on("click", function (e) {
                    _this_1.funnelResizeSource.clear();
                    var fCount = 0;
                    var f = null;
                    var funnel = null;
                    var funnel360 = null;
                    var iconFeatureName = null;
                    _this_1.map.forEachFeatureAtPixel(e.pixel, function (feature, layer) {
                        f = feature;
                        fCount++;
                        if ((f.values_.type == mapDefaults.mapFeatureTypes.funnel || f.values_.type == "funnelIconFeature") && f.get('description') != 'Camera360') {
                            funnel = feature;
                        }
                        else if ((f.values_.type == mapDefaults.mapFeatureTypes.funnel || f.values_.type == "funnelIconFeature") && f.get('description') == 'Camera360') {
                            funnel360 = feature;
                        }
                        if (f.values_.type == "iconFeature") {
                            iconFeatureName = true;
                        }
                    });
                    if (funnel && fCount == 1) {
                        var coord = funnel.getGeometry().getCoordinates();
                        for (var i = 1; i < coord[0].length; i++) {
                            var pointFeature = new ol.Feature({
                                id: "resize_point" + i,
                                geometry: new ol.geom.Point(coord[0][i]),
                                name: "resize_point" + i,
                                type: "resize_point",
                                resourceId: "point" + funnel.values_.resourceId
                            });
                            pointFeature.set("feature", funnel);
                            pointFeature.set("currentPointCount", i);
                            pointFeature.set("origin", coord[0][0]);
                            _this_1.funnelResizeSource.addFeature(pointFeature);
                        }
                    }
                    else if (funnel360 && fCount == 1) {
                        var coord = funnel360.getGeometry().getCoordinates();
                        var pointFeature = new ol.Feature({
                            id: "resize_point" + 0,
                            geometry: new ol.geom.Point(coord[0][0]),
                            name: "resize_point" + 0,
                            type: "resize_point",
                            resourceId: "point" + funnel360.values_.resourceId
                        });
                        pointFeature.set("feature", funnel360);
                        pointFeature.set("currentPointCount", 0);
                        pointFeature.set("origin", coord[0][0]);
                        _this_1.funnelResizeSource.addFeature(pointFeature);
                    }
                    //check:-> command to disable change icons btn
                    //Start config->disable change icon button if user clicks on map
                    //  let changeIconBtn: HTMLElement = document.getElementById("changeIconBtn");
                    //  if (iconFeatureName) {
                    //      changeIconBtn.removeAttribute("disabled");
                    //      this.scope.mapsIcon = false;
                    //      this.map.getInteractions().forEach((interaction) => { interaction.setActive(true); });
                    //      this.eventDispatcher.fireEvent('ENABLE_CHANGE_ICON', f, this.scope, this.globalDataAccessPoint);
                    //      return true;
                    //  } else {
                    //      changeIconBtn.setAttribute("disabled", 'true');
                    //      this.scope.mapsIcon = true;
                    //      this.eventDispatcher.fireEvent('DISABLE_CHANGE_ICON', f, this.scope, this.globalDataAccessPoint);
                    //      return true;
                    //  }
                    //End
                });
            };
            this.setAngleDisplacement = function (iconFeature) {
                _this_1.map.getLayers().forEach(function (layer) {
                    if (layer instanceof ol.layer.Vector) {
                        var source = layer.getSource();
                        var feature = source.getFeatures();
                        feature.forEach(function (featureItem) {
                            if (featureItem.values_.type === 'funnelIconFeature' && iconFeature.values_.resourceId === featureItem.values_.resourceId) {
                                var coord = featureItem.getGeometry().getCoordinates();
                                var iconCord = iconFeature.getGeometry().getCoordinates();
                                _this_1.x1Delta = coord[0][1][0] - iconCord[0];
                                _this_1.y1Delta = coord[0][1][1] - iconCord[1];
                                _this_1.x2Delta = coord[0][2][0] - iconCord[0];
                                _this_1.y2Delta = iconCord[1] - coord[0][2][1];
                            }
                        });
                    }
                });
            };
            this.translateFunnel = function (currentType, coordinates, f) {
                if (currentType == 'resize_point') {
                    _this_1.mapElement.style.cursor = "nw-resize";
                    var origin_1 = f.get("origin");
                    var feature_2 = f.get("feature");
                    var currentPointCount = f.get("currentPointCount");
                    var coord = feature_2.getGeometry().getCoordinates();
                    var dist = Math.sqrt(Math.pow((origin_1[0] - coordinates[0]), 2) + Math.pow((origin_1[1] - coordinates[1]), 2));
                    var scale_1;
                    var restrictScaleFunnel = void 0;
                    _this_1.map.getLayers().forEach(function (layer) {
                        if (layer instanceof ol.layer.Vector) {
                            var source = layer.getSource();
                            var feature1 = source.getFeatures();
                            feature1.forEach(function (featureItem) {
                                //iconFeature
                                if (featureItem.values_.type === 'iconFeature' && feature_2.values_.resourceId === featureItem.values_.resourceId) {
                                    var style = featureItem.getStyle();
                                    var imgStye = style.getImage();
                                    scale_1 = imgStye.getScale();
                                }
                            });
                        }
                    });
                    restrictScaleFunnel = _this_1.restrictScaleSizeFunnel(scale_1, dist);
                    if (currentPointCount == 1) {
                        if (dist <= restrictScaleFunnel) {
                            f.getGeometry().setCoordinates(coord[0][1]);
                            return;
                        }
                        else {
                            coord[0][1] = coordinates;
                        }
                    }
                    else if (currentPointCount == 2) {
                        if (dist <= restrictScaleFunnel) {
                            f.getGeometry().setCoordinates(coord[0][2]);
                            return;
                        }
                        else {
                            coord[0][2] = coordinates;
                        }
                    }
                    else if (currentPointCount == 0) {
                        var fExtent = feature_2.getGeometry().getExtent();
                        var center = ol.extent.getCenter(fExtent);
                        dist = Math.sqrt(Math.pow((center[0] - coordinates[0]), 2) + Math.pow((center[1] - coordinates[1]), 2));
                        if (dist <= restrictScaleFunnel) {
                            f.getGeometry().setCoordinates(coord[0][0]);
                            return;
                        }
                        _this_1.translateCircle(feature_2, coordinates, center);
                        return;
                    }
                    feature_2.getGeometry().setCoordinates(coord);
                }
                else {
                    _this_1.funnelResizeSource.clear();
                }
            };
            this.restrictScaleSizeFunnel = function (scale, dist) {
                var defaultScaleRestriction = 0.07466817293925089;
                var defaultImgScale = new CameraIcons(_this_1.mapResource.mapIconSize).getIconScale(_this_1.mapResource.mapIconSize);
                var scaleInPercent = (defaultScaleRestriction / defaultImgScale * 100);
                var restrictScaleCoord = (scaleInPercent / 100 * scale);
                return restrictScaleCoord;
            };
            this.translateNote = function (currentType, coordinates, f) {
                var geoC = _this_1.getMapTypeDelta();
                if (currentType == 'resize_note5') {
                    _this_1.mapElement.style.cursor = "nw-resize";
                    var feature_3 = f.get("feature");
                    var maxcoordinatesY = f.get("maxcoordinatesY");
                    var maxcoordinatesX = f.get("maxcoordinatesX");
                    if (maxcoordinatesY && coordinates[1] > maxcoordinatesY[1]) {
                        f.getGeometry().setCoordinates([coordinates[0], maxcoordinatesY[1]]);
                        return;
                    }
                    if (maxcoordinatesX && coordinates[0] < maxcoordinatesX[0]) {
                        f.getGeometry().setCoordinates([maxcoordinatesX[0], coordinates[1]]);
                        return;
                    }
                    var coord_1 = feature_3.getGeometry().getCoordinates();
                    var deltaX = (coordinates[0] - MapsOpenLayers.POINT_X_DELTA * geoC) - coord_1[0][5][0];
                    var deltaY = (coordinates[1] + MapsOpenLayers.POINT_Y_DELTA * geoC) - coord_1[0][5][1];
                    // point 1 (triangle left edge)
                    coord_1[0][1][0] = coord_1[0][1][0] + deltaX;
                    coord_1[0][1][1] = coord_1[0][1][1] + deltaY;
                    // point 2 (rectangle bottom left)
                    coord_1[0][2][1] = coord_1[0][2][1] + deltaY;
                    // point 4 (rectangle top right)
                    coord_1[0][4][0] = coord_1[0][4][0] + deltaX;
                    // point 5 (rectangle bottom right)
                    coord_1[0][5][0] = coord_1[0][5][0] + deltaX;
                    coord_1[0][5][1] = coord_1[0][5][1] + deltaY;
                    // point 6 (triangle right edge)
                    coord_1[0][6][0] = coord_1[0][6][0] + deltaX;
                    coord_1[0][6][1] = coord_1[0][6][1] + deltaY;
                    // adjust triangle 
                    var midX = (coord_1[0][2][0] + coord_1[0][5][0]) / 2;
                    var midC = [midX, coord_1[0][1][1]];
                    var br1 = [midC[0] - 0.03 * geoC, midC[1]];
                    var br2 = [midC[0] + 0.02 * geoC, midC[1]];
                    var br3 = [midC[0] - 0.04 * geoC, midC[1] - 0.03 * geoC];
                    coord_1[0][0] = br3;
                    coord_1[0][1] = br1;
                    coord_1[0][6] = br2;
                    //set coordinates
                    feature_3.getGeometry().setCoordinates(coord_1);
                    _this_1.map.getLayers().forEach(function (l) {
                        if (l.get('name') == "notes") {
                            var s = l.getSource();
                            var f_2 = s.getFeatures();
                            f_2.forEach(function (fItem) {
                                if (fItem.getId() == feature_3.getId()) {
                                    fItem.getGeometry().setCoordinates([coord_1[0].slice(1, 7)]);
                                    var diffCoords = coord_1[0][4][0] - coord_1[0][3][0];
                                    var textSize = Math.ceil((MapsOpenLayers.TEXT_DELTA / 100.0) * diffCoords);
                                    fItem.getStyle().getText().setText(_this_1.divideString(feature_3.get("textvalue"), textSize, "\n"));
                                }
                            });
                        }
                        if (l.get('name') == "stickyNoteResizeLayer") {
                            var s = l.getSource();
                            var f_3 = s.getFeatures();
                            f_3.forEach(function (fItem) {
                                if (fItem.values_.id == "resize_note0") {
                                    fItem.getGeometry().setCoordinates(coord_1[0][0]);
                                    fItem.set("maxcoordinates", coord_1[0][1]);
                                }
                                if (fItem.values_.id == "resize_note_rec5") {
                                    fItem.getGeometry().setCoordinates([[
                                            [coord_1[0][2][0] - MapsOpenLayers.POINT_X_DELTA * geoC, coord_1[0][2][1] - MapsOpenLayers.POINT_Y_DELTA * geoC],
                                            [coord_1[0][3][0] - MapsOpenLayers.POINT_X_DELTA * geoC, coord_1[0][3][1] + MapsOpenLayers.POINT_Y_DELTA * geoC],
                                            [coord_1[0][4][0] + MapsOpenLayers.POINT_X_DELTA * geoC, coord_1[0][4][1] + MapsOpenLayers.POINT_Y_DELTA * geoC],
                                            [coord_1[0][5][0] + MapsOpenLayers.POINT_X_DELTA * geoC, coord_1[0][5][1] - MapsOpenLayers.POINT_Y_DELTA * geoC]
                                        ]]);
                                }
                            });
                        }
                    });
                }
                else if (currentType == 'resize_note0') {
                    _this_1.mapElement.style.cursor = "nw-resize";
                    var feature = f.get("feature");
                    var maxcoordinates = f.get("maxcoordinates");
                    if (maxcoordinates && coordinates[1] > maxcoordinates[1]) {
                        f.getGeometry().setCoordinates([coordinates[0], maxcoordinates[1]]);
                        return;
                    }
                    var coord = feature.getGeometry().getCoordinates();
                    var deltaX = coordinates[0] - coord[0][0][0];
                    var deltaY = coordinates[1] - coord[0][0][1];
                    coord[0][0][0] = coord[0][0][0] + deltaX;
                    coord[0][0][1] = coord[0][0][1] + deltaY;
                    feature.getGeometry().setCoordinates(coord);
                }
                else {
                    _this_1.stickyNoteResizeSource.clear();
                }
            };
            //  private setLinkedMapAlarmLayer = (map: any) => {
            //      this.linkedAlarmSource = new ol.source.Vector({
            //          features: [],
            //          wrapX: false
            //      });
            //      //== Then creating layer from the Vector
            //      this.linkedAlarmLayer = new ol.layer.Vector({
            //          source: this.linkedAlarmSource
            //      });
            //      this.linkedAlarmLayer.set('name', "linkedMapAlarmLayer");
            //      this.linkedAlarmLayer.setZIndex(2);
            //      map.addLayer(this.linkedAlarmLayer);
            //  }
            this.setStickNoteLayerInteraction = function (map) {
                // configure layers for points
                _this_1.stickyNoteResizeSource = new ol.source.Vector({
                    features: [],
                    wrapX: false
                });
                //== Then creating layer from the Vector
                _this_1.stickyNoteResizelayer = new ol.layer.Vector({
                    source: _this_1.stickyNoteResizeSource
                });
                _this_1.stickyNoteResizelayer.set('name', "stickyNoteResizeLayer");
                _this_1.stickyNoteResizelayer.setZIndex(2);
                map.addLayer(_this_1.stickyNoteResizelayer);
                map.on("click", function (e) {
                    _this_1.stickyNoteResizeSource.clear();
                    var fCount = 0;
                    var f = null;
                    var note = null;
                    var geoC = _this_1.getMapTypeDelta();
                    _this_1.map.forEachFeatureAtPixel(e.pixel, function (feature, layer) {
                        f = feature;
                        fCount++;
                        if (f.values_.type == mapDefaults.mapFeatureTypes.stickyNote) {
                            note = feature;
                        }
                    });
                    if (note && fCount == 1) {
                        var coord = note.getGeometry().getCoordinates();
                        for (var i = 0; i < coord[0].length; i++) {
                            if (i == 5) {
                                var pointCoords = [coord[0][i][0] + MapsOpenLayers.POINT_X_DELTA * geoC, coord[0][i][1] - MapsOpenLayers.POINT_Y_DELTA * geoC];
                                var pointFeature = new ol.Feature({
                                    id: "resize_note" + i,
                                    geometry: new ol.geom.Point(pointCoords),
                                    name: "resize_note" + i,
                                    type: "resize_note" + i,
                                    resourceId: "point" + note.values_.resourceId
                                });
                                var recFeature = new ol.Feature({
                                    id: "resize_note_rec" + i,
                                    geometry: new ol.geom.Polygon([[
                                            [coord[0][2][0] - MapsOpenLayers.POINT_X_DELTA * geoC, coord[0][2][1] - MapsOpenLayers.POINT_Y_DELTA * geoC],
                                            [coord[0][3][0] - MapsOpenLayers.POINT_X_DELTA * geoC, coord[0][3][1] + MapsOpenLayers.POINT_Y_DELTA * geoC],
                                            [coord[0][4][0] + MapsOpenLayers.POINT_X_DELTA * geoC, coord[0][4][1] + MapsOpenLayers.POINT_Y_DELTA * geoC],
                                            [coord[0][5][0] + MapsOpenLayers.POINT_X_DELTA * geoC, coord[0][5][1] - MapsOpenLayers.POINT_Y_DELTA * geoC]
                                        ]]),
                                    name: "resize_note_rec" + i,
                                    type: "resize_note_rec" + i,
                                    resourceId: "point" + note.values_.resourceId
                                });
                                pointFeature.set("feature", note);
                                pointFeature.set("currentPointCount", i);
                                pointFeature.set("maxcoordinatesY", coord[0][4]);
                                pointFeature.set("maxcoordinatesX", coord[0][2]);
                                _this_1.stickyNoteResizeSource.addFeature(pointFeature);
                                _this_1.stickyNoteResizeSource.addFeature(recFeature);
                            }
                            else if (i == 0) {
                                var pointCoords = [coord[0][i][0], coord[0][i][1] - MapsOpenLayers.POINT_Y_DELTA * geoC];
                                var pointFeature = new ol.Feature({
                                    id: "resize_note" + i,
                                    geometry: new ol.geom.Point(pointCoords),
                                    name: "resize_note" + i,
                                    type: "resize_note" + i,
                                    resourceId: "point" + note.values_.resourceId
                                });
                                pointFeature.set("feature", note);
                                pointFeature.set("currentPointCount", i);
                                pointFeature.set("maxcoordinates", coord[0][1]);
                                _this_1.stickyNoteResizeSource.addFeature(pointFeature);
                            }
                        }
                    }
                });
            };
            this.getRecordingStatus = function (feature, nvrId) {
                //check flip values 
                var flip = feature.get("initFlipValue");
                var flop = feature.get("initFlopValue");
                //end
                var sourceId = feature.getId();
                // let addResource = this.globalDataAccessPoint.resources.byGuid[sourceId];
                var addResource = _this_1.mObjectPane.resourcesArray.filter(function (item) {
                    return item.id == sourceId;
                })[0];
                var check360Camera = (addResource && addResource.sourceProperties && addResource.sourceProperties.length > 0 && addResource.sourceProperties[0] === 'Camera360');
                //let resourceType = addResource.resourceType;
                var recordingIpPort = false;
                if (addResource.resourceType != 'DigitalInput' && addResource.resourceType != 'RelayOutput' && addResource.resourceType != 'Tour' && addResource.resourceType != 'View' && addResource.resourceType != 'LPRSensorResource' && addResource.resourceType != 'resourceType') {
                    //check for existing icon
                    if (addResource.changeIcon && addResource.changeIcon.length > 0) {
                        var style = feature.getStyle();
                        var activeStyle = _this_1.getResourceActiveIcon(feature);
                        style.setImage(new ol.style.Icon({
                            anchor: new CameraIcons(_this_1.mapResource.mapIconSize).anchorSize,
                            size: new CameraIcons(_this_1.mapResource.mapIconSize).getIconSize(_this_1.mapResource.mapIconSize),
                            opacity: 1,
                            scale: style.getImage().getScale(),
                            src: new CameraIcons(_this_1.mapResource.mapIconSize).getIconStyle(activeStyle, _this_1.mapResource.mapIconSize),
                            rotation: style.getImage().getRotation()
                        }));
                        feature.setStyle(style);
                        if (flip || flop)
                            _this_1.applyFlip(feature, flip, flop, true);
                    }
                    else {
                        var style = feature.getStyle();
                        var activeStyle = _this_1.getActiveIdelMixedCamera("Yes", addResource, check360Camera);
                        ;
                        style.setImage(new ol.style.Icon({
                            anchor: new CameraIcons(_this_1.mapResource.mapIconSize).anchorSize,
                            size: new CameraIcons(_this_1.mapResource.mapIconSize).getIconSize(_this_1.mapResource.mapIconSize),
                            opacity: 1,
                            scale: style.getImage().getScale(),
                            src: new CameraIcons(_this_1.mapResource.mapIconSize).getIconStyle(activeStyle, _this_1.mapResource.mapIconSize),
                            rotation: style.getImage().getRotation()
                        }));
                        feature.setStyle(style);
                        if (flip || flop)
                            _this_1.applyFlip(feature, flip, flop, true);
                    }
                    //
                    //handling for disconnected cameras
                    //  if (this.fromMonitoring) {
                    //      var disConnectedDevices = this.activeResources.filter((item:any) => {
                    //          return ((item.id == addResource.id) && (item.actualObject.isDisconnected == true));
                    //      });
                    //      if (disConnectedDevices.length != 0) {
                    //          let style = feature.getStyle();
                    //          let resourceStyle: any = this.getActiveIdelMixedCamera("No", addResource, check360Camera);
                    //          style.setImage(new ol.style.Icon({
                    //              anchor: new CameraIcons(this.mapResource.mapIconSize).anchorSize,
                    //              size: new CameraIcons(this.mapResource.mapIconSize).getIconSize(this.mapResource.mapIconSize),
                    //              opacity: 1,
                    //              scale: style.getImage().getScale(),
                    //              src: resourceStyle,
                    //              rotation: style.getImage().getRotation()
                    //          }))
                    //          feature.setStyle(style);
                    //          if (flip || flop)
                    //              this.applyFlip(feature, flip, flop, true);
                    //      }
                    //  }
                    ////handling for audio channel
                    //if (this.fromMonitoring) {
                    //    var audioChannelDevices = this.activeResources.filter((item) => {
                    //        if (item.type == "AudioSource") {
                    //            return (item.id == addResource.id) && (item.actualObject.isRecording == false);
                    //        }
                    //    });
                    //    console.log("audio soruce ::: -> ");
                    //    if (audioChannelDevices.length != 0) {
                    //        let style = feature.getStyle();
                    //        let resourceStyle: any = this.getActiveIdelMixedCamera("No", addResource, check360Camera);
                    //        style.setImage(new ol.style.Icon({
                    //            anchor: new CameraIcons(this.mapResource.mapIconSize).anchorSize,
                    //            size: new CameraIcons(this.mapResource.mapIconSize).getIconSize(this.mapResource.mapIconSize),
                    //            opacity: 1,
                    //            scale: style.getImage().getScale(),
                    //            src: resourceStyle,
                    //            rotation: style.getImage().getRotation()
                    //        }))
                    //        feature.setStyle(style);
                    //    }
                    //    else {
                    //        let style = feature.getStyle();
                    //        let resourceStyle: any = this.getActiveIdelMixedCamera("Yes", addResource, check360Camera);
                    //        style.setImage(new ol.style.Icon({
                    //            anchor: new CameraIcons(this.mapResource.mapIconSize).anchorSize,
                    //            size: new CameraIcons(this.mapResource.mapIconSize).getIconSize(this.mapResource.mapIconSize),
                    //            opacity: 1,
                    //            scale: style.getImage().getScale(),
                    //            src: resourceStyle,
                    //            rotation: style.getImage().getRotation()
                    //        }))
                    //        feature.setStyle(style);
                    //    }
                    //}
                    //  var getActive = this.activeResources.filter((item:any) => {
                    //      return (item.id == addResource.id)
                    //  })
                    //  //Green dot issue fix 1 : Show off if removed 
                    //  if (!getActive || getActive.length == 0) {
                    //      let style = feature.getStyle();
                    //      let resourceStyle: any = this.getActiveIdelMixedCamera("No", addResource, check360Camera);
                    //      style.setImage(new ol.style.Icon({
                    //          anchor: new CameraIcons(this.mapResource.mapIconSize).anchorSize,
                    //          size: new CameraIcons(this.mapResource.mapIconSize).getIconSize(this.mapResource.mapIconSize),
                    //          opacity: 1,
                    //          scale: style.getImage().getScale(),
                    //          src: resourceStyle,//this.getIdleResourceStyle(addResource),
                    //          rotation: style.getImage().getRotation()
                    //      }))
                    //      feature.setStyle(style);
                    //      if (flip || flop)
                    //          this.applyFlip(feature, flip, flop, true);
                    //  }
                    //  else {
                    //      //this.storageService.getRecordingStorage(nvrId).then((data) => {
                    //      this.prePolledData["recordingStorage"].forEach((data:any) => {
                    //          if (data.Volumes) {
                    //              data = this.modifyRecordingStorageObj(data);
                    //              data = this.storageService.setRecordingStorageObject(data, nvrId);
                    //              if (data.volumes && data.volumes.recording.length > 0) {
                    //                  let activeStorage = data.volumes.recording.filter((item:any) => {
                    //                      return (item.enabled == true)
                    //                  });
                    //                  if (!activeStorage || activeStorage.length == 0) {
                    //                      let style = feature.getStyle();
                    //                      let resourceStyle: any = this.getActiveIdelMixedCamera("No", addResource, check360Camera);
                    //                      style.setImage(new ol.style.Icon({
                    //                          anchor: new CameraIcons(this.mapResource.mapIconSize).anchorSize,
                    //                          size: new CameraIcons(this.mapResource.mapIconSize).getIconSize(this.mapResource.mapIconSize),
                    //                          opacity: 1,
                    //                          scale: style.getImage().getScale(),
                    //                          src: resourceStyle,//this.getIdleResourceStyle(addResource),
                    //                          rotation: style.getImage().getRotation()
                    //                      }))
                    //                      feature.setStyle(style);
                    //                      if (flip || flop)
                    //                          this.applyFlip(feature, flip, flop, true);
                    //                  }
                    //                  else {
                    //                      //this.recordingService.getRecordingSchedule(sourceId, true).then((response) => {
                    //                      this.prePolledData["recordingSettings"].forEach((response:any) => {
                    //                          if (response.SourceId == sourceId) {
                    //                              response = this.recordingService.setRecordingScheduleObject(response);
                    //                              try {
                    //                                  if (!response.recordingEnabled) {
                    //                                      let style = feature.getStyle();
                    //                                      let resourceStyle: any = this.getActiveIdelMixedCamera("No", addResource, check360Camera);
                    //                                      style.setImage(new ol.style.Icon({
                    //                                          anchor: new CameraIcons(this.mapResource.mapIconSize).anchorSize,
                    //                                          size: new CameraIcons(this.mapResource.mapIconSize).getIconSize(this.mapResource.mapIconSize),
                    //                                          opacity: 1,
                    //                                          scale: style.getImage().getScale(),
                    //                                          src: resourceStyle,
                    //                                          rotation: style.getImage().getRotation()
                    //                                      }))
                    //                                      feature.setStyle(style);
                    //                                      if (flip || flop)
                    //                                          this.applyFlip(feature, flip, flop, true);
                    //                                  }
                    //                                  else if (addResource.isDisconnected) {
                    //                                      let style = feature.getStyle();
                    //                                      let resourceStyle: any = this.getActiveIdelMixedCamera("No", addResource, check360Camera);
                    //                                      style.setImage(new ol.style.Icon({
                    //                                          anchor: new CameraIcons(this.mapResource.mapIconSize).anchorSize,
                    //                                          size: new CameraIcons(this.mapResource.mapIconSize).getIconSize(this.mapResource.mapIconSize),
                    //                                          opacity: 1,
                    //                                          scale: style.getImage().getScale(),
                    //                                          src: resourceStyle,
                    //                                          rotation: style.getImage().getRotation()
                    //                                      }))
                    //                                      feature.setStyle(style);
                    //                                      if (flip || flop)
                    //                                          this.applyFlip(feature, flip, flop, true);
                    //                                  }
                    //                              }
                    //                              catch (e) { }
                    //                          } else {
                    //                              //let style = feature.getStyle();
                    //                              //let resourceStyle: any = this.getActiveIdelMixedCamera("No", addResource, check360Camera);
                    //                              //style.setImage(new ol.style.Icon({
                    //                              //    anchor: new CameraIcons(this.mapResource.mapIconSize).anchorSize,
                    //                              //    size: new CameraIcons(this.mapResource.mapIconSize).getIconSize(this.mapResource.mapIconSize),
                    //                              //    opacity: 1,
                    //                              //    scale: style.getImage().getScale(),
                    //                              //    src: resourceStyle,//this.getIdleResourceStyle(addResource),
                    //                              //    rotation: style.getImage().getRotation()
                    //                              //}))
                    //                              //feature.setStyle(style);
                    //                          }
                    //                      })
                    //                  }
                    //              }
                    //              else {
                    //                  let style = feature.getStyle();
                    //                  let resourceStyle: any = this.getActiveIdelMixedCamera("No", addResource, check360Camera);
                    //                  style.setImage(new ol.style.Icon({
                    //                      anchor: new CameraIcons(this.mapResource.mapIconSize).anchorSize,
                    //                      size: new CameraIcons(this.mapResource.mapIconSize).getIconSize(this.mapResource.mapIconSize),
                    //                      opacity: 1,
                    //                      scale: style.getImage().getScale(),
                    //                      src: resourceStyle,
                    //                      rotation: style.getImage().getRotation()
                    //                  }))
                    //                  feature.setStyle(style);
                    //                  if (flip || flop)
                    //                      this.applyFlip(feature, flip, flop, true);
                    //              }
                    //          } else {
                    //              let style = feature.getStyle();
                    //              let resourceStyle: any = this.getActiveIdelMixedCamera("No", addResource, check360Camera);
                    //              style.setImage(new ol.style.Icon({
                    //                  anchor: new CameraIcons(this.mapResource.mapIconSize).anchorSize,
                    //                  size: new CameraIcons(this.mapResource.mapIconSize).getIconSize(this.mapResource.mapIconSize),
                    //                  opacity: 1,
                    //                  scale: style.getImage().getScale(),
                    //                  src: resourceStyle,
                    //                  rotation: style.getImage().getRotation()
                    //              }))
                    //              feature.setStyle(style);
                    //              if (flip || flop)
                    //                  this.applyFlip(feature, flip, flop, true);
                    //          }
                    //      })
                    //  }
                }
                else if (addResource.resourceType == 'DigitalInput') {
                    if (addResource.changeIcon && addResource.changeIcon.length > 0) {
                        var style = feature.getStyle();
                        var idelStyle = _this_1.getResourceIdelIcon(feature);
                        style.setImage(new ol.style.Icon({
                            anchor: new CameraIcons(_this_1.mapResource.mapIconSize).anchorSize,
                            size: new CameraIcons(_this_1.mapResource.mapIconSize).getIconSize(_this_1.mapResource.mapIconSize),
                            opacity: 1,
                            scale: style.getImage().getScale(),
                            src: new CameraIcons(_this_1.mapResource.mapIconSize).getIconStyle(idelStyle, _this_1.mapResource.mapIconSize),
                            rotation: style.getImage().getRotation()
                        }));
                        feature.setStyle(style);
                        if (flip || flop)
                            _this_1.applyFlip(feature, flip, flop, true);
                    }
                    if (!addResource.isActivated) {
                        var style = feature.getStyle();
                        var idelStyle = _this_1.getResourceIdelIcon(feature);
                        style.setImage(new ol.style.Icon({
                            anchor: new CameraIcons(_this_1.mapResource.mapIconSize).anchorSize,
                            size: new CameraIcons(_this_1.mapResource.mapIconSize).getIconSize(_this_1.mapResource.mapIconSize),
                            opacity: 1,
                            scale: style.getImage().getScale(),
                            src: new CameraIcons(_this_1.mapResource.mapIconSize).getIconStyle(idelStyle, _this_1.mapResource.mapIconSize),
                            rotation: style.getImage().getRotation()
                        }));
                        feature.setStyle(style);
                        if (flip || flop)
                            _this_1.applyFlip(feature, flip, flop, true);
                    }
                    if (addResource.isActivated && addResource.isActivated != false && addResource.isActivated != undefined) {
                        var style = feature.getStyle();
                        var activeStyle = _this_1.getResourceActiveIcon(feature);
                        style.setImage(new ol.style.Icon({
                            anchor: new CameraIcons(_this_1.mapResource.mapIconSize).anchorSize,
                            size: new CameraIcons(_this_1.mapResource.mapIconSize).getIconSize(_this_1.mapResource.mapIconSize),
                            opacity: 1,
                            scale: style.getImage().getScale(),
                            src: new CameraIcons(_this_1.mapResource.mapIconSize).getIconStyle(activeStyle, _this_1.mapResource.mapIconSize),
                            rotation: style.getImage().getRotation()
                        }));
                        feature.setStyle(style);
                        if (flip || flop)
                            _this_1.applyFlip(feature, flip, flop, true);
                    }
                }
                else if (addResource.resourceType == 'RelayOutput') {
                    if (addResource.changeIcon && addResource.changeIcon.length > 0) {
                        var style = feature.getStyle();
                        var idelStyle = _this_1.getResourceIdelIcon(feature);
                        style.setImage(new ol.style.Icon({
                            anchor: new CameraIcons(_this_1.mapResource.mapIconSize).anchorSize,
                            size: new CameraIcons(_this_1.mapResource.mapIconSize).getIconSize(_this_1.mapResource.mapIconSize),
                            opacity: 1,
                            scale: style.getImage().getScale(),
                            src: new CameraIcons(_this_1.mapResource.mapIconSize).getIconStyle(idelStyle, _this_1.mapResource.mapIconSize),
                            rotation: style.getImage().getRotation()
                        }));
                        feature.setStyle(style);
                        if (flip || flop)
                            _this_1.applyFlip(feature, flip, flop, true);
                    }
                    if (!addResource.isActivated) {
                        var style = feature.getStyle();
                        var idelStyle = _this_1.getResourceIdelIcon(feature);
                        style.setImage(new ol.style.Icon({
                            anchor: new CameraIcons(_this_1.mapResource.mapIconSize).anchorSize,
                            size: new CameraIcons(_this_1.mapResource.mapIconSize).getIconSize(_this_1.mapResource.mapIconSize),
                            opacity: 1,
                            scale: style.getImage().getScale(),
                            src: new CameraIcons(_this_1.mapResource.mapIconSize).getIconStyle(idelStyle, _this_1.mapResource.mapIconSize),
                            rotation: style.getImage().getRotation()
                        }));
                        feature.setStyle(style);
                        if (flip || flop)
                            _this_1.applyFlip(feature, flip, flop, true);
                    }
                    if (addResource.isActivated && addResource.isActivated != false && addResource.isActivated != undefined) {
                        var style = feature.getStyle();
                        var activeStyle = _this_1.getResourceActiveIcon(feature);
                        style.setImage(new ol.style.Icon({
                            anchor: new CameraIcons(_this_1.mapResource.mapIconSize).anchorSize,
                            size: new CameraIcons(_this_1.mapResource.mapIconSize).getIconSize(_this_1.mapResource.mapIconSize),
                            opacity: 1,
                            scale: style.getImage().getScale(),
                            src: new CameraIcons(_this_1.mapResource.mapIconSize).getIconStyle(activeStyle, _this_1.mapResource.mapIconSize),
                            rotation: style.getImage().getRotation()
                        }));
                        feature.setStyle(style);
                        if (flip || flop)
                            _this_1.applyFlip(feature, flip, flop, true);
                    }
                }
                else if (addResource.resourceType == 'Tour') {
                    if (addResource.changeIcon && addResource.changeIcon.length > 0) {
                        var style = feature.getStyle();
                        var idelStyle = _this_1.getActiveResourceStyle(addResource);
                        style.setImage(new ol.style.Icon({
                            anchor: new CameraIcons(_this_1.mapResource.mapIconSize).anchorSize,
                            size: new CameraIcons(_this_1.mapResource.mapIconSize).getIconSize(_this_1.mapResource.mapIconSize),
                            opacity: 1,
                            scale: style.getImage().getScale(),
                            src: new CameraIcons(_this_1.mapResource.mapIconSize).getIconStyle(idelStyle, _this_1.mapResource.mapIconSize),
                            rotation: style.getImage().getRotation()
                        }));
                        feature.setStyle(style);
                        if (flip || flop)
                            _this_1.applyFlip(feature, flip, flop, true);
                    }
                    if (!addResource.isActivated) {
                        var style = feature.getStyle();
                        var idelStyle = _this_1.getResourceIdelIcon(feature);
                        style.setImage(new ol.style.Icon({
                            anchor: new CameraIcons(_this_1.mapResource.mapIconSize).anchorSize,
                            size: new CameraIcons(_this_1.mapResource.mapIconSize).getIconSize(_this_1.mapResource.mapIconSize),
                            opacity: 1,
                            scale: style.getImage().getScale(),
                            src: new CameraIcons(_this_1.mapResource.mapIconSize).getIconStyle(idelStyle, _this_1.mapResource.mapIconSize),
                            rotation: style.getImage().getRotation()
                        }));
                        feature.setStyle(style);
                        if (flip || flop)
                            _this_1.applyFlip(feature, flip, flop, true);
                    }
                    if (addResource.isActivated && addResource.isActivated != false && addResource.isActivated != undefined) {
                        var style = feature.getStyle();
                        var activeStyle = _this_1.getResourceActiveIcon(addResource);
                        style.setImage(new ol.style.Icon({
                            anchor: new CameraIcons(_this_1.mapResource.mapIconSize).anchorSize,
                            size: new CameraIcons(_this_1.mapResource.mapIconSize).getIconSize(_this_1.mapResource.mapIconSize),
                            opacity: 1,
                            scale: style.getImage().getScale(),
                            src: new CameraIcons(_this_1.mapResource.mapIconSize).getIconStyle(activeStyle, _this_1.mapResource.mapIconSize),
                            rotation: style.getImage().getRotation()
                        }));
                        feature.setStyle(style);
                        if (flip || flop)
                            _this_1.applyFlip(feature, flip, flop, true);
                    }
                }
                else if (addResource.resourceType == 'View') {
                    if (addResource.changeIcon && addResource.changeIcon.length > 0) {
                        var style = feature.getStyle();
                        var idelStyle = _this_1.getActiveResourceStyle(addResource);
                        style.setImage(new ol.style.Icon({
                            anchor: new CameraIcons(_this_1.mapResource.mapIconSize).anchorSize,
                            size: new CameraIcons(_this_1.mapResource.mapIconSize).getIconSize(_this_1.mapResource.mapIconSize),
                            opacity: 1,
                            scale: style.getImage().getScale(),
                            src: new CameraIcons(_this_1.mapResource.mapIconSize).getIconStyle(idelStyle, _this_1.mapResource.mapIconSize),
                            rotation: style.getImage().getRotation()
                        }));
                        feature.setStyle(style);
                        if (flip || flop)
                            _this_1.applyFlip(feature, flip, flop, true);
                    }
                    if (addResource.isActivated && addResource.isActivated != false && addResource.isActivated != undefined) {
                        var style = feature.getStyle();
                        var activeStyle = _this_1.getResourceActiveIcon(addResource);
                        style.setImage(new ol.style.Icon({
                            anchor: new CameraIcons(_this_1.mapResource.mapIconSize).anchorSize,
                            size: new CameraIcons(_this_1.mapResource.mapIconSize).getIconSize(_this_1.mapResource.mapIconSize),
                            opacity: 1,
                            scale: style.getImage().getScale(),
                            src: new CameraIcons(_this_1.mapResource.mapIconSize).getIconStyle(activeStyle, _this_1.mapResource.mapIconSize),
                            rotation: style.getImage().getRotation()
                        }));
                        feature.setStyle(style);
                        if (flip || flop)
                            _this_1.applyFlip(feature, flip, flop, true);
                    }
                }
            };
            this.restoreIconsAfterAlarm = function (feature, nvrId) {
                var sourceId = feature.getId();
                //let addResource = this.globalDataAccessPoint.resources.byGuid[sourceId];
                var addResource = _this_1.mObjectPane.resourcesArray.filter(function (item) {
                    return item.id == sourceId;
                })[0];
                var featureInfo = feature;
                var check360Camera = false; //this.is360CameraItem(addResource); //TODO
                if (addResource.resourceType != 'DigitalInput' && addResource.resourceType != 'RelayOutput' && addResource.resourceType != 'VAXDoorResource' && addResource.resourceType != 'LPRSensorResource') {
                    //          //this.storageService.getRecordingStorage(nvrId).then((data) => {
                    _this_1.prePolledData["recordingStorage"].forEach(function (data) {
                        try {
                            if (data.Volumes) {
                                data = _this_1.modifyRecordingStorageObj(data);
                                data = _this_1.storageService.setRecordingStorageObject(data, nvrId);
                                if (data.volumes.fixed[0].serverId == nvrId) {
                                    if (data.volumes && data.volumes.fixed.length > 0) {
                                        var activeStorage = data.volumes.fixed.filter(function (item) {
                                            return (item.enabled == true);
                                        });
                                        if (!activeStorage || activeStorage.length == 0) {
                                            var style = featureInfo.getStyle();
                                            var resourceStyle = _this_1.getActiveIdelMixedCamera("No", addResource, check360Camera);
                                            style.setImage(new ol.style.Icon({
                                                anchor: [0.5, 0.48],
                                                size: new CameraIcons(_this_1.mapResource.mapIconSize).getIconSize(_this_1.mapResource.mapIconSize),
                                                opacity: 1,
                                                scale: new CameraIcons(_this_1.mapResource.mapIconSize).getIconScale(_this_1.mapResource.mapIconSize),
                                                src: new CameraIcons(_this_1.mapResource.mapIconSize).getIconStyle(resourceStyle, _this_1.mapResource.mapIconSize),
                                                rotation: style.getImage().getRotation()
                                            }));
                                            featureInfo.setStyle(style);
                                        }
                                        else {
                                            //this.recordingService.getRecordingSchedule(sourceId, true).then((response) => {
                                            _this_1.prePolledData["recordingSettings"].forEach(function (response) {
                                                if (response.SourceId == sourceId) {
                                                    response = _this_1.recordingService.setRecordingScheduleObject(response);
                                                    try {
                                                        if (!response.recordingEnabled) {
                                                            var style = featureInfo.getStyle();
                                                            var resourceStyle = _this_1.getActiveIdelMixedCamera("No", addResource, check360Camera);
                                                            style.setImage(new ol.style.Icon({
                                                                anchor: [0.5, 0.48],
                                                                size: new CameraIcons(_this_1.mapResource.mapIconSize).getIconSize(_this_1.mapResource.mapIconSize),
                                                                opacity: 1,
                                                                scale: new CameraIcons(_this_1.mapResource.mapIconSize).getIconScale(_this_1.mapResource.mapIconSize),
                                                                src: new CameraIcons(_this_1.mapResource.mapIconSize).getIconStyle(resourceStyle, _this_1.mapResource.mapIconSize),
                                                                rotation: style.getImage().getRotation()
                                                            }));
                                                            featureInfo.setStyle(style);
                                                        }
                                                        else {
                                                            var style = featureInfo.getStyle();
                                                            var resourceStyle = _this_1.getActiveIdelMixedCamera("Yes", addResource, check360Camera);
                                                            style.setImage(new ol.style.Icon({
                                                                anchor: [0.5, 0.48],
                                                                size: new CameraIcons(_this_1.mapResource.mapIconSize).getIconSize(_this_1.mapResource.mapIconSize),
                                                                opacity: 1,
                                                                scale: new CameraIcons(_this_1.mapResource.mapIconSize).getIconScale(_this_1.mapResource.mapIconSize),
                                                                src: new CameraIcons(_this_1.mapResource.mapIconSize).getIconStyle(resourceStyle, _this_1.mapResource.mapIconSize),
                                                                rotation: style.getImage().getRotation()
                                                            }));
                                                            featureInfo.setStyle(style);
                                                        }
                                                    }
                                                    catch (e) {
                                                        console.log("in catche");
                                                    }
                                                }
                                                else {
                                                    var style_2 = featureInfo.getStyle();
                                                    var resourceStyle_1 = _this_1.getActiveIdelMixedCamera("Yes", addResource, check360Camera);
                                                    setTimeout(function () {
                                                        style_2.setImage(new ol.style.Icon({
                                                            anchor: [0.5, 0.48],
                                                            size: new CameraIcons(_this_1.mapResource.mapIconSize).getIconSize(_this_1.mapResource.mapIconSize),
                                                            opacity: 1,
                                                            scale: new CameraIcons(_this_1.mapResource.mapIconSize).getIconScale(_this_1.mapResource.mapIconSize),
                                                            src: new CameraIcons(_this_1.mapResource.mapIconSize).getIconStyle(resourceStyle_1, _this_1.mapResource.mapIconSize),
                                                            rotation: style_2.getImage().getRotation()
                                                        }));
                                                        featureInfo.setStyle(style_2);
                                                    }, 5000);
                                                }
                                            });
                                        }
                                    }
                                    else {
                                        var style = featureInfo.getStyle();
                                        var resourceStyle = _this_1.getActiveIdelMixedCamera("No", addResource, check360Camera);
                                        style.setImage(new ol.style.Icon({
                                            anchor: [0.5, 0.48],
                                            size: new CameraIcons(_this_1.mapResource.mapIconSize).getIconSize(_this_1.mapResource.mapIconSize),
                                            opacity: 1,
                                            scale: new CameraIcons(_this_1.mapResource.mapIconSize).getIconScale(_this_1.mapResource.mapIconSize),
                                            src: new CameraIcons(_this_1.mapResource.mapIconSize).getIconStyle(resourceStyle, _this_1.mapResource.mapIconSize),
                                            rotation: style.getImage().getRotation()
                                        }));
                                        featureInfo.setStyle(style);
                                    }
                                }
                                else {
                                    var style = featureInfo.getStyle();
                                    var resourceStyle = _this_1.getActiveIdelMixedCamera("No", addResource, check360Camera);
                                    style.setImage(new ol.style.Icon({
                                        anchor: [0.5, 0.48],
                                        size: new CameraIcons(_this_1.mapResource.mapIconSize).getIconSize(_this_1.mapResource.mapIconSize),
                                        opacity: 1,
                                        scale: new CameraIcons(_this_1.mapResource.mapIconSize).getIconScale(_this_1.mapResource.mapIconSize),
                                        src: new CameraIcons(_this_1.mapResource.mapIconSize).getIconStyle(resourceStyle, _this_1.mapResource.mapIconSize),
                                        rotation: style.getImage().getRotation()
                                    }));
                                    featureInfo.setStyle(style);
                                }
                            }
                        }
                        catch (e) {
                            console.log("Error maps: recordingStorage ", e);
                        }
                    });
                }
                else if (addResource.resourceType == 'DigitalInput') {
                    if (addResource.state != "Off") {
                        var style = featureInfo.getStyle();
                        var activeStyle = _this_1.getResourceActiveIcon(featureInfo);
                        style.setImage(new ol.style.Icon({
                            anchor: [0.5, 0.48],
                            size: new CameraIcons(_this_1.mapResource.mapIconSize).getIconSize(_this_1.mapResource.mapIconSize),
                            opacity: 1,
                            scale: style.getImage().getScale(),
                            src: new CameraIcons(_this_1.mapResource.mapIconSize).getIconStyle(activeStyle, _this_1.mapResource.mapIconSize),
                            rotation: style.getImage().getRotation()
                        }));
                        featureInfo.setStyle(style);
                    }
                    else {
                        var style = featureInfo.getStyle();
                        var idelStyle = _this_1.getResourceIdelIcon(featureInfo);
                        style.setImage(new ol.style.Icon({
                            anchor: [0.5, 0.48],
                            size: new CameraIcons(_this_1.mapResource.mapIconSize).getIconSize(_this_1.mapResource.mapIconSize),
                            opacity: 1,
                            scale: style.getImage().getScale(),
                            src: new CameraIcons(_this_1.mapResource.mapIconSize).getIconStyle(idelStyle, _this_1.mapResource.mapIconSize),
                            rotation: style.getImage().getRotation()
                        }));
                        featureInfo.setStyle(style);
                    }
                }
                else if (addResource.resourceType == 'RelayOutput') {
                    if (addResource.isActivated != false) {
                        var style = featureInfo.getStyle();
                        var activeStyle = _this_1.getResourceActiveIcon(featureInfo);
                        style.setImage(new ol.style.Icon({
                            anchor: [0.5, 0.48],
                            size: new CameraIcons(_this_1.mapResource.mapIconSize).getIconSize(_this_1.mapResource.mapIconSize),
                            opacity: 1,
                            scale: style.getImage().getScale(),
                            src: new CameraIcons(_this_1.mapResource.mapIconSize).getIconStyle(activeStyle, _this_1.mapResource.mapIconSize),
                            rotation: style.getImage().getRotation()
                        }));
                        featureInfo.setStyle(style);
                    }
                    else {
                        var style = featureInfo.getStyle();
                        var idelStyle = _this_1.getResourceIdelIcon(featureInfo);
                        style.setImage(new ol.style.Icon({
                            anchor: [0.5, 0.48],
                            size: new CameraIcons(_this_1.mapResource.mapIconSize).getIconSize(_this_1.mapResource.mapIconSize),
                            opacity: 1,
                            scale: style.getImage().getScale(),
                            src: new CameraIcons(_this_1.mapResource.mapIconSize).getIconStyle(idelStyle, _this_1.mapResource.mapIconSize),
                            rotation: style.getImage().getRotation()
                        }));
                        featureInfo.setStyle(style);
                    }
                }
                else if (addResource.resourceType == "VAXDoorResource" || addResource.resourceType == "LPRSensorResource") {
                    _this_1.partnerEventGapTime = { resource: addResource.resourceType, time: new Date().getSeconds() };
                    var style_3 = featureInfo.getStyle();
                    var idelStyle_1 = _this_1.getResourceActiveIcon(featureInfo);
                    setTimeout(function () {
                        var totalDelay = new Date().getSeconds() - _this_1.partnerEventGapTime.time;
                        if (totalDelay > 0 && totalDelay < 10) {
                            style_3.setImage(new ol.style.Icon({
                                anchor: [0.5, 0.48],
                                size: new CameraIcons(_this_1.mapResource.mapIconSize).getIconSize(_this_1.mapResource.mapIconSize),
                                opacity: 1,
                                scale: style_3.getImage().getScale(),
                                src: new CameraIcons(_this_1.mapResource.mapIconSize).getIconStyle(idelStyle_1, _this_1.mapResource.mapIconSize),
                                rotation: style_3.getImage().getRotation()
                            }));
                            setTimeout(function () { featureInfo.setStyle(style_3); }, _this_1.partnerAlarmDelay);
                        }
                        else {
                            style_3.setImage(new ol.style.Icon({
                                anchor: [0.5, 0.48],
                                size: new CameraIcons(_this_1.mapResource.mapIconSize).getIconSize(_this_1.mapResource.mapIconSize),
                                opacity: 1,
                                scale: style_3.getImage().getScale(),
                                src: new CameraIcons(_this_1.mapResource.mapIconSize).getIconStyle(idelStyle_1, _this_1.mapResource.mapIconSize),
                                rotation: style_3.getImage().getRotation()
                            }));
                            featureInfo.setStyle(style_3);
                        }
                    }, 10000 /*this.partnerAlarmDelay*/);
                }
            };
            this.calculateRelativeCoordinates = function (coordinates, isReverse) {
                if (isReverse === void 0) { isReverse = false; }
                var actualE = _this_1.map.get("actualExtent");
                var modifiedE = _this_1.map.get("modifiedExtent");
                var actualExent = actualE ? actualE : _this_1.actualExtent;
                var modifiedExtent = modifiedE ? modifiedE : _this_1.modifiedExtend;
                if (!actualExent || !modifiedExtent)
                    return coordinates;
                if (!isReverse) {
                    if (coordinates.length == 1) {
                        coordinates[0].forEach(function (c) {
                            var xPer = (c[0] / actualExent[2]) * 100;
                            var yPer = (c[1] / actualExent[3]) * 100;
                            var relX = (xPer / 100) * modifiedExtent[2];
                            var relY = (yPer / 100) * modifiedExtent[3];
                            c[0] = relX;
                            c[1] = relY;
                        });
                    }
                    else {
                        var xPer = (coordinates[0] / actualExent[2]) * 100;
                        var yPer = (coordinates[1] / actualExent[3]) * 100;
                        var relX = (xPer / 100) * modifiedExtent[2];
                        var relY = (yPer / 100) * modifiedExtent[3];
                        coordinates[0] = relX;
                        coordinates[1] = relY;
                    }
                }
                else {
                    if (coordinates.length == 1) {
                        coordinates[0].forEach(function (c) {
                            var xPer = (c[0] / modifiedExtent[2]) * 100;
                            var yPer = (c[1] / modifiedExtent[3]) * 100;
                            var relX = (xPer / 100) * actualExent[2];
                            var relY = (yPer / 100) * actualExent[3];
                            c[0] = relX;
                            c[1] = relY;
                        });
                    }
                    else {
                        var xPer = (coordinates[0] / modifiedExtent[2]) * 100;
                        var yPer = (coordinates[1] / modifiedExtent[3]) * 100;
                        var relX = (xPer / 100) * actualExent[2];
                        var relY = (yPer / 100) * actualExent[3];
                        coordinates[0] = relX;
                        coordinates[1] = relY;
                    }
                }
                return coordinates;
            };
            this.navigateToPrevieousMap = function (e) {
                var pane = _this_1.map.get("map_pane");
                var historyItem = _this_1.mapResource.mapParentId;
                if (historyItem && historyItem != '') {
                    localStorage.setItem("dblClickOnMap", "0");
                    localStorage.setItem("isLinkedMap", "true");
                    localStorage.removeItem("fromSwap");
                    //localStorage.removeItem('OldMapId');
                    //localStorage.removeItem('BackButton');
                    //set back button 
                    //if (!this.globalDataAccessPoint.olMapDataLink[pane._id] || this.globalDataAccessPoint.olMapDataLink[pane._id].length == 0) {
                    if (e && e.target && e.target.parentNode)
                        e.target.parentNode.style.setProperty("display", "none");
                    //}
                    var obj = new ThickClientCommunication();
                    obj.callBackToThickClientFunction('mapBackCommand', historyItem);
                    localStorage.setItem("linkedMapAction", "true");
                    //this.eventDispatcher.fireEvent('draw_map_on_new_pane', { id: historyItem.map }, pane);
                }
            };
            //  //Change Icon
            this.changeIconStyle = function (id) {
                //check for event type
                //this.setResourcePath(addResource, data);
                var source;
                var feature;
                var addResource;
                _this_1.map.getLayers().forEach(function (layer) {
                    if (layer instanceof ol.layer.Vector) {
                        source = layer.getSource();
                        feature = source.getFeatures();
                        feature.forEach(function (featureItem) {
                            // addResource = this.globalDataAccessPoint.resources.byGuid[id];
                            addResource = _this_1.mObjectPane.resourcesArray.filter(function (item) {
                                return item.id == id;
                            })[0];
                            //if (featureItem.values_.id == addResource.id) {
                            if (featureItem.values_.id == addResource.id && featureItem.values_.type == 'iconFeature') {
                                setTimeout(function () {
                                    _this_1.getRecordingStatus(featureItem, addResource.nvrId);
                                });
                            }
                        });
                    }
                });
            };
            this.translateSqure = function (feature, coordinates, coord) {
                var deltaX = (coordinates[0] - MapsOpenLayers.POINT_X_DELTA) - coord[0][3][0];
                var deltaY = (coordinates[1] + MapsOpenLayers.POINT_Y_DELTA) - coord[0][3][1];
                coord[0][0][1] = coord[0][0][1] + deltaY;
                coord[0][2][0] = coord[0][2][0] + deltaX;
                coord[0][3][0] = coord[0][3][0] + deltaX;
                coord[0][3][1] = coord[0][3][1] + deltaY;
                coord[0][4][1] = coord[0][4][1] + deltaY;
                feature.getGeometry().setCoordinates(coord);
                _this_1.map.getLayers().forEach(function (l) {
                    if (l.get('name') == "linkedMapResizeLayer") {
                        _this_1.mapElement.style.cursor = "nw-resize";
                        var s = l.getSource();
                        var f = s.getFeatures();
                        f.forEach(function (fItem) {
                            if (fItem.values_.id == "resize_linkedMap_rec") {
                                var deltaObj = _this_1.getMaxDxDyAndCenter(feature, coord);
                                fItem.getGeometry().setCoordinates([[
                                        [deltaObj.center[0] - deltaObj.dx, deltaObj.center[1] - deltaObj.dy],
                                        [deltaObj.center[0] - deltaObj.dx, deltaObj.center[1] + deltaObj.dy],
                                        [deltaObj.center[0] + deltaObj.dx, deltaObj.center[1] + deltaObj.dy],
                                        [deltaObj.center[0] + deltaObj.dx, deltaObj.center[1] - deltaObj.dy],
                                        [deltaObj.center[0] - deltaObj.dx, deltaObj.center[1] - deltaObj.dy]
                                    ]]);
                            }
                        });
                    }
                });
            };
            this.translateTriangle = function (feature, coordinates, coord) {
                var deltaX = (coordinates[0] - MapsOpenLayers.POINT_X_DELTA) - coord[0][2][0];
                var deltaY = (coordinates[1] + MapsOpenLayers.POINT_Y_DELTA) - coord[0][2][1];
                coord[0][0][0] = coord[0][0][0] - deltaX;
                coord[0][0][1] = coord[0][0][1] + deltaY;
                coord[0][2][0] = coord[0][2][0] + deltaX;
                coord[0][2][1] = coord[0][2][1] + deltaY;
                coord[0][3][0] = coord[0][3][0] - deltaX;
                coord[0][3][1] = coord[0][3][1] + deltaY;
                feature.getGeometry().setCoordinates(coord);
                _this_1.map.getLayers().forEach(function (l) {
                    if (l.get('name') == "linkedMapResizeLayer") {
                        _this_1.mapElement.style.cursor = "nw-resize";
                        var s = l.getSource();
                        var f = s.getFeatures();
                        f.forEach(function (fItem) {
                            if (fItem.values_.id == "resize_linkedMap_rec") {
                                var deltaObj = _this_1.getMaxDxDyAndCenter(feature, coord);
                                fItem.getGeometry().setCoordinates([[
                                        [deltaObj.center[0] - deltaObj.dx, deltaObj.center[1] - deltaObj.dy],
                                        [deltaObj.center[0] - deltaObj.dx, deltaObj.center[1] + deltaObj.dy],
                                        [deltaObj.center[0] + deltaObj.dx, deltaObj.center[1] + deltaObj.dy],
                                        [deltaObj.center[0] + deltaObj.dx, deltaObj.center[1] - deltaObj.dy],
                                        [deltaObj.center[0] - deltaObj.dx, deltaObj.center[1] - deltaObj.dy]
                                    ]]);
                            }
                        });
                    }
                });
            };
            this.translateArrow = function (feature, coordinates, coord) {
                var geoC = _this_1.getMapTypeDelta();
                var deltaX = (coordinates[0] - MapsOpenLayers.POINT_X_DELTA * geoC) - coord[0][4][0];
                var deltaY = (coordinates[1] + MapsOpenLayers.POINT_Y_DELTA * geoC) - coord[0][4][1];
                coord[0][0][0] = coord[0][0][0] - deltaX;
                coord[0][1][1] = coord[0][1][1] - deltaY;
                coord[0][2][1] = coord[0][2][1] - deltaY;
                coord[0][3][0] = coord[0][3][0] + deltaX;
                coord[0][3][1] = coord[0][3][1] - deltaY;
                coord[0][4][0] = coord[0][4][0] + deltaX;
                coord[0][4][1] = coord[0][4][1] + deltaY;
                coord[0][5][1] = coord[0][5][1] + deltaY;
                coord[0][6][1] = coord[0][6][1] + deltaY;
                coord[0][7][0] = coord[0][7][0] - deltaX;
                feature.getGeometry().setCoordinates(coord);
                _this_1.map.getLayers().forEach(function (l) {
                    if (l.get('name') == "linkedMapResizeLayer") {
                        _this_1.mapElement.style.cursor = "nw-resize";
                        var s = l.getSource();
                        var f = s.getFeatures();
                        f.forEach(function (fItem) {
                            if (fItem.values_.id == "resize_linkedMap_rec") {
                                var deltaObj = _this_1.getMaxDxDyAndCenter(feature, coord);
                                fItem.getGeometry().setCoordinates([[
                                        [deltaObj.center[0] - deltaObj.dx, deltaObj.center[1] - deltaObj.dy],
                                        [deltaObj.center[0] - deltaObj.dx, deltaObj.center[1] + deltaObj.dy],
                                        [deltaObj.center[0] + deltaObj.dx, deltaObj.center[1] + deltaObj.dy],
                                        [deltaObj.center[0] + deltaObj.dx, deltaObj.center[1] - deltaObj.dy],
                                        [deltaObj.center[0] - deltaObj.dx, deltaObj.center[1] - deltaObj.dy]
                                    ]]);
                            }
                        });
                    }
                });
            };
            this.translateCircle = function (feature, coordinates, coord) {
                var geoC = _this_1.getMapTypeDelta();
                var deltaX = (coordinates[0] - MapsOpenLayers.POINT_X_DELTA * geoC) - coord[0];
                feature.setGeometry(ol.geom.Polygon.fromCircle(new ol.geom.Circle(coord, deltaX, 'XY')));
                _this_1.map.getLayers().forEach(function (l) {
                    if (l.get('name') == "linkedMapResizeLayer") {
                        _this_1.mapElement.style.cursor = "nw-resize";
                        var s = l.getSource();
                        var f = s.getFeatures();
                        f.forEach(function (fItem) {
                            if (fItem.values_.id == "resize_linkedMap_rec") {
                                var gextent = feature.getGeometry().getExtent();
                                var cCoords = feature.getGeometry().getCoordinates();
                                var center = ol.extent.getCenter(gextent);
                                var dx = 0;
                                var dy = 0;
                                dx = Math.abs((cCoords[0][1][0] + MapsOpenLayers.POINT_X_DELTA * geoC) - center[0]);
                                dy = Math.abs(cCoords[0][1][1] - center[1]);
                                var delta = dx;
                                if (dy > delta)
                                    delta = dy;
                                fItem.getGeometry().setCoordinates([[
                                        [center[0] - delta, center[1] - delta],
                                        [center[0] - delta, center[1] + delta],
                                        [center[0] + delta, center[1] + delta],
                                        [center[0] + delta, center[1] - delta],
                                        [center[0] - delta, center[1] - delta]
                                    ]]);
                            }
                        });
                    }
                });
            };
            this.translateLinkedMap = function (currentType, coordinates, f) {
                if (currentType == 'resize_linkedMap') {
                    _this_1.mapElement.style.cursor = "nw-resize";
                    _this_1.mapConfigSelectInteraction.getFeatures().clear();
                    var feature = f.get("feature");
                    var coord = feature.getGeometry().getCoordinates();
                    switch (coord[0].length) {
                        case 8:
                            _this_1.translateArrow(feature, coordinates, coord);
                            break;
                        case 4:
                            _this_1.translateTriangle(feature, coordinates, coord);
                            break;
                        case 5:
                            _this_1.translateSqure(feature, coordinates, coord);
                            break;
                        default:
                            var fExtent = feature.getGeometry().getExtent();
                            var center = ol.extent.getCenter(fExtent);
                            _this_1.translateCircle(feature, coordinates, center);
                    }
                }
                else {
                    //check:-> commented to uncomment again
                    _this_1.linkedMapResizeSource.clear();
                }
            };
            //  //Resize Icon
            this.translateIcon = function (currentType, coordinates, f) {
                if (currentType == 'resize_icon_point') {
                    _this_1.mapElement.style.cursor = "nw-resize";
                    _this_1.mapConfigSelectInteraction.getFeatures().clear();
                    var feature = f.get("feature");
                    var currentId_1 = feature.get('resourceId');
                    var currentType_1 = feature.get('type');
                    var coord = feature.getGeometry().getCoordinates();
                    var deltaY_1 = coordinates[1] - coord[0][3][1]; //-deltaX;//coordinates[1] - coord[0][3][1];
                    var deltaX_1 = -deltaY_1; //coordinates[0] - coord[0][3][0];
                    if (coordinates[0] <= coord[0][1][0] || coordinates[1] >= coord[0][1][1]) {
                        f.getGeometry().setCoordinates([coord[0][3][0], coord[0][3][1]]);
                        return;
                    }
                    var icnFeature = feature.get("feature");
                    if (!icnFeature)
                        return;
                    var style = icnFeature.getStyle();
                    var imgStye = style.getImage();
                    var scale = imgStye.getScale();
                    if ((deltaX_1 < 0 && (scale - 0.021) <= 0.31) || (deltaX_1 > 0 && (scale + 0.021) >= 0.79)) {
                        f.getGeometry().setCoordinates([coord[0][3][0], coord[0][3][1]]);
                        return;
                    }
                    coord[0][0][0] = coord[0][0][0] - deltaX_1;
                    coord[0][0][1] = coord[0][0][1] + deltaY_1;
                    coord[0][1][0] = coord[0][1][0] - deltaX_1;
                    coord[0][1][1] = coord[0][1][1] - deltaY_1;
                    coord[0][2][0] = coord[0][2][0] + deltaX_1;
                    coord[0][2][1] = coord[0][2][1] - deltaY_1;
                    coord[0][3][0] = coord[0][3][0] + deltaX_1;
                    coord[0][3][1] = coord[0][3][1] + deltaY_1;
                    coord[0][4][0] = coord[0][4][0] - deltaX_1;
                    coord[0][4][1] = coord[0][4][1] + deltaY_1;
                    feature.getGeometry().setCoordinates(coord);
                    f.getGeometry().setCoordinates([coord[0][3][0], coord[0][3][1]]);
                    //set scalling for Icon
                    if (deltaX_1 < 0) {
                        imgStye.setScale(scale - 0.021);
                        style.setImage(imgStye);
                        icnFeature.setStyle(style);
                        icnFeature.set("scaleValue", (scale - 0.021));
                        icnFeature.set("scaleCoords", coord);
                    }
                    else if (deltaX_1 > 0) {
                        imgStye.setScale(scale + 0.021);
                        style.setImage(imgStye);
                        icnFeature.setStyle(style);
                        icnFeature.set("scaleValue", (scale + 0.021));
                        icnFeature.set("scaleCoords", coord);
                    }
                    //Resetting funnel, while resizing image icon            
                    angular.forEach(_this_1.getAllFeaturesForSave(), function (ele) {
                        if (ele.get('type') == 'funnelIconFeature' && currentType_1 == 'resize_icon') {
                            var resId = 'rec' + ele.get('resourceId');
                            if (currentId_1 == resId) {
                                var geom = ele.getGeometry();
                                var coordEle = geom.getCoordinates();
                                //coord
                                coordEle[0][1][0] = coordEle[0][1][0] + deltaX_1;
                                coordEle[0][1][1] = coordEle[0][1][1] + deltaY_1;
                                coordEle[0][2][0] = coordEle[0][2][0] + deltaX_1;
                                coordEle[0][2][1] = coordEle[0][2][1] - deltaY_1;
                                geom.setCoordinates(coordEle);
                            }
                        }
                    });
                    //end
                }
                else {
                    _this_1.iconResizeSource.clear();
                }
            };
            //  //Resize Icon End
            this.getActiveIdelMixedCamera = function (state, resource, check360Camera) {
                var resourceStyle;
                if (state === "No") {
                    //check for thermal radar
                    if (resource.isThermalRadar) {
                        resourceStyle = _this_1.getIdleResourceStyle(resource);
                    }
                    else if (resource.isMobileDevice) {
                        resourceStyle = _this_1.getIdleResourceStyle(resource);
                    }
                    else {
                        var icon360Idle = 'images/05A_360Camera.png'; //CameraIcons.ICON_SRC.icon360Idle;
                        var icon360MixedIdle = 'images/11_360Camera.png'; //CameraIcons.ICON_SRC.iconMixed360Idle;
                        if ((resource.resourceType === 'MixedVideoSource' || resource.resourceType === 'PtzMixedVideoSource') && check360Camera === true) {
                            resourceStyle = icon360MixedIdle;
                        }
                        else if (check360Camera) {
                            resourceStyle = icon360Idle;
                        }
                        else {
                            resourceStyle = _this_1.getIdleResourceStyle(resource);
                        }
                    }
                    if (resource.changeIcon && resource.changeIcon.length > 0) {
                        var idle = resource.changeIcon.filter(function (item) {
                            return (item.type == "idle");
                        });
                        if (idle && idle.length > 0) {
                            resourceStyle = _this_1.getImagePathFromUrl(idle[0].path);
                        }
                    }
                }
                else {
                    if (resource.isThermalRadar) {
                        resourceStyle = _this_1.getActiveResourceStyle(resource);
                    }
                    else if (resource.isMobileDevice) {
                        resourceStyle = _this_1.getActiveResourceStyle(resource);
                    }
                    else {
                        var icon360Active = 'images/05A_360CameraActive.png'; //CameraIcons.ICON_SRC.icon360;
                        var icon360MixedActive = 'images/11_360CameraActive.png'; //CameraIcons.ICON_SRC.iconMixed360;
                        if ((resource.resourceType === 'MixedVideoSource' || resource.resourceType === 'PtzMixedVideoSource') && check360Camera === true) {
                            resourceStyle = icon360MixedActive;
                        }
                        else if (check360Camera) {
                            resourceStyle = icon360Active;
                        }
                        else {
                            resourceStyle = _this_1.getActiveResourceStyle(resource);
                        }
                    }
                    if (resource.changeIcon && resource.changeIcon.length > 0) {
                        var active = resource.changeIcon.filter(function (item) {
                            return (item.type == "active");
                        });
                        if (active && active.length > 0) {
                            resourceStyle = _this_1.getImagePathFromUrl(active[0].path);
                        }
                    }
                }
                return resourceStyle;
            };
            this.getResourceIdelIcon = function (feature) {
                var sourceId = feature.getId();
                //let addResource = this.globalDataAccessPoint.resources.byGuid[sourceId];
                var addResource = _this_1.mObjectPane.resourcesArray.filter(function (item) {
                    return item.id == sourceId;
                })[0];
                var idelStyle = _this_1.getIdleResourceStyle(addResource);
                if (addResource.changeIcon && addResource.changeIcon.length > 0) {
                    var idle = addResource.changeIcon.filter(function (item) {
                        return (item.type == "idle");
                    });
                    if (idle && idle.length > 0) {
                        idelStyle = _this_1.getImagePathFromUrl(idle[0].path);
                    }
                }
                return idelStyle;
            };
            this.getResourceActiveIcon = function (feature) {
                var sourceId = feature.getId();
                //let addResource = this.globalDataAccessPoint.resources.byGuid[sourceId];
                var addResource = _this_1.mObjectPane.resourcesArray.filter(function (item) {
                    return item.id == sourceId;
                })[0];
                var activeStyle = _this_1.getActiveResourceStyle(addResource);
                if (addResource.changeIcon && addResource.changeIcon.length > 0) {
                    var active = addResource.changeIcon.filter(function (item) {
                        return (item.type == "active");
                    });
                    if (active && active.length > 0) {
                        activeStyle = _this_1.getImagePathFromUrl(active[0].path);
                    }
                }
                return activeStyle;
            };
            this.setLinkedMapInteraction = function (map) {
                // configure layers for points
                _this_1.linkedMapResizeSource = new ol.source.Vector({
                    features: [],
                    wrapX: false
                });
                //== Then creating layer from the Vector
                _this_1.linkedMapResizelayer = new ol.layer.Vector({
                    source: _this_1.linkedMapResizeSource
                });
                _this_1.linkedMapResizelayer.set('name', "linkedMapResizeLayer");
                _this_1.linkedMapResizelayer.setZIndex(3);
                map.addLayer(_this_1.linkedMapResizelayer);
                map.on("click", function (e) {
                    _this_1.linkedMapResizeSource.clear();
                    var geoC = _this_1.getMapTypeDelta();
                    var fCount = 0;
                    var f = null;
                    var linked = null;
                    _this_1.map.forEachFeatureAtPixel(e.pixel, function (feature, layer) {
                        f = feature;
                        fCount++;
                        if (f.values_.type == mapDefaults.mapFeatureTypes.linkedMap) {
                            linked = feature;
                        }
                    });
                    if (linked && fCount == 1) {
                        var coord = linked.getGeometry().getCoordinates();
                        var pointCoord = coord[0][1];
                        var recCoords = [];
                        var gextent = null;
                        var center = null;
                        var deltaObj = null;
                        deltaObj = _this_1.getMaxDxDyAndCenter(linked, coord);
                        switch (coord[0].length) {
                            case 8:
                                pointCoord = [coord[0][4][0] + MapsOpenLayers.POINT_X_DELTA * geoC, coord[0][4][1] - MapsOpenLayers.POINT_Y_DELTA * geoC]; //coord[0][4];
                                break;
                            case 4:
                                pointCoord = [coord[0][2][0] + MapsOpenLayers.POINT_X_DELTA * geoC, coord[0][2][1] - MapsOpenLayers.POINT_Y_DELTA * geoC]; //coord[0][2];
                                break;
                            case 5:
                                pointCoord = [coord[0][3][0] + MapsOpenLayers.POINT_X_DELTA * geoC, coord[0][3][1] - MapsOpenLayers.POINT_Y_DELTA * geoC]; //coord[0][3];
                                break;
                            default:
                                pointCoord = [coord[0][1][0] + MapsOpenLayers.POINT_X_DELTA * geoC, coord[0][1][1]];
                                gextent = linked.getGeometry().getExtent();
                                center = ol.extent.getCenter(gextent);
                                var dx = 0;
                                var dy = 0;
                                dx = Math.abs((coord[0][1][0] + MapsOpenLayers.POINT_X_DELTA * geoC) - center[0]);
                                dy = Math.abs((coord[0][1][1] - MapsOpenLayers.POINT_Y_DELTA * geoC) - center[1]);
                                var delta = dx;
                                if (dy > delta)
                                    delta = dy;
                                recCoords = [[
                                        [center[0] - delta, center[1] - delta],
                                        [center[0] - delta, center[1] + delta],
                                        [center[0] + delta, center[1] + delta],
                                        [center[0] + delta, center[1] - delta],
                                        [center[0] - delta, center[1] - delta]
                                    ]];
                        }
                        if (coord[0].length <= 8) {
                            recCoords = [[
                                    [deltaObj.center[0] - deltaObj.dx, deltaObj.center[1] - deltaObj.dy],
                                    [deltaObj.center[0] - deltaObj.dx, deltaObj.center[1] + deltaObj.dy],
                                    [deltaObj.center[0] + deltaObj.dx, deltaObj.center[1] + deltaObj.dy],
                                    [deltaObj.center[0] + deltaObj.dx, deltaObj.center[1] - deltaObj.dy],
                                    [deltaObj.center[0] - deltaObj.dx, deltaObj.center[1] - deltaObj.dy]
                                ]];
                        }
                        var pointFeature = new ol.Feature({
                            id: "resize_linkedMap",
                            geometry: new ol.geom.Point(pointCoord),
                            name: "resize_linkedMap",
                            type: "resize_linkedMap",
                            resourceId: "point" + linked.values_.resourceId
                        });
                        pointFeature.set("feature", linked);
                        _this_1.linkedMapResizeSource.addFeature(pointFeature);
                        var recFeature = new ol.Feature({
                            id: "resize_linkedMap_rec",
                            geometry: new ol.geom.Polygon(recCoords),
                            name: "resize_linkedMap_rec",
                            type: "resize_linkedMap_rec",
                            resourceId: "point" + linked.values_.resourceId
                        });
                        recFeature.set("feature", linked);
                        _this_1.linkedMapResizeSource.addFeature(recFeature);
                    }
                    else if (linked && fCount > 1) {
                        console.log("FCount greater than 1");
                        var coord = linked.getGeometry().getCoordinates();
                        var pointCoord = coord[0][1];
                        var recCoords = [];
                        var gextent = null;
                        var center = null;
                        var deltaObj = null;
                        deltaObj = _this_1.getMaxDxDyAndCenter(linked, coord);
                        switch (coord[0].length) {
                            case 8:
                                pointCoord = [coord[0][4][0] + MapsOpenLayers.POINT_X_DELTA * geoC, coord[0][4][1] - MapsOpenLayers.POINT_Y_DELTA * geoC]; //coord[0][4];
                                break;
                            case 4:
                                pointCoord = [coord[0][2][0] + MapsOpenLayers.POINT_X_DELTA * geoC, coord[0][2][1] - MapsOpenLayers.POINT_Y_DELTA * geoC]; //coord[0][2];
                                break;
                            case 5:
                                pointCoord = [coord[0][3][0] + MapsOpenLayers.POINT_X_DELTA * geoC, coord[0][3][1] - MapsOpenLayers.POINT_Y_DELTA * geoC]; //coord[0][3];
                                break;
                            default:
                                pointCoord = [coord[0][1][0] + MapsOpenLayers.POINT_X_DELTA * geoC, coord[0][1][1]];
                                gextent = linked.getGeometry().getExtent();
                                center = ol.extent.getCenter(gextent);
                                var dx = 0;
                                var dy = 0;
                                dx = Math.abs((coord[0][1][0] + MapsOpenLayers.POINT_X_DELTA * geoC) - center[0]);
                                dy = Math.abs((coord[0][1][1] - MapsOpenLayers.POINT_Y_DELTA * geoC) - center[1]);
                                var delta = dx;
                                if (dy > delta)
                                    delta = dy;
                                recCoords = [[
                                        [center[0] - delta, center[1] - delta],
                                        [center[0] - delta, center[1] + delta],
                                        [center[0] + delta, center[1] + delta],
                                        [center[0] + delta, center[1] - delta],
                                        [center[0] - delta, center[1] - delta]
                                    ]];
                        }
                        if (coord[0].length <= 8) {
                            recCoords = [[
                                    [deltaObj.center[0] - deltaObj.dx, deltaObj.center[1] - deltaObj.dy],
                                    [deltaObj.center[0] - deltaObj.dx, deltaObj.center[1] + deltaObj.dy],
                                    [deltaObj.center[0] + deltaObj.dx, deltaObj.center[1] + deltaObj.dy],
                                    [deltaObj.center[0] + deltaObj.dx, deltaObj.center[1] - deltaObj.dy],
                                    [deltaObj.center[0] - deltaObj.dx, deltaObj.center[1] - deltaObj.dy]
                                ]];
                        }
                        var pointFeature = new ol.Feature({
                            id: "resize_linkedMap",
                            geometry: new ol.geom.Point(pointCoord),
                            name: "resize_linkedMap",
                            type: "resize_linkedMap",
                            resourceId: "point" + linked.values_.resourceId
                        });
                        pointFeature.set("feature", linked);
                        _this_1.linkedMapResizeSource.addFeature(pointFeature);
                        var recFeature = new ol.Feature({
                            id: "resize_linkedMap_rec",
                            geometry: new ol.geom.Polygon(recCoords),
                            name: "resize_linkedMap_rec",
                            type: "resize_linkedMap_rec",
                            resourceId: "point" + linked.values_.resourceId
                        });
                        recFeature.set("feature", linked);
                        _this_1.linkedMapResizeSource.addFeature(recFeature);
                    }
                });
            };
            //  //Resize Icon
            this.setIconInteraction = function (map) {
                // configure layers for points
                //this.iconResizeSource = new ol.source.Vector({
                //    features: []
                //});
                //== Then creating layer from the Vector
                //this.iconResizelayer = new ol.layer.Vector({
                //    source: this.iconResizeSource
                //});
                //this.iconResizelayer.set('name', "iconResize");
                //this.iconResizelayer.setZIndex(9);
                //map.addLayer(this.iconResizelayer);
                map.on("click", function (e) {
                    _this_1.iconResizeSource.clear();
                    var fCount = 0;
                    var f = null;
                    var linked = null;
                    var geoC = _this_1.getMapTypeDelta();
                    _this_1.map.forEachFeatureAtPixel(e.pixel, function (feature, layer) {
                        f = feature;
                        fCount++;
                        if (f.values_.type == mapDefaults.mapFeatureTypes.camera) {
                            linked = feature;
                        }
                    });
                    if (linked && fCount == 1) {
                        var c = linked.getGeometry().getCoordinates();
                        c[0] = c[0] - 0.05 * geoC;
                        c[1] = c[1] - 0.05 * geoC;
                        var coords = [[c, [c[0], c[1] + 0.1 * geoC], [c[0] + 0.1 * geoC, c[1] + 0.1 * geoC], [c[0] + 0.1 * geoC, c[1]], c]];
                        var storedCoords = linked.get("scaleCoords");
                        if (storedCoords) {
                            //set stored coordinates to existing feature
                            //calculate distance between points
                            var scaleVal = linked.get("scaleValue");
                            c[0] = c[0] - scaleVal ? scaleVal : 0.05 * geoC;
                            c[1] = c[1] - scaleVal ? scaleVal : 0.05 * geoC;
                            coords = storedCoords;
                        }
                        var recFeature = new ol.Feature({
                            id: "resize_icon",
                            geometry: new ol.geom.Polygon(coords),
                            name: "resize_icon",
                            type: "resize_icon",
                            resourceId: "rec" + linked.values_.resourceId
                        });
                        recFeature.set("feature", linked);
                        _this_1.iconResizeSource.addFeature(recFeature);
                        var pointFeature = new ol.Feature({
                            id: "resize_icon_point",
                            geometry: new ol.geom.Point(coords[0][3]),
                            name: "resize_icon_point",
                            type: "resize_icon_point",
                            resourceId: "point" + linked.values_.resourceId
                        });
                        pointFeature.set("feature", recFeature);
                        _this_1.iconResizeSource.addFeature(pointFeature);
                    }
                    //check:-> disable change icons
                    //  this.eventDispatcher.fireEvent('DISABLE_CHANGE_ICON', null, this.scope, this.globalDataAccessPoint);
                });
            };
            //  //Resize Icon
            //  public relocateFeatures = (isReverse = false) => {
            //      this.map.getLayers().forEach((l: any) => {
            //          if (l.get('name') != "bgMapImageLayer") {
            //              let s = l.getSource();
            //              let f = s.getFeatures();
            //              f.forEach((fItem: any) => {
            //                  let coords = fItem.getGeometry().getCoordinates();
            //                  fItem.getGeometry().setCoordinates(this.calculateRelativeCoordinates(coords, isReverse));
            //              });
            //          }
            //      })
            //  };
            this.loadBackgroundForMap = function (layers, mapResource) {
                try {
                    //  const staticMapImgUrl = this.mapsApiProvider.getMapStaticImageUrl(mapResource.id);
                    var staticMapImgUrl = mapResource.ImageURI || mapResource.imageUrl;
                    ;
                    var imageMapSource = new ol.source.ImageStatic({
                        url: staticMapImgUrl,
                        projection: _this_1.bgImageProjection,
                        imageExtent: _this_1.staticImagePoints
                    });
                    imageMapSource.on("imageloaderror", function () {
                        setTimeout(function () {
                            _this_1.loadBackgroundForMap(layers, mapResource);
                        }, 2000);
                    });
                    _this_1.bgMapImageLayer.setSource(imageMapSource);
                }
                catch (e) {
                    console.log("Error in loading BG layer ", e);
                }
            };
            this.loadDataToMapAsync = function (layers, mapResource) {
                try {
                    var timeoutSetting = 0;
                    var loder_1 = _this_1.loderTimeStamp || '';
                    if (_this_1.fromMonitoring) {
                        timeoutSetting = 90;
                    }
                    setTimeout(function () {
                        var currLayer;
                        if (_this_1.bgMapImageLayer != layers[_this_1.layersCount]) {
                            _this_1.map.addLayer(layers[_this_1.layersCount]);
                            currLayer = layers[_this_1.layersCount];
                        }
                        _this_1.layersCount++;
                        if (_this_1.layersCount < layers.length) {
                            _this_1.loadDataToMapAsync(layers, mapResource);
                            setTimeout(function () {
                                //let viewId = this.monitoringViewID;  // this.monitoringViewContainer.getActiveView()._id;
                                if (_this_1.mObjectPane && _this_1.mapResource) {
                                    var show = localStorage.getItem('visibilityLayerLinkedMapText' + _this_1.mObjectPane.id + _this_1.mapResource.id);
                                    console.log("Show on update: ", show);
                                    if (show && show == 'true' && currLayer.get('name') === 'linkedMapsLayer') {
                                        _this_1.hideLinkedMapText(true);
                                    }
                                }
                            }, 10);
                        }
                        else {
                            var loadingOverlay = _this_1.map.getOverlayById('mapLoadingOverlay_' + loder_1);
                            if (loadingOverlay) {
                                loadingOverlay.setPosition(undefined);
                                //this.enableControlPanel();
                            }
                            if (_this_1.fromMonitoring) {
                                try {
                                    //this.loadBackgroundForMap(layers, mapResource)
                                    //this.setxDiffValuePercent();
                                    //if (this.overLayList && this.overLayList.length > 0)
                                    //    this.setOverlayPosition();
                                    //this.makeLinkedTree(this.mapResource);
                                    //this.setLinkedMapAlarmLayer(this.map);
                                    //this.changeAlertOnLinkedMap();
                                }
                                catch (e) {
                                    console.log(e);
                                }
                            }
                            if (_this_1.mapResource.mapType != 'Image') { //TODO
                                var Geocoder_1 = _this_1.mapsExternalLibrariesService.getGeocoder();
                                var geocoder = new Geocoder_1('nominatim', {
                                    provider: 'osm',
                                    lang: 'en-US',
                                    placeholder: 'search',
                                    targetType: 'text-input',
                                    limit: 5,
                                    keepOpen: true,
                                    autoComplete: true,
                                    autoCompleteMinLength: 2
                                });
                                geocoder.on('addresschosen', function (evt) {
                                    var feature = evt.feature, coord = evt.coordinate, address = evt.address;
                                    //console.log("address chosen  ", evt);
                                    // some popup solution
                                    // content.innerHTML = '<p>' + address.formatted + '</p>';
                                    // overlay.setPosition(coord);
                                });
                                geocoder.set("name", "mapGeocoder");
                                _this_1.map.addControl(geocoder);
                                if (_this_1.fromMonitoring)
                                    _this_1.searchButtonPressed(null);
                                if (_this_1.controllerItem) {
                                    $("#gcd-input-query").click(function (e) {
                                        _this_1.controllerItem.showSearchTourBox = false;
                                    });
                                }
                                else if (_this_1.fromMonitoring) {
                                    $("#gcd-input-query").click(function (e) {
                                        var dom = _this_1.mObjectPane.domContainer;
                                        dom.focus();
                                        e.currentTarget.focus();
                                    });
                                }
                                if (_this_1.fromMonitoring) {
                                    var dom = _this_1.mObjectPane.domContainer;
                                    var minimumWidth = (MapsOpenLayers.CONTROLPANEL_VISIBILITY_VALUE / 100) * window.innerWidth;
                                    if (dom && dom.offsetWidth > minimumWidth) {
                                        var controls = _this_1.map.getControls();
                                        if (!controls || !controls.array_ || controls.array_.length == 0)
                                            return;
                                        //  for (let i = 0; i < controls.array_.length; i++) {
                                        //     if (controls.array_[i].get("name") == "mapGeocoder") {
                                        //         $(controls.array_[i].element).css("display", "block");
                                        //     }
                                        //  }
                                    }
                                    else {
                                        var controls = _this_1.map.getControls();
                                        if (!controls || !controls.array_ || controls.array_.length == 0)
                                            return;
                                        for (var i = 0; i < controls.array_.length; i++) {
                                            if (controls.array_[i].get("name") == "mapGeocoder") {
                                                $(controls.array_[i].element).css("display", "none");
                                            }
                                        }
                                    }
                                }
                                _this_1.init();
                            }
                            //this.setHomePositionMarker();
                            var center = _this_1.map.getView().getCenter();
                            var zoom = _this_1.map.getView().getZoom();
                            _this_1.defaultHome.center = center;
                            _this_1.defaultHome.zoom = zoom;
                        }
                    }, timeoutSetting);
                }
                catch (e) {
                    console.log("loadDataToMapAsync error ", e);
                }
            };
            this.removeItemFromMapResource = function (feature) {
                if (!_this_1.mapResource || !_this_1.mapResource.mapItems)
                    return;
                _this_1.mapResource.mapItems = _this_1.mapResource.mapItems.filter(function (item) {
                    var itemToRemove = null;
                    if (item.funnels && item.funnels.resourceId == feature.getId()) {
                        itemToRemove = item;
                    }
                    else if (item.images && item.images.resourceId == feature.getId()) {
                        itemToRemove = item;
                    }
                    if (!itemToRemove)
                        return true;
                    else
                        return false;
                });
            };
            this.setObjectNameOnConfig = function (map, resources) {
                map.on('pointermove', function (e) {
                    e.map.forEachFeatureAtPixel(e.pixel, function (feature, layer) {
                        var currentFeature = feature;
                        if ((!currentFeature.values_.name || currentFeature.values_.name == undefined) && feature.get('rotate-anchor') == true) {
                            _this_1.mapConfigSelectInteraction.getFeatures().clear();
                        }
                        else {
                            _this_1.selectedFeature = feature;
                            var lprSensorInfo_1;
                            var deviceInfo = void 0;
                            var lprDeviceInfo = void 0;
                            var vaxDoorInfo = void 0;
                            var vaxInfo = void 0;
                            var vaxActionPlanInfo = void 0;
                            if (_this_1.selectedFeature.values_.type === 'iconFeature') {
                                //this.getNameResourceConfig = this.selectedFeature.values_.name;
                                // lprSensorInfo = this.globalDataAccessPoint.resources.byGuid[this.selectedFeature.values_.resourceId];
                                // vaxInfo = this.globalDataAccessPoint.resources.byGuid[this.selectedFeature.values_.resourceId];
                                lprSensorInfo_1 = _this_1.mObjectPane.resourcesArray.filter(function (item) {
                                    return item.id == _this_1.selectedFeature.values_.resourceId;
                                })[0];
                                vaxInfo = _this_1.mObjectPane.resourcesArray.filter(function (item) {
                                    return item.id == _this_1.selectedFeature.values_.resourceId;
                                })[0];
                                vaxActionPlanInfo = _this_1.mObjectPane.resourcesArray.filter(function (item) {
                                    return item.id == _this_1.selectedFeature.values_.resourceId;
                                })[0];
                                if (lprSensorInfo_1 != null && lprSensorInfo_1.resourceType == "LPRSensorResource") {
                                    if (lprSensorInfo_1.hasOwnProperty('sensor')) {
                                        //lprDeviceInfo = this.globalDataAccessPoint.resources.byGuid[lprSensorInfo.sensor.id];
                                        lprDeviceInfo = _this_1.mObjectPane.resourcesArray.filter(function (item) {
                                            return item.id == lprSensorInfo_1.sensor.id;
                                        })[0];
                                        if (lprDeviceInfo != null && lprDeviceInfo.hasOwnProperty('name')) {
                                            _this_1.getLPRSensorNameResourceConfig = lprDeviceInfo.name;
                                        }
                                        else {
                                            _this_1.getLPRSensorNameResourceConfig = lprDeviceInfo._name;
                                        }
                                        _this_1.getNameResourceConfig = lprSensorInfo_1.name;
                                    }
                                }
                                else if (vaxInfo != null && vaxInfo.resourceType == "VAXDoorResource") {
                                    if (vaxInfo.hasOwnProperty('door')) {
                                        vaxDoorInfo = vaxInfo.door;
                                        _this_1.addPartnerService.getLPRSensorResourcesList(_this_1.selectedFeature.values_.resourceId).then(function (data) {
                                            if (data && data.length) {
                                                //let relRes = this.globalDataAccessPoint.resources.byGuid[data[0]];
                                                var relRes = _this_1.mObjectPane.resourcesArray.filter(function (item) {
                                                    return item.id == lprSensorInfo_1.sensor.id;
                                                })[0];
                                                if (relRes != null && relRes.hasOwnProperty('name')) {
                                                    _this_1.getVAXDoorNameResourceConfig = relRes.name;
                                                }
                                                else if (relRes != null) {
                                                    _this_1.getVAXDoorNameResourceConfig = relRes._name;
                                                }
                                                else {
                                                    _this_1.getVAXDoorNameResourceConfig = '';
                                                }
                                            }
                                            else {
                                                _this_1.getVAXDoorNameResourceConfig = '';
                                            }
                                        });
                                        //if (vaxDoorInfo != null && vaxDoorInfo.hasOwnProperty('name')) {
                                        //    this.getVAXDoorNameResourceConfig = vaxDoorInfo.name;
                                        //} else {
                                        //    this.getVAXDoorNameResourceConfig = vaxDoorInfo._name;
                                        //} // commented to show the related resource of VAX
                                        _this_1.getVAXNameResourceConfig = vaxInfo.name;
                                    }
                                }
                                else if (vaxActionPlanInfo != null && vaxActionPlanInfo.resourceType == "VAXActionPlanResource") {
                                    //console.log(vaxActionPlanInfo)
                                    _this_1.getVAXActionPlanNameResourceConfig = vaxActionPlanInfo.name || vaxActionPlanInfo._name;
                                }
                                else if (lprSensorInfo_1 != null && lprSensorInfo_1.resourceType == "VideoSource") {
                                    _this_1.getNameResourceConfig = lprSensorInfo_1.name;
                                }
                                else {
                                    _this_1.getNameResourceConfig = lprSensorInfo_1.name;
                                }
                            }
                        }
                    });
                });
            };
            this.getMaxDxDyAndCenter = function (feature, coord) {
                var gextent = feature.getGeometry().getExtent();
                var center = ol.extent.getCenter(gextent);
                var dx = 0;
                var dy = 0;
                var geoC = _this_1.getMapTypeDelta();
                coord[0].forEach(function (c) {
                    var xD = Math.abs((c[0] + MapsOpenLayers.POINT_X_DELTA * geoC) - center[0]);
                    var yD = Math.abs((c[1] - MapsOpenLayers.POINT_Y_DELTA * geoC) - center[1]);
                    if (dx < xD)
                        dx = xD;
                    if (dy < yD)
                        dy = yD;
                });
                return { center: center, dx: dx, dy: dy };
            };
            //  private setOverlayPosition = () => {
            //      setTimeout(() => {
            //          this.map.getLayers().forEach((layer) => {
            //              if (layer instanceof ol.layer.Vector) {
            //                  let source = layer.getSource();
            //                  let feature = source.getFeatures();
            //                  feature.forEach((featureItem: any) => {
            //                      if (featureItem.values_.type === 'iconFeature') {
            //                          let overlay = this.overLayList.filter((o) => {
            //                              return (o.resourceId == featureItem.values_.id);
            //                          })
            //                          if (overlay && overlay.length > 0) {
            //                              let popuLiveVdopObj: any = overlay[0].oObj.getElement();
            //                              if (popuLiveVdopObj.style.display == "block") {
            //                                  let coords: any = featureItem.getGeometry().getCoordinates();
            //                                  overlay[0].oObj.setPosition(coords);
            //                                  this.resetOverlayPosWithPanel(featureItem.values_.id);
            //                              }
            //                          }
            //                      }
            //                  })
            //              }
            //          });
            //      }, 100)
            //  }
            //  public handeledMapsInstanseToggelButton = () => {
            //      if (this.mapResource._visible == false) {
            //          let getActiveView = this.monitoringViewContainer.getActiveView();
            //          for (let i = 0; i < getActiveView.layout._layoutItems.length; i++) {
            //              if (getActiveView.layout._layoutItems[i]._pane._resource) {
            //                  if (getActiveView.layout._layoutItems[i]._pane._resource._id == this.mapResource._id) {
            //                      getActiveView.layout._layoutItems[i]._pane.dispose();
            //                      break;
            //                  }
            //              }
            //          }
            //      }
            //  }
            //  public handeledMapsInstanseToggelButtonMultiple = (mapResource) => {
            //      if (mapResource.Visible == false) {
            //          let getActiveView = this.monitoringViewContainer.getActiveView();
            //          for (let i = 0; i < getActiveView.layout._layoutItems.length; i++) {
            //              if (getActiveView.layout._layoutItems[i]._pane._resource) {
            //                  if (getActiveView.layout._layoutItems[i]._pane._resource._id == mapResource.Id) {
            //                      getActiveView.layout._layoutItems[i]._pane.dispose();
            //                      break;
            //                  }
            //              }
            //          }
            //      }
            //  }
            //  //on zoom set font size
            this.setFontOnZoom = function (map) {
                map.on('moveend', (function () {
                    var zoom = map.getView().getZoom();
                    map.getLayers().forEach(function (l) {
                        if (l.get('name') == "notes" || l.get('name') == "linkedMapsLayer") {
                            var s = l.getSource();
                            var f = s.getFeatures();
                            f.forEach(function (fItem) {
                                var style = fItem.getStyle();
                                var despFonts = style.getText().getFont();
                                var fontDescPart = despFonts.split(" ");
                                var size = parseInt(fontDescPart[0].substring(0, fontDescPart[0].length - 2));
                                if (zoom > _this_1.lastZoom && size) {
                                    size = size + 8;
                                }
                                else if (zoom < _this_1.lastZoom) {
                                    size = size - 10;
                                }
                                if (size > 72)
                                    size = 72;
                                if (size < 11)
                                    size = 11;
                                despFonts = size + "px" + " " + fontDescPart.slice(1, fontDescPart.length).join(" ");
                                style.getText().setFont(despFonts);
                                fItem.setStyle(style);
                            });
                        }
                    });
                    _this_1.lastZoom = zoom;
                }));
            };
            this.getRelativeFontSize = function (fontSize) {
                if (!_this_1.isExpended)
                    return fontSize;
                /*  let activeView = this.monitoringViewContainer.getActiveView();
                  if (activeView && activeView.layout) {
     
                      let len = activeView.layout._layoutItems.length;
                      let cFont = fontSize / len;
                      if (cFont < 11)
                          return 11;
                      else
                          return cFont;
                  } else {
                      return fontSize;
                  } */
            };
            //  //END
            //  private fnCreateHeader = () => {
            //      var elmHeaderContainer, elmContextMenuCnt, elmResourceIconCnt,
            //          elmResourceName, elmResourceRemoveTrigger, elmResourceAlternateStream, elmResourceAlternateWarning;//, elmResourceAlternatePath;
            //      elmHeaderContainer = document.createElement("div");
            //      /* Ruslan */
            //      var elmHeaderLeftContainer = document.createElement("div");
            //      var elmHeaderRightContainer = document.createElement("div");
            //      /*  */
            //      elmContextMenuCnt = document.createElement("div");
            //      elmResourceIconCnt = document.createElement("span");
            //      elmResourceName = document.createElement("span");
            //      elmResourceRemoveTrigger = document.createElement("span");
            //      elmResourceRemoveTrigger.pane = 'pane';
            //      elmResourceAlternateStream = document.createElement("span");
            //      elmResourceAlternateStream.title = this.languageService.getValueByKey("Alternate");
            //      elmResourceAlternateWarning = document.createElement('span');
            //      elmResourceAlternateWarning.className = 'vicon-font v-warning';
            //      elmResourceAlternateWarning.appendChild(document.createElement('span'));
            //      elmResourceAlternateWarning.appendChild(document.createElement('i'));
            //      elmResourceAlternateWarning.appendChild(document.createElement('i'));
            //      elmResourceAlternateStream.appendChild(elmResourceAlternateWarning);
            //      elmHeaderContainer.classList.add("vms-player-tools");
            //      elmHeaderContainer.classList.add("flex-between");
            //      /* Ruslan */
            //      elmHeaderLeftContainer.classList.add("flex-start");
            //      elmHeaderRightContainer.classList.add("flex-end");
            //      elmResourceIconCnt.classList.add("vms-pane-resource-type-icon");
            //      elmResourceName.classList.add("vms-player-resource-title");
            //      elmResourceName.classList.add("text-overflow");
            //      elmResourceRemoveTrigger.className = 'vms-btn-pane-closer vicon-font v-close-x';
            //      // elmResourceAlternateStream.classList.add("vms-player-alternate-info");
            //      elmResourceAlternateStream.className = 'vms-player-alternate';
            //      elmHeaderLeftContainer.appendChild(elmResourceIconCnt); // resource type icon
            //      elmHeaderLeftContainer.appendChild(elmContextMenuCnt); // context menu
            //      elmHeaderLeftContainer.appendChild(elmResourceName); // resource name title
            //      elmHeaderLeftContainer.appendChild(elmResourceAlternateStream); // alternate steame info
            //      elmHeaderRightContainer.appendChild(elmResourceRemoveTrigger); // clear pane button
            //      elmResourceRemoveTrigger.onclick = () => {
            //          this.mObjectPane.disposeConfig();
            //      }
            //      elmHeaderContainer.appendChild(elmHeaderLeftContainer); // add left panel
            //      elmHeaderContainer.appendChild(elmHeaderRightContainer); // add right panel
            //      return elmHeaderContainer;
            //  }
            this.resetOverlayPosWithPanel = function (resourceId) {
                //Temporarily commented
                ////control left side window for popup
                //let infoContainer = document.getElementById("xyz" + "camInfo" + this.mObjectPane.id + resourceId);
                //let dom = this.mObjectPane.domContainer;
                //let left: any = 0;
                //if ((infoContainer.parentElement.offsetLeft + 348) > dom.offsetWidth) {
                //    let widthDiff = (infoContainer.parentElement.offsetLeft + 348) - dom.offsetWidth;
                //    left = infoContainer.parentElement.offsetLeft - widthDiff;
                //}
                //if (left > 0) {
                //    infoContainer.parentElement.style.left = left.toString() + "px";
                //}
                //var rect = dom.getBoundingClientRect();
                //var infoRect = infoContainer.parentElement.getBoundingClientRect();
                //let paneBottom = rect.bottom;
                //let overlayBottom = infoRect.top + 220;
                //if (paneBottom < overlayBottom) {
                //    infoContainer.parentElement.style.top = (infoRect.top - 220).toString() + "px";
                //    infoContainer.parentElement.style.bottom = (overlayBottom - 220).toString() + "px";
                //}
                //end
            };
            //  private clearControlPanel = () => {
            //      var controlEle = this.mapElement.getElementsByClassName('map-controls-panel draggable-panel custom-panel');
            //      if (controlEle && controlEle.length > 0) {
            //          this.mapElement.removeChild(controlEle[0]);
            //      }
            //  }
            this.addResourcesToLinkedTree = function (map, linkedObject) {
                map.mapItems.forEach(function (item) {
                    if (item.type == "MapItemImage" && item.images) {
                        linkedObject.resources.push(item.images.resourceId);
                    }
                });
                map.mapItems.forEach(function (item) {
                    if (item.funnels && item.funnels.resourceId) {
                        //let mapResource: any = this.globalDataAccessPoint.resources.byGuid[item.funnels.resourceId];
                        var mapResource = item.resource;
                        if (mapResource.resourceType == 'Map') {
                            _this_1.addResourcesToLinkedTree(mapResource, linkedObject);
                        }
                    }
                });
            };
            this.makeLinkedTree = function (map) {
                map.mapItems.forEach(function (item) {
                    if (item.funnels && item.funnels.resourceId) {
                        //let mapResource: any = this.globalDataAccessPoint.resources.byGuid[item.funnels.resourceId];
                        var mapResource = item.resource;
                        if (mapResource && mapResource.resourceType == 'Map') {
                            var linkedMap = { map: item.funnels.resourceId, resources: [] };
                            _this_1.linkedMapResources.push(linkedMap);
                            _this_1.addResourcesToLinkedTree(mapResource, linkedMap);
                        }
                    }
                });
            };
            this.getMapTypeDelta = function () {
                var geoC = 1;
                var zoom = _this_1.map.getView().getZoom();
                if (_this_1.mapResource.mapType == mapDefaults.mapTypes.geo) {
                    geoC = 10000000 / ((zoom == 0 || zoom == 3) ? 1 : zoom);
                    if (zoom >= 24)
                        geoC = 1;
                    else if (zoom >= 19)
                        geoC = 10000000 / ((zoom == 0 || zoom == 3) ? 1 : (zoom * 10000));
                    else if (zoom >= 16)
                        geoC = 10000000 / ((zoom == 0 || zoom == 3) ? 1 : (zoom * 500));
                    else if (zoom >= 13)
                        geoC = 10000000 / ((zoom == 0 || zoom == 3) ? 1 : (zoom * 300));
                    else if (zoom >= 10)
                        geoC = 10000000 / ((zoom == 0 || zoom == 3) ? 1 : (zoom * 8));
                    else if (zoom >= 8)
                        geoC = 10000000 / ((zoom == 0 || zoom == 3) ? 1 : (zoom * 4));
                }
                return geoC;
            };
            this.setHomePositionMarker = function () {
                if (_this_1.mapResource.mapType != 'MapService')
                    return;
                var home = _this_1.getInitialHomePosition();
                if (!home)
                    return;
                if (home && home.initial == true && !_this_1.fromMonitoring)
                    _this_1.controllerItem.scope.isGeoHomeSet = false;
                _this_1.homeMarkerSource = new ol.source.Vector({ wrapX: false });
                _this_1.homeMarkerLayer = new ol.layer.Vector({
                    source: _this_1.homeMarkerSource
                });
                _this_1.homeMarkerLayer.setZIndex(3);
                var feature = new ol.Feature({
                    id: "homepostionMarker",
                    geometry: new ol.geom.Point(home.center),
                    name: "homepostionMarker"
                });
                _this_1.homeMarkerSource.addFeature(feature);
                _this_1.homeMarkerLayer.set("name", "homeMarkerLayer");
                _this_1.map.addLayer(_this_1.homeMarkerLayer);
            };
            //  private isHomePositionSet = () => {
            //      if (this.mapResource.mapType != mapDefaults.mapTypes.geo)
            //          return true;
            //      let home: any = this.getInitialHomePosition();
            //      if (!home) return false;
            //      if (home && !home.initial) return true
            //      return false;
            //  }
            //  public updateHomePosition = (long, lat, zoom) => {
            //      this.mapResource.longitude = long;
            //      this.mapResource.latitude = lat;
            //      this.mapResource.zoom = zoom;
            //  }
            this.onInternetConnectionChanged = function (isOnline) {
                //  this.eventDispatcher.subscribe("internet_connection_changed", (isOnline: any) => {
                if (_this_1.fromMonitoring && isOnline == _this_1.isSysOnline)
                    return;
                _this_1.isSysOnline = isOnline;
                if (_this_1.mapResource && _this_1.mapResource.mapType != mapDefaults.mapTypes.geo)
                    return;
                if (!_this_1.fromMonitoring) {
                    var internetOverlay = _this_1.map.getOverlayById('internetOverlay');
                    if (internetOverlay) {
                        var center = _this_1.getMapCenter();
                        if (isOnline == true) {
                            internetOverlay.setPosition(undefined);
                            internetOverlay.getElement;
                            _this_1.map.getInteractions().forEach(function (interaction) { interaction.setActive(true); });
                            if (_this_1.controllerItem)
                                _this_1.controllerItem.scope.isDisablePointer = false;
                        }
                        else {
                            internetOverlay.setPosition(center);
                            var ele = internetOverlay.element;
                            ele.classList.add("no_internet_overlay");
                            _this_1.map.getInteractions().forEach(function (interaction) { interaction.setActive(false); });
                            if (_this_1.controllerItem)
                                _this_1.controllerItem.scope.isDisablePointer = true;
                        }
                    }
                }
                else {
                    var internetOverlay = _this_1.map.getOverlayById('internetOverlay' + _this_1.mObjectPane.id);
                    if (internetOverlay) {
                        var center = _this_1.getMapCenter();
                        if (isOnline == true) {
                            internetOverlay.setPosition(undefined);
                            internetOverlay.getElement;
                            _this_1.map.getInteractions().forEach(function (interaction) { interaction.setActive(true); });
                        }
                        else {
                            internetOverlay.setPosition(center);
                            var ele = internetOverlay.element;
                            ele.classList.add("no_internet_overlay");
                            _this_1.map.getInteractions().forEach(function (interaction) { interaction.setActive(false); });
                        }
                    }
                }
                //  })
            };
            this.internetOverlay = function () {
                var internetOverlayHtml;
                if (_this_1.fromMonitoring) {
                    internetOverlayHtml = document.getElementById('internetOverlay' + _this_1.mObjectPane.id);
                    if (!internetOverlayHtml) {
                        internetOverlayHtml = angular.element('<div class="no_internet_overlay_text" id="internetOverlay' + _this_1.mObjectPane.id + '">System is offline and Geo maps cannot be used.</div>')[0];
                        internetOverlayHtml.onmousemove = function (e) {
                            e.preventDefault();
                            e.stopPropagation();
                        };
                        internetOverlayHtml.onpointermove = function (e) {
                            e.preventDefault();
                            e.stopPropagation();
                        };
                        internetOverlayHtml.oncontextmenu = function (e) {
                            e.preventDefault();
                            e.stopPropagation();
                        };
                        internetOverlayHtml.ondblclick = function (e) {
                            e.preventDefault();
                            e.stopPropagation();
                        };
                        internetOverlayHtml.onpointerdown = function (e) {
                            e.preventDefault();
                            e.stopPropagation();
                        };
                        internetOverlayHtml.onpointerup = function (e) {
                            e.preventDefault();
                            e.stopPropagation();
                        };
                        internetOverlayHtml.onclick = function (e) {
                            e.preventDefault();
                            e.stopPropagation();
                        };
                        document.body.appendChild(internetOverlayHtml);
                    }
                }
                else {
                    internetOverlayHtml = document.getElementById('internetOverlay');
                    if (!internetOverlayHtml) {
                        internetOverlayHtml = angular.element('<div class="no_internet_overlay_text" id="internetOverlay">System is offline and Geo maps cannot be used.</div>')[0];
                        internetOverlayHtml.onmousemove = function (e) {
                            e.preventDefault();
                            e.stopPropagation();
                        };
                        internetOverlayHtml.onpointermove = function (e) {
                            e.preventDefault();
                            e.stopPropagation();
                        };
                        internetOverlayHtml.oncontextmenu = function (e) {
                            e.preventDefault();
                            e.stopPropagation();
                        };
                        internetOverlayHtml.ondblclick = function (e) {
                            e.preventDefault();
                            e.stopPropagation();
                        };
                        internetOverlayHtml.onpointerdown = function (e) {
                            e.preventDefault();
                            e.stopPropagation();
                        };
                        internetOverlayHtml.onpointerup = function (e) {
                            e.preventDefault();
                            e.stopPropagation();
                        };
                        internetOverlayHtml.onclick = function (e) {
                            e.preventDefault();
                            e.stopPropagation();
                        };
                        document.body.appendChild(internetOverlayHtml);
                    }
                }
                var internetOverlay = new ol.Overlay({
                    id: _this_1.fromMonitoring ? 'internetOverlay' + _this_1.mObjectPane.id : 'internetOverlay',
                    element: internetOverlayHtml,
                    stopEvent: false,
                    positioning: 'center-center',
                    offset: [0, 0],
                    autoPan: true
                });
                internetOverlay.set("name", "internetoverlay");
                _this_1.map.addOverlay(internetOverlay);
            };
            //  public setPollData = (mapResource): any => {
            //      var deferred = this.$q.defer();
            //      let mapResourcesLength = !!mapResource.mapItems ? mapResource.mapItems.length : 0;
            //      for (let i = 0; i < mapResourcesLength; i++) {
            //          if (mapResource.mapItems != null && mapResource.mapItems[i].hasOwnProperty('type')) {
            //              switch (mapResource.mapItems[i].type) {
            //                  case 'MapItemImage':
            //                      const mapImages = mapResource.mapItems[i].images;
            //                      const addResource: any = this.globalDataAccessPoint.resources.byGuid[mapImages.resourceId];
            //                      if (!addResource) continue;
            //                      if (mapImages.resourceId != "" && mapImages.resourceId !== null && mapImages.resourceId !== undefined) {
            //                          var resource = this.globalDataAccessPoint.resources.byGuid[mapImages.resourceId];
            //                          if (resource._resourceType != 'View' && resource._resourceType != 'DigitalInput' && resource._resourceType != 'RelayOutput' && resource._resourceType != 'Tour' && resource._resourceType != 'Url' && resource._resourceType != 'LPRSensorResource' && resource._resourceType != 'VAXDoorResource') {
            //                              this.prePolledDataId.push({ "id": mapImages.resourceId })
            //                              if (resource._resourceType == 'VideoSource' ||
            //                                  resource._resourceType == 'PtzMixedVideoSource' ||
            //                                  resource._resourceType == 'PtzVideoSource' ||
            //                                  resource._resourceType == 'MixedVideoSource' ||
            //                                  resource._resourceType == 'AudioSource'
            //                              ) {
            //                                  if (!addResource.hasOwnProperty('isDisconnected')) {
            //                                      this.prePolledDataPresetId.push(mapImages.resourceId)
            //                                  }
            //                              }
            //                          }
            //                      }
            //                      if (addResource !== undefined && addResource.nvrId !== undefined) {
            //                          this.prePolledDataNvrId.push(addResource.nvrId)
            //                      }
            //                      break;
            //              }
            //          }
            //      }
            //      this.prePolledData["recordingStorage"] = [];
            //      this.prePolledData["recordingSettings"] = [];
            //      this.prePolledData["preset"] = [];
            //      this.getRecordingSettings(this.prePolledDataNvrId, this.prePolledDataPresetId).then((data) => {
            //          deferred.resolve();
            //      });
            //      return deferred.promise;
            //  }
            //  private getRecordingSettings = (prePolledDataNvrId: any, prePolledDataPresetId: any): any => {
            //      var deferred = this.$q.defer();
            //      var reqData = {
            //          "ResourceId": prePolledDataPresetId,
            //          "NVRId": prePolledDataNvrId
            //      };
            //      //call for parallel api hit:- this.mapsApiProvider.getRecordingSettingsParallel
            //      //call for sequential api hit:- this.mapsApiProvider.getRecordingSettings
            //      this.mapsApiProvider.getRecordingSettingsParallel(reqData).then(
            //          //== On success
            //          (data): void => {
            //              this.prePolledData["recordingStorage"] = data["recordingStorageData"] ? data["recordingStorageData"] : [];
            //              this.prePolledData["recordingSettings"] = data["sourceRecordingSettings"] ? data["sourceRecordingSettings"] : [];
            //              deferred.resolve([]);
            //          },
            //          //== On error
            //          (err): void => {
            //              this.prePolledData["recordingStorage"] = [];
            //              this.prePolledData["recordingSettings"] = [];
            //              this.prePolledData["preset"] = [];
            //              deferred.reject(err);
            //              this.mapCounter = this.mapCounter + 1;
            //          }
            //      );
            //      return deferred.promise;
            //  }
            this.addSpecialFeatureToIcon = function (iconFeature, CameraIconsListForLayer) {
                //show resource name as per resource type
                var resourceId = iconFeature.get("resourceId");
                var iStyle = iconFeature.getStyle();
                if (!resourceId)
                    return;
                //let addResource: any = this.globalDataAccessPoint.resources.byGuid[resourceId];
                var addResource = _this_1.mObjectPane.resourcesArray.filter(function (item) {
                    return item.id == resourceId;
                })[0];
                if (_this_1.fromMonitoring)
                    _this_1.setPresetList(iconFeature);
                //if (this.fromMonitoring && addResource.resourceType == "VAXDoorResource") {
                //    this.setVaxLinkedResourceList(iconFeature)
                //}
                //if (this.fromMonitoring && addResource.resourceType == "LPRSensorResource") {
                //    this.setLPRLinkedResourceList(iconFeature)
                //}
                var alarmed = MapsOpenLayers.alarmedResources.indexOf(resourceId);
                var scaleValue = iconFeature.get("scaleValue");
                var check360Camera = _this_1.is360CameraItem(addResource);
                if (alarmed >= 0) {
                    //let alarmStyle = this.getAlarmResourceStyle(iconFeature);
                    var alarmStyle = void 0;
                    var icon360CameraAlarm = "images/05A_360CameraAlarm.png";
                    var icon360MixedCameraAlarm = "images/11_360CameraAlarm.png";
                    var iconThermal = "images/MobileAlarm.png";
                    var iconMobile = "images/MobileAlarm.png";
                    var style = iconFeature.getStyle();
                    if (addResource.isThermalRadar) {
                        alarmStyle = iconThermal;
                        //check360Camera = true;
                    }
                    else if (addResource.isMobileDevice) {
                        alarmStyle = iconMobile;
                        //check360Camera = true;
                    }
                    else if ((addResource.resourceType === 'MixedVideoSource' || addResource.resourceType === 'PtzMixedVideoSource') && check360Camera === true) {
                        alarmStyle = icon360MixedCameraAlarm;
                    }
                    else if (check360Camera) {
                        alarmStyle = icon360CameraAlarm;
                    }
                    else {
                        alarmStyle = _this_1.getAlarmResourceStyle(iconFeature);
                    }
                    style.setImage(new ol.style.Icon({
                        anchor: [0.5, 0.48],
                        size: new CameraIcons(_this_1.mapResource.mapIconSize).getIconSize(_this_1.mapResource.mapIconSize),
                        opacity: 1,
                        scale: style.getImage().getScale(),
                        src: new CameraIcons(_this_1.mapResource.mapIconSize).getIconStyle(alarmStyle, _this_1.mapResource.mapIconSize),
                        rotation: style.getImage().getRotation()
                    }));
                    iconFeature.setStyle(style);
                }
                else {
                    var flip = iconFeature.get("initFlipValue");
                    var flop = iconFeature.get("initFlopValue");
                    var isCurrentResource = iconFeature.get("isCurrentResource");
                    //this.setViewList(iconFeature, resourceId);
                    //this.setNVRIdName(iconFeature, resourceId);
                    if (alarmed < 0) {
                        //if ((flip || flop) && !this.fromMonitoring)
                        //    this.applyFlip(iconFeature, flip, flop, true);
                        //else 
                        _this_1.getRecordingStatus(iconFeature, addResource.nvrId);
                    }
                    // else { }
                    //Resize Icon
                    if (scaleValue) {
                        iStyle.getImage().setScale(scaleValue);
                        iconFeature.setStyle(iStyle);
                    }
                    //End Resize Icon
                    if (isCurrentResource) {
                        setTimeout(function () {
                            _this_1.flash(_this_1.map, iconFeature, 3000);
                        }, 500);
                    }
                }
            };
            //  private loadingMapOverlay = (loderTime: any) => {
            //      let loder = loderTime || '';
            //      let mapLoadingOverlay: HTMLElement = document.getElementById('mapLoadingOverlay_' + loder);
            //      if (!mapLoadingOverlay) {
            //          mapLoadingOverlay = angular.element('<div id="mapLoadingOverlay_' + loder + '" style="position: absolute;top: calc(50% - 75px);left: calc(50% - 109px);background:black;padding:15px;width:200px;height:100px;text-align:center" class="loading-map">Loading<span>.</span><span>.</span><span>.</span></div>')[0];
            //          document.body.appendChild(mapLoadingOverlay);
            //      }
            //      let mapLoadOverlay = new ol.Overlay({
            //          id: 'mapLoadingOverlay_' + loder,
            //          element: mapLoadingOverlay,
            //          stopEvent: false,
            //          positioning: 'center-center',
            //          offset: [0, 0],
            //          autoPan: false
            //      });
            //      mapLoadOverlay.set("name", "loadingOverlay");
            //      this.map.addOverlay(mapLoadOverlay);
            //  }
            this.loadMapItemPolygon = function (mapResource, index, linkedMapsListForLayer, cameraFunnelsListForLayer) {
                var mapPolygon = mapResource.mapItems[index].funnels;
                var resourceId = mapPolygon.resourceId;
                var propertyBag = mapPolygon.coordinates;
                var description = mapPolygon.description;
                var fill = mapPolygon.fill;
                var shape = null;
                var coordinates;
                var rotation = 0;
                var dataFromBag = angular.copy(mapPolygon.propertyBagDetails);
                coordinates = _this_1.calculateRelativeCoordinates(dataFromBag.coordinates);
                rotation = dataFromBag.rotation == undefined ? 0 : dataFromBag.rotation;
                // circle for 360
                //  const addResource: any = this.globalDataAccessPoint.resources.byGuid[resourceId];
                var addResource = mapResource.mapItems[index].resource;
                //if (!addResource) return;
                //const funnelIconStyle = new CameraIcons(this.mapResource.mapIconSize).iconfunnel;
                var funnelIconStyle = new ol.style.Style({
                    // Pi/4 is 45 degrees
                    image: new ol.style.RegularShape({
                        fill: new ol.style.Fill({ color: [53, 140, 216, 0.5] }),
                        stroke: new ol.style.Stroke({ color: [53, 140, 216, 0], width: 0 }),
                        points: 3,
                        radius: 10,
                        angle: Math.PI / 4
                    }),
                    text: new ol.style.Text(({ rotateWithView: true, rotation: 0 })),
                    fill: new ol.style.Fill({ color: [53, 140, 216, 0.5] }),
                    stroke: new ol.style.Stroke({ color: [53, 140, 216, 0], width: 0 })
                });
                // const shapeStyle = new CameraIcons(this.mapResource.mapIconSize).shapeStyle;
                var shapeStyle = new ol.style.Style({
                    image: new ol.style.Circle({
                        fill: new ol.style.Fill({ color: [226, 43, 138, 0.5] }),
                        stroke: new ol.style.Stroke({ color: [226, 43, 138, 0], width: 0 }),
                        radius: 5
                    }),
                    text: new ol.style.Text(({
                        rotateWithView: true,
                        rotation: 0,
                        font: '14px Arial Italic',
                        fill: new ol.style.Fill({ color: '#1a2028' }),
                        text: '',
                    })),
                    fill: new ol.style.Fill({ color: [226, 43, 138, 0.5] }),
                    stroke: new ol.style.Stroke({ color: [226, 43, 138, 0], width: 0 })
                });
                if (!addResource) {
                    if (dataFromBag.shape || (dataFromBag.featureType && (dataFromBag.featureType == 'unlinked' || dataFromBag.featureType == 'linkedMap'))) {
                        var rStyle = shapeStyle;
                        fill = dataFromBag.fill;
                        shape = dataFromBag.shape;
                        description = dataFromBag.description;
                        if (fill) {
                            rStyle.setFill(new ol.style.Fill({
                                color: fill.split(",")
                            }));
                            rStyle.getText().setText(description);
                            _this_1.linkedCount = true;
                            var funnelIconFeature = new ol.Feature({
                                id: dataFromBag.id,
                                name: 'name',
                                type: 'linkedMapFeature',
                                resourceId: resourceId,
                                iconStyle: rStyle,
                                description: 'shape',
                            });
                            funnelIconFeature.setStyle(rStyle);
                            funnelIconFeature.setId(dataFromBag.id); //== Set external feature ID, now getFeatureById can be used
                            funnelIconFeature.set('defaultStyle', rStyle);
                            if (shape) {
                                funnelIconFeature.set("shape", shape);
                                funnelIconFeature.set("featureType", "unlinked");
                            }
                            var iconGeometryFunnel = new ol.geom.Polygon(coordinates);
                            funnelIconFeature.set('geometry', iconGeometryFunnel);
                            funnelIconFeature.getGeometry().rotate((-rotation * Math.PI / 180), coordinates[0][0]); //@roshan                                                
                            linkedMapsListForLayer.push(funnelIconFeature);
                        }
                    }
                }
                else {
                    var check360Camera = _this_1.is360CameraItem(addResource);
                    var rType = addResource.resourceType != "Map" ? "funnelIconFeature" : "linkedMapFeature";
                    var rStyle = addResource.resourceType != "Map" ? funnelIconStyle : shapeStyle;
                    if (addResource.resourceType == "Map") {
                        description = dataFromBag.description;
                        fill = dataFromBag.fill;
                        shape = dataFromBag.shape;
                        if (fill) {
                            rStyle.setFill(new ol.style.Fill({
                                color: fill.split(",")
                            }));
                        }
                        rStyle.getText().setText(description);
                        _this_1.linkedCount = true;
                    }
                    else {
                        _this_1.funnelCount = true;
                    }
                    var inc = Math.floor(Math.random() * Math.floor(100));
                    var funnelIconFeature = new ol.Feature({
                        id: resourceId,
                        name: 'name',
                        type: rType,
                        resourceId: resourceId,
                        iconStyle: rStyle,
                        description: check360Camera ? 'Camera360' : 'Other',
                    });
                    funnelIconFeature.setStyle(rStyle);
                    funnelIconFeature.setId(resourceId + inc); //== Set external feature ID, now getFeatureById can be used
                    funnelIconFeature.set('defaultStyle', rStyle);
                    if (shape) {
                        funnelIconFeature.set("shape", shape);
                        //   this.setMapName(funnelIconFeature, resourceId);
                    }
                    var iconGeometryFunnel = new ol.geom.Polygon(coordinates);
                    funnelIconFeature.set('geometry', iconGeometryFunnel);
                    funnelIconFeature.getGeometry().rotate((-rotation * Math.PI / 180), coordinates[0][0]);
                    //set funnel if 360 change
                    if (addResource.resourceType != "Map" && !addResource.isThermalRadar && !addResource.isMobileDevice) {
                        if (!check360Camera && coordinates[0].length > 3) {
                            var fExtent = funnelIconFeature.getGeometry().getExtent();
                            var center = ol.extent.getCenter(fExtent);
                            var dX = 0.2;
                            var dY = 0.2;
                            if (_this_1.fromMonitoring && _this_1.mapResource.mapType != "MapService") {
                                var perX = (0.2 * 100) / _this_1.actualExtent[2];
                                var perY = (0.2 * 100) / _this_1.actualExtent[3];
                                dX = (perX / 100) * _this_1.modifiedExtend[2];
                                dY = (perY / 100) * _this_1.modifiedExtend[3];
                            }
                            else if (_this_1.mapResource.mapType == "MapService") {
                                dX = Math.abs(center[0] - coordinates[0][0][0]);
                                dY = Math.abs(center[1] - coordinates[0][0][1]);
                                if (dY == 0)
                                    dY = dX;
                                else if (dX == 0)
                                    dX = dY;
                            }
                            var cPoints = new ol.geom.Polygon([[center, [center[0] + dX, center[1] - dY], [center[0] + dX, center[1] + dY]]]).getCoordinates();
                            var geom = funnelIconFeature.getGeometry();
                            geom.setCoordinates(cPoints);
                            funnelIconFeature.setGeometry(geom);
                        }
                        else if (check360Camera && coordinates[0].length == 3) {
                            var center = coordinates[0][0];
                            var dX = 0.2;
                            if (_this_1.fromMonitoring && _this_1.mapResource.mapType != "MapService") {
                                var perX = (0.2 * 100) / _this_1.actualExtent[2];
                                dX = (perX / 100) * _this_1.modifiedExtend[2];
                            }
                            else if (_this_1.mapResource.mapType == "MapService") {
                                //override radius by calculating max axis difference
                                var radiusX = 0;
                                var radiusY = 0;
                                for (var i = 0; i < coordinates[0].length; i++) {
                                    var diffX = Math.abs(coordinates[0][0][0] - coordinates[0][i][0]);
                                    var diffY = Math.abs(coordinates[0][0][1] - coordinates[0][i][1]);
                                    if (radiusX < diffX)
                                        radiusX = diffX;
                                    if (radiusY < diffY)
                                        radiusY = diffY;
                                }
                                if (radiusY > radiusX)
                                    dX = radiusY;
                                else
                                    dX = radiusX;
                            }
                            var cPoints = ol.geom.Polygon.fromCircle(new ol.geom.Circle(center, dX, 'XY')).getCoordinates();
                            var geom = funnelIconFeature.getGeometry();
                            geom.setCoordinates(cPoints);
                            funnelIconFeature.setGeometry(geom);
                        }
                    }
                    //end
                    _this_1.testingDataPush.push(funnelIconFeature); //@todo need to remove this usage under std model 
                    if (addResource.resourceType != "Map") {
                        cameraFunnelsListForLayer.push(funnelIconFeature);
                    }
                    else {
                        linkedMapsListForLayer.push(funnelIconFeature);
                    }
                }
            };
            this.loadMapItemImage = function (mapResource, index, CameraIconsListForLayer) {
                var mapImages = mapResource.mapItems[index].images;
                var resourceId = mapImages.resourceId;
                //showOnMaps
                var isCurrentResource = false;
                if (MapsOpenLayers.monitoringCameraResource && MapsOpenLayers.monitoringCameraResource.length > 0 && _this_1.fromMonitoring) {
                    var objCurrentView_1 = _this_1.monitoringViewContainer.getActiveView();
                    var selectedMapObject = MapsOpenLayers.monitoringCameraResource.filter(function (r) {
                        return (r.map == mapResource._id && r.resource == resourceId && r.view == objCurrentView_1._id);
                    });
                    if (selectedMapObject && selectedMapObject.length > 0) {
                        isCurrentResource = true;
                        //clear existing cameras
                        while (MapsOpenLayers.monitoringCameraResource.length > 0) {
                            MapsOpenLayers.monitoringCameraResource.pop();
                        }
                    }
                }
                var dataFromBag = angular.copy(mapResource.mapItems[index].images.propertyBagDetails);
                var coordinates = _this_1.calculateRelativeCoordinates(dataFromBag.coordinates);
                var rotation = (dataFromBag.rotation == undefined || dataFromBag.rotation == null) ? 0 : parseInt(dataFromBag.rotation);
                var flip = (dataFromBag.flip && dataFromBag.flip == 'True') ? true : dataFromBag.flip ? true : false;
                var flop = (dataFromBag.flop && dataFromBag.flop == 'True') ? true : dataFromBag.flop ? true : false;
                //Resize Icon
                var scaleValue = dataFromBag.scaleValue ? dataFromBag.scaleValue : null;
                var scaleCoords = dataFromBag.scaleCoords ? dataFromBag.scaleCoords : null;
                //Resize Icon End
                //    const addResource: any = this.globalDataAccessPoint.resources.byGuid[mapImages.resourceId];
                var addResource = mapResource.mapItems[index].resource;
                console.log("actual resource object: ", addResource);
                if (!addResource)
                    return;
                //circle for 360
                var check360Camera = _this_1.is360CameraItem(addResource);
                var icon360Camera = 'images/05A_360CameraActive.png';
                var icon360MixedCamera = '11_360CameraActive.png';
                //   let iconThermal = new CameraIcons(this.mapResource.mapIconSize).iconThermalStyle;
                //   let iconMobile = new CameraIcons(this.mapResource.mapIconSize).iconMobileStyle;
                var CameraIconstyle;
                if (addResource.isThermalRadar) {
                    //   CameraIconstyle = iconThermal;
                    //check360Camera = true;
                }
                else if (addResource.isMobileDevice) {
                    //  CameraIconstyle = iconMobile;
                    //check360Camera = true;
                }
                else if ((addResource.resourceType === 'MixedVideoSource' || addResource.resourceType === 'PtzMixedVideoSource' && check360Camera === true)) {
                    CameraIconstyle = new ol.style.Style({
                        image: new ol.style.Icon({
                            anchor: [0.5, 0.48],
                            size: new CameraIcons(_this_1.mapResource.mapIconSize).getIconSize(_this_1.mapResource.mapIconSize),
                            opacity: 1,
                            scale: new CameraIcons(_this_1.mapResource.mapIconSize).getIconScale(_this_1.mapResource.mapIconSize),
                            src: icon360MixedCamera,
                            rotation: 0
                        }),
                        zIndex: 2
                    });
                    ;
                }
                else if (check360Camera) {
                    CameraIconstyle = new ol.style.Style({
                        image: new ol.style.Icon({
                            anchor: [0.5, 0.48],
                            size: new CameraIcons(_this_1.mapResource.mapIconSize).getIconSize(_this_1.mapResource.mapIconSize),
                            opacity: 1,
                            scale: new CameraIcons(_this_1.mapResource.mapIconSize).getIconScale(_this_1.mapResource.mapIconSize),
                            src: icon360Camera,
                            rotation: 0
                        }),
                        zIndex: 2
                    });
                }
                else {
                    CameraIconstyle = _this_1.getResourceStyle(addResource);
                }
                var iconFeature = new ol.Feature({
                    id: resourceId,
                    geometry: new ol.geom.Point(coordinates),
                    name: addResource.name,
                    type: "iconFeature",
                    resourceId: resourceId,
                    alarm: false,
                    iconStyle: CameraIconstyle,
                    description: check360Camera ? 'Camera360' : 'Other',
                    nvrName: addResource.nvrName,
                    resourceType: addResource.resourceType,
                    presetData: addResource.presets
                });
                iconFeature.setStyle(CameraIconstyle);
                iconFeature.setId(resourceId);
                iconFeature.set('defaultStyle', CameraIconstyle);
                iconFeature.set('rotation', rotation);
                _this_1.testingDataPush.push(iconFeature);
                iconFeature.set("initFlipValue", flip);
                iconFeature.set("initFlopValue", flop);
                iconFeature.set("scaleValue", scaleValue);
                if (scaleCoords) {
                    iconFeature.set("scaleCoords", scaleCoords);
                }
                iconFeature.set("actualCoordinates", coordinates);
                iconFeature.set("isCurrentResource", isCurrentResource);
                CameraIconsListForLayer.push(iconFeature);
            };
            this.loadMapItemText = function (mapResource, index, stickyNotesListForLayer, notesListForLayer) {
                var dataFromBag = angular.copy(mapResource.mapItems[index].stickyNotes.propertyBagDetails);
                var id = dataFromBag.id == undefined ? null : dataFromBag.id;
                var coordinates = _this_1.calculateRelativeCoordinates(dataFromBag.coordinates);
                var description = dataFromBag.description == undefined ? "" : dataFromBag.description;
                var despFonts = dataFromBag.despFonts == undefined ? null : dataFromBag.despFonts;
                var despFontColor = dataFromBag.despFontColor == undefined ? null : dataFromBag.despFontColor;
                var dTextCoord1 = dataFromBag.coordinates[0][4][0];
                var dTextCoord2 = dataFromBag.coordinates[0][3][0];
                var stickyNotesStyle = new ol.style.Style({
                    fill: new ol.style.Fill({
                        color: 'rgba(255, 255, 255, 0.2)',
                    }),
                    stroke: new ol.style.Stroke({
                        color: '#ffcc33',
                        width: 2
                    }),
                    text: new ol.style.Text({
                        font: '14px Arial Italic',
                        fill: new ol.style.Fill({ color: '#1a2028' }),
                        text: '',
                        textAlign: 'center',
                        textBaseline: 'middle'
                    }),
                    image: new ol.style.RegularShape({
                        points: 4,
                        radius: 30,
                        fill: new ol.style.Fill({ color: [255, 255, 255, 0] }),
                        stroke: new ol.style.Stroke({ color: [53, 140, 216, 0.5], width: 2 })
                    }),
                });
                var stickyNoteFeature = new ol.Feature({
                    id: id,
                    geometry: new ol.geom.Polygon(coordinates),
                    type: 'stickyNoteFeature'
                });
                if (description == 'Please double click to update notes') {
                    description = "";
                }
                stickyNotesStyle.getText().setText("");
                stickyNotesStyle.getText().setFont(despFonts);
                stickyNotesStyle.getText().getFill().setColor(despFontColor);
                stickyNoteFeature.setStyle(stickyNotesStyle);
                stickyNoteFeature.setId(id);
                stickyNoteFeature.set("textvalue", description);
                stickyNotesListForLayer.push(stickyNoteFeature);
                //text over polygon
                var noteStyle = new ol.style.Style({
                    text: new ol.style.Text({
                        font: '14px Arial Italic',
                        fill: new ol.style.Fill({ color: '#1a2028' }),
                        text: 'Please double click to update notes',
                        textAlign: 'center',
                        textBaseline: 'middle'
                    })
                });
                var noteFeature = new ol.Feature({
                    id: id,
                    geometry: new ol.geom.Polygon([coordinates[0].slice(1, 7)]),
                    type: "note"
                });
                if (description == 'Please double click to update notes') {
                    description = "";
                }
                var diffCoords = dTextCoord1 - dTextCoord2;
                var textSize = Math.ceil((MapsOpenLayers.TEXT_DELTA / 100.0) * diffCoords);
                noteStyle.getText().setText(_this_1.divideString(description, textSize, "\n"));
                if (!_this_1.fromMonitoring)
                    noteStyle.getText().setFont(despFonts);
                else {
                    var fontDescPart = despFonts.split(" ");
                    var size = parseInt(fontDescPart[0].substring(0, fontDescPart[0].length - 2));
                    console.log('fsize', size);
                    var relSize = size; //this.getRelativeFontSize(size);
                    despFonts = relSize + "px" + " " + fontDescPart.slice(1, fontDescPart.length).join(" ");
                    noteStyle.getText().setFont(despFonts);
                }
                noteStyle.getText().getFill().setColor(despFontColor);
                noteFeature.setStyle(noteStyle);
                noteFeature.setId(id);
                notesListForLayer.push(noteFeature);
                _this_1.stickeyCount = true;
            };
            this.createOrUseMap = function (resource, mapelement, paneObj) {
                //      //store alarm map one instance per resource
                //      if (paneObj.domContainer.className == "player-div") {
                //          let mapDataAlarm = this.globalDataAccessPoint.olMapDataAlarm.filter(function (item) {
                //              return (item.id == resource._id);
                //          });
                //          let isLinkedMap: any = localStorage.getItem("isLinkedMap");
                //          let showOnMap = localStorage.getItem("showONMapPass");
                //          if ((!mapDataAlarm || mapDataAlarm.length == 0 || isLinkedMap == "true" || showOnMap == "true")) {
                //              this.map = this.createMap(mapelement);
                //              if (!mapDataAlarm || mapDataAlarm.length == 0)
                //                  this.globalDataAccessPoint.olMapDataAlarm.push({ id: resource._id, instance: this.map });
                //              localStorage.removeItem("isLinkedMap");
                //              localStorage.removeItem("showONMapPass");
                //          }
                //          else {
                //              this.existingMap = true;
                //              this.map = mapDataAlarm[0].instance;
                //          }
                //      } else {
                //          let mapData = this.globalDataAccessPoint.olMapData.filter(function (item) {
                //              return (item.id == resource._id && item.paneId == paneObj.id);
                //          });
                //          let isLinkedMap: any = localStorage.getItem("isLinkedMap");
                //          let showOnMap = localStorage.getItem("showONMapPass");
                //          if ((!mapData || mapData.length == 0 || isLinkedMap == "true" || showOnMap == "true")) {
                _this_1.map = _this_1.createMap(mapelement);
                //              if (!mapData || mapData.length == 0)
                //                  this.globalDataAccessPoint.olMapData.push({ id: resource._id, paneId: paneObj.id, instance: this.map });
                //              localStorage.removeItem("isLinkedMap");
                //              localStorage.removeItem("showONMapPass");
                //          }
                //          else {
                //              this.existingMap = true;
                //              this.map = mapData[0].instance;
                //          }
                //      }
            };
            //  private refreshMapWithBg = () => {
            //      if (!!this.mapResource.mapType && this.mapResource.mapType == mapDefaults.mapTypes.geo) {
            //          this.bgMapImageLayer = new ol.layer.Tile({
            //              source: new ol.source.OSM()
            //          })
            //          // this.map.addLayer(this.bgMapImageLayer);
            //          let home: any = this.getInitialHomePosition()
            //          var view = new ol.View({
            //              center: [0, 0],
            //              zoom: 2,
            //              minZoom: 2
            //          });
            //          if (!home.initial) {
            //              view = new ol.View({
            //                  center: home.center,
            //                  zoom: home.zoom,
            //                  minZoom: 2
            //              });
            //          }
            //          //this.bgMapImageLayer.set('name', mapDefaults.mapLayers.mapLayer);
            //          this.map.setView(view);
            //          this.init();
            //      }
            //      else {
            //          let fitval = false;
            //          if (this.mapResource.mapImage != undefined && this.mapResource.mapImage.hasOwnProperty('fit')) {
            //              fitval = this.mapResource.mapImage.fit;
            //          } else if (this.mapResource.MapImage != undefined && this.mapResource.MapImage.hasOwnProperty('Fit')) {
            //              fitval = this.mapResource.MapImage.Fit;
            //          }
            //          this.staticImagePoints = this.getCurrentImageExtentPoints(fitval);
            //          this.map.set("actualExtent", (<any>Object).assign([], this.actualExtent));
            //          this.map.set("modifiedExtent", (<any>Object).assign([], this.modifiedExtend));
            //          this.bgImageProjection = new ol.proj.Projection({
            //              code: 'xkcd-image',
            //              units: 'pixels',
            //              extent: this.staticImagePoints
            //          });
            //          //this.map.getView().calculateExtent(this.staticImagePoints);
            //          //this.map.getView().setCenter(ol.extent.getCenter(this.staticImagePoints));
            //          let source: any = this.bgMapImageLayer.getSource();
            //          //console.log("source   ->  ", source)
            //          //source.imageExtent = this.staticImagePoints;
            //          //source.projection = this.bgImageProjection;
            //          //this.bgMapImageLayer.setSource(source);
            //          const mapView = new ol.View({
            //              projection: this.bgImageProjection,
            //              center: ol.extent.getCenter(this.staticImagePoints),
            //              zoom: 1,
            //              resolution: 1,
            //              extent: this.staticImagePoints //== prevent dragging image outside the viewport
            //          });
            //          this.map.setView(mapView);
            //          this.createBGLayerImage(source.image_.src_, fitval);
            //      }
            //      let center = this.map.getView().getCenter();
            //      let zoom = this.map.getView().getZoom();
            //      this.map.set("defaultCenter", center);
            //      this.map.set("defaultZoom", zoom);
            //      //this.defaultHome.center = center;
            //      //this.defaultHome.zoom = zoom;
            //      //end
            //  }
            //  private adjustImageCoordinates = (layer) => {
            //      let s = layer.getSource();
            //      let f = s.getFeatures();
            //      f.forEach((fItem: any) => {
            //          let mapItem = this.mapResource.mapItems.filter((mItem: any) => {
            //              return (mItem && mItem.images && mItem.images.resourceId == fItem.get("resourceId"));
            //          });
            //          if (mapItem && mapItem.length > 0) {
            //              let addResource: any = this.globalDataAccessPoint.resources.byGuid[fItem.get("resourceId")];
            //              let check360Camera = this.is360CameraItem(addResource);
            //              let icon360Camera = new CameraIcons(this.mapResource.mapIconSize).icon360Style;
            //              let icon360MixedCamera = new CameraIcons(this.mapResource.mapIconSize).icon360MixedStyle;
            //              let CameraIconstyle;
            //              if ((addResource.resourceType === 'MixedVideoSource' || addResource.resourceType === 'PtzMixedVideoSource') && check360Camera === true) {
            //                  CameraIconstyle = icon360MixedCamera;
            //              } else if (check360Camera) {
            //                  CameraIconstyle = icon360Camera;
            //              } else {
            //                  CameraIconstyle = this.getResourceStyle(addResource);
            //              }
            //              if (addResource.changeIcon && addResource.changeIcon.length > 0) {
            //                  let alarm = addResource.changeIcon.filter((item) => {
            //                      return (item.Type == "alarm");
            //                  });
            //                  let idle = addResource.changeIcon.filter((item) => {
            //                      return (item.Type == "idle");
            //                  });
            //                  var imgSrc = "";
            //                  if (idle) {
            //                      imgSrc = this.getIdleResourceStyle(addResource);
            //                  } else if (alarm) {
            //                      imgSrc = this.getAlarmResourceStyle(addResource);
            //                  } else {
            //                      imgSrc = this.getActiveResourceStyle(addResource);
            //                  }
            //                  if (imgSrc != null && imgSrc != undefined && imgSrc != "") {
            //                      //let img: ol.style.Icon = CameraIconstyle.getImage();
            //                      CameraIconstyle.setImage(new ol.style.Icon({
            //                          anchor: [0.5, 0.48],
            //                          size: new CameraIcons(this.mapResource.mapIconSize).getIconSize(this.mapResource.mapIconSize),
            //                          opacity: 1,
            //                          scale: new CameraIcons(this.mapResource.mapIconSize).getIconScale(this.mapResource.mapIconSize),
            //                          src: imgSrc,
            //                          rotation: 0
            //                      }));
            //                  }
            //              }
            //              let scaleValue: any = fItem.get("scaleValue");
            //              if (scaleValue) {
            //                  let imgStye = CameraIconstyle.getImage();
            //                  imgStye.setScale(scaleValue);
            //                  CameraIconstyle.setImage(imgStye);
            //              }
            //              fItem.getGeometry().setCoordinates(this.calculateRelativeCoordinates((<any>Object).assign([], mapItem[0].images.propertyBagDetails.coordinates)));
            //              fItem.setStyle(CameraIconstyle);
            //          }
            //      });
            //  }
            //  private adjustPolygonCoordinates = (layer) => {
            //      let s = layer.getSource();
            //      let f = s.getFeatures();
            //      f.forEach((fItem: any) => {
            //          let mapItem = this.mapResource.mapItems.filter((mItem: any) => {
            //              return (mItem && mItem.funnels && mItem.funnels.resourceId == fItem.get("resourceId"));
            //          });
            //          if (mapItem && mapItem.length > 0) {
            //              let addResource: any = this.globalDataAccessPoint.resources.byGuid[fItem.get("resourceId")];
            //              let check360Camera = (addResource && addResource.sourceProperties && addResource.sourceProperties.length > 0 && addResource.sourceProperties[0] === 'Camera360');
            //              let coords = this.calculateRelativeCoordinates(angular.copy(mapItem[0].funnels.propertyBagDetails.coordinates));
            //              fItem.getGeometry().setCoordinates(coords);
            //              if (addResource.resourceType != "Map" && !addResource.isThermalRadar && !addResource.isMobileDevice) {
            //                  if (check360Camera && coords[0].length == 3) {
            //                      let center = coords[0][0];
            //                      let dX = 0.2;
            //                      if (this.fromMonitoring && this.mapResource.mapType != mapDefaults.mapTypes.geo) {
            //                          let perX = (0.2 * 100) / this.actualExtent[2];
            //                          dX = (perX / 100) * this.modifiedExtend[2];
            //                      }
            //                      else if (this.fromMonitoring && this.mapResource.mapType == mapDefaults.mapTypes.geo) {
            //                          //override radius by calculating max axis difference
            //                          let radiusX: any = 0;
            //                          let radiusY: any = 0;
            //                          for (let i = 0; i < coords[0].length; i++) {
            //                              let diffX = Math.abs(coords[0][0][0] - coords[0][i][0]);
            //                              let diffY = Math.abs(coords[0][0][1] - coords[0][i][1]);
            //                              if (radiusX < diffX)
            //                                  radiusX = diffX;
            //                              if (radiusY < diffY)
            //                                  radiusY = diffY;
            //                          }
            //                          if (radiusY > radiusX)
            //                              dX = radiusY;
            //                          else
            //                              dX = radiusX;
            //                      }
            //                      let cPoints = ol.geom.Polygon.fromCircle(new ol.geom.Circle(center, dX, 'XY')).getCoordinates();
            //                      let geom: any = fItem.getGeometry();
            //                      geom.setCoordinates(cPoints);
            //                      fItem.setGeometry(geom);
            //                  } else if (!check360Camera && coords[0].length > 3) {
            //                      let fExtent = fItem.getGeometry().getExtent();
            //                      let center = ol.extent.getCenter(fExtent);
            //                      let dX = 0.2;
            //                      let dY = 0.2;
            //                      if (this.fromMonitoring && this.mapResource.mapType != mapDefaults.mapTypes.geo) {
            //                          let perX = (0.2 * 100) / this.actualExtent[2];
            //                          let perY = (0.2 * 100) / this.actualExtent[3];
            //                          dX = (perX / 100) * this.modifiedExtend[2];
            //                          dY = (perY / 100) * this.modifiedExtend[3];
            //                      } else if (this.mapResource.mapType == mapDefaults.mapTypes.geo) {
            //                          dX = Math.abs(center[0] - coords[0][0][0]);
            //                          dY = Math.abs(center[1] - coords[0][0][1]);
            //                          if (dY == 0)
            //                              dY = dX;
            //                          else if (dX == 0)
            //                              dX = dY;
            //                      }
            //                      let cPoints: any = new ol.geom.Polygon([[center, [center[0] + dX, center[1] - dY], [center[0] + dX, center[1] + dY]]]).getCoordinates();
            //                      let geom: any = fItem.getGeometry();
            //                      geom.setCoordinates(cPoints);
            //                      fItem.setGeometry(geom);
            //                  }
            //              }
            //          }
            //      });
            //  }
            //  private adjustLinkedMapsCoordinates = (layer) => {
            //      let s = layer.getSource();
            //      let f = s.getFeatures();
            //      let takenMapItems = [];
            //      f.forEach((fItem: any) => {
            //          if (fItem.get("resourceId")) {
            //              let mapItem = this.mapResource.mapItems.filter((mItem: any) => {
            //                  return (mItem.funnels && mItem.funnels.resourceId == fItem.get("resourceId") && takenMapItems.indexOf(mItem) < 0);
            //              });
            //              if (mapItem && mapItem.length > 0) {
            //                  takenMapItems.push(mapItem[0]);
            //                  fItem.getGeometry().setCoordinates(this.calculateRelativeCoordinates(angular.copy(mapItem[0].funnels.propertyBagDetails.coordinates)));
            //              }
            //          }
            //          else if (fItem.get("id")) {
            //              let mapItem = this.mapResource.mapItems.filter((mItem: any) => {
            //                  return (mItem.funnels && mItem.funnels.propertyBagDetails && mItem.funnels.propertyBagDetails.id == fItem.get("id") && takenMapItems.indexOf(mItem) < 0);
            //              });
            //              if (mapItem && mapItem.length > 0) {
            //                  takenMapItems.push(mapItem[0]);
            //                  fItem.getGeometry().setCoordinates(this.calculateRelativeCoordinates(angular.copy(mapItem[0].funnels.propertyBagDetails.coordinates)));
            //              }
            //          }
            //      });
            //  }
            //  private adjustStickyNoteCoordinates = (polygonLayer, textlayer) => {
            //      let sL = polygonLayer.getSource();
            //      let fL = sL.getFeatures();
            //      let tL = textlayer.getSource();
            //      let fT = tL.getFeatures();
            //      fL.forEach((fItem: any) => {
            //          let mapItem = this.mapResource.mapItems.filter((mItem: any) => {
            //              return (mItem.stickyNotes && mItem.stickyNotes.propertyBagDetails && mItem.stickyNotes.propertyBagDetails.id == fItem.get("id"));
            //          });
            //          if (mapItem && mapItem.length > 0) {
            //              let coords = this.calculateRelativeCoordinates(angular.copy(mapItem[0].stickyNotes.propertyBagDetails.coordinates));
            //              let fontDesc = mapItem[0].stickyNotes.propertyBagDetails.despFonts;
            //              fItem.getGeometry().setCoordinates(coords);
            //              fT.forEach((tItem) => {
            //                  if (tItem.get("id") == fItem.get("id")) {
            //                      tItem.getGeometry().setCoordinates([coords[0].slice(1, 7)]);
            //                      if (fontDesc) {
            //                          let style = tItem.getStyle();
            //                          let fontDescPart = fontDesc.split(" ");
            //                          let size = parseInt(fontDescPart[0].substring(0, fontDescPart[0].length - 2));
            //                          let relSize = this.getRelativeFontSize(size);
            //                          fontDesc = relSize + "px" + " " + fontDescPart.slice(1, fontDescPart.length).join(" ");
            //                          style.getText().setFont(fontDesc);
            //                          tItem.setStyle(style);
            //                      }
            //                  }
            //              })
            //          }
            //      });
            //  }
            this.homeButtonPressed = function (e) {
                try {
                    var pane = _this_1.map.get("map_pane");
                    //this.globalDataAccessPoint.mapCustomHomes[this.map.get("mapId") + '_' + pane.id] = null;
                    //delete this.globalDataAccessPoint.mapCustomHomes[this.map.get("mapId") + '_' + pane.id];
                    //localStorage.setItem("mapCustomHomes", JSON.stringify(this.globalDataAccessPoint.mapCustomHomes));
                    localStorage.removeItem(("customhome_" + _this_1.map.get("mapId") + "_" + _this_1.getLayoutOfCurrentPane()));
                }
                catch (e) {
                    console.log("error in removing object key ", e);
                }
                var home = _this_1.getInitialHomePosition();
                var view = _this_1.map.getView();
                if (home && !home.initial) {
                    var zoom = home.zoom;
                    var coordinates = Object.assign([], home.center);
                    //console.log("coordinates : ", coordinates);
                    if (_this_1.fromMonitoring) {
                        coordinates = _this_1.calculateRelativeCoordinates(coordinates);
                    }
                    view.animate({ zoom: zoom, center: coordinates, duration: 200 }, function () { });
                }
                else {
                    var center = _this_1.map.get("defaultCenter");
                    var zoom = _this_1.map.get("defaultZoom");
                    //const zoom = this.defaultHome.zoom;
                    var coordinates = Object.assign([], center ? center : _this_1.defaultHome.center);
                    view.animate({ zoom: zoom ? zoom : _this_1.defaultHome.zoom, center: coordinates, duration: 200 }, function () { });
                }
            };
            this.searchButtonPressed = function (e) {
                var controls = _this_1.map.getControls();
                if (!controls || !controls.array_ || controls.array_.length == 0)
                    return;
                for (var i = 0; i < controls.array_.length; i++) {
                    if (controls.array_[i].get("name") == "mapGeocoder") {
                        $(controls.array_[i].element).toggle();
                    }
                    if (controls.array_[i].get("name") == "searchButtonControl") {
                        $(controls.array_[i].element).toggleClass("ol-active-btn");
                    }
                }
            };
            this.updateCameras = function (payload) {
                var resourceId = payload.resourceId;
                var status = payload.status.toLowerCase() == 'offline' ? 'No' : 'Yes';
                var addResource = _this_1.mObjectPane.resourcesArray.filter(function (item) {
                    return item.id == resourceId;
                });
                var check360Camera = _this_1.is360CameraItem(addResource);
                _this_1.map.getLayers().forEach(function (layer) {
                    if (layer instanceof ol.layer.Vector && layer.get('name') == "cameraImageLayer") {
                        var source = layer.getSource();
                        var features = source.getFeatures();
                        features.forEach(function (featureItem) {
                            if (featureItem.values_.type === 'iconFeature' && featureItem.values_.resourceId == resourceId) {
                                setTimeout(function () {
                                    setTimeout(function () {
                                        if (addResource.resourceType != 'DigitalInput' && addResource.resourceType != 'RelayOutput' && addResource.resourceType != 'VAXDoorResource' && addResource.resourceType != 'LPRSensorResource' && addResource.resourceType != 'VAXActionPlanResource') {
                                            var style = featureItem.getStyle();
                                            var resourceStyle = _this_1.getActiveIdelMixedCamera(status, addResource, check360Camera);
                                            style.setImage(new ol.style.Icon({
                                                anchor: [0.5, 0.48],
                                                size: new CameraIcons(_this_1.mapResource.mapIconSize).getIconSize(_this_1.mapResource.mapIconSize),
                                                opacity: 1,
                                                scale: style.getImage().getScale(),
                                                src: new CameraIcons(_this_1.mapResource.mapIconSize).getIconStyle(resourceStyle, _this_1.mapResource.mapIconSize),
                                                rotation: style.getImage().getRotation()
                                            }));
                                            featureItem.setStyle(style);
                                        }
                                    }, 500);
                                });
                            }
                        });
                    }
                });
            };
            this.setPresetDataForResource = function (payload) {
                var resourceId = payload.resourceId;
                var presetList = payload.presets;
                var ptzResetItems = [];
                _this_1.map.getLayers().forEach(function (layer) {
                    if (layer instanceof ol.layer.Vector && layer.get('name') == "cameraImageLayer") {
                        var source = layer.getSource();
                        var feature = source.getFeatures();
                        feature.forEach(function (featureItem) {
                            if (featureItem.values_.type === 'iconFeature' && featureItem.values_.resourceId == resourceId) {
                                presetList.forEach(function (element) {
                                    ptzResetItems.push({ text: element.presetName, data: [featureItem, element], callback: _this_1.onPresetClick });
                                });
                                featureItem.set("presetData", ptzResetItems);
                            }
                        });
                    }
                });
            };
            this.setShowOnMap = function (imageFeatureLayer, resId) {
                var source = imageFeatureLayer.getSource();
                var features = source.getFeatures();
                //  if (MapsOpenLayers.monitoringCameraResource && MapsOpenLayers.monitoringCameraResource.length > 0 && this.fromMonitoring) {
                //      //let objCurrentView = this.monitoringViewContainer.getActiveView();
                //      features.forEach((fItem: any) => {
                //          let resourceId = fItem.values_.resourceId;
                //          var selectedMapObject = MapsOpenLayers.monitoringCameraResource.filter((r: any) => {
                //              return (r.map == this.mapResource._id && r.resource == resourceId && r.resource == resId);
                //          })
                //          if (selectedMapObject && selectedMapObject.length > 0) {
                //              setTimeout(() => {
                //                  this.flash(this.map, fItem, 3000);
                //              }, 500);
                //              //clear existing cameras
                //              while (MapsOpenLayers.monitoringCameraResource.length > 0) {
                //                  MapsOpenLayers.monitoringCameraResource.pop();
                //              }
                //          }
                //      });
                //  }
                //   this.setPollData(this.mapResource).then(() => {
                features.forEach(function (featureItem) {
                    //TODO: need to update the below condition as per vax
                    if (featureItem.values_.type === 'iconFeature' && featureItem.values_.resourceId == resId) {
                        //let addResource: any = this.globalDataAccessPoint.resources.byGuid[featureItem.values_.resourceId];
                        setTimeout(function () {
                            setTimeout(function () {
                                _this_1.flash(_this_1.map, featureItem, 3000);
                            }, 500);
                        });
                    }
                });
                //var isCurrentResource = false;
                //if (MapsOpenLayers.monitoringCameraResource && MapsOpenLayers.monitoringCameraResource.length > 0 && this.fromMonitoring) {
                //    let objCurrentView = this.monitoringViewContainer.getActiveView();
                //    for
                //    var selectedMapObject = MapsOpenLayers.monitoringCameraResource.filter(function (r) {
                //        return (r.map == this.mapResource._id && r.resource == resourceId && r.view == objCurrentView._id);
                //    })
                //    if (selectedMapObject && selectedMapObject.length > 0) {
                //        isCurrentResource = true;
                //        //clear existing cameras
                //        while (MapsOpenLayers.monitoringCameraResource.length > 0) {
                //            MapsOpenLayers.monitoringCameraResource.pop();
                //        }
                //    }
                //}
            };
            this.setHightlightIconOnfunnelClick = function (objPane) {
                //      //if (!!this.mapResource.mapType && this.mapResource.mapType == mapDefaults.mapTypes.geo) return
                _this_1.cameraHighlightSource = new ol.source.Vector({
                    features: [],
                    wrapX: false
                });
                //      //== Then creating layer from the Vector
                _this_1.cameraHightlightLayer = new ol.layer.Vector({
                    source: _this_1.cameraHighlightSource
                });
                _this_1.cameraHightlightLayer.setZIndex(4);
                _this_1.map.addLayer(_this_1.cameraHightlightLayer);
                _this_1.map.on("click", function (e) {
                    _this_1.cameraHighlightSource.clear();
                    var layerObj = MapsOpenLayers.getMapLayerByName(_this_1.map, 'funnelIconLayer');
                    var defaultVisiblity = true;
                    if (layerObj) {
                        defaultVisiblity = layerObj.getVisible();
                        if (!defaultVisiblity)
                            layerObj.setVisible(true);
                    }
                    setTimeout(function () {
                        _this_1.map.forEachFeatureAtPixel(e.pixel, function (feature, layer) {
                            if (layer.get('name') == 'funnelIconLayer') {
                                var rId_1 = feature.get("resourceId");
                                var resObj = objPane.resource.mapItems[0].resource;
                                for (var i = 0; i < objPane.resource.mapItems.length; i++) {
                                    if (objPane.resource.mapItems[i].resource && objPane.resource.mapItems[i].resource.id == rId_1) {
                                        resObj = objPane.resource.mapItems[i].resource;
                                        resObj._resourceType = resObj.resourceType;
                                    }
                                }
                                var hasPlayLiveRestriction = _this_1.permissionsService.hasPlayliveRestriction(resObj);
                                if (!hasPlayLiveRestriction) {
                                    _this_1.map.getLayers().forEach(function (layer) {
                                        if (layer instanceof ol.layer.Vector && layer.get("name") == 'cameraImageLayer') {
                                            var source = layer.getSource();
                                            var features = source.getFeatures();
                                            features.forEach(function (featureItem) {
                                                if (featureItem.get("resourceId") == rId_1) {
                                                    var geom = featureItem.getGeometry();
                                                    var coord = geom.getCoordinates();
                                                    var dX = 0.05;
                                                    if (_this_1.fromMonitoring && _this_1.mapResource.mapType != 'Geo') {
                                                        var perX = (dX * 100) / _this_1.actualExtent[2];
                                                        dX = (perX / 100) * _this_1.modifiedExtend[2];
                                                    }
                                                    else {
                                                        dX = 50; //for Geo map
                                                    }
                                                    var cameraHightlightFeature = new ol.Feature({
                                                        id: "cameraHightlight" + rId_1,
                                                        geometry: new ol.geom.Point(coord),
                                                        name: "cameraHightlight" + rId_1,
                                                        type: "cameraHightlight",
                                                        resourceId: "cameraHightlight" + rId_1
                                                    });
                                                    var style = new ol.style.Style({
                                                        image: new ol.style.Icon({
                                                            anchor: [0.5, 0.48],
                                                            size: [30, 30],
                                                            opacity: 0.75,
                                                            scale: 1,
                                                            //  src: CameraIcons.HIGHLIGHTCAMERA_IMG,
                                                            src: 'images/yellow.png',
                                                            rotation: 0
                                                        }),
                                                        fill: new ol.style.Fill({ color: [226, 43, 138, 0.5] }),
                                                        stroke: new ol.style.Stroke({ color: [226, 43, 138, 0], width: 0 })
                                                    });
                                                    cameraHightlightFeature.setStyle(style);
                                                    _this_1.cameraHighlightSource.addFeature(cameraHightlightFeature);
                                                }
                                            });
                                        }
                                    });
                                }
                            }
                        });
                        if (!defaultVisiblity)
                            layerObj.setVisible(false);
                    }, 20);
                });
            };
            this.switchToLinkedMap = function (mapID, objPane, feature) {
                var newMapResource = {};
                //  if (!!newMapResource) {
                //      const view = this.map.getView();
                //      const featureCenter = ol.extent.getCenter(feature.getGeometry().getExtent());
                //      view.animate({ zoom: view.getZoom() + 0.3, center: featureCenter, duration: 500 },
                //          () => {
                //              objPane.resource = newMapResource;
                //              this.createMapForMonitoring(objPane);
                //          }
                //      );
                //  }
            };
            //  private disableControlPanel = () => {
            //      setTimeout(() => {
            //          try {
            //              if (this.mapElement)
            //                  this.mapElement.style.pointerEvents = "none";
            //              let domconfig = document.getElementById("vms-center-configuration-container");
            //              if (domconfig) {
            //                  domconfig.style.pointerEvents = "none";
            //                  domconfig.style.opacity = "0.7";
            //              }
            //          }
            //          catch (e) { }
            //      }, 20);
            //  }
            //  private enableControlPanel = () => {
            //      setTimeout(() => {
            //          try {
            //              if (this.mapElement)
            //                  this.mapElement.style.pointerEvents = "all";
            //              let domconfig = document.getElementById("vms-center-configuration-container");
            //              if (domconfig) {
            //                  domconfig.style.pointerEvents = "all";
            //                  domconfig.style.opacity = "1";
            //              }
            //          }
            //          catch (e) { }
            //      }, 20);
            //  }
            this.adjustCurrentResourceStatus = function (layer) {
                var source = layer.getSource();
                var features = source.getFeatures();
                features.forEach(function (featureItem) {
                    var addResource = _this_1.globalDataAccessPoint.resources.byGuid[featureItem.values_.id];
                    //if (featureItem.values_.id == addResource.id) {
                    if (featureItem.values_.id == addResource.id && featureItem.values_.type == 'iconFeature') {
                        setTimeout(function () {
                            _this_1.getRecordingStatus(featureItem, addResource.nvrId);
                        });
                    }
                });
            };
            this.isSourceIdInMapItems = function (id) {
                if (!id)
                    return;
                if (!_this_1.mapResource || !_this_1.mapResource.mapItems || _this_1.mapResource.mapItems.length == 0)
                    return;
                var isAvail = false;
                _this_1.mapResource.mapItems.forEach(function (item) {
                    if (item == null)
                        return;
                    if (item.type != "MapItemImage")
                        return;
                    if (item.images && item.images.resourceId == id) {
                        isAvail = true;
                    }
                });
                return isAvail;
            };
            //  private registerDeviceChangedEvents = () => {
            //      let deviceChangeTimer: any = null;
            //      let timerValue: any = 60000;
            //      let lprAlarmInfoFromEvent: any = "";
            //      let sourceIdFromLPREvent: any = "";
            //      let vaxAlarmInfoFromEvent: any = "";
            //      let sourceIdFromVAXEvent: any = "";
            //      this.eventDispatcher.on("INTERNAL_DEVICE_CHANGED", (data) => {
            //          var sExists = false;
            //          if (!data || data.length == 0) return;
            //          for (var i = 0; i < data.length; i++) {
            //              if (this.isSourceIdInMapItems(data[i].sourceId)) {
            //                  sExists = true;
            //              } 
            //          }
            //          if (!sExists) return;
            //          if (deviceChangeTimer) {
            //              clearTimeout(deviceChangeTimer);
            //              deviceChangeTimer = null;
            //          }
            //          deviceChangeTimer = setTimeout(() => {
            //              this.map.getLayers().forEach((layer) => {
            //                  if (layer instanceof ol.layer.Vector && layer.get('name') == "cameraImagesLayer") {
            //                      let source = layer.getSource();
            //                      let feature = source.getFeatures();
            //                      this.setPollData(this.mapResource).then(() => {
            //                          feature.forEach((featureItem: any) => {
            //                              if (featureItem.values_.type === 'iconFeature') {
            //                                  let addResource: any = this.globalDataAccessPoint.resources.byGuid[featureItem.values_.resourceId];
            //                                  setTimeout(() => {
            //                                      this.getRecordingStatus(featureItem, addResource.nvrId);
            //                                  })
            //                              }
            //                          });
            //                      });
            //                  }
            //              });
            //          }, timerValue)
            //      });
            //      this.eventDispatcher.on("INTERNAL_" + ("digitalInput".toUpperCase()) + "_CHANGED", (data) => {
            //          if (!this.isSourceIdInMapItems(data.sourceId)) {
            //              //console.log("===>  No related source found on map");
            //              return;
            //          }
            //          //if (deviceChangeTimer) {
            //          //    clearTimeout(deviceChangeTimer);
            //          //    deviceChangeTimer = null;
            //          //}
            //          //deviceChangeTimer = setTimeout(() => {
            //          // console.log("INTERNAL_digital_CHANGED  inside map ", data);
            //          this.map.getLayers().forEach((layer) => {
            //              if (layer instanceof ol.layer.Vector && layer.get('name') == "cameraImagesLayer") {
            //                  let source = layer.getSource();
            //                  let feature = source.getFeatures();
            //                  feature.forEach((featureItem: any) => {
            //                      if (featureItem.values_.type === 'iconFeature' && featureItem.values_.resourceId == data.sourceId) {
            //                          let addResource: any = this.globalDataAccessPoint.resources.byGuid[featureItem.values_.resourceId];
            //                          // this.setPollData(this.mapResource).then(() => {
            //                          setTimeout(() => {
            //                              this.getRecordingStatus(featureItem, addResource.nvrId);
            //                          })
            //                          // });
            //                      }
            //                  });
            //              }
            //          });
            //          // }, timerValue)
            //      });
            //      this.eventDispatcher.on('INTERNAL_RelayOutput_CHANGED', (data) => {
            //          if (!this.isSourceIdInMapItems(data.sourceId)) {
            //              //console.log("===>  No related source found on map");
            //              return;
            //          }
            //          //if (deviceChangeTimer) {
            //          //    clearTimeout(deviceChangeTimer);
            //          //    deviceChangeTimer = null;
            //          //}
            //          //deviceChangeTimer = setTimeout(() => {
            //          //console.log("INTERNAL_RelayOutput_CHANGED  inside m map ", data);
            //          this.map.getLayers().forEach((layer) => {
            //              if (layer instanceof ol.layer.Vector && layer.get('name') == "cameraImagesLayer") {
            //                  let source = layer.getSource();
            //                  let feature = source.getFeatures();
            //                  feature.forEach((featureItem: any) => {
            //                      if (featureItem.values_.type === 'iconFeature' && featureItem.values_.resourceId == data._id) {
            //                          let addResource: any = this.globalDataAccessPoint.resources.byGuid[featureItem.values_.resourceId];
            //                          //this.setPollData(this.mapResource).then(() => {
            //                          setTimeout(() => {
            //                              this.getRecordingStatus(featureItem, addResource.nvrId);
            //                          })
            //                          //});
            //                      }
            //                  });
            //              }
            //          });
            //          //}, timerValue)
            //      });
            //      this.eventDispatcher.on("NVRRecordingONOFF", (data) => {
            //          if (deviceChangeTimer) {
            //              clearTimeout(deviceChangeTimer);
            //              deviceChangeTimer = null;
            //          }
            //          deviceChangeTimer = setTimeout(() => {
            //              //console.log("NVRRecordingONOFF  inside  map ", data);
            //              this.map.getLayers().forEach((layer) => {
            //                  if (layer instanceof ol.layer.Vector && layer.get('name') == "cameraImagesLayer") {
            //                      let source = layer.getSource();
            //                      let feature = source.getFeatures();
            //                      this.setPollData(this.mapResource).then(() => {
            //                          feature.forEach((featureItem: any) => {
            //                              if (featureItem.values_.type === 'iconFeature') {
            //                                  let addResource: any = this.globalDataAccessPoint.resources.byGuid[featureItem.values_.resourceId];
            //                                  setTimeout(() => {
            //                                      this.getRecordingStatus(featureItem, addResource.nvrId);
            //                                  })
            //                              }
            //                          });
            //                      });
            //                  }
            //              });
            //          }, timerValue);
            //      })
            //      this.eventDispatcher.on("NT_ET:NORECORDINGSETTINGS_VIDEOSOURCE", (data) => {
            //          //if (deviceChangeTimer) {
            //          //    clearTimeout(deviceChangeTimer);
            //          //    deviceChangeTimer = null;
            //          //}
            //          //deviceChangeTimer = setTimeout(() => {
            //          //console.log("NT_ET:NORECORDINGSETTINGS_VIDEOSOURCE  inside condition map ", data);
            //          this.map.getLayers().forEach((layer) => {
            //              if (layer instanceof ol.layer.Vector && layer.get('name') == "cameraImagesLayer") {
            //                  let source = layer.getSource();
            //                  let feature = source.getFeatures();
            //                  feature.forEach((featureItem: any) => {
            //                      if (featureItem.values_.type === 'iconFeature' && featureItem.values_.resourceId == data.sourceId) {
            //                          let addResource: any = this.globalDataAccessPoint.resources.byGuid[featureItem.values_.resourceId];
            //                          this.setPollData(this.mapResource).then(() => {
            //                              setTimeout(() => {
            //                                  this.getRecordingStatus(featureItem, addResource.nvrId);
            //                              })
            //                          });
            //                      }
            //                  });
            //              }
            //          });
            //          //}, timerValue)
            //      });
            //      this.eventDispatcher.on("NT_ET:NORECORDINGSETTINGS_AUDIOSOURCE", (data) => {
            //          //if (deviceChangeTimer) {
            //          //    clearTimeout(deviceChangeTimer);
            //          //    deviceChangeTimer = null;
            //          //}
            //          // deviceChangeTimer = setTimeout(() => {
            //          // console.log("NT_ET:NORECORDINGSETTINGS_AUDIOSOURCE inside condition on map ", data);
            //          this.map.getLayers().forEach((layer) => {
            //              if (layer instanceof ol.layer.Vector && layer.get('name') == "cameraImagesLayer") {
            //                  let source = layer.getSource();
            //                  let feature = source.getFeatures();
            //                  feature.forEach((featureItem: any) => {
            //                      if (featureItem.values_.type === 'iconFeature' && featureItem.values_.resourceId == data.sourceId) {
            //                          let addResource: any = this.globalDataAccessPoint.resources.byGuid[featureItem.values_.resourceId];
            //                          this.setPollData(this.mapResource).then(() => {
            //                              setTimeout(() => {
            //                                  //console.log("audio modified:  ", addResource);
            //                                  this.getRecordingStatus(featureItem, addResource.nvrId);
            //                              })
            //                          });
            //                      }
            //                  });
            //              }
            //          });
            //          // }, timerValue)
            //      });
            //      this.eventDispatcher.on("NT_NVR_CHANGED", (data) => {
            //          if (deviceChangeTimer) {
            //              clearTimeout(deviceChangeTimer);
            //              deviceChangeTimer = null;
            //          }
            //          deviceChangeTimer = setTimeout(() => {
            //              //console.log("NT_NVR_CHANGED  inside condition map ", data);
            //              this.map.getLayers().forEach((layer) => {
            //                  if (layer instanceof ol.layer.Vector && layer.get('name') == "cameraImagesLayer") {
            //                      let source = layer.getSource();
            //                      let feature = source.getFeatures();
            //                      this.setPollData(this.mapResource).then(() => {
            //                          feature.forEach((featureItem: any) => {
            //                              if (featureItem.values_.type === 'iconFeature') {
            //                                  let addResource: any = this.globalDataAccessPoint.resources.byGuid[featureItem.values_.resourceId];
            //                                  setTimeout(() => {
            //                                      this.getRecordingStatus(featureItem, addResource.nvrId);
            //                                  })
            //                              }
            //                          });
            //                      });
            //                  }
            //              });
            //          }, timerValue);
            //      });
            // Function for LPR Sensor and VAX Door Resource Event
            this.showAlarmforPartnerEvent = function (payload) {
                switch (payload.resourceType) {
                    case 'LPRSensorResource':
                        _this_1.LPR_EventIsTriggered(payload, payload.sourceId);
                        break;
                    case 'VAXDoorResource':
                        _this_1.VAX_EventIsTriggered(payload, payload.sourceId);
                        break;
                    case 'VAXActionPlanResource':
                        _this_1.VAXActionPlan_EventIsTriggered(payload, payload.sourceId);
                        break;
                }
            };
            //function for Normal Alarm Event for Thick client Map Resource
            this.showAlarmforThickClientEvent = function (payload) {
                console.log("Payload--->>>", payload);
                if (payload.resourceType == "VideoSource" || payload.resourceType == "PtzVideoSource" || payload.resourceType == "MixedVideoSource" || payload.resourceType == "PtzMixedVideoSource" || payload.resourceType == "VAXDoorResource" || payload.resourceType == "LPRSensorResource") {
                    _this_1.AlarmIsTriggeredEvent(payload);
                }
            };
            //function for device change -> icon change as per state 
            this.updateIconOnDeviceChange = function (payload) {
                var sourceId = payload.sourceId;
                var state = payload.state;
                var deviceChangeTimer = 100;
                var addResource = _this_1.mObjectPane.resourcesArray.filter(function (item) {
                    return item.id == sourceId;
                })[0];
                //let globalResource = this.globalDataAccessPoint.resources.byGuid[sourceId];
                var globalResource = _this_1.mObjectPane.resourcesArray.filter(function (item) {
                    return item.id == sourceId;
                })[0];
                addResource.state = state;
                globalResource.state = state;
                addResource.isActivated = state.toLowerCase() != 'off' ? true : false;
                globalResource.isActivated = state.toLowerCase() != 'off' ? true : false;
                if (deviceChangeTimer) {
                    clearTimeout(deviceChangeTimer);
                    deviceChangeTimer = null;
                }
                deviceChangeTimer = setTimeout(function () {
                    _this_1.map.getLayers().forEach(function (layer) {
                        if (layer instanceof ol.layer.Vector && layer.get('name') == "cameraImageLayer") {
                            var source = layer.getSource();
                            var feature = source.getFeatures();
                            feature.forEach(function (featureItem) {
                                if (featureItem.values_.type === 'iconFeature' && featureItem.values_.resourceId == sourceId) {
                                    setTimeout(function () {
                                        _this_1.getRecordingStatus(featureItem, undefined);
                                    });
                                }
                            });
                        }
                    });
                }, 100);
            };
            //      //LPR Events need to change
            this.LPR_EventIsTriggered = function (lprEventInfo, sourceId) {
                //      this.eventDispatcher.on("LPR_Event_Is_Triggered", (lprEventInfo, sourceId) => {
                //          //console.log("lprEventInfo====>", lprEventInfo);
                if (!_this_1.isSourceIdInMapItems(sourceId)) {
                    // console.log("===>  No related source found on map");
                    return;
                }
                var lprAlarmInfoFromEvent = lprEventInfo;
                var sourceIdFromLPREvent = sourceId;
                var deviceChangeTimer = 100;
                //console.log("lprAlarmInfoFromEvent====>", lprAlarmInfoFromEvent);
                if (deviceChangeTimer) {
                    clearTimeout(deviceChangeTimer);
                    deviceChangeTimer = null;
                }
                deviceChangeTimer = setTimeout(function () {
                    _this_1.map.getLayers().forEach(function (layer) {
                        //console.log("layer name==>", layer.get('name'));
                        if (layer instanceof ol.layer.Vector && layer.get('name') == "cameraImageLayer") {
                            var source = layer.getSource();
                            var feature = source.getFeatures();
                            //   this.setPollData(this.mapResource).then(() => {
                            feature.forEach(function (featureItem) {
                                if (featureItem.values_.type === 'iconFeature' && featureItem.values_.resourceId == sourceIdFromLPREvent) {
                                    // let addResource: any = this.globalDataAccessPoint.resources.byGuid[featureItem.values_.resourceId];
                                    setTimeout(function () {
                                        console.log("Called Show LPR Alarm Info ");
                                        _this_1.showLprAlarmInfoPopUp(featureItem, lprEventInfo, _this_1.map);
                                    });
                                }
                            });
                            //    });
                        }
                    });
                }, 100);
                //      });
            };
            //      //Access Control - VAX
            this.VAX_EventIsTriggered = function (vaxEventInfo, sourceId) {
                //      this.eventDispatcher.on("VAX_Event_Is_Triggered", (vaxEventInfo, sourceId) => {
                if (!_this_1.isSourceIdInMapItems(sourceId)) {
                    //console.log("===>  No related source found on map");
                    return;
                }
                var vaxAlarmInfoFromEvent = vaxEventInfo;
                var sourceIdFromVAXEvent = sourceId;
                var deviceChangeTimer = 100;
                if (deviceChangeTimer) {
                    clearTimeout(deviceChangeTimer);
                    deviceChangeTimer = null;
                }
                deviceChangeTimer = setTimeout(function () {
                    _this_1.map.getLayers().forEach(function (layer) {
                        if (layer instanceof ol.layer.Vector && layer.get('name') == "cameraImageLayer") {
                            var source = layer.getSource();
                            var feature = source.getFeatures();
                            //   this.setPollData(this.mapResource).then(() => {
                            feature.forEach(function (featureItem) {
                                //TODO: need to update the below condition as per vax
                                if (featureItem.values_.type === 'iconFeature' && featureItem.values_.resourceId == sourceIdFromVAXEvent) {
                                    //let addResource: any = this.globalDataAccessPoint.resources.byGuid[featureItem.values_.resourceId];
                                    setTimeout(function () {
                                        //console.log("in vxa pop up");
                                        _this_1.showVAXAlarmInfoPopUp(featureItem, vaxEventInfo, _this_1.map);
                                    });
                                }
                            });
                            //  });
                        }
                    });
                }, 100);
                //      })
            };
            //      //vax end
            this.VAXActionPlan_EventIsTriggered = function (vaxEventInfo, sourceId) {
                //      this.eventDispatcher.on("VAX_Event_Is_Triggered", (vaxEventInfo, sourceId) => {
                if (!_this_1.isSourceIdInMapItems(sourceId)) {
                    //console.log("===>  No related source found on map");
                    return;
                }
                var vaxAlarmInfoFromEvent = vaxEventInfo;
                var sourceIdFromVAXEvent = sourceId;
                var deviceChangeTimer = 100;
                var addResource = _this_1.mObjectPane.resourcesArray.filter(function (item) {
                    return item.id == sourceIdFromVAXEvent;
                })[0];
                if (deviceChangeTimer) {
                    clearTimeout(deviceChangeTimer);
                    deviceChangeTimer = null;
                }
                deviceChangeTimer = setTimeout(function () {
                    _this_1.map.getLayers().forEach(function (layer) {
                        if (layer instanceof ol.layer.Vector && layer.get('name') == "cameraImageLayer") {
                            var source = layer.getSource();
                            var feature = source.getFeatures();
                            feature.forEach(function (featureItem) {
                                if (featureItem.values_.type === 'iconFeature' && featureItem.values_.resourceId == sourceIdFromVAXEvent) {
                                    setTimeout(function () {
                                        var alarmImageSource = _this_1.getAlarmResourceStyle(addResource);
                                        var style = featureItem.getStyle();
                                        style.setImage(new ol.style.Icon({
                                            anchor: [0.5, 0.48],
                                            size: new CameraIcons(_this_1.mapResource.mapIconSize).getIconSize(_this_1.mapResource.mapIconSize),
                                            opacity: 1,
                                            scale: style.getImage().getScale(),
                                            src: new CameraIcons(_this_1.mapResource.mapIconSize).getIconStyle(alarmImageSource, _this_1.mapResource.mapIconSize),
                                            rotation: style.getImage().getRotation()
                                        }));
                                        featureItem.setStyle(style);
                                    });
                                }
                            });
                        }
                    });
                }, 100);
                setTimeout(function () {
                    _this_1.map.getLayers().forEach(function (layer) {
                        if (layer instanceof ol.layer.Vector && layer.get('name') == "cameraImageLayer") {
                            var source = layer.getSource();
                            var feature = source.getFeatures();
                            feature.forEach(function (featureItem) {
                                if (featureItem.values_.type === 'iconFeature' && featureItem.values_.resourceId == sourceIdFromVAXEvent) {
                                    setTimeout(function () {
                                        var IdleImageSource = _this_1.getIdleResourceStyle(addResource);
                                        var style = featureItem.getStyle();
                                        style.setImage(new ol.style.Icon({
                                            anchor: [0.5, 0.48],
                                            size: new CameraIcons(_this_1.mapResource.mapIconSize).getIconSize(_this_1.mapResource.mapIconSize),
                                            opacity: 1,
                                            scale: style.getImage().getScale(),
                                            src: new CameraIcons(_this_1.mapResource.mapIconSize).getIconStyle(IdleImageSource, _this_1.mapResource.mapIconSize),
                                            rotation: style.getImage().getRotation()
                                        }));
                                        featureItem.setStyle(style);
                                    });
                                }
                            });
                        }
                    });
                }, 10000);
            };
            //      //vax end
            //      //showing and changing to alarm icon when normal icon triggered
            this.AlarmIsTriggeredEvent = function (data) {
                //      this.eventDispatcher.on("AlarmIsTriggeredEvent", (data) => {
                try {
                    var dataResourceId = data.sourceId;
                    var eventState = data.eventState;
                    //console.log("alarmed id->", dataResourceId);
                    //if (dataResourceId) {
                    setTimeout(function () {
                        _this_1.map.getLayers().forEach(function (layer) {
                            if (layer instanceof ol.layer.Vector) {
                                //new logic implement to show alarm/normal icon as per event state
                                var source = layer.getSource();
                                var feature = source.getFeatures();
                                if (eventState == "On") {
                                    feature.forEach(function (featureItem) {
                                        //console.log("feature id for alarm=>", featureItem.values_.resourceId);                                
                                        if (featureItem.values_.type === 'iconFeature' && featureItem.values_.resourceId == dataResourceId) {
                                            //changing icon as per event state
                                            MapsOpenLayers.alarmedResources.push(featureItem.values_.resourceId);
                                            var addResource = _this_1.mObjectPane.resourcesArray.filter(function (item) {
                                                return item.id == featureItem.values_.resourceId;
                                            })[0]; //[featureItem.values_.resourceId];
                                            var check360Camera = _this_1.is360CameraItem(addResource);
                                            var alarmImageSource = void 0;
                                            var icon360Alarm = 'images/05A_360CameraAlarm.png'; //CameraIcons.ICON_SRC.icon360Alarm;
                                            var icon360MixedAlarm = 'images/11_360CameraAlarm.png'; //CameraIcons.ICON_SRC.iconMixed360Alarm;
                                            if ((addResource.resourceType === 'MixedVideoSource' || addResource.resourceType === 'PtzMixedVideoSource' && check360Camera === true)) {
                                                alarmImageSource = icon360MixedAlarm;
                                            }
                                            else if (check360Camera) {
                                                alarmImageSource = icon360Alarm;
                                            }
                                            else {
                                                alarmImageSource = _this_1.getAlarmResourceStyle(addResource);
                                            }
                                            var style = featureItem.getStyle();
                                            style.setImage(new ol.style.Icon({
                                                anchor: [0.5, 0.48],
                                                size: new CameraIcons(_this_1.mapResource.mapIconSize).getIconSize(_this_1.mapResource.mapIconSize),
                                                opacity: 1,
                                                scale: style.getImage().getScale(),
                                                src: new CameraIcons(_this_1.mapResource.mapIconSize).getIconStyle(alarmImageSource, _this_1.mapResource.mapIconSize),
                                                rotation: style.getImage().getRotation()
                                            }));
                                            featureItem.setStyle(style);
                                        }
                                    });
                                }
                                else if (eventState == "Off") {
                                    MapsOpenLayers.alarmedResources;
                                    while (MapsOpenLayers.alarmedResources.length > 0)
                                        MapsOpenLayers.alarmedResources.pop();
                                    feature.forEach(function (OffFeatureItem) {
                                        if (OffFeatureItem.values_.type === 'iconFeature' && OffFeatureItem.values_.resourceId == dataResourceId) {
                                            var OffAddResource = _this_1.mObjectPane.resourcesArray.filter(function (item) {
                                                return item.id == OffFeatureItem.values_.resourceId;
                                            })[0];
                                            var check360Camera = _this_1.is360CameraItem(OffAddResource);
                                            ///this.restoreIconsAfterAlarm(OffFeatureItem, OffAddResource.nvrId);
                                            var style_4 = OffFeatureItem.getStyle();
                                            var resourceStyle_2 = _this_1.getActiveIdelMixedCamera("Yes", OffAddResource, check360Camera);
                                            setTimeout(function () {
                                                style_4.setImage(new ol.style.Icon({
                                                    anchor: [0.5, 0.48],
                                                    size: new CameraIcons(_this_1.mapResource.mapIconSize).getIconSize(_this_1.mapResource.mapIconSize),
                                                    opacity: 1,
                                                    scale: style_4.getImage().getScale(),
                                                    src: new CameraIcons(_this_1.mapResource.mapIconSize).getIconStyle(resourceStyle_2, _this_1.mapResource.mapIconSize),
                                                    rotation: style_4.getImage().getRotation()
                                                }));
                                                OffFeatureItem.setStyle(style_4);
                                            }, 5000);
                                        }
                                    });
                                }
                            }
                        });
                    }, 100);
                    //}
                }
                catch (e) {
                }
                //      });
            };
            //  }
            this.is360CameraItem = function (addResource) {
                var check360Camera = (addResource && addResource.sourceProperties && addResource.sourceProperties.length > 0 && addResource.sourceProperties[0] === 'Camera360');
                if (addResource.isThermalRadar) {
                    check360Camera = true;
                }
                else if (addResource.isMobileDevice) {
                    check360Camera = true;
                }
                return check360Camera;
            };
            this.addListnerToGetViewportFeatures = function (map) {
                console.log("**** Event registered ******");
                map.on('moveend', (function () {
                    var extent = map.getView().calculateExtent(map.getSize());
                    _this_1.cameraVectorSource.forEachFeatureIntersectingExtent(extent, function (feature) {
                        //console.log("feature in viewport ==> ", feature);
                    });
                }));
            };
            //  //lpr alarm info Pop-up    
            this.loadLprInfoPopUpOnMapForMonitoring = function (map, objPane) {
                //console.log('loadLprInfoPopUpOnMapForMonitoring');
                var lprInfo = document.getElementById('getLprInfoBox' + objPane.id);
                if (!lprInfo) {
                    lprInfo = angular.element('<div id="getLprInfoBox' + objPane.id + '" style="height: auto;box-shadow: 0 0 8px 0 #3e4249; font-size: 14px;padding:8px;color:#fff; border: solid 1px #ffffff;line-height:normal;background-color: #686b71;"><a href="javascript:;" style="float:right" id="lpr-info-popup-closer"></a><span id="numberPlateTitleInfo" class="vicon-font v-info" style="margin-right:6px;"></span><span id="numberPlateInfo' + objPane.id + '"></span></div>')[0];
                    document.body.appendChild(lprInfo);
                }
                var lprInfoBox = new ol.Overlay({
                    id: 'lprInfo',
                    element: lprInfo,
                    stopEvent: false,
                    positioning: 'center-center',
                    offset: [0, 0],
                    autoPan: true
                });
                lprInfoBox.set("name", "lprInfoOverlay");
                map.addOverlay(lprInfoBox);
            };
            this.showLprAlarmInfoPopUp = function (feature, lprAlarmInfoFromEvent, map) {
                var sourceId = feature.getId();
                var lprAlarmInfoEvent = lprAlarmInfoFromEvent;
                var lprInfoBoxpopUp = map.getOverlayById('lprInfo');
                var lprInfoDetails = document.getElementById("getLprInfoBox" + _this_1.mObjectPane.id);
                if (lprInfoDetails) {
                    var geom = feature.getGeometry();
                    var featureExtent = geom.getExtent();
                    var featureCenter = ol.extent.getCenter(featureExtent);
                    var center = featureCenter;
                    lprInfoBoxpopUp.setPosition(center);
                    var lprInfoBoxpopUpObj = lprInfoBoxpopUp.getElement();
                    console.log("lprInfoBoxpopUpObj---->>>", lprInfoBoxpopUpObj);
                    lprInfoBoxpopUpObj.style.display = 'block';
                    lprInfoBoxpopUpObj.style.zIndex = "99999";
                    map.getInteractions().forEach(function (interaction) { interaction.setActive(false); });
                    var numberPlateInfo_1 = document.getElementById("numberPlateInfo" + _this_1.mObjectPane.id);
                    if (numberPlateInfo_1) {
                        setTimeout(function () {
                            numberPlateInfo_1.innerHTML = "" + lprAlarmInfoEvent.plateNumber;
                        });
                    }
                    var closer_1 = document.getElementById('lpr-info-popup-closer');
                    if (closer_1) {
                        // this popup will close automatically after 10 second 
                        setTimeout(function () {
                            closer_1.click();
                            lprInfoBoxpopUp.setPosition(undefined);
                            closer_1.blur();
                            map.getInteractions().forEach(function (interaction) { interaction.setActive(true); });
                            return false;
                        }, 5000 /* this.partnerInfoBoxTimer*/);
                    }
                }
            };
            //  //lpr alarm info Pop-up end
            //Access Control - VAX
            this.loadVAXInfoPopUpOnMapForMonitoring = function (map, objPane) {
                var vaxInfo = document.getElementById('getvaxInfoBox' + objPane.id);
                if (!vaxInfo) {
                    //TODO: need to update the template as per design(no design yet)
                    vaxInfo = angular.element('<div id="getvaxInfoBox' + objPane.id + '" style="height: auto;box-shadow: 0 0 8px 0 #3e4249; font-size: 14px;padding:8px;color:#fff; border: solid 1px #ffffff;line-height:normal;background-color: #686b71;top:35px;position:relative;"><a href="javascript:;" style="float:right" id="vax-info-popup-closer"></a><span id="numberPlateTitleInfo1" class="vicon-font v-info" style="margin-right:6px;"></span><span id="numberPlateInfo1' + objPane.id + '"></span></div>')[0];
                    document.body.appendChild(vaxInfo);
                }
                var vaxInfoBox = new ol.Overlay({
                    id: 'vaxInfo',
                    element: vaxInfo,
                    stopEvent: false,
                    positioning: 'center-center',
                    offset: [0, 0],
                    autoPan: true
                });
                vaxInfoBox.set("name", "vaxInfoOverlay");
                map.addOverlay(vaxInfoBox);
            };
            this.showVAXAlarmInfoPopUp = function (feature, vaxAlarmInfoFromEvent, map) {
                var sourceId = feature.getId();
                var vaxAlarmInfoEvent = vaxAlarmInfoFromEvent;
                var vaxInfoBoxpopUp = map.getOverlayById('vaxInfo');
                var vaxInfoDetails = document.getElementById("getvaxInfoBox" + _this_1.mObjectPane.id);
                if (vaxInfoDetails) {
                    var geom = feature.getGeometry();
                    var featureExtent = geom.getExtent();
                    var featureCenter = ol.extent.getCenter(featureExtent);
                    var center = featureCenter;
                    vaxInfoBoxpopUp.setPosition(center);
                    var vaxInfoBoxpopUpObj = vaxInfoBoxpopUp.getElement();
                    vaxInfoBoxpopUpObj.style.display = 'block';
                    vaxInfoBoxpopUpObj.style.zIndex = "99999";
                    map.getInteractions().forEach(function (interaction) { interaction.setActive(false); });
                    var vaxInfoId_1 = document.getElementById('numberPlateInfo1' + _this_1.mObjectPane.id);
                    if (vaxInfoId_1 && sourceId == vaxAlarmInfoEvent.sourceId) {
                        setTimeout(function () {
                            vaxInfoId_1.innerHTML = "" + vaxAlarmInfoEvent.message;
                        });
                    }
                    var closer_2 = document.getElementById('vax-info-popup-closer');
                    if (closer_2) {
                        // this popup will close automatically after 10 second 
                        setTimeout(function () {
                            closer_2.click();
                            vaxInfoBoxpopUp.setPosition(undefined);
                            closer_2.blur();
                            map.getInteractions().forEach(function (interaction) { interaction.setActive(true); });
                            return false;
                        }, 5000 /*this.partnerInfoBoxTimer*/);
                    }
                }
                //}
            };
            //  private setViewID() {
            //      this.monitoringViewID = null;
            //      try {
            //          this.monitoringViewID = this.monitoringViewContainer.getActiveView()._id;
            //      } catch (e) {
            //          console.log("setting alternate view ID: ", e);
            //          this.monitoringViewID = Math.round(Date.now() + Math.random());
            //      }
            //      //console.log("monitoring view ID: ", this.monitoringViewID);
            //  }
            this.modifyRecordingStorageObj = function (data) {
                var dataInfo = {
                    //"Volumes": {
                    //    "Fixed": [],
                    //    "Network": []
                    //}
                    "Volumes": {
                        "Recording": [],
                        "Archiving": []
                    }
                };
                //var data.volumes.Network = ;
                //console.log("data.Volumes.length-->", data.Volumes.length);
                for (var i = 0; i < data.Volumes.length; i++) {
                    //if (data.Volumes[i].Type == 'Fixed') {
                    //    dataInfo.Volumes.Fixed.push(data.Volumes[i]);
                    //} else if (data.Volumes[i].Type == 'Network') {
                    //    dataInfo.Volumes.Network.push(data.Volumes[i]);
                    //}
                    if (data.Volumes[i].StorageType == 'Recording') {
                        dataInfo.Volumes.Recording.push(data.Volumes[i]);
                    }
                    else if (data.Volumes[i].StorageType == 'Archiving') {
                        dataInfo.Volumes.Archiving.push(data.Volumes[i]);
                    }
                }
                return dataInfo;
            };
            this.closingPlayerWindow = function (payload) {
                if (_this_1.openPlayerIds[payload])
                    _this_1.openPlayerIds[payload] = null;
            };
            this.onShowSnapshot = function (payload) {
                if (!payload.resourceId || !payload.data || payload.data == '')
                    return;
                if (_this_1.snapshotId && _this_1.snapshotId == payload.resourceId && _this_1.cameraInfoBoxId) {
                    var popupCameraImg = document.getElementById(_this_1.cameraInfoBoxId);
                    var popupCameraImgText = document.getElementById(_this_1.cameraInfoBoxIdText);
                    if (popupCameraImgText)
                        popupCameraImgText.style.display = "none";
                    if (popupCameraImg) {
                        popupCameraImg.style.display = "block";
                        _this_1.loadImageWithTest(popupCameraImg, "data:image/jpg;base64," + payload.data);
                    }
                }
            };
            this.changeIconSize = function (size) {
                _this_1.mapResource.mapIconSize = size;
                _this_1.map.getLayers().forEach(function (layer) {
                    if (layer instanceof ol.layer.Vector && layer.get("name") == "cameraImageLayer") {
                        var source = layer.getSource();
                        var features = source.getFeatures();
                        features.forEach(function (featureItem) {
                            var style = featureItem.getStyle();
                            var src = style.getImage().getSrc();
                            //let srcParts = src.split("/");
                            //if (srcParts.length <= 1) return;
                            //if (size != 25 && size != 50 && size != 75) {
                            //    if (srcParts[srcParts.length - 2] == 25 || srcParts[srcParts.length - 2] == 50 || srcParts[srcParts.length - 2] == 75)
                            //        srcParts.splice(srcParts.length - 2, 1);
                            //    src = srcParts.join("/");
                            //} else {
                            //    if (srcParts[srcParts.length - 2] == 25 || srcParts[srcParts.length - 2] == 50 || srcParts[srcParts.length - 2] == 75)
                            //        srcParts[srcParts.length - 2] = size;
                            //    else 
                            //        srcParts.splice(srcParts.length - 1, 0, size);
                            //    src = srcParts.join("/");
                            //}
                            //console.log("Src = ", src);
                            featureItem.unset("scaleValue");
                            featureItem.unset("scaleCoords");
                            var camIconsObj = new CameraIcons(size);
                            var scale = (size != 25 && size != 50 && size != 75) ? camIconsObj.imageScale : camIconsObj.getIconScale(size);
                            // style.getImage().setScale(scale);
                            style.setImage(new ol.style.Icon({
                                anchor: new CameraIcons(_this_1.mapResource.mapIconSize).anchorSize,
                                size: (size != 25 && size != 50 && size != 75) ? new CameraIcons(size).imageSize : new CameraIcons(size).imageSizeResize[size],
                                opacity: 1,
                                scale: scale,
                                src: src,
                                rotation: style.getImage().getRotation()
                            }));
                            //// fItem.setStyle(style);
                            //console.log("style of feature : ", style);
                            featureItem.setStyle(style);
                        });
                    }
                });
                //checK:-> make form dirty
                _this_1.controllerItem.setMapDirty();
            };
            this.changeResourceIcon = function (payload) {
                var changedIcondetails;
                var addResource;
                console.log("rress: ", _this_1.mObjectPane.resourcesArray);
                if (payload && payload.length > 0) {
                    for (var i = 0; i < payload.length; i++) {
                        changedIcondetails = payload[i];
                        console.log("changedIcondetails.id ", changedIcondetails.id);
                        //addResource = this.globalDataAccessPoint.resources.byGuid[changedIcondetails.id];
                        addResource = _this_1.mObjectPane.resourcesArray.filter(function (item) {
                            return item.id == changedIcondetails.id;
                        })[0];
                        if (addResource) {
                            _this_1.setResourcePath(addResource, changedIcondetails);
                            _this_1.changeIconStyle(payload[i].id);
                        }
                    }
                    // this.changeIconStyle(payload[0].id);
                }
            };
            this.changeFeatureText = function (payload) {
                var featureCurrentStyle;
                var stickyNotesStyle;
                _this_1.map.getLayers().forEach(function (layer) {
                    if (layer instanceof ol.layer.Vector) {
                        var source = layer.getSource();
                        var feature = source.getFeatures();
                        feature.forEach(function (featureItem) {
                            featureCurrentStyle = featureItem.getStyle();
                            var currentId = featureItem.getId();
                            if (!currentId) {
                                currentId = featureItem.values_.id;
                            }
                            if (payload.type == 'stickynote' && featureItem.values_.type === 'stickyNoteFeature' && currentId == payload.id) {
                                featureItem.setProperties({ 'id': currentId, 'resourceId': currentId, 'type': 'stickyNoteFeature' });
                                stickyNotesStyle = featureItem.getStyle();
                                var text = stickyNotesStyle.getText().getText();
                                if (text != payload.value) {
                                    _this_1.map.getLayers().forEach(function (l) {
                                        if (l.get('name') == "notes") {
                                            var s = l.getSource();
                                            var f = s.getFeatures();
                                            f.forEach(function (fItem) {
                                                if (fItem.getId() == featureItem.getId()) {
                                                    var stl = fItem.getStyle();
                                                    var coordinates = featureItem.getGeometry().getCoordinates();
                                                    var diffCoords = coordinates[0][4][0] - coordinates[0][3][0];
                                                    var textSize = Math.ceil((MapsOpenLayers.TEXT_DELTA / 100.0) * diffCoords);
                                                    stl.getText().setText(_this_1.divideString(payload.value, textSize, "\n"));
                                                    fItem.setStyle(stl);
                                                }
                                            });
                                        }
                                    });
                                    featureItem.set("textvalue", payload.value);
                                    featureItem.setStyle(stickyNotesStyle);
                                    _this_1.selectedFeature = featureItem;
                                    _this_1.controllerItem.setMapDirty();
                                    _this_1.map.getInteractions().forEach(function (interaction) { interaction.setActive(true); });
                                }
                            }
                            else if (payload.type == 'highlight' && featureItem.values_.type === 'linkedMapFeature' && currentId == payload.id) {
                                var shapeStyle = featureItem.getStyle();
                                var text = shapeStyle.getText().getText();
                                if (text != payload.value) {
                                    shapeStyle.getText().setText(payload.value);
                                    featureItem.setStyle(shapeStyle);
                                    _this_1.selectedFeature = featureItem;
                                    _this_1.controllerItem.setMapDirty();
                                    _this_1.map.getInteractions().forEach(function (interaction) { interaction.setActive(true); });
                                }
                            }
                        });
                    }
                });
            };
            this.prePolledData["recordingStorage"] = [];
            this.prePolledData["recordingSettings"] = [];
            this.prePolledData["preset"] = [];
            this.loderTimeStamp = Date.now();
            this.eventDispatcher = {};
            this.videoChannelsHelperService = {};
            this.globalDataAccessPoint = {};
            this.mapsExternalLibrariesService = mapsExternalLibrariesService;
            this.languageService = {};
            this.cacheManager = {};
            this.mapsApiProvider = {};
            this.vidData = {};
            this.vmsTreeViewService = {};
            this.monitoringViewContainer = {}; //showOnMap
            //== init flags
            this.fitToPageMoveStatrted = false;
            //== main init function
            this.testingDataPush = [];
            // this.getAllActiveResources();
            //Sticky Note
            this.defaultFontColor = "#1a2028";
            this.defaultFontSize = "18px";
            this.defaultFontName = "Arial";
            this.defaultShapeName = "Circle";
            this.defaultOpacity = 0.5;
            this.ptzService = {};
            this.ptzResetItems = [];
            this.vmsPlayerByPlayerIdMapping = {};
            this.audioData = {};
            this.recordingService = {};
            this.storageService = {};
            this.isContextMenuOpen = false;
            this.mapsFactory = {};
            this.scope = {};
            this.permissionsService = {
                hasPlayliveRestriction: function (resource) {
                    if (!resource)
                        return false;
                    if (resource.isLiveAllowed == false)
                        return true;
                    return false;
                },
                hasPlaybackRestriction: function (resource) {
                    if (!resource)
                        return false;
                    if (resource.isPlaybackAllowed == false)
                        return true;
                    return false;
                }
            };
            this.confirmService = {};
            this.playerFactory = {};
            this.playerHelperService = {};
            this.paneBtns = {};
            this.$q = {};
            this.AUDITLOGMSGES = {};
            //this.eventDispatcher.on("setDefaultShapeOptions", () => {
            //    this.updateHighlightStyle("color", "#e22b8a");
            //    this.updateHighlightStyle("shape", "Ractangle");
            //    this.updateHighlightStyle("opacity", 50);
            //})
            //this.partnerAlarmDelay = window['partnerAlarmDelay'];
            //this.partnerInfoBoxTimer = window['partnerInfoBoxTimer'];
            this.addPartnerService = {};
        }
        MapsOpenLayers.prototype.hexToRgb = function (hex) {
            var result = /^#?([a-f\d]{2})([a-f\d]{2})([a-f\d]{2})$/i.exec(hex);
            return result ? {
                r: parseInt(result[1], 16),
                g: parseInt(result[2], 16),
                b: parseInt(result[3], 16)
            } : null;
        };
        MapsOpenLayers.prototype.componentToHex = function (c) {
            var hex = Number(c).toString(16);
            if (hex.length < 2) {
                hex = "0" + hex;
            }
            return hex;
        };
        ;
        MapsOpenLayers.prototype.rgbToHex = function (r, g, b) {
            return "#" + this.componentToHex(r) + this.componentToHex(g) + this.componentToHex(b);
        };
        //  //== on camera drag and drop - on drop event
        MapsOpenLayers.dropCameraOnMonitoringPane = function (resourceId, objPane) {
            var monitoringPane = document.querySelectorAll('.vms-display-layout-pane:hover');
            //== check if the drop was on one of monitoring zones
            if (!!monitoringPane.length && !!monitoringPane[0] && monitoringPane[0].id !== objPane.id) {
                var event_1 = document.createEvent("Event");
                event_1.initEvent("drop", true, true);
                event_1.isMapEvent = true;
                event_1.resourceId = resourceId;
                //== fire drop event to approprite monitoring zone
                monitoringPane[0].dispatchEvent(event_1);
            }
        };
        MapsOpenLayers.prototype.loadImageWithTest = function (imgObj, imgSrc) {
            //== set default one pixel image
            // imgObj.src = "/app/images/map/pixel.png";
            //== create a tester image
            //   let tester: any = new Image();
            //   tester.addEventListener('load', () => {
            //       imgObj.src = tester.src;
            //       imgObj.style.height = "120px";
            //   });
            //== set up a source to tester image
            imgObj.src = imgSrc;
            imgObj.style.height = "120px";
        };
        //== Resize Map when canvas size changes
        MapsOpenLayers.prototype.resizeMap = function () {
            this.map.updateSize();
        };
        //  //== set Sticky Note font size depend on map zoom
        //  private setStickyNoteStyle = (defaultStyle: ol.style.Style): ol.style.Style => {
        //      //== get current zoom
        //      const zoom = this.map.getView().getZoom() || 0.5;
        //      //== apply zoomed text style 
        //      defaultStyle.getText().setFont((zoom * 10) + 'px normal Arial');
        //      //== return changed object
        //      return defaultStyle;
        //  }
        //  //== Wrap (divide) string with new line - fron Open Layers examples    
        //  //== http://openlayers.org/en/latest/examples/vector-labels.html
        //  private stringDivider = (str, width): string => {
        //      const spaceReplacer = '\n';
        //      if (str.length > width) {
        //          var p = width;
        //          while (p > 0 && (str[p] != ' ' && str[p] != '-')) {
        //              p--;
        //          }
        //          if (p > 0) {
        //              var left;
        //              if (str.substring(p, p + 1) == '-') {
        //                  left = str.substring(0, p + 1);
        //              } else {
        //                  left = str.substring(0, p);
        //              }
        //              var right = str.substring(p + 1);
        //              return left + spaceReplacer + this.stringDivider(right, width);
        //          }
        //      }
        //      return str;
        //  }
        //  //==  will check it this is specific layer
        //  private isCameraImagesLayer = (layer: ol.layer.Layer) => {
        //      return layer.get('name') === mapDefaults.mapLayers.cameraLayer;
        //  }
        //  //==  will check it this is specific layer
        //  private isHighlightLayer = (layer: ol.layer.Layer) => {
        //      return layer.get('name') === mapDefaults.mapLayers.linkedMapsLayer;
        //  }
        //  //== Get global resource by it's ID
        //  private getMapResourceByID = (mapID: string): any => {
        //      const mapResource: any = this.globalDataAccessPoint.resources.byGuid[mapID];
        //      return mapResource;
        //  }
        //  // For sticky Note
        MapsOpenLayers.prototype.getCurrentAppliedColor = function () {
            return this.defaultFontColor;
        };
        MapsOpenLayers.prototype.getCurrentAppliedSize = function () {
            return this.defaultFontSize;
        };
        MapsOpenLayers.prototype.getCurrentAppliedName = function () {
            return this.defaultFontName;
        };
        //  private setxDiffValuePercent = () => {
        //      let res = this.map.getView().getResolution();
        //      let percentDiffX = 20 / res;
        //      this.deltaXDiff = percentDiffX * res;
        //      this.map.getView().on('change:resolution', (e) => {
        //          let res1 = this.map.getView().getResolution();
        //          this.deltaXDiff = percentDiffX * res1;
        //          if (this.infoFeatObj && this.infoOvPoObj) {
        //              let gFeature: any = this.infoFeatObj.getGeometry();
        //              let coords: any = gFeature.getCoordinates();
        //              coords[0] = coords[0] + this.deltaXDiff;
        //              this.infoOvPoObj.setPosition(coords);
        //          }
        //      });
        //  }
        MapsOpenLayers.prototype.getResourceObj = function (resourceId) {
            var vxvmsTreeViewService = this.vmsTreeViewService;
            var x = vxvmsTreeViewService.getTreeData().unassociatedGroup.children;
            var customGroup = vxvmsTreeViewService.getTreeData().customGroups;
            var res = x.filter(function (items) {
                return items.id === resourceId;
            });
            if ((!res || res.length == 0) && customGroup && customGroup.length > 0) {
                customGroup.forEach(function (group) {
                    if (!res || res.length == 0) {
                        if (group.children && group.children.length > 0) {
                            res = group.children.filter(function (items) {
                                return items.id === resourceId;
                            });
                        }
                    }
                });
            }
            return res[0];
        };
        MapsOpenLayers.prototype.getNewPanel = function () {
            var ele = document.getElementById("vms-monitoring-tpl");
            ele = !ele ? document.getElementById("plc-div") : ele;
            var ctr = angular.element(ele).scope();
            return ctr.createNewPane();
        };
        MapsOpenLayers.prototype.createPlayer = function (paneObj, playerBody, resourceId, playback, from) {
            var resource = this.globalDataAccessPoint.resources.byGuid[resourceId];
            playerBody.querySelector(".vms-player-resource-title").textContent = resource.name;
            playerBody.querySelector(".vms-player-resource-title").setAttribute("title", resource.name);
            var players = playerBody.getElementsByClassName("vms-player");
            if (players && players.length > 0) {
                for (var i = 0; i < players.length; i++) {
                    playerBody.removeChild(players[i]);
                }
            }
            var playerId = 'mapPlayer' + Date.now();
            var paramOptions = {
                'magnify-filter': 'false',
                'marquee-filter': 'true',
                'toolbar': 'false',
                'showControls': 'false',
                'windowless': 'false',
                'fullscreen-toolbar': 'false',
                'fullscreen': 'false',
                'gui-enabled': 'true',
                'bgcolor': '#353f4c',
                'debug-vout-dummy': 'false',
                'mask-enabled': 'false'
            };
            var playerDOMElement = document.createElement('object');
            playerDOMElement.id = playerId;
            playerDOMElement.className = 'vms-player';
            playerDOMElement.setAttribute('type', 'application/vnd.vicon.mediaplayer');
            playerDOMElement.setAttribute('events', 'true');
            for (var key in paramOptions) {
                var param = document.createElement('param');
                param.setAttribute('name', key);
                param.setAttribute('value', paramOptions[key]);
                playerDOMElement.appendChild(param);
            }
            playerBody.appendChild(playerDOMElement);
            var objPlayer = this.playerFactory.createVideoPlayer(playerDOMElement);
            objPlayer._resourceId = resourceId;
            this.paneBtns.initVideoSource(paneObj, objPlayer);
            paneObj.vmsPlayerId = objPlayer.__vms_player_id;
            paneObj.playerObj = objPlayer;
            this.playerHelperService.addPlayer(objPlayer, playerId);
            if (playback)
                objPlayer._playback(resourceId, playback, from);
            else
                objPlayer._playLive(resourceId);
            objPlayer.masking = true;
        };
        //  public removeOverlaysPlayer = () => {
        //      try {
        //          let overlays: any = this.map.getOverlays();
        //          if (!overlays || !overlays.array_ || overlays.array_.length == 0) return;
        //          for (let i = 0; i < overlays.array_.length; i++) {
        //              if (overlays.array_[i].get("name") == "cameraLiveFeedOverlay" && overlays.array_[i].element) {
        //                  if (overlays.array_[i].element.firstChild) {
        //                      overlays.array_[i].element.firstChild.style.setProperty("width", "348px");
        //                      overlays.array_[i].element.firstChild.style.setProperty("height", "220px");
        //                      let player: any = overlays.array_[i].element.firstChild.getElementsByTagName("object");
        //                      if (player && player.length > 0) {
        //                          player[0].removeNode();
        //                      }
        //                      angular.element(overlays.array_[i].element.firstChild).hide();
        //                  }
        //              }
        //          }
        //      }
        //      catch (e) {
        //          console.log("removeOverlaysPlayer error: ", e);
        //      }
        //  }
        MapsOpenLayers.prototype.executeShowOnMap = function (resId) {
            var _this_1 = this;
            var isShowingFlash = false;
            this.map.getLayers().forEach(function (layer) {
                if (layer instanceof ol.layer.Vector && layer.get('name') == "cameraImageLayer") {
                    isShowingFlash = true;
                    _this_1.setShowOnMap(layer, resId);
                }
            });
            if (isShowingFlash) {
                setTimeout(function () {
                    _this_1.map.updateSize();
                }, 1000);
            }
        };
        MapsOpenLayers.prototype.updateCameraStatus = function (payload) {
            this.updateCameras(payload);
        };
        MapsOpenLayers.prototype.updateCameraStatusOnLoad = function (objPane) {
            var i;
            try {
                for (i = 0; i < objPane.resourcesArray.length; i++) {
                    if (objPane.resourcesArray[i].status == 'offline') {
                        this.updateCameras({ resourceId: objPane.resourcesArray[i].id, status: objPane.resourcesArray[i].status });
                    }
                }
            }
            catch (error) {
                console.log('Error on updating icons on load', error);
            }
        };
        //  //vax end
        MapsOpenLayers.prototype.adjustHomePostionOnChange = function () {
            var _this_1 = this;
            try {
                if (!this.fromMonitoring)
                    return;
                this.map.on('moveend', (function () {
                    //console.log("moveend for adjusthome");
                    var zoom = _this_1.getMapZoom();
                    var center = _this_1.getMapCenter();
                    var localobject = {
                        zoom: zoom,
                        center: center
                    };
                    //  console.log("current view layout Id => ", this.getLayoutOfCurrentPane());
                    localStorage.setItem("customhome_" + _this_1.map.get("mapId") + "_" + _this_1.getLayoutOfCurrentPane(), JSON.stringify(localobject));
                }));
            }
            catch (e) {
                console.log("Error in resetting home location: ", e);
            }
        };
        MapsOpenLayers.prototype.getLayoutOfCurrentPane = function () {
            try {
                var pane = this.map.get("map_pane");
                //   let objCurrentView = this.monitoringViewContainer.getActiveView();
                var currentLayoutId = null;
                //objCurrentView.layout.layoutItems.forEach(item => {
                //    if (item.pane.id == pane.id) {
                //        currentLayoutId = item.id;
                //    }
                //});
                return pane.id;
            }
            catch (e) {
                console.log("Error in getting layout for pane:- ", e);
            }
        };
        MapsOpenLayers.monitoringCameraResource = [];
        MapsOpenLayers.isFromMonitoring = 0;
        MapsOpenLayers.mapsHistory = {};
        MapsOpenLayers.tempObjPane = {};
        MapsOpenLayers.alarmedResources = [];
        MapsOpenLayers.POINT_X_DELTA = 0.007;
        MapsOpenLayers.POINT_Y_DELTA = 0.007;
        MapsOpenLayers.TEXT_DELTA = 7246;
        MapsOpenLayers.currentResourceId = { id: null, resource: null };
        //default value as per resolution 1920 X 1080
        MapsOpenLayers.CONTROLPANEL_VISIBILITY_VALUE = 17.239583333333332;
        //  //Ends
        //  //== Get layer from map by layer name
        MapsOpenLayers.getMapLayerByName = function (map, layerName) {
            var layersArr = map.getLayers();
            //== filter map layers by layer name
            var layerObjectsArr = layersArr.getArray().filter(function (layer) {
                return layer.get('name') == layerName;
            });
            //== layer not exists on current map - not creating a button
            if (!!layerObjectsArr && !!layerObjectsArr.length && !!layerObjectsArr[0]) {
                return layerObjectsArr[0];
            }
            return null;
        };
        return MapsOpenLayers;
    }());
    standalonePlayer.MapsOpenLayers = MapsOpenLayers;
    ;
})(standalonePlayer || (standalonePlayer = {}));
/// <reference path="mapsOpenlayers.ts"/>
//== This service created for creating an instance of Open Layers Class
var standalonePlayer;
/// <reference path="mapsOpenlayers.ts"/>
//== This service created for creating an instance of Open Layers Class
(function (standalonePlayer) {
    "use strict";
    var MapsOpenLayersService = /** @class */ (function () {
        //== constructor
        function MapsOpenLayersService(mapsExternalLibrariesService) {
            var _this = this;
            this.getInstance = function () {
                return new standalonePlayer.MapsOpenLayers(_this.mapsExternalLibrariesService);
            };
            //FIX FOR MULTI INSTANNSE PANE 
            this.updatePane = function (pane) {
                // MapsOpenLayers.tempObjPane = pane
            };
            //FIX FOR MULTI INSTANNSE PANE 
            this.clearPane = function () {
                // MapsOpenLayers.tempObjPane = []
            };
            this.mapsExternalLibrariesService = mapsExternalLibrariesService;
        }
        MapsOpenLayersService.$inject = ['mapsExternalLibrariesService'];
        return MapsOpenLayersService;
    }());
    standalonePlayer.MapsOpenLayersService = MapsOpenLayersService;
})(standalonePlayer || (standalonePlayer = {}));
/// <reference path="../../Scripts/typings/jquery/jquery.d.ts"/>
/// <reference path="../../Scripts/typings/angularjs/angular.d.ts"/>
/// <reference path="../../Scripts/typings/jquery.contextMenu/jquery.contextMenu.d.ts"/>
/// <reference path="utils/mapsOpenlayersService.ts"/>
var standalonePlayer;
(function (standalonePlayer) {
    "use strict";
    angular.module("standalonePlayer", []);
    standalonePlayer.getNgApp = function () {
        return angular.module("standalonePlayer");
    };
    var MainController = /** @class */ (function () {
        function MainController($rootScope, $scope, mapsOpenLayersService) {
            this.$rootScope = $rootScope;
            this.mapsOpenLayersService = mapsOpenLayersService;
            this.welcome = "";
            $scope.hello = "hello";
            var mapTS;
            $scope.isMapGallery = false;
            $scope.imgUri = "";
            $scope.mapPayload = null;
            $scope.isGeoMap = false;
            $scope.showSearchTourBox = false;
            $scope.globalDataAccessPoint = {
                resources: {
                    list: [],
                    byGuid: {},
                },
            };
            function addResArrayToGDA(payload) {
                if (!payload.resource ||
                    !payload.resource.mapItems ||
                    payload.resource.mapItems.length == 0)
                    return;
                $scope.globalDataAccessPoint.resources.list = [];
                $scope.globalDataAccessPoint.resources.byGuid = {};
                payload.resource.mapItems.forEach(function (item) {
                    if (item.type != "MapItemImage" || !item.resource)
                        return;
                    $scope.globalDataAccessPoint.resources.list.push(item.resource);
                    $scope.globalDataAccessPoint.resources.byGuid[item.resource.id] =
                        item.resource;
                });
            }
            $scope.showOrHideLocationSearchGeo = function () {
                if (!$scope.isGeoMap)
                    return;
                var isHide = localStorage.getItem("hideGeocoderInfo");
                if (isHide && isHide == "true")
                    return;
                var elm = document.getElementById("config-maparea");
                if (elm)
                    elm.style.display = "block";
                //$scope.showSearchTourBox = true;
            };
            $scope.hideGeoInfo = function () {
                localStorage.setItem("hideGeocoderInfo", "true");
                var elm = document.getElementById("config-maparea");
                if (elm)
                    elm.style.display = "none";
                //$scope.showSearchTourBox = false;
            };
            $scope.loadMap = function (payload) {
                $scope.mapPayload = payload;
                $scope.isGeoMap = payload.resource.mapType != "Image";
                $scope.showOrHideLocationSearchGeo();
                // let appInfoDiv = document.getElementById("appInfoDiv");
                // if(appInfoDiv){
                //     var pre = document.createElement("pre");
                //     pre.innerHTML= angular.toJson(payload);
                //     appInfoDiv.append(pre);
                // }
                addResArrayToGDA(payload);
                mapTS = mapsOpenLayersService.getInstance();
                mapTS.setGDA($scope.globalDataAccessPoint);
                if (payload.isMapGallery) {
                    $scope.isMapGallery = true;
                    $scope.imgUri = payload.resource.ImageURI;
                    if (payload.resource.mapType == "Image") {
                        var divElm = document.createElement("div");
                        divElm.classList.add("map_img");
                        var elem = document.createElement("img");
                        elem.setAttribute("src", $scope.imgUri);
                        divElm.appendChild(elem);
                        document.getElementById("map-canvas").appendChild(divElm);
                    }
                    else {
                        mapTS.createMapForGallery(payload);
                    }
                }
                else {
                    $scope.isMapGallery = false;
                    mapTS.createMapForEdit(payload, $scope);
                }
                //mapTS.mapConfigRotateInteraction
            };
            //var mapTS = mapsOpenLayersService.getInstance();
            //mapTS.createMapForMonitoring(pane);
            //mapTS.mapConfigRotateInteraction
            $scope.drawStickyNotesOnMap = function (isClicked) {
                $scope.setDirty = false;
                mapTS.createStickyNotes(isClicked, $scope);
            };
            $scope.changeStickyNotesPropFont = function (fontName) {
                $scope.setDirty = false;
                //this.fontName = "Arial";
                this.fontName = fontName;
                mapTS.setFontName(this.fontName);
            };
            $scope.changeStickyNotesPropFontSize = function (fontSize) {
                $scope.setDirty = false;
                //this.fontSize = "14";
                this.fontSize = fontSize;
                mapTS.setFontSize(this.fontSize);
            };
            $scope.changeStickyNotesPropFontColor = function (fontColor) {
                $scope.setDirty = false;
                //this.fontColor = "#1a2028";
                this.fontColor = fontColor;
                mapTS.setFontColor(this.fontColor);
            };
            $scope.changeStickyNotesPropFontColor = function (fontColor) {
                $scope.setDirty = false;
                //this.fontColor = "#1a2028";
                this.fontColor = fontColor;
                mapTS.setFontColor(this.fontColor);
            };
            $scope.returnEditedMapObject = function (payload) {
                //$scope.setDirty = false;
                //this.fontColor = "#1a2028";
                // this.payload = payload;
                // mapTS.returnDirtymapObject(this.payload);
                var apiObj = $scope.transformMapResourceToApi($scope.mapPayload.resource);
                //call thick client command
                var obj = new ThickClientCommunication();
                obj.callBackToThickClientFunction("updatedMapObjectToSave", apiObj);
            };
            $scope.showAlarmforPartnerEvent = function (payload) {
                //mapTS = mapsOpenLayersService.getInstance();
                mapTS.showAlarmforPartnerEvent(payload);
            };
            $scope.showAlarmforThickClientEvent = function (payload) {
                //mapTS = mapsOpenLayersService.getInstance();
                mapTS.showAlarmforThickClientEvent(payload);
            };
            $scope.closingPlayerWindow = function (payload) {
                mapTS.closingPlayerWindow(payload);
            };
            $scope.onQuickPlayback = function (time, currentId) {
                var payload = {
                    seconds: time,
                    resourceId: mapTS.playbackResource.resourceId,
                    coordinates: mapTS.playbackResource.actualCoordinates,
                };
                mapTS.sendInfoToThickClient("quickPlayback", payload);
            };
            $scope.hideConfirmationDialogPopup = function (payload) {
                var payload = JSON.parse(payload);
                console.log("Hide Confirmation Dialog Popup Payload ::", payload);
                mapTS.deleteStickyNote(payload);
            };
            $scope.executeShowOnMap = function (resId) {
                mapTS.executeShowOnMap(resId);
            };
            $scope.updateCameraStatus = function (payload) {
                mapTS.updateCameraStatus(payload);
            };
            $scope.setPresetDataForResource = function (payload) {
                mapTS.setPresetDataForResource(payload);
            };
            $scope.resetMapControl = function () {
                if ($scope.mapPayload)
                    $scope.loadMap($scope.mapPayload);
            };
            $scope.onInternetConnectionChanged = function (payload) {
                mapTS.onInternetConnectionChanged(payload);
            };
            $scope.onShowSnapshot = function (payload) {
                mapTS.onShowSnapshot(payload);
            };
            $scope.updateIconOnDeviceChange = function (payload) {
                mapTS.updateIconOnDeviceChange(payload);
            };
            $scope.changeBackGroundSize = function (payload) {
                mapTS.changeBGImageFitToPageState(payload);
                var tempMapData = angular.copy($scope.mapPayload.resource);
                tempMapData.mapImage.fit = payload;
                var apiObj = $scope.transformMapResourceToApi(tempMapData);
                var obj = new ThickClientCommunication();
                apiObj.Latitude = 1;
                apiObj.Longitude = 1;
                apiObj.Zoom = 1;
                obj.callBackToThickClientFunction("updatedMapObjectToSave", apiObj);
            };
            $scope.changeBackGroundImage = function (payload) {
                mapTS.changeBGLayerImage(payload.file, payload.isFitToPage);
            };
            $scope.setHomeposition = function () {
                //let updatedMapObject = mapTS.getMapWithHomePosition
                var tempMapData = angular.copy($scope.mapPayload.resource);
                var zoom = mapTS.getMapZoom();
                var coordinates = mapTS.getMapCenter();
                if ($scope.mapPayload.resource.mapImage.fit)
                    coordinates = mapTS.calculateRelativeCoordinates(coordinates, true);
                var longitude = coordinates[0]; //== X coord - horizontal - width
                var latitude = coordinates[1]; //== Y coord - vertical   - height
                tempMapData.latitude = latitude;
                tempMapData.longitude = longitude;
                tempMapData.zoom = zoom;
                var apiObj = $scope.transformMapResourceToApi(tempMapData);
                //call thick client command
                var obj = new ThickClientCommunication();
                obj.callBackToThickClientFunction("updatedMapObjectToSave", apiObj);
            };
            $scope.addUnlinkedHighlight = function () {
                mapTS.DrawUnlinkShape();
            };
            $scope.addLinkedHighlight = function (payload) {
                mapTS.DrawShapeForMaps(payload);
            };
            $scope.changeIconSize = function (size) {
                mapTS.changeIconSize(size);
            };
            $scope.changeHighlightShape = function (shape) {
                mapTS.setCurrentShape(shape);
            };
            $scope.changeHighlightOpacity = function (opacity) {
                mapTS.setCurrentOpacity(opacity);
            };
            $scope.changeHighlightColor = function (opacity) {
                mapTS.setCurrentColor(opacity);
            };
            $scope.transformMapResourceToApi = function (mapControllerItem) {
                var mapImageItem = null;
                if (mapControllerItem.mapType == "Image") {
                    mapImageItem = {
                        "Width": (!!mapControllerItem.mapImage && !!mapControllerItem.mapImage.width) ? mapControllerItem.mapImage.width : 0,
                        "Height": (!!mapControllerItem.mapImage && !!mapControllerItem.mapImage.height) ? mapControllerItem.mapImage.height : 0,
                        "Fit": (!!mapControllerItem.mapImage && !!mapControllerItem.mapImage.fit) ? mapControllerItem.mapImage.fit : false,
                    };
                }
                var mapItemType = {
                    image: "Image",
                    polygon: "Polygon",
                    circle: "Circle",
                    text: "Text"
                };
                var mapItemsAll = [];
                var mapItemsData2 = {};
                var typeVal;
                var mapItemTypeVal;
                angular.forEach(mapTS.getAllFeaturesForSave(), function (items) {
                    var resourceId = items.get('resourceId');
                    var stickyNoteId = items.get('id');
                    //Added to store Sticky Note in DB code start from here
                    if (items.get('type') === 'stickyNoteFeature') {
                        var stickyNoteDecription = items.get("textvalue"); //items.getStyle().getText().getText();
                        var stickyNoteDespFont = items.getStyle().getText().getFont();
                        var stickyNoteDespFontColor = items.getStyle().getText().getFill().getColor();
                        var coordinates = items.getGeometry().getCoordinates();
                        typeVal = "MapItemText";
                        mapItemTypeVal = mapItemType.text;
                        mapItemsData2 = {
                            "Type": typeVal,
                            "Data": {
                                "Latitude": 22,
                                "Longitude": 11,
                                "MapItemType": mapItemTypeVal,
                                "PropertyBag": JSON.stringify({ "description": stickyNoteDecription, "coordinates": coordinates, "resourceId": resourceId, "despFonts": stickyNoteDespFont, "despFontColor": stickyNoteDespFontColor, "id": stickyNoteId }),
                            }
                        };
                    }
                    //ends here
                    if (items.get('type') === 'funnelFeature' || items.get('type') === 'funnelIconFeature') {
                        var coordinates = items.getGeometry().getCoordinates();
                        var rotation = items.get('rotation');
                        typeVal = "MapItemPolygon";
                        mapItemTypeVal = mapItemType.polygon;
                        mapItemsData2 = {
                            "Type": typeVal,
                            "Data": {
                                "Latitude": 22,
                                "Longitude": 11,
                                "MapItemType": mapItemTypeVal,
                                //"PropertyBag": JSON.stringify(items.getGeometry().getCoordinates()),
                                "PropertyBag": JSON.stringify({ "coordinates": coordinates, "rotation": rotation }),
                                "ResourceId": resourceId
                            }
                        };
                    }
                    if (items.get('type') === 'iconFeature') {
                        var rotation = items.get('rotation');
                        var coordinates = items.getGeometry().getCoordinates();
                        var flip = items.get('flip');
                        var flop = items.get('flop');
                        //Resize Icon
                        var scaleValue = items.get('scaleValue');
                        var scaleCoords = items.get('scaleCoords');
                        //Resize Icon End
                        typeVal = "MapItemImage";
                        mapItemTypeVal = mapItemType.image;
                        mapItemsData2 = {
                            "Type": typeVal,
                            "Data": {
                                "Latitude": 22,
                                "Longitude": 11,
                                "MapItemType": mapItemTypeVal,
                                "PropertyBag": JSON.stringify({ "coordinates": coordinates, "rotation": rotation, flip: flip ? flip : false, flop: flop ? flop : false, scaleValue: scaleValue ? scaleValue : null, scaleCoords: scaleCoords ? scaleCoords : null }),
                                //"PropertyBag": JSON.stringify({ "coordinates": coordinates, "rotation": rotation, flip: flip ? flip : false, flop: flop ? flop : false }),
                                "ResourceId": resourceId,
                                'Rotation': rotation
                            }
                        };
                    }
                    if (items.get('type') === 'linkedMapFeature') {
                        var coordinates = items.getGeometry().getCoordinates();
                        var rotation = items.get('rotation');
                        var featureType = items.get('featureType');
                        var description = "";
                        var fill = "";
                        if (items.getStyle()) {
                            description = items.getStyle().getText().getText();
                            var fillStyle = items.getStyle().getFill();
                            if (fillStyle) {
                                fill = fillStyle.color_.join(",");
                            }
                        }
                        typeVal = "MapItemPolygon";
                        mapItemTypeVal = mapItemType.polygon;
                        var shape = items.get("shape");
                        var propertyBag = JSON.stringify({ "coordinates": coordinates, "rotation": rotation, "description": description, "fill": fill, "shape": shape ? shape : "", featureType: featureType ? featureType : "" });
                        if (featureType && featureType == 'unlinked') {
                            var resourceId_1 = items.get("resourceId");
                            var id = items.get('id');
                            propertyBag = JSON.stringify({ "coordinates": coordinates, "rotation": rotation, "description": description, "fill": fill, "shape": shape ? shape : "", id: id ? id : "", resourceId: resourceId_1 ? resourceId_1 : "", featureType: featureType });
                        }
                        mapItemsData2 = {
                            "Type": typeVal,
                            "Data": {
                                "Latitude": 22,
                                "Longitude": 11,
                                "MapItemType": mapItemTypeVal,
                                //"PropertyBag": JSON.stringify(items.getGeometry().getCoordinates()),
                                "PropertyBag": propertyBag,
                                "ResourceId": (featureType && featureType == 'unlinked') ? null : resourceId
                            }
                        };
                    }
                    mapItemsAll.push(mapItemsData2);
                });
                var mapApiItem = {
                    Description: mapControllerItem.description,
                    Enabled: true,
                    Fixed: false,
                    Id: mapControllerItem.id || '0',
                    Latitude: mapControllerItem.latitude || 0,
                    Longitude: mapControllerItem.longitude || 0,
                    MapImage: mapImageItem,
                    MapItems: mapItemsAll,
                    MapType: mapControllerItem.mapType,
                    Name: mapControllerItem.name || "",
                    Permissions: ["ViewResource"],
                    ResourceType: "Map",
                    RestrictedPermissions: null,
                    ShortcutNumber: mapControllerItem.numericId,
                    Visible: mapControllerItem.visible || false,
                    Zoom: mapControllerItem.zoom || 0,
                    MapIconSize: mapControllerItem.mapIconSize || 100
                };
                return mapApiItem;
            };
            $scope.setMapDirty = function () {
                var obj = new ThickClientCommunication();
                obj.callBackToThickClientFunction("setMapToDirty", {});
            };
            $scope.changeResourceIcon = function (payload) {
                mapTS.changeResourceIcon(payload);
            };
            $scope.mapFeatureClicked = function (payload) {
                var obj = new ThickClientCommunication();
                obj.callBackToThickClientFunction("clickOnFeatureOnMap", payload);
            };
            $scope.mapFeatureDoubleClicked = function (payload) {
                var obj = new ThickClientCommunication();
                obj.callBackToThickClientFunction("dblClickOnFeature", payload);
            };
            $scope.changeFeatureText = function (payload) {
                mapTS.changeFeatureText(payload);
            };
        }
        MainController.$inject = [
            "$rootScope",
            "$scope",
            "mapsOpenLayersService",
        ];
        return MainController;
    }());
    (function (main) {
        main.service("mapsOpenLayersService", standalonePlayer.MapsOpenLayersService);
        main.service("mapsExternalLibrariesService", [
            function () {
                function getMapsContextMenu() {
                    return ContextMenu;
                }
                function getMapsRotateFeature() {
                    return RotateFeatureInteraction;
                }
                function getGeocoder() {
                    return Geocoder;
                }
                function getPromise() {
                    return Promise;
                }
                return {
                    getMapsContextMenu: getMapsContextMenu,
                    getMapsRotateFeature: getMapsRotateFeature,
                    getGeocoder: getGeocoder,
                    getPromise: getPromise,
                };
            },
        ]);
        main.controller("mainController", MainController);
    })(standalonePlayer.getNgApp());
})(standalonePlayer || (standalonePlayer = {}));
// module standalonePlayer {
//     "use strict";
//     export  class CameraIcons {
//         icon1: ol.style.Style;
//         ptzIconStyle: ol.style.Style;
//         mixedIconStyle: ol.style.Style;
//         ptzMixedIconStyle: ol.style.Style;
//         iconfunnel: ol.style.Style;
//         iconStickyNotes: ol.style.Style; // Sticky Note
//         iconCircle: ol.style.Style;
//         shapeStyle: ol.style.Style;
//         urlSourceStyle: ol.style.Style;
//         diSourceStyle: ol.style.Style;
//         roSourceStyle: ol.style.Style;
//         audioSourceStyle: ol.style.Style;
//         viewSourceStyle: ol.style.Style;
//         mediaIcon: ol.style.Style;
//         tourIconStyle: ol.style.Style;
//         icon360Style: ol.style.Style;
//         icon360MixedStyle: ol.style.Style;
//         notes: ol.style.Style;
//         linkedAlarm: ol.style.Style;
//         removedChannelIconStyle: ol.style.Style;
//         iconMobileStyle: ol.style.Style;
//         iconThermalStyle: ol.style.Style;
//         lprIconStyle: ol.style.Style;
//         vaxIconStyle: ol.style.Style;
//         imageSize: any = [128, 128];
//         imageSizeResize: any = {
//             75: [38, 38],
//             50: [25, 25],
//             25: [21, 21]
//         };
//         alarmSize: any = [32, 31];
//         anchorSize: any = [0.5, 0.48];
//         imageScale: any = 0.35;
//         static HIGHLIGHTCAMERA_IMG = "/app/_main/components/configuration/network/maps/utils/mapsIcons/yellow.png"
//         static ICON_SRC: any = {
//             default: "/app/_main/components/configuration/network/maps/utils/mapsIcons/02A_DomeStaticCameraActive.png",
//             defaultIdle: "/app/_main/components/configuration/network/maps/utils/mapsIcons/02A_DomeStaticCamera.png",
//             defaultAlarm: "/app/_main/components/configuration/network/maps/utils/mapsIcons/02A_DomeStaticCameraAlarm.png",
//             ptz: "/app/_main/components/configuration/network/maps/utils/mapsIcons/04B_PTZDomeActive.png",
//             ptzIdle: "/app/_main/components/configuration/network/maps/utils/mapsIcons/04B_PTZDome.png",
//             ptzAlarm: "/app/_main/components/configuration/network/maps/utils/mapsIcons/04B_PTZDomeAlarm.png",
//             ptzMixed: "/app/_main/components/configuration/network/maps/utils/mapsIcons/10_PTZDome2Active.png",
//             ptzMixedIdle: "/app/_main/components/configuration/network/maps/utils/mapsIcons/10_PTZDome2.png",
//             ptzMixedAlarm: "/app/_main/components/configuration/network/maps/utils/mapsIcons/10_PTZDome2Alarm.png",
//             mixedIcon: "/app/_main/components/configuration/network/maps/utils/mapsIcons/02_MixedChannelActive.png",
//             mixedIconIdle: "/app/_main/components/configuration/network/maps/utils/mapsIcons/02_MixedChannel.png",
//             mixedIconAlarm: "/app/_main/components/configuration/network/maps/utils/mapsIcons/02_MixedChannelAlarm.png",
//             digitalInput: "/app/_main/components/configuration/network/maps/utils/mapsIcons/04_DigitalInput.png",
//             relayOutput: "/app/_main/components/configuration/network/maps/utils/mapsIcons/03_Relayoutput.png",
//             audio: "/app/_main/components/configuration/network/maps/utils/mapsIcons/01_MicrophoneActive.png",
//             audioIdle: "/app/_main/components/configuration/network/maps/utils/mapsIcons/01_Microphone.png",
//             audioAlarm: "/app/_main/components/configuration/network/maps/utils/mapsIcons/01_MicrophoneAlarm.png",
//             digitalInputActive: "/app/_main/components/configuration/network/maps/utils/mapsIcons/04_DigitalInputActive.png",
//             relayOutputActive: "/app/_main/components/configuration/network/maps/utils/mapsIcons/03_RelayoutputActive.png",
//             view: "/app/_main/components/configuration/network/maps/utils/mapsIcons/05_ViewActive.png",
//             viewIdle: "/app/_main/components/configuration/network/maps/utils/mapsIcons/05_View.png",
//             viewAlarm: "/app/_main/components/configuration/network/maps/utils/mapsIcons/05_ViewAlarm.png",
//             digitalInputAlarm: "/app/_main/components/configuration/network/maps/utils/mapsIcons/04_DigitalInputAlarm.png",
//             relayOutputAlarm: "/app/_main/components/configuration/network/maps/utils/mapsIcons/03_RelayoutputAlarm.png",
//             tourIdle: "/app/_main/components/configuration/network/maps/utils/mapsIcons/06_Tour.png",
//             tourAlarm: "/app/_main/components/configuration/network/maps/utils/mapsIcons/06_TourAlarm.png",
//             tour: "/app/_main/components/configuration/network/maps/utils/mapsIcons/06_TourActive.png",
//             icon360: "/app/_main/components/configuration/network/maps/utils/mapsIcons/05A_360CameraActive.png",
//             icon360Idle: "/app/_main/components/configuration/network/maps/utils/mapsIcons/05A_360Camera.png",
//             icon360Alarm: "/app/_main/components/configuration/network/maps/utils/mapsIcons/05A_360CameraAlarm.png",
//             iconMixed360: "/app/_main/components/configuration/network/maps/utils/mapsIcons/11_360CameraActive.png",
//             iconMixed360Idle: "/app/_main/components/configuration/network/maps/utils/mapsIcons/11_360Camera.png",
//             iconMixed360Alarm: "/app/_main/components/configuration/network/maps/utils/mapsIcons/11_360CameraAlarm.png",
//             linkedAlarm: "/app/_main/components/configuration/network/maps/utils/mapsIcons/alarm.png",
//             iconMobile: "/app/_main/components/configuration/network/maps/utils/mapsIcons/Mobile.png",
//             iconMobileActive: "/app/_main/components/configuration/network/maps/utils/mapsIcons/MobileActive.png",
//             iconMobileAlarm: "/app/_main/components/configuration/network/maps/utils/mapsIcons/MobileAlarm.png",
//             iconThermal: "/app/_main/components/configuration/network/maps/utils/mapsIcons/ThermalRadar2.png",
//             iconThermalActive: "/app/_main/components/configuration/network/maps/utils/mapsIcons/Thermal Radar2Active.png",
//             iconThermalAlarm: "/app/_main/components/configuration/network/maps/utils/mapsIcons/Thermal Radar2Alarm.png",
//             iconLPR: "/app/_main/components/configuration/network/maps/utils/mapsIcons/lprActive.png",
//             iconLPRAlarm: "/app/_main/components/configuration/network/maps/utils/mapsIcons/lprImage.png",
//             vaxDoorIdle: "/app/_main/components/configuration/network/maps/utils/mapsIcons/door-idle.png",
//             vaxDoorActive: "/app/_main/components/configuration/network/maps/utils/mapsIcons/door-active.png",
//             vaxDoorAlarm: "/app/_main/components/configuration/network/maps/utils/mapsIcons/door-alarm.png",
//         };
//         public getIconStyle = (src, iconSize) => {
//             if (iconSize != 25 && iconSize != 50 && iconSize != 75 && iconSize) {
//                 return src;
//             }
//             let srcParts = src.split("/");
//             if (srcParts.length <= 1) return src;
//             srcParts.splice(srcParts.length - 1, 0, iconSize);
//             return srcParts.join("/");
//         }
//         public getIconSize(iconSize) {
//             if (iconSize != 25 && iconSize != 50 && iconSize != 75) {
//                 return this.imageSize;
//             }
//             return this.imageSizeResize[iconSize];
//         }
//         public getIconScale(iconSize) {
//             if (iconSize != 25 && iconSize != 50 && iconSize != 75) {
//                 return this.imageScale;
//             }
//             return 1;
//         }
//         constructor(iconSize:any = 100) {
//             this.icon1 = new ol.style.Style({			
//                 image: new ol.style.Icon({
//                     anchor: this.anchorSize,
//                     size: this.getIconSize(iconSize), //this.imageSize,
//                     opacity: 1,
//                     scale: this.getIconScale(iconSize),
//                     src: this.getIconStyle(CameraIcons.ICON_SRC.default, iconSize),
//                     rotation: 0
//                 }),
//                 zIndex: 2
//             });
//             this.icon360Style = new ol.style.Style({
//                 image: new ol.style.Icon({
//                     anchor: this.anchorSize,
//                     size: this.getIconSize(iconSize),
//                     opacity: 1,
//                     scale: this.getIconScale(iconSize),
//                     src: this.getIconStyle(CameraIcons.ICON_SRC.icon360, iconSize),
//                     rotation: 0
//                 }),
//                 zIndex: 2
//             });
//             this.icon360MixedStyle = new ol.style.Style({
//                 image: new ol.style.Icon({
//                     anchor: this.anchorSize,
//                     size: this.getIconSize(iconSize),
//                     opacity: 1,
//                     scale: this.getIconScale(iconSize),
//                     src: this.getIconStyle(CameraIcons.ICON_SRC.iconMixed360, iconSize),
//                     rotation: 0
//                 }),
//                 zIndex: 2
//             });
//             this.ptzIconStyle = new ol.style.Style({            
//                 image: new ol.style.Icon({
//                     anchor: this.anchorSize,
//                     size: this.getIconSize(iconSize),
//                     opacity: 1,
//                     scale: this.getIconScale(iconSize),
//                     src: this.getIconStyle(CameraIcons.ICON_SRC.ptz, iconSize),
//                     rotation: 0
//                 }),
//                 zIndex: 2
//             });
//             this.ptzMixedIconStyle = new ol.style.Style({            
//                 image: new ol.style.Icon({
//                     anchor: this.anchorSize,
//                     size: this.getIconSize(iconSize),
//                     opacity: 1,
//                     scale: this.getIconScale(iconSize),
//                     src: this.getIconStyle(CameraIcons.ICON_SRC.ptzMixed, iconSize),
//                     rotation: 0
//                 }),
//                 zIndex: 2
//             });        
//             this.mixedIconStyle = new ol.style.Style({            
//                 image: new ol.style.Icon({
//                     anchor: this.anchorSize,
//                     size: this.getIconSize(iconSize),
//                     opacity: 1,
//                     scale: this.getIconScale(iconSize),
//                     src: this.getIconStyle(CameraIcons.ICON_SRC.ptzMixed, iconSize),
//                     rotation: 0
//                 }),
//                 zIndex: 2
//             });
//             this.vaxIconStyle = new ol.style.Style({
//                 image: new ol.style.Icon({
//                     anchor: this.anchorSize,
//                     size: this.getIconSize(iconSize),
//                     opacity: 1,
//                     scale: this.getIconScale(iconSize),
//                     src: this.getIconStyle(CameraIcons.ICON_SRC.vaxDoorActive, iconSize),
//                     rotation: 0
//                 }),
//                 zIndex: 2
//             });
//             this.vaxActionPlanIconStyle = new ol.style.Style({
//                 image: new ol.style.Icon({
//                     anchor: this.anchorSize,
//                     size: this.getIconSize(iconSize),
//                     opacity: 1,
//                     scale: this.getIconScale(iconSize),
//                     src: this.getIconStyle(CameraIcons.ICON_SRC.vaxActionPlanIdle, iconSize),
//                     rotation: 0
//                 }),
//                 zIndex: 2
//             });
//             //Added to create funnel style
//             this.iconfunnel = new ol.style.Style({
//                 // Pi/4 is 45 degrees
//                 image: new ol.style.RegularShape({
//                     fill: new ol.style.Fill({ color: [53, 140, 216, 0.5] }),
//                     stroke: new ol.style.Stroke({ color: [53, 140, 216, 0], width: 0 }),
//                     points: 3,
//                     radius: 10,
//                     angle: Math.PI / 4
//                 }),
//                 text: new ol.style.Text(({ rotateWithView: true, rotation: 0 })),
//                 fill: new ol.style.Fill({ color: [53, 140, 216, 0.5] }),
//                 stroke: new ol.style.Stroke({ color: [53, 140, 216, 0], width: 0 })
//             })
//             //Sticky Note
//             this.iconStickyNotes = new ol.style.Style({
//                 fill: new ol.style.Fill({
//                     color: 'rgba(255, 255, 255, 0.2)',//'blanchedAlmond',
//                 }),
//                 stroke: new ol.style.Stroke({
//                     color: '#ffcc33',//'#959595',
//                     width: 2
//                 }),
//                 text: new ol.style.Text({
//                     font: '14px Arial Italic',
//                     fill: new ol.style.Fill({ color: '#1a2028' }),
//                     text: '',
//                     textAlign: 'center',
//                     textBaseline: 'middle'
//                 }),
//                 image: new ol.style.RegularShape({
//                     points: 4,
//                     radius: 30,
//                     fill: new ol.style.Fill({ color: [255, 255, 255, 0] }),
//                     stroke: new ol.style.Stroke({ color: [53, 140, 216, 0.5], width: 2 })
//                 }),
//             });
//             //circle for 360
//             this.iconCircle = new ol.style.Style({
//                 // Pi/4 is 45 degrees
//                 image: new ol.style.Circle({
//                     fill: new ol.style.Fill({ color: [53, 140, 216, 0.5] }),
//                     stroke: new ol.style.Stroke({ color: [53, 140, 216, 0], width: 0 }),
//                     radius: 10
//                 }),
//                 text: new ol.style.Text(({ rotateWithView: true, rotation: 0 })),
//                 fill: new ol.style.Fill({ color: [53, 140, 216, 0.5] }),
//                 stroke: new ol.style.Stroke({ color: [53, 140, 216, 0], width: 0 })
//             });
//             //default shape for add highlight
//             this.shapeStyle = new ol.style.Style({
//                 image: new ol.style.Circle({
//                     fill: new ol.style.Fill({ color: [226, 43, 138, 0.5] }),
//                     stroke: new ol.style.Stroke({ color: [226, 43, 138, 0], width: 0 }),
//                     radius: 5
//                 }),
//                 text: new ol.style.Text(({
//                     rotateWithView: true,
//                     rotation: 0,
//                     font: '14px Arial Italic',
//                     fill: new ol.style.Fill({ color: '#1a2028' }),
//                     text: '',
//                 })),
//                 fill: new ol.style.Fill({ color: [226, 43, 138, 0.5] }),
//                 stroke: new ol.style.Stroke({ color: [226, 43, 138, 0], width: 0 })
//             });
//             this.urlSourceStyle = new ol.style.Style({
//                 image: new ol.style.RegularShape({
//                     points: 4,
//                     radius: 30,
//                     angle: Math.PI / 4, // Pi/4 is 45 degrees
//                     fill: new ol.style.Fill({ color: [255, 255, 255, 0] }),
//                     //stroke: new ol.style.Stroke({ color: [53, 140, 216, 0.5], width: 2 })
//                 }),
//                 text: new ol.style.Text(({
//                     scale: 1,
//                     font: 'normal 38px vicon-font',
//                     offsetX: 0,
//                     offsetY: 0,
//                     rotateWithView: true,
//                     text: '\ue92a',
//                     textAlign: 'center',
//                     textBaseline: 'middle',
//                     fill: new ol.style.Fill({
//                         color: [0, 0, 255, 1],
//                     }),
//                     //stroke: new ol.style.Stroke({
//                     //	color: [255, 255, 255, 1],
//                     //	width: 1
//                     //}),
//                     rotation: 0 //== Rotation in radians -2 to 2*Math.PI (1 Pi = 3.14 = 180 degrees)
//                 })),
//                 zIndex: 2
//             });
//             this.diSourceStyle = new ol.style.Style({            
//                 image: new ol.style.Icon({
//                     anchor: this.anchorSize,
//                     size: this.getIconSize(iconSize),
//                     opacity: 1,
//                     scale: this.getIconScale(iconSize),
//                     src: this.getIconStyle(CameraIcons.ICON_SRC.digitalInput, iconSize),
//                     rotation: 0
//                 }),
//                 zIndex: 2
//             });
//             this.roSourceStyle = new ol.style.Style({            
//                 image: new ol.style.Icon({
//                     anchor: this.anchorSize,
//                     size: this.getIconSize(iconSize), 
//                     opacity: 1,
//                     scale: this.getIconScale(iconSize),
//                     src: this.getIconStyle(CameraIcons.ICON_SRC.relayOutput, iconSize),
//                     rotation: 0
//                 }),
//                 zIndex: 2
//             });
//             this.audioSourceStyle = new ol.style.Style({            
//                 image: new ol.style.Icon({
//                     anchor: this.anchorSize,
//                     size: this.getIconSize(iconSize),
//                     opacity: 1,
//                     scale: this.getIconScale(iconSize),
//                     src: this.getIconStyle(CameraIcons.ICON_SRC.audio, iconSize),
//                     rotation: 0
//                 }),
//                 zIndex: 2
//             });
//             this.viewSourceStyle = new ol.style.Style({            
//                 image: new ol.style.Icon({
//                     anchor: this.anchorSize,
//                     size: this.getIconSize(iconSize),
//                     opacity: 1,
//                     scale: this.getIconScale(iconSize),
//                     src: this.getIconStyle(CameraIcons.ICON_SRC.view, iconSize),
//                     rotation: 0
//                 }),
//                 zIndex: 2
//             });
//             this.tourIconStyle = new ol.style.Style({
//                 image: new ol.style.Icon({
//                     anchor: this.anchorSize,
//                     size: this.getIconSize(iconSize),
//                     opacity: 1,
//                     scale: this.getIconScale(iconSize),
//                     src: this.getIconStyle(CameraIcons.ICON_SRC.tour, iconSize),
//                     rotation: 0
//                 }),
//                 zIndex: 2
//             });
//             this.lprIconStyle = new ol.style.Style({
//                 image: new ol.style.Icon({
//                     anchor: this.anchorSize,
//                     size: this.getIconSize(iconSize),
//                     opacity: 1,
//                     scale: this.getIconScale(iconSize),
//                     src: this.getIconStyle(CameraIcons.ICON_SRC.iconLPR, iconSize),
//                     rotation: 0
//                 }),
//                 zIndex: 2
//             });
//             this.removedChannelIconStyle = new ol.style.Style({
//                 image: new ol.style.Icon({
//                     anchor: this.anchorSize,
//                     size: this.getIconSize(iconSize),
//                     opacity: 1,
//                     scale: this.getIconScale(iconSize),
//                     src: this.getIconStyle(CameraIcons.ICON_SRC.audioIdle, iconSize),
//                     rotation: 0
//                 }),
//                 zIndex: 2
//             });
//             this.notes = new ol.style.Style({
//                 text: new ol.style.Text({
//                     font: '14px Arial Italic',
//                     fill: new ol.style.Fill({ color: '#1a2028' }),
//                     text: 'Please double click to update notes',
//                     textAlign: 'center',
//                     textBaseline: 'middle'
//                 })
//             });
//             this.linkedAlarm = new ol.style.Style({
//                 image: new ol.style.Icon({
//                     anchor: this.anchorSize,
//                     size: this.getIconSize(iconSize),
//                     opacity: 1,
//                     scale: 1,
//                     src: this.getIconStyle(CameraIcons.ICON_SRC.linkedAlarm, iconSize),
//                     rotation: 0
//                 }),
//                 zIndex: 2
//             });
//             this.iconMobileStyle = new ol.style.Style({
//                 image: new ol.style.Icon({
//                     anchor: this.anchorSize,
//                     size: this.getIconSize(iconSize),
//                     opacity: 1,
//                     scale: this.getIconScale(iconSize),
//                     src: this.getIconStyle(CameraIcons.ICON_SRC.iconMobileActive, iconSize),
//                     rotation: 0
//                 }),
//                 zIndex: 2
//             });
//             this.iconThermalStyle = new ol.style.Style({
//                 image: new ol.style.Icon({
//                     anchor: this.anchorSize,
//                     size: this.getIconSize(iconSize),
//                     opacity: 1,
//                     scale: this.getIconScale(iconSize),
//                     src: this.getIconStyle(CameraIcons.ICON_SRC.iconThermalActive, iconSize),
//                     rotation: 0
//                 }),
//                 zIndex: 2
//             });
//         }
//     }
// }
var standalonePlayer;
(function (standalonePlayer) {
    "use strict";
    //export enum Colors {
    var Colors;
    (function (Colors) {
        Colors["INDIANRED"] = "#CD5C5C";
        Colors["LIGHTCORAL"] = "#F08080";
        Colors["SALMON"] = "#FA8072";
        Colors["DARKSALMON"] = "#E9967A";
        Colors["CRIMSON"] = "#DC143C";
        Colors["RED"] = "#FF0000";
        Colors["FIREBRICK"] = "#B22222";
        Colors["DARKRED"] = "#8B0000";
        Colors["PINK"] = "#FFC0CB";
        Colors["LIGHTPINK"] = "#FFB6C1";
        Colors["HOTPINK"] = "#FF69B4";
        Colors["DEEPPINK"] = "#FF1493";
        Colors["MEDIUMVIOLETRED"] = "#C71585";
        Colors["PALEVIOLETRED"] = "#DB7093";
        Colors["LIGHTSALMON"] = "#FFA07A";
        Colors["CORAL"] = "#FF7F50";
        Colors["TOMATO"] = "#FF6347";
        Colors["ORANGERED"] = "#FF4500";
        Colors["DARKORANGE"] = "#FF8C00";
        Colors["ORANGE"] = "#FFA500";
        Colors["GOLD"] = "#FFD700";
        Colors["YELLOW"] = "#FFFF00";
        Colors["LIGHTYELLOW"] = "#FFFFE0";
        Colors["LEMONCHIFFON"] = "#FFFACD";
        Colors["LIGHTGOLDENRODYELLOW"] = "#FAFAD2";
        Colors["PAPAYAWHIP"] = "#FFEFD5";
        Colors["MOCCASIN"] = "#FFE4B5";
        Colors["PEACHPUFF"] = "#FFDAB9";
        Colors["PALEGOLDENROD"] = "#EEE8AA";
        Colors["KHAKI"] = "#F0E68C";
        Colors["DARKKHAKI"] = "#BDB76B";
        Colors["LAVENDER"] = "#E6E6FA";
        Colors["THISTLE"] = "#D8BFD8";
        Colors["PLUM"] = "#DDA0DD";
        Colors["VIOLET"] = "#EE82EE";
        Colors["ORCHID"] = "#DA70D6";
        Colors["FUCHSIA"] = "#FF00FF";
        Colors["MAGENTA"] = "#FF00FF";
        Colors["MEDIUMORCHID"] = "#BA55D3";
        Colors["MEDIUMPURPLE"] = "#9370DB";
        Colors["REBECCAPURPLE"] = "#663399";
        Colors["BLUEVIOLET"] = "#8A2BE2";
        Colors["DARKVIOLET"] = "#9400D3";
        Colors["DARKORCHID"] = "#9932CC";
        Colors["DARKMAGENTA"] = "#8B008B";
        Colors["PURPLE"] = "#800080";
        Colors["INDIGO"] = "#4B0082";
        Colors["SLATEBLUE"] = "#6A5ACD";
        Colors["DARKSLATEBLUE"] = "#483D8B";
        Colors["MEDIUMSLATEBLUE"] = "#7B68EE";
        Colors["GREENYELLOW"] = "#ADFF2F";
        Colors["CHARTREUSE"] = "#7FFF00";
        Colors["LAWNGREEN"] = "#7CFC00";
        Colors["LIME"] = "#00FF00";
        Colors["LIMEGREEN"] = "#32CD32";
        Colors["PALEGREEN"] = "#98FB98";
        Colors["LIGHTGREEN"] = "#90EE90";
        Colors["MEDIUMSPRINGGREEN"] = "#00FA9A";
        Colors["SPRINGGREEN"] = "#00FF7F";
        Colors["MEDIUMSEAGREEN"] = "#3CB371";
        Colors["SEAGREEN"] = "#2E8B57";
        Colors["FORESTGREEN"] = "#228B22";
        Colors["GREEN"] = "#008000";
        Colors["DARKGREEN"] = "#006400";
        Colors["YELLOWGREEN"] = "#9ACD32";
        Colors["OLIVEDRAB"] = "#6B8E23";
        Colors["OLIVE"] = "#808000";
        Colors["DARKOLIVEGREEN"] = "#556B2F";
        Colors["MEDIUMAQUAMARINE"] = "#66CDAA";
        Colors["DARKSEAGREEN"] = "#8FBC8B";
        Colors["LIGHTSEAGREEN"] = "#20B2AA";
        Colors["DARKCYAN"] = "#008B8B";
        Colors["TEAL"] = "#008080";
        Colors["AQUA"] = "#00FFFF";
        Colors["CYAN"] = "#00FFFF";
        Colors["LIGHTCYAN"] = "#E0FFFF";
        Colors["PALETURQUOISE"] = "#AFEEEE";
        Colors["AQUAMARINE"] = "#7FFFD4";
        Colors["TURQUOISE"] = "#40E0D0";
        Colors["MEDIUMTURQUOISE"] = "#48D1CC";
        Colors["DARKTURQUOISE"] = "#00CED1";
        Colors["CADETBLUE"] = "#5F9EA0";
        Colors["STEELBLUE"] = "#4682B4";
        Colors["LIGHTSTEELBLUE"] = "#B0C4DE";
        Colors["POWDERBLUE"] = "#B0E0E6";
        Colors["LIGHTBLUE"] = "#ADD8E6";
        Colors["SKYBLUE"] = "#87CEEB";
        Colors["LIGHTSKYBLUE"] = "#87CEFA";
        Colors["DEEPSKYBLUE"] = "#00BFFF";
        Colors["DODGERBLUE"] = "#1E90FF";
        Colors["CORNFLOWERBLUE"] = "#6495ED";
        Colors["ROYALBLUE"] = "#4169E1";
        Colors["BLUE"] = "#0000FF";
        Colors["MEDIUMBLUE"] = "#0000CD";
        Colors["DARKBLUE"] = "#00008B";
        Colors["NAVY"] = "#000080";
        Colors["MIDNIGHTBLUE"] = "#191970";
        Colors["CORNSILK"] = "#FFF8DC";
        Colors["BLANCHEDALMOND"] = "#FFEBCD";
        Colors["BISQUE"] = "#FFE4C4";
        Colors["NAVAJOWHITE"] = "#FFDEAD";
        Colors["WHEAT"] = "#F5DEB3";
        Colors["BURLYWOOD"] = "#DEB887";
        Colors["TAN"] = "#D2B48C";
        Colors["ROSYBROWN"] = "#BC8F8F";
        Colors["SANDYBROWN"] = "#F4A460";
        Colors["GOLDENROD"] = "#DAA520";
        Colors["DARKGOLDENROD"] = "#B8860B";
        Colors["PERU"] = "#CD853F";
        Colors["CHOCOLATE"] = "#D2691E";
        Colors["SADDLEBROWN"] = "#8B4513";
        Colors["SIENNA"] = "#A0522D";
        Colors["BROWN"] = "#A52A2A";
        Colors["MAROON"] = "#800000";
        Colors["WHITE"] = "#FFFFFF";
        Colors["SNOW"] = "#FFFAFA";
        Colors["HONEYDEW"] = "#F0FFF0";
        Colors["MINTCREAM"] = "#F5FFFA";
        Colors["AZURE"] = "#F0FFFF";
        Colors["ALICEBLUE"] = "#F0F8FF";
        Colors["GHOSTWHITE"] = "#F8F8FF";
        Colors["WHITESMOKE"] = "#F5F5F5";
        Colors["SEASHELL"] = "#FFF5EE";
        Colors["BEIGE"] = "#F5F5DC";
        Colors["OLDLACE"] = "#FDF5E6";
        Colors["FLORALWHITE"] = "#FFFAF0";
        Colors["IVORY"] = "#FFFFF0";
        Colors["ANTIQUEWHITE"] = "#FAEBD7";
        Colors["LINEN"] = "#FAF0E6";
        Colors["LAVENDERBLUSH"] = "#FFF0F5";
        Colors["MISTYROSE"] = "#FFE4E1";
        Colors["GAINSBORO"] = "#DCDCDC";
        Colors["LIGHTGRAY"] = "#D3D3D3";
        Colors["SILVER"] = "#C0C0C0";
        Colors["DARKGRAY"] = "#A9A9A9";
        Colors["GRAY"] = "#808080";
        Colors["DIMGRAY"] = "#696969";
        Colors["LIGHTSLATEGRAY"] = "#778899";
        Colors["SLATEGRAY"] = "#708090";
        Colors["DARKSLATEGRAY"] = "#2F4F4F";
        Colors["BLACK"] = "#000000";
    })(Colors = standalonePlayer.Colors || (standalonePlayer.Colors = {}));
    ;
    var Size;
    (function (Size) {
        Size["Size8"] = "8px";
        Size["Size9"] = "9px";
        Size["Size10"] = "10px";
        Size["Size11"] = "11px";
        Size["Size12"] = "12px";
        Size["Size14"] = "14px";
        Size["Size16"] = "16px";
        Size["Size18"] = "18px";
        Size["Size20"] = "20px";
        Size["Size22"] = "22px";
        Size["Size24"] = "24px";
        Size["Size26"] = "26px";
        Size["Size28"] = "28px";
        Size["Size36"] = "36px";
        Size["Size48"] = "48px";
        Size["Size72"] = "72px";
    })(Size = standalonePlayer.Size || (standalonePlayer.Size = {}));
    ;
    var Name;
    (function (Name) {
        Name["Algerian"] = "Algerian";
        Name["Garamond"] = "Garamond";
        Name["Latha"] = "Latha";
        Name["Constantia"] = "Constantia";
        Name["Arial"] = "Arial";
    })(Name = standalonePlayer.Name || (standalonePlayer.Name = {}));
    ;
    var Shapes;
    (function (Shapes) {
        Shapes["Ractangle"] = "Square";
        Shapes["Triangle"] = "Triangle";
        Shapes["Circle"] = "Circle";
        Shapes["LeftArrow"] = "Arrow";
        //RightArrow = "Right Arrow",
        //DownArrow = "Down Arrow",
        //UpArrow = "Up Arrow"
    })(Shapes = standalonePlayer.Shapes || (standalonePlayer.Shapes = {}));
})(standalonePlayer || (standalonePlayer = {}));
//    const mapLayers = {
//        mapLayer: 'bgMapImageLayer',
//        cameraLayer: 'cameraImagesLayer',
//        funnelLayer: 'funnelLayer',
//        linkedMapsLayer: 'linkedMapsLayer',
//        stickyNotesLayer: 'stickyNotesLayer',
//        viewLayer: 'viewLayer'
//    }
//    const mapFeatureTypes = {
//        camera: 'iconFeature',
//        funnel: 'funnelFeature',
//        linkedMap: 'linkedMapFeature',
//        stickyNote: 'stickyNoteFeature',
//        view: 'viewFature'
//    }
//    const mapCameraTypes = {
//        image: 'image',
//        text: 'text'
//    }
//    const mapTypes = {
//        static: 'Image',
//        geo: 'MapService'
//    }
//    const mapLinkedType = {
//        linked: 'linked',
//        unlinked: 'unlinked'
//    }
//module standalonePlayer {
//    "use strict";
//    //== populating all objects for export
//    export  { mapLayers, mapTypes, mapFeatureTypes, mapCameraTypes, mapLinkedType };
//}
// declare var ol:any;
// const defaultStyle = {
//    highlight: new ol.style.Style({
//        fill: new ol.style.Fill({
//            color: [147, 147, 93, 0.8]
//        }),
//        stroke: new ol.style.Stroke({
//            color: [147, 147, 93, 0.8],
//            width: 2,
//            lineDash: [5]
//        })
//    }),
//    note: new ol.style.Style({
//        fill: new ol.style.Fill({
//            color: [252, 233, 168, 1]
//        }),
//        stroke: new ol.style.Stroke({
//            color: [191, 183, 154, 1],
//            width: 1
//        }),
//        text: new ol.style.Text(({
//            scale: 1,
//            font: 'normal 18px Arial',
//            offsetX: 0,
//            offsetY: 0,
//            rotateWithView: true,
//            textAlign: 'center',
//            textBaseline: 'middle',
//            //overflow: true,
//            fill: new ol.style.Fill({
//                color: [0, 0, 0, 1]
//            }),
//            stroke: new ol.style.Stroke({
//                color: [0, 0, 0, 0],
//                width: 1
//            }),
//            rotation: 0 //== Rotation in radians -2 to 2*Math.PI (1 Pi = 3.14 = 180 degrees)
//        })),
//        zIndex: 2
//    })
// }
// const selectedStyle = {
//    camera: new ol.style.Style({
//        text: new ol.style.Text(({
//            scale: 1,
//            font: 'normal 34px vicon-font',
//            //placement: 'point',
//            offsetX: 10,
//            offsetY: 10,
//            //overflow: false,
//            rotateWithView: true,
//            text: '\ue928',
//            textAlign: 'center',
//            textBaseline: 'middle',
//            fill: new ol.style.Fill({
//                color: 'rgba(0, 0, 255, 1)',
//            }),
//            //padding: [1, 1, 1, 1],
//            stroke: new ol.style.Stroke({
//                color: 'rgba(255, 0, 0, 0.5)',
//                width: 2
//            })
//        })),
//        zIndex: 2
//    }),
//    funnel: new ol.style.Style({
//        text: new ol.style.Text(({
//            scale: 1,
//            font: 'normal 34px vicon-font',
//            //placement: 'point',
//            offsetX: 10,
//            offsetY: 10,
//            //overflow: false,
//            rotateWithView: true,
//            text: '\ue928',
//            textAlign: 'center',
//            textBaseline: 'middle',
//            fill: new ol.style.Fill({
//                color: 'rgba(0, 0, 255, 1)',
//            }),
//            //padding: [1, 1, 1, 1],
//            stroke: new ol.style.Stroke({
//                color: 'rgba(255, 0, 0, 0.5)',
//                width: 2
//            })
//        })),
//        zIndex: 2
//    }),
//    highlight: new ol.style.Style({
//        fill: new ol.style.Fill({
//            color: [147, 147, 93, 0.8]
//        }),
//        stroke: new ol.style.Stroke({
//            color: [255, 0, 0, 1],
//            width: 2
//        })
//    }),
//    note: new ol.style.Style({
//        fill: new ol.style.Fill({
//            color: [252, 233, 168, 1]
//        }),
//        stroke: new ol.style.Stroke({
//            color: [255, 0, 0, 1],
//            width: 1
//        }),
//        text: new ol.style.Text(({
//            scale: 1,
//            font: 'normal 18px Arial',
//            offsetX: 0,
//            offsetY: 0,
//            rotateWithView: true,
//            textAlign: 'center',
//            textBaseline: 'middle',
//            //overflow: true,
//            fill: new ol.style.Fill({
//                color: [0, 0, 0, 1]
//            }),
//            stroke: new ol.style.Stroke({
//                color: [0, 0, 0, 0],
//                width: 1
//            }),
//            rotation: 0 //== Rotation in radians -2 to 2*Math.PI (1 Pi = 3.14 = 180 degrees)
//        })),
//        zIndex: 2
//    })
// }
// const hoverStyle = {
//    highlight: new ol.style.Style({
//        fill: new ol.style.Fill({
//            color: [147, 147, 93, 0.8]
//        }),
//        stroke: new ol.style.Stroke({
//            color: [53, 140, 216, 0.5],
//            width: 2
//        })
//    }),
//    camera: new ol.style.Style({
//        fill: new ol.style.Fill({
//            color: [147, 147, 93, 0.8]
//        }),
//        stroke: new ol.style.Stroke({
//            color: [53, 140, 216, 0.5],
//            width: 2
//        })
//    }),
//    note: new ol.style.Style({
//        fill: new ol.style.Fill({
//            color: [252, 233, 168, 1]
//        }),
//        stroke: new ol.style.Stroke({
//            color: [53, 140, 216, 1],
//            width: 1
//        }),
//        text: new ol.style.Text(({
//            scale: 1,
//            font: 'normal 18px Arial',
//            offsetX: 0,
//            offsetY: 0,
//            rotateWithView: true,
//            textAlign: 'center',
//            textBaseline: 'middle',
//            //overflow: true,
//            fill: new ol.style.Fill({
//                color: [0, 0, 0, 1]
//            }),
//            stroke: new ol.style.Stroke({
//                color: [0, 0, 0, 0],
//                width: 1
//            }),
//            rotation: 0 //== Rotation in radians -2 to 2*Math.PI (1 Pi = 3.14 = 180 degrees)
//        })),
//        zIndex: 2
//    })
// }
// //== Rotate feature - style of anchor point and dragging arrow
// const rotateStyles = {
//    anchor: [
//        new ol.style.Style({
//            image: new ol.style.RegularShape({
//                fill: new ol.style.Fill({
//                    color: '#4a4a4a'
//                }),
//                stroke: new ol.style.Stroke({
//                    color: '#bababa',
//                    width: 1
//                }),
//                radius: 3,
//                points: 6
//            }),
//            zIndex: Infinity
//        })
//    ],
//    arrow: [
//        new ol.style.Style({ //== rotate icon
//            text: new ol.style.Text({
//                font: 'normal 20px vicon-font',
//                offsetX: -1,
//                offsetY: 0,
//                text: '\ue91e',
//                rotateWithView: false,
//                textAlign: 'center',
//                fill: new ol.style.Fill({
//                    color: '#4a4a4a'
//                }),
//                stroke: new ol.style.Stroke({
//                    color: 'white',
//                    width: 2
//                })
//            }),
//            zIndex: Infinity
//        }),
//        new ol.style.Style({ //== white dashed line
//            stroke: new ol.style.Stroke({
//                color: 'white',
//                width: 3,
//                lineDash: [5, 5]
//            }),
//            text: new ol.style.Text({ //== text with stroke
//                font: '12px sans-serif',
//                offsetX: 20,
//                offsetY: -20,
//                fill: new ol.style.Fill({
//                    color: '#4a4a4a'
//                }),
//                stroke: new ol.style.Stroke({
//                    color: 'white',
//                    width: 2
//                })
//            }),
//            zIndex: Infinity
//        }),
//        new ol.style.Style({ //== red dashed line
//            stroke: new ol.style.Stroke({
//                color: '#4a4a4a',
//                width: 2,
//                lineDash: [5, 5]
//            }),
//            zIndex: Infinity
//        }),
//        new ol.style.Style({ //== opacity stroke is for mouse pointer dragging
//            stroke: new ol.style.Stroke({
//                color: [0, 0, 0, 0.1],
//                width: 6,
//                lineDash: [5, 5]
//            }),
//            zIndex: Infinity
//        })
//    ]
// }
// //== populating all objects for export
// export default { defaultStyle, selectedStyle, hoverStyle, rotateStyles}; 

//# sourceMappingURL=app.js.map
